/*
 * Decompiled with CFR 0.152.
 */
package org.bk.ass.path;

import java.util.Collections;
import org.bk.ass.grid.Grid;
import org.bk.ass.path.AbstractPathFinder;
import org.bk.ass.path.PPMap;
import org.bk.ass.path.Position;
import org.bk.ass.path.Result;

public class PPJps {
    private final PPMap map;

    public PPJps(PPMap map) {
        this.map = map;
    }

    public PPJps(Grid<Boolean> map) {
        this(PPMap.fromMap(map));
    }

    public Result findPath(Position start, Position end) {
        if (start.equals(end)) {
            return new Result(0.0f, Collections.singletonList(start));
        }
        return new PathFinder(end, this.map).searchFrom(start);
    }

    private static class PathFinder
    extends AbstractPathFinder {
        private final PPMap map;

        PathFinder(Position target, PPMap map) {
            super(target, map);
            this.map = map;
        }

        @Override
        protected Position jumpHorizontal(int px, int py, int dx) {
            short x;
            assert (dx != 0);
            if (dx < 0) {
                x = this.map.left(px, py);
                if (py == this.target.y && px >= this.target.x && (x < 0 && -x - 1 <= this.target.x || x >= 0 && x <= this.target.x)) {
                    x = (short)this.target.x;
                }
            } else {
                x = this.map.right(px, py);
                if (py == this.target.y && px <= this.target.x && (x < 0 && -x - 1 >= this.target.x || x >= this.target.x)) {
                    x = (short)this.target.x;
                }
            }
            if (x >= 0) {
                return new Position(x, py);
            }
            return null;
        }

        @Override
        protected Position jumpVertical(int px, int py, int dy) {
            short y;
            assert (dy != 0);
            if (dy < 0) {
                y = this.map.up(px, py);
                if (px == this.target.x && py >= this.target.y && (y < 0 && -y - 1 <= this.target.y || y >= 0 && y <= this.target.y)) {
                    y = (short)this.target.y;
                }
            } else {
                y = this.map.down(px, py);
                if (px == this.target.x && py <= this.target.y && (y < 0 && -y - 1 >= this.target.y || y >= this.target.y)) {
                    y = (short)this.target.y;
                }
            }
            if (y >= 0) {
                return new Position(px, y);
            }
            return null;
        }
    }
}

