/*
 * Decompiled with CFR 0.152.
 */
package org.bk.ass.path;

import java.util.ArrayList;
import java.util.Collections;
import java.util.PriorityQueue;
import org.bk.ass.grid.Grid;
import org.bk.ass.path.Position;
import org.bk.ass.path.Result;

abstract class AbstractPathFinder {
    private final Node CLOSED = new Node();
    private final PriorityQueue<Node> openQueue = new PriorityQueue();
    private final Node[] nodes;
    final Position target;
    private final Grid<Boolean> map;

    AbstractPathFinder(Position target, Grid<Boolean> map) {
        this.target = target;
        this.map = map;
        this.nodes = new Node[map.getHeight() * map.getWidth()];
    }

    Result searchFrom(Position start) {
        Node best;
        this.openQueue.add(new Node(start));
        while ((best = this.openQueue.poll()) != null) {
            if (best.position.equals(this.target)) {
                ArrayList<Position> path = new ArrayList<Position>();
                Node n = best;
                while (n != null) {
                    path.add(n.position);
                    n = n.parent;
                }
                Collections.reverse(path);
                return new Result((float)best.g / 10.0f, path);
            }
            Position p = best.position;
            int index = this.idx(p);
            if (this.nodes[index] == this.CLOSED) continue;
            this.nodes[index] = this.CLOSED;
            if (best.parent == null) {
                this.addToOpenSet(best, this.jumpHorizontal(p.x, p.y, -1));
                this.addToOpenSet(best, this.jumpHorizontal(p.x, p.y, 1));
                this.addToOpenSet(best, this.jumpVertical(p.x, p.y, -1));
                this.addToOpenSet(best, this.jumpVertical(p.x, p.y, 1));
                this.addToOpenSet(best, this.jumpDiag(p.x, p.y, 1, 1));
                this.addToOpenSet(best, this.jumpDiag(p.x, p.y, -1, 1));
                this.addToOpenSet(best, this.jumpDiag(p.x, p.y, -1, -1));
                this.addToOpenSet(best, this.jumpDiag(p.x, p.y, 1, -1));
                continue;
            }
            int dx = Integer.signum(p.x - best.parent.position.x);
            int dy = Integer.signum(p.y - best.parent.position.y);
            if (dx != 0 && dy != 0) {
                this.addToOpenSet(best, this.jumpHorizontal(p.x, p.y, dx));
                this.addToOpenSet(best, this.jumpVertical(p.x, p.y, dy));
                this.addToOpenSet(best, this.jumpDiag(p.x, p.y, dx, dy));
                if (!this.map.get(p.x - dx, p.y).booleanValue()) {
                    this.addToOpenSet(best, this.jumpDiag(p.x, p.y, -dx, dy));
                }
                if (this.map.get(p.x, p.y - dy).booleanValue()) continue;
                this.addToOpenSet(best, this.jumpDiag(p.x, p.y, dx, -dy));
                continue;
            }
            if (dx != 0) {
                this.addToOpenSet(best, this.jumpHorizontal(p.x, p.y, dx));
                if (!this.map.get(p.x, p.y - 1).booleanValue()) {
                    this.addToOpenSet(best, this.jumpDiag(p.x, p.y, dx, -1));
                }
                if (this.map.get(p.x, p.y + 1).booleanValue()) continue;
                this.addToOpenSet(best, this.jumpDiag(p.x, p.y, dx, 1));
                continue;
            }
            this.addToOpenSet(best, this.jumpVertical(p.x, p.y, dy));
            if (!this.map.get(p.x - 1, p.y).booleanValue()) {
                this.addToOpenSet(best, this.jumpDiag(p.x, p.y, -1, dy));
            }
            if (this.map.get(p.x + 1, p.y).booleanValue()) continue;
            this.addToOpenSet(best, this.jumpDiag(p.x, p.y, 1, dy));
        }
        return new Result(Float.POSITIVE_INFINITY, Collections.emptyList());
    }

    private int idx(Position p) {
        return this.idx(p.y, this.map.getWidth(), p.x);
    }

    private int idx(int y, int width, int x) {
        return y * width + x;
    }

    protected abstract Position jumpVertical(int var1, int var2, int var3);

    protected abstract Position jumpHorizontal(int var1, int var2, int var3);

    private void addToOpenSet(Node parent, Position pos) {
        int index;
        if (pos != null && this.nodes[index = this.idx(pos)] != this.CLOSED) {
            Node node = new Node(parent, pos);
            Node existing = this.nodes[index];
            if (existing == null || existing.f > node.f) {
                if (existing != null) {
                    this.openQueue.remove(existing);
                }
                this.openQueue.add(node);
                this.nodes[index] = node;
            }
        }
    }

    private Position jumpDiag(int px, int py, int dx, int dy) {
        assert (dx != 0);
        assert (dy != 0);
        int x = px + dx;
        int y = py + dy;
        int a = (this.map.get(x - dx, y) != false ? 0 : 1) | (this.map.get(x, y - dy) != false ? 0 : 2);
        while (this.map.get(x, y).booleanValue()) {
            int b = (this.map.get(x - dx, y + dy) != false ? 1 : 0) | (this.map.get(x + dx, y - dy) != false ? 2 : 0);
            if (x == this.target.x && y == this.target.y || (a & b) != 0 || this.jumpHorizontal(x, y, dx) != null || this.jumpVertical(x, y, dy) != null) {
                return new Position(x, y);
            }
            x += dx;
            y += dy;
            a = ~b;
        }
        return null;
    }

    private class Node
    implements Comparable<Node> {
        final Node parent;
        final Position position;
        final int g;
        final int f;

        Node() {
            this.parent = null;
            this.position = null;
            this.f = 0;
            this.g = 0;
        }

        Node(Position start) {
            this.parent = null;
            this.position = start;
            this.g = 0;
            this.f = this.estCost(this.position.x - AbstractPathFinder.this.target.x, this.position.y - AbstractPathFinder.this.target.y);
        }

        private int estCost(int dx, int dy) {
            int distX = Math.abs(dx);
            int distY = Math.abs(dy);
            return 10 * Math.max(distX, distY) + 4 * Math.min(distX, distY);
        }

        Node(Node parent, Position position) {
            this.parent = parent;
            this.position = position;
            this.g = parent.g + this.estCost(position.x - parent.position.x, position.y - parent.position.y);
            this.f = this.g + this.estCost(position.x - AbstractPathFinder.this.target.x, position.y - AbstractPathFinder.this.target.y);
        }

        @Override
        public int compareTo(Node o) {
            return Integer.compare(this.f, o.f);
        }

        public String toString() {
            return this.position + " : " + this.f;
        }
    }
}

