/*
 * Decompiled with CFR 0.152.
 */
package org.bk.ass.manage;

import bwapi.UnitType;
import org.openbw.bwapi4j.type.TechType;
import org.openbw.bwapi4j.type.UpgradeType;

public final class GMS {
    public final int gas;
    public final int minerals;
    public final int supply;

    public GMS(int gas, int minerals, int supply) {
        this.gas = gas;
        this.minerals = minerals;
        this.supply = supply;
    }

    public static GMS unitCost(UnitType unitType) {
        return new GMS(unitType.gasPrice(), unitType.mineralPrice(), unitType.supplyRequired());
    }

    public static GMS unitCost(org.openbw.bwapi4j.type.UnitType unitType) {
        return new GMS(unitType.gasPrice(), unitType.mineralPrice(), unitType.supplyRequired());
    }

    public static GMS techCost(bwapi.TechType techType) {
        return new GMS(techType.gasPrice(), techType.mineralPrice(), 0);
    }

    public static GMS techCost(TechType techType) {
        return new GMS(techType.gasPrice(), techType.mineralPrice(), 0);
    }

    public static GMS researchCost(bwapi.UpgradeType upgradeType, int level) {
        return new GMS(upgradeType.gasPrice(level), upgradeType.mineralPrice(level), 0);
    }

    public static GMS researchCost(UpgradeType upgradeType, int level) {
        return new GMS(upgradeType.gasPrice(level), upgradeType.mineralPrice(level), 0);
    }

    public GMS subtract(GMS gms) {
        return new GMS(this.gas - gms.gas, this.minerals - gms.minerals, this.supply - gms.supply);
    }

    public GMS add(GMS gms) {
        return new GMS(this.gas + gms.gas, this.minerals + gms.minerals, this.supply + gms.supply);
    }

    public boolean greaterOrEqual(GMS gms) {
        return Integer.max(0, this.gas) >= gms.gas && Integer.max(0, this.minerals) >= gms.minerals && Integer.max(0, this.supply) >= gms.supply;
    }

    public String toString() {
        return "gas: " + this.gas + ", minerals: " + this.minerals + ", supply: " + this.supply;
    }
}

