/*
 * Decompiled with CFR 0.152.
 */
package org.bk.ass.collection;

import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.bk.ass.collection.FastArrayFill;

public class UnorderedCollection<T>
extends AbstractCollection<T> {
    T[] items;
    private int size;

    public UnorderedCollection() {
        this(16);
    }

    public UnorderedCollection(int capacity) {
        this.items = new Object[capacity];
    }

    public UnorderedCollection(Collection<T> source) {
        this((int)((long)source.size() * 7L / 4L));
        this.addAll(source);
    }

    public void clearReferences() {
        if (this.size < this.items.length) {
            FastArrayFill.fillArray(this.items, this.size, this.items.length, null);
        }
    }

    @Override
    public boolean add(T value) {
        if (this.size == this.items.length) {
            this.resize((int)((long)this.size * 7L / 4L));
        }
        this.items[this.size++] = value;
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends T> elementsToAdd) {
        if (elementsToAdd.isEmpty()) {
            return false;
        }
        int targetSize = elementsToAdd.size() + this.size;
        if (targetSize >= this.items.length) {
            this.resize(targetSize * 7 / 4);
        }
        for (T e : elementsToAdd) {
            this.items[this.size++] = e;
        }
        return true;
    }

    @Override
    public boolean remove(Object value) {
        for (int i = 0; i < this.size; ++i) {
            if (this.items[i] != value) continue;
            this.removeAt(i);
            return true;
        }
        return false;
    }

    public T removeAt(int index) {
        T last;
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index " + index + " must be >= 0 and < " + this.size);
        }
        T removed = this.items[index];
        this.items[index] = last = this.items[--this.size];
        return removed;
    }

    private void resize(int newCapacity) {
        int capacityToUse = Math.max(8, newCapacity);
        Object[] newItems = new Object[capacityToUse];
        System.arraycopy(this.items, 0, newItems, 0, Math.min(this.size, newItems.length));
        this.items = newItems;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean contains(Object value) {
        for (int i = 0; i < this.size; ++i) {
            if (this.items[i] != value) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<T> iterator() {
        return new UnorderedListIterator();
    }

    @Override
    public Object[] toArray() {
        return Arrays.copyOf(this.items, this.size);
    }

    @Override
    public <R> R[] toArray(R[] a) {
        return this.items;
    }

    public T get(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index " + index + " must be > 0 and < " + this.size);
        }
        return this.items[index];
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    private class UnorderedListIterator
    implements Iterator<T> {
        private int index;

        private UnorderedListIterator() {
        }

        @Override
        public void remove() {
            UnorderedCollection.this.removeAt(this.index - 1);
        }

        @Override
        public boolean hasNext() {
            return this.index < UnorderedCollection.this.size;
        }

        @Override
        public T next() {
            if (this.index >= UnorderedCollection.this.size) {
                throw new NoSuchElementException();
            }
            return UnorderedCollection.this.items[this.index++];
        }
    }
}

