/*
 * Decompiled with CFR 0.152.
 */
package learning;

import lombok.Generated;

public class GameRecord {
    private long timestamp;
    private int numStartingLocations;
    private String mapName;
    private String opponentName;
    private String opponentRace;
    private String opener;
    private String buildOrder;
    private String detectedStrategies;
    private boolean isWinner;

    public String toCsvRow() {
        return String.format("%d,%s,%d,%s,%s,%s,%s,%s,%s", this.timestamp, this.isWinner, this.numStartingLocations, GameRecord.escapeCsvField(this.mapName), GameRecord.escapeCsvField(this.opponentName), GameRecord.escapeCsvField(this.opponentRace), GameRecord.escapeCsvField(this.opener), GameRecord.escapeCsvField(this.buildOrder), GameRecord.escapeCsvField(this.detectedStrategies));
    }

    public static GameRecord fromCsvRow(String csvRow) {
        String[] fields = GameRecord.parseCsvRow(csvRow);
        return GameRecord.builder().timestamp(Long.parseLong(fields[0])).isWinner(Boolean.parseBoolean(fields[1])).numStartingLocations(Integer.parseInt(fields[2])).mapName(fields[3]).opponentName(fields[4]).opponentRace(fields[5]).opener(fields[6]).buildOrder(fields[7]).detectedStrategies(fields[8]).build();
    }

    private static String escapeCsvField(String field) {
        if (field == null) {
            return "";
        }
        if (field.contains(",") || field.contains("\"") || field.contains("\n")) {
            return "\"" + field.replace("\"", "\"\"") + "\"";
        }
        return field;
    }

    private static String[] parseCsvRow(String csvRow) {
        String[] result = new String[9];
        boolean inQuotes = false;
        StringBuilder currentField = new StringBuilder();
        int fieldIndex = 0;
        int i = 0;
        while (i < csvRow.length()) {
            char c = csvRow.charAt(i);
            if (c == '\"') {
                if (inQuotes && i + 1 < csvRow.length() && csvRow.charAt(i + 1) == '\"') {
                    currentField.append('\"');
                    ++i;
                } else {
                    inQuotes = !inQuotes;
                }
            } else if (c == ',' && !inQuotes) {
                result[fieldIndex++] = currentField.toString();
                currentField = new StringBuilder();
            } else {
                currentField.append(c);
            }
            ++i;
        }
        result[fieldIndex] = currentField.toString();
        return result;
    }

    @Generated
    GameRecord(long timestamp, int numStartingLocations, String mapName, String opponentName, String opponentRace, String opener, String buildOrder, String detectedStrategies, boolean isWinner) {
        this.timestamp = timestamp;
        this.numStartingLocations = numStartingLocations;
        this.mapName = mapName;
        this.opponentName = opponentName;
        this.opponentRace = opponentRace;
        this.opener = opener;
        this.buildOrder = buildOrder;
        this.detectedStrategies = detectedStrategies;
        this.isWinner = isWinner;
    }

    @Generated
    public static GameRecordBuilder builder() {
        return new GameRecordBuilder();
    }

    @Generated
    public long getTimestamp() {
        return this.timestamp;
    }

    @Generated
    public int getNumStartingLocations() {
        return this.numStartingLocations;
    }

    @Generated
    public String getMapName() {
        return this.mapName;
    }

    @Generated
    public String getOpponentName() {
        return this.opponentName;
    }

    @Generated
    public String getOpponentRace() {
        return this.opponentRace;
    }

    @Generated
    public String getOpener() {
        return this.opener;
    }

    @Generated
    public String getBuildOrder() {
        return this.buildOrder;
    }

    @Generated
    public String getDetectedStrategies() {
        return this.detectedStrategies;
    }

    @Generated
    public boolean isWinner() {
        return this.isWinner;
    }

    @Generated
    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    @Generated
    public void setNumStartingLocations(int numStartingLocations) {
        this.numStartingLocations = numStartingLocations;
    }

    @Generated
    public void setMapName(String mapName) {
        this.mapName = mapName;
    }

    @Generated
    public void setOpponentName(String opponentName) {
        this.opponentName = opponentName;
    }

    @Generated
    public void setOpponentRace(String opponentRace) {
        this.opponentRace = opponentRace;
    }

    @Generated
    public void setOpener(String opener) {
        this.opener = opener;
    }

    @Generated
    public void setBuildOrder(String buildOrder) {
        this.buildOrder = buildOrder;
    }

    @Generated
    public void setDetectedStrategies(String detectedStrategies) {
        this.detectedStrategies = detectedStrategies;
    }

    @Generated
    public void setWinner(boolean isWinner) {
        this.isWinner = isWinner;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GameRecord)) {
            return false;
        }
        GameRecord other = (GameRecord)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTimestamp() != other.getTimestamp()) {
            return false;
        }
        if (this.getNumStartingLocations() != other.getNumStartingLocations()) {
            return false;
        }
        if (this.isWinner() != other.isWinner()) {
            return false;
        }
        String this$mapName = this.getMapName();
        String other$mapName = other.getMapName();
        if (this$mapName == null ? other$mapName != null : !this$mapName.equals(other$mapName)) {
            return false;
        }
        String this$opponentName = this.getOpponentName();
        String other$opponentName = other.getOpponentName();
        if (this$opponentName == null ? other$opponentName != null : !this$opponentName.equals(other$opponentName)) {
            return false;
        }
        String this$opponentRace = this.getOpponentRace();
        String other$opponentRace = other.getOpponentRace();
        if (this$opponentRace == null ? other$opponentRace != null : !this$opponentRace.equals(other$opponentRace)) {
            return false;
        }
        String this$opener = this.getOpener();
        String other$opener = other.getOpener();
        if (this$opener == null ? other$opener != null : !this$opener.equals(other$opener)) {
            return false;
        }
        String this$buildOrder = this.getBuildOrder();
        String other$buildOrder = other.getBuildOrder();
        if (this$buildOrder == null ? other$buildOrder != null : !this$buildOrder.equals(other$buildOrder)) {
            return false;
        }
        String this$detectedStrategies = this.getDetectedStrategies();
        String other$detectedStrategies = other.getDetectedStrategies();
        return !(this$detectedStrategies == null ? other$detectedStrategies != null : !this$detectedStrategies.equals(other$detectedStrategies));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GameRecord;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $timestamp = this.getTimestamp();
        result = result * 59 + (int)($timestamp ^ $timestamp >>> 32);
        result = result * 59 + this.getNumStartingLocations();
        result = result * 59 + (this.isWinner() ? 79 : 97);
        String $mapName = this.getMapName();
        result = result * 59 + ($mapName == null ? 43 : $mapName.hashCode());
        String $opponentName = this.getOpponentName();
        result = result * 59 + ($opponentName == null ? 43 : $opponentName.hashCode());
        String $opponentRace = this.getOpponentRace();
        result = result * 59 + ($opponentRace == null ? 43 : $opponentRace.hashCode());
        String $opener = this.getOpener();
        result = result * 59 + ($opener == null ? 43 : $opener.hashCode());
        String $buildOrder = this.getBuildOrder();
        result = result * 59 + ($buildOrder == null ? 43 : $buildOrder.hashCode());
        String $detectedStrategies = this.getDetectedStrategies();
        result = result * 59 + ($detectedStrategies == null ? 43 : $detectedStrategies.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "GameRecord(timestamp=" + this.getTimestamp() + ", numStartingLocations=" + this.getNumStartingLocations() + ", mapName=" + this.getMapName() + ", opponentName=" + this.getOpponentName() + ", opponentRace=" + this.getOpponentRace() + ", opener=" + this.getOpener() + ", buildOrder=" + this.getBuildOrder() + ", detectedStrategies=" + this.getDetectedStrategies() + ", isWinner=" + this.isWinner() + ")";
    }

    @Generated
    public static class GameRecordBuilder {
        @Generated
        private long timestamp;
        @Generated
        private int numStartingLocations;
        @Generated
        private String mapName;
        @Generated
        private String opponentName;
        @Generated
        private String opponentRace;
        @Generated
        private String opener;
        @Generated
        private String buildOrder;
        @Generated
        private String detectedStrategies;
        @Generated
        private boolean isWinner;

        @Generated
        GameRecordBuilder() {
        }

        @Generated
        public GameRecordBuilder timestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @Generated
        public GameRecordBuilder numStartingLocations(int numStartingLocations) {
            this.numStartingLocations = numStartingLocations;
            return this;
        }

        @Generated
        public GameRecordBuilder mapName(String mapName) {
            this.mapName = mapName;
            return this;
        }

        @Generated
        public GameRecordBuilder opponentName(String opponentName) {
            this.opponentName = opponentName;
            return this;
        }

        @Generated
        public GameRecordBuilder opponentRace(String opponentRace) {
            this.opponentRace = opponentRace;
            return this;
        }

        @Generated
        public GameRecordBuilder opener(String opener) {
            this.opener = opener;
            return this;
        }

        @Generated
        public GameRecordBuilder buildOrder(String buildOrder) {
            this.buildOrder = buildOrder;
            return this;
        }

        @Generated
        public GameRecordBuilder detectedStrategies(String detectedStrategies) {
            this.detectedStrategies = detectedStrategies;
            return this;
        }

        @Generated
        public GameRecordBuilder isWinner(boolean isWinner) {
            this.isWinner = isWinner;
            return this;
        }

        @Generated
        public GameRecord build() {
            return new GameRecord(this.timestamp, this.numStartingLocations, this.mapName, this.opponentName, this.opponentRace, this.opener, this.buildOrder, this.detectedStrategies, this.isWinner);
        }

        @Generated
        public String toString() {
            return "GameRecord.GameRecordBuilder(timestamp=" + this.timestamp + ", numStartingLocations=" + this.numStartingLocations + ", mapName=" + this.mapName + ", opponentName=" + this.opponentName + ", opponentRace=" + this.opponentRace + ", opener=" + this.opener + ", buildOrder=" + this.buildOrder + ", detectedStrategies=" + this.detectedStrategies + ", isWinner=" + this.isWinner + ")";
        }
    }
}

