/*
 * Decompiled with CFR 0.152.
 */
package info.tracking;

import bwapi.Game;
import bwapi.Race;
import info.tracking.ObservedStrategy;
import info.tracking.ObservedUnitTracker;
import info.tracking.protoss.FFE;
import info.tracking.protoss.OneGateCore;
import info.tracking.protoss.TwoGate;
import info.tracking.terran.TwoRaxAcademy;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import util.Time;

public class StrategyTracker {
    private Set<ObservedStrategy> detectedStrategies = new HashSet<ObservedStrategy>();
    private Set<ObservedStrategy> possibleStrategies = new HashSet<ObservedStrategy>();
    private Set<ObservedStrategy> discardedStrategies = new HashSet<ObservedStrategy>();
    private final Game game;
    private final ObservedUnitTracker tracker;

    public StrategyTracker(Game game, Race opponentRace, ObservedUnitTracker tracker) {
        this.game = game;
        this.tracker = tracker;
        this.init(opponentRace);
    }

    private void init(Race race) {
        if (race == Race.Protoss || race == Race.Unknown) {
            this.possibleStrategies.add(new FFE());
            this.possibleStrategies.add(new OneGateCore());
            this.possibleStrategies.add(new TwoGate());
        }
        if (race == Race.Terran || race == Race.Unknown) {
            this.possibleStrategies.add(new TwoRaxAcademy());
        }
    }

    public void updateRace(Race opponentRace) {
        this.possibleStrategies = this.possibleStrategies.stream().filter(s -> s.getRace() == opponentRace).collect(Collectors.toSet());
    }

    public void onFrame() {
        Time currentTime = new Time(this.game.getFrameCount());
        HashSet<ObservedStrategy> newlyDetected = new HashSet<ObservedStrategy>();
        for (ObservedStrategy strategy : this.possibleStrategies) {
            if (!strategy.isDetected(this.tracker, currentTime)) continue;
            newlyDetected.add(strategy);
        }
        this.detectedStrategies.addAll(newlyDetected);
        this.possibleStrategies.removeAll(newlyDetected);
        HashSet<ObservedStrategy> newlyDiscarded = new HashSet<ObservedStrategy>();
        for (ObservedStrategy detected : this.detectedStrategies) {
            for (ObservedStrategy possible : this.possibleStrategies) {
                if (detected.isCompatibleStrategy(possible)) continue;
                newlyDiscarded.add(possible);
            }
        }
        this.possibleStrategies.removeAll(newlyDiscarded);
        this.discardedStrategies.addAll(newlyDiscarded);
    }

    public boolean isDetectedStrategy(String strategyName) {
        for (ObservedStrategy strategy : this.detectedStrategies) {
            if (!strategy.getName().equals(strategyName)) continue;
            return true;
        }
        return false;
    }

    public String getDetectedStrategiesAsString() {
        return this.detectedStrategies.stream().map(ObservedStrategy::getName).collect(Collectors.joining(";"));
    }

    @Generated
    public Set<ObservedStrategy> getDetectedStrategies() {
        return this.detectedStrategies;
    }
}

