/*
 * Decompiled with CFR 0.152.
 */
package info;

import bwapi.TechType;
import bwapi.UpgradeType;
import lombok.Generated;

public class TechProgression {
    private boolean spawningPool = false;
    private boolean hydraliskDen = false;
    private boolean lair = false;
    private boolean spire = false;
    private boolean queensNest = false;
    private boolean hive = false;
    private int evolutionChambers = 0;
    private boolean plannedSpawningPool = false;
    private boolean plannedDen = false;
    private boolean plannedLair = false;
    private boolean plannedSpire = false;
    private boolean plannedQueensNest = false;
    private boolean plannedHive = false;
    private int plannedEvolutionChambers = 0;
    private boolean lurker = false;
    private boolean metabolicBoost = false;
    private boolean muscularAugments = false;
    private boolean groovedSpines = false;
    private int carapaceUpgrades = 0;
    private int rangedUpgrades = 0;
    private int meleeUpgrades = 0;
    private int flyerAttack = 0;
    private int flyerDefense = 0;
    private boolean overlordSpeed = false;
    private boolean plannedOverlordSpeed = false;
    private boolean plannedLurker = false;
    private boolean plannedMetabolicBoost = false;
    private boolean plannedMuscularAugments = false;
    private boolean plannedGroovedSpines = false;
    private boolean plannedCarapaceUpgrades = false;
    private boolean plannedRangedUpgrades = false;
    private boolean plannedMeleeUpgrades = false;
    private boolean plannedFlyerAttack = false;
    private boolean plannedFlyerDefense = false;

    public boolean canPlanSunkenColony() {
        return this.spawningPool;
    }

    public boolean canPlanExtractor() {
        return this.spawningPool || this.plannedSpawningPool;
    }

    public boolean canPlanPool() {
        return !this.plannedSpawningPool && !this.spawningPool;
    }

    public boolean canPlanHydraliskDen() {
        return this.spawningPool && !this.plannedDen && !this.hydraliskDen;
    }

    public boolean canPlanLair() {
        return this.spawningPool && !this.plannedLair && !this.lair;
    }

    public boolean canPlanHive() {
        return this.queensNest && this.lair && !this.plannedHive && !this.hive;
    }

    public boolean canPlanSpire() {
        return this.lair && !this.plannedSpire && !this.spire;
    }

    public boolean canPlanQueensNest() {
        return this.lair && !this.plannedQueensNest && !this.queensNest;
    }

    public boolean canPlanMetabolicBoost() {
        return this.spawningPool && !this.plannedMetabolicBoost && !this.metabolicBoost;
    }

    public boolean canPlanMuscularAugments() {
        return this.hydraliskDen && !this.plannedMuscularAugments && !this.muscularAugments;
    }

    public boolean canPlanGroovedSpines() {
        return this.hydraliskDen && !this.plannedGroovedSpines && !this.groovedSpines;
    }

    public boolean canPlanLurker() {
        return this.hydraliskDen && this.lair && !this.plannedLurker && !this.lurker;
    }

    public boolean canPlanEvolutionChamber() {
        return this.spawningPool && this.plannedEvolutionChambers + this.evolutionChambers < 2;
    }

    public int evolutionChambers() {
        return this.plannedEvolutionChambers + this.evolutionChambers;
    }

    public boolean canPlanCarapaceUpgrades() {
        if (this.plannedCarapaceUpgrades) {
            return false;
        }
        if (this.evolutionChambers == 0) {
            return false;
        }
        if (this.carapaceUpgrades >= 3) {
            return false;
        }
        if (this.carapaceUpgrades == 2 && !this.hive) {
            return false;
        }
        return this.carapaceUpgrades != 1 || this.lair;
    }

    public boolean canPlanRangedUpgrades() {
        if (this.plannedRangedUpgrades) {
            return false;
        }
        if (this.evolutionChambers == 0) {
            return false;
        }
        if (this.rangedUpgrades >= 3) {
            return false;
        }
        if (this.rangedUpgrades == 2 && !this.hive) {
            return false;
        }
        return this.rangedUpgrades != 1 || this.lair;
    }

    public boolean canPlanMeleeUpgrades() {
        if (this.plannedMeleeUpgrades) {
            return false;
        }
        if (this.evolutionChambers == 0) {
            return false;
        }
        if (this.meleeUpgrades >= 3) {
            return false;
        }
        if (this.meleeUpgrades == 2 && !this.hive) {
            return false;
        }
        return this.meleeUpgrades != 1 || this.lair;
    }

    public boolean canPlanFlyerAttack() {
        if (this.plannedFlyerAttack) {
            return false;
        }
        if (!this.spire) {
            return false;
        }
        if (this.flyerAttack >= 3) {
            return false;
        }
        return this.flyerAttack != 2 || this.hive;
    }

    public boolean canPlanFlyerDefense() {
        if (this.plannedFlyerDefense) {
            return false;
        }
        if (!this.spire) {
            return false;
        }
        if (this.flyerDefense >= 3) {
            return false;
        }
        return this.flyerDefense != 2 || this.hive;
    }

    public boolean canPlanOverlordSpeed() {
        return !this.plannedOverlordSpeed && !this.overlordSpeed;
    }

    public void upgradeTech(TechType t) {
        if (TechType.Lurker_Aspect == t) {
            this.plannedLurker = false;
            this.lurker = true;
        }
    }

    public void upgradeTech(UpgradeType u) {
        switch (u) {
            case Metabolic_Boost: {
                this.metabolicBoost = true;
                this.plannedMetabolicBoost = false;
                break;
            }
            case Muscular_Augments: {
                this.muscularAugments = true;
                this.plannedMuscularAugments = false;
                break;
            }
            case Grooved_Spines: {
                this.groovedSpines = true;
                this.plannedGroovedSpines = false;
                break;
            }
            case Zerg_Carapace: {
                ++this.carapaceUpgrades;
                this.plannedCarapaceUpgrades = false;
                break;
            }
            case Zerg_Melee_Attacks: {
                ++this.meleeUpgrades;
                this.plannedMeleeUpgrades = false;
                break;
            }
            case Zerg_Missile_Attacks: {
                ++this.rangedUpgrades;
                this.plannedRangedUpgrades = false;
                break;
            }
            case Zerg_Flyer_Attacks: {
                ++this.flyerAttack;
                this.plannedFlyerAttack = false;
                break;
            }
            case Zerg_Flyer_Carapace: {
                ++this.flyerDefense;
                this.plannedFlyerDefense = false;
                break;
            }
            case Pneumatized_Carapace: {
                this.overlordSpeed = true;
                this.plannedOverlordSpeed = false;
                break;
            }
        }
    }

    public int evolutionChamberBuffer() {
        int buffer = 0;
        if (this.plannedCarapaceUpgrades) {
            buffer += UpgradeType.Zerg_Carapace.upgradeTime();
        }
        if (this.plannedRangedUpgrades) {
            buffer += UpgradeType.Zerg_Missile_Attacks.upgradeTime();
        }
        if (this.plannedMeleeUpgrades) {
            buffer += UpgradeType.Zerg_Melee_Attacks.upgradeTime();
        }
        return buffer;
    }

    public boolean needLairForNextEvolutionChamberUpgrades() {
        return this.meleeUpgrades + this.rangedUpgrades + this.carapaceUpgrades > 1;
    }

    public boolean needHiveForUpgrades() {
        return this.needHiveForNextEvolutionChamberUpgrades() || this.needHiveForSpireUpgrades();
    }

    private boolean needHiveForSpireUpgrades() {
        return this.flyerAttack + this.flyerDefense > 3;
    }

    private boolean needHiveForNextEvolutionChamberUpgrades() {
        return this.meleeUpgrades + this.rangedUpgrades + this.carapaceUpgrades > 3;
    }

    @Generated
    public boolean isSpawningPool() {
        return this.spawningPool;
    }

    @Generated
    public boolean isHydraliskDen() {
        return this.hydraliskDen;
    }

    @Generated
    public boolean isLair() {
        return this.lair;
    }

    @Generated
    public boolean isSpire() {
        return this.spire;
    }

    @Generated
    public boolean isQueensNest() {
        return this.queensNest;
    }

    @Generated
    public boolean isHive() {
        return this.hive;
    }

    @Generated
    public int getEvolutionChambers() {
        return this.evolutionChambers;
    }

    @Generated
    public boolean isPlannedSpawningPool() {
        return this.plannedSpawningPool;
    }

    @Generated
    public boolean isPlannedDen() {
        return this.plannedDen;
    }

    @Generated
    public boolean isPlannedLair() {
        return this.plannedLair;
    }

    @Generated
    public boolean isPlannedSpire() {
        return this.plannedSpire;
    }

    @Generated
    public boolean isPlannedQueensNest() {
        return this.plannedQueensNest;
    }

    @Generated
    public boolean isPlannedHive() {
        return this.plannedHive;
    }

    @Generated
    public int getPlannedEvolutionChambers() {
        return this.plannedEvolutionChambers;
    }

    @Generated
    public boolean isLurker() {
        return this.lurker;
    }

    @Generated
    public boolean isMetabolicBoost() {
        return this.metabolicBoost;
    }

    @Generated
    public boolean isMuscularAugments() {
        return this.muscularAugments;
    }

    @Generated
    public boolean isGroovedSpines() {
        return this.groovedSpines;
    }

    @Generated
    public int getCarapaceUpgrades() {
        return this.carapaceUpgrades;
    }

    @Generated
    public int getRangedUpgrades() {
        return this.rangedUpgrades;
    }

    @Generated
    public int getMeleeUpgrades() {
        return this.meleeUpgrades;
    }

    @Generated
    public int getFlyerAttack() {
        return this.flyerAttack;
    }

    @Generated
    public int getFlyerDefense() {
        return this.flyerDefense;
    }

    @Generated
    public boolean isOverlordSpeed() {
        return this.overlordSpeed;
    }

    @Generated
    public boolean isPlannedOverlordSpeed() {
        return this.plannedOverlordSpeed;
    }

    @Generated
    public boolean isPlannedLurker() {
        return this.plannedLurker;
    }

    @Generated
    public boolean isPlannedMetabolicBoost() {
        return this.plannedMetabolicBoost;
    }

    @Generated
    public boolean isPlannedMuscularAugments() {
        return this.plannedMuscularAugments;
    }

    @Generated
    public boolean isPlannedGroovedSpines() {
        return this.plannedGroovedSpines;
    }

    @Generated
    public boolean isPlannedCarapaceUpgrades() {
        return this.plannedCarapaceUpgrades;
    }

    @Generated
    public boolean isPlannedRangedUpgrades() {
        return this.plannedRangedUpgrades;
    }

    @Generated
    public boolean isPlannedMeleeUpgrades() {
        return this.plannedMeleeUpgrades;
    }

    @Generated
    public boolean isPlannedFlyerAttack() {
        return this.plannedFlyerAttack;
    }

    @Generated
    public boolean isPlannedFlyerDefense() {
        return this.plannedFlyerDefense;
    }

    @Generated
    public void setSpawningPool(boolean spawningPool) {
        this.spawningPool = spawningPool;
    }

    @Generated
    public void setHydraliskDen(boolean hydraliskDen) {
        this.hydraliskDen = hydraliskDen;
    }

    @Generated
    public void setLair(boolean lair) {
        this.lair = lair;
    }

    @Generated
    public void setSpire(boolean spire) {
        this.spire = spire;
    }

    @Generated
    public void setQueensNest(boolean queensNest) {
        this.queensNest = queensNest;
    }

    @Generated
    public void setHive(boolean hive) {
        this.hive = hive;
    }

    @Generated
    public void setEvolutionChambers(int evolutionChambers) {
        this.evolutionChambers = evolutionChambers;
    }

    @Generated
    public void setPlannedSpawningPool(boolean plannedSpawningPool) {
        this.plannedSpawningPool = plannedSpawningPool;
    }

    @Generated
    public void setPlannedDen(boolean plannedDen) {
        this.plannedDen = plannedDen;
    }

    @Generated
    public void setPlannedLair(boolean plannedLair) {
        this.plannedLair = plannedLair;
    }

    @Generated
    public void setPlannedSpire(boolean plannedSpire) {
        this.plannedSpire = plannedSpire;
    }

    @Generated
    public void setPlannedQueensNest(boolean plannedQueensNest) {
        this.plannedQueensNest = plannedQueensNest;
    }

    @Generated
    public void setPlannedHive(boolean plannedHive) {
        this.plannedHive = plannedHive;
    }

    @Generated
    public void setPlannedEvolutionChambers(int plannedEvolutionChambers) {
        this.plannedEvolutionChambers = plannedEvolutionChambers;
    }

    @Generated
    public void setLurker(boolean lurker) {
        this.lurker = lurker;
    }

    @Generated
    public void setMetabolicBoost(boolean metabolicBoost) {
        this.metabolicBoost = metabolicBoost;
    }

    @Generated
    public void setMuscularAugments(boolean muscularAugments) {
        this.muscularAugments = muscularAugments;
    }

    @Generated
    public void setGroovedSpines(boolean groovedSpines) {
        this.groovedSpines = groovedSpines;
    }

    @Generated
    public void setCarapaceUpgrades(int carapaceUpgrades) {
        this.carapaceUpgrades = carapaceUpgrades;
    }

    @Generated
    public void setRangedUpgrades(int rangedUpgrades) {
        this.rangedUpgrades = rangedUpgrades;
    }

    @Generated
    public void setMeleeUpgrades(int meleeUpgrades) {
        this.meleeUpgrades = meleeUpgrades;
    }

    @Generated
    public void setFlyerAttack(int flyerAttack) {
        this.flyerAttack = flyerAttack;
    }

    @Generated
    public void setFlyerDefense(int flyerDefense) {
        this.flyerDefense = flyerDefense;
    }

    @Generated
    public void setOverlordSpeed(boolean overlordSpeed) {
        this.overlordSpeed = overlordSpeed;
    }

    @Generated
    public void setPlannedOverlordSpeed(boolean plannedOverlordSpeed) {
        this.plannedOverlordSpeed = plannedOverlordSpeed;
    }

    @Generated
    public void setPlannedLurker(boolean plannedLurker) {
        this.plannedLurker = plannedLurker;
    }

    @Generated
    public void setPlannedMetabolicBoost(boolean plannedMetabolicBoost) {
        this.plannedMetabolicBoost = plannedMetabolicBoost;
    }

    @Generated
    public void setPlannedMuscularAugments(boolean plannedMuscularAugments) {
        this.plannedMuscularAugments = plannedMuscularAugments;
    }

    @Generated
    public void setPlannedGroovedSpines(boolean plannedGroovedSpines) {
        this.plannedGroovedSpines = plannedGroovedSpines;
    }

    @Generated
    public void setPlannedCarapaceUpgrades(boolean plannedCarapaceUpgrades) {
        this.plannedCarapaceUpgrades = plannedCarapaceUpgrades;
    }

    @Generated
    public void setPlannedRangedUpgrades(boolean plannedRangedUpgrades) {
        this.plannedRangedUpgrades = plannedRangedUpgrades;
    }

    @Generated
    public void setPlannedMeleeUpgrades(boolean plannedMeleeUpgrades) {
        this.plannedMeleeUpgrades = plannedMeleeUpgrades;
    }

    @Generated
    public void setPlannedFlyerAttack(boolean plannedFlyerAttack) {
        this.plannedFlyerAttack = plannedFlyerAttack;
    }

    @Generated
    public void setPlannedFlyerDefense(boolean plannedFlyerDefense) {
        this.plannedFlyerDefense = plannedFlyerDefense;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TechProgression)) {
            return false;
        }
        TechProgression other = (TechProgression)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isSpawningPool() != other.isSpawningPool()) {
            return false;
        }
        if (this.isHydraliskDen() != other.isHydraliskDen()) {
            return false;
        }
        if (this.isLair() != other.isLair()) {
            return false;
        }
        if (this.isSpire() != other.isSpire()) {
            return false;
        }
        if (this.isQueensNest() != other.isQueensNest()) {
            return false;
        }
        if (this.isHive() != other.isHive()) {
            return false;
        }
        if (this.getEvolutionChambers() != other.getEvolutionChambers()) {
            return false;
        }
        if (this.isPlannedSpawningPool() != other.isPlannedSpawningPool()) {
            return false;
        }
        if (this.isPlannedDen() != other.isPlannedDen()) {
            return false;
        }
        if (this.isPlannedLair() != other.isPlannedLair()) {
            return false;
        }
        if (this.isPlannedSpire() != other.isPlannedSpire()) {
            return false;
        }
        if (this.isPlannedQueensNest() != other.isPlannedQueensNest()) {
            return false;
        }
        if (this.isPlannedHive() != other.isPlannedHive()) {
            return false;
        }
        if (this.getPlannedEvolutionChambers() != other.getPlannedEvolutionChambers()) {
            return false;
        }
        if (this.isLurker() != other.isLurker()) {
            return false;
        }
        if (this.isMetabolicBoost() != other.isMetabolicBoost()) {
            return false;
        }
        if (this.isMuscularAugments() != other.isMuscularAugments()) {
            return false;
        }
        if (this.isGroovedSpines() != other.isGroovedSpines()) {
            return false;
        }
        if (this.getCarapaceUpgrades() != other.getCarapaceUpgrades()) {
            return false;
        }
        if (this.getRangedUpgrades() != other.getRangedUpgrades()) {
            return false;
        }
        if (this.getMeleeUpgrades() != other.getMeleeUpgrades()) {
            return false;
        }
        if (this.getFlyerAttack() != other.getFlyerAttack()) {
            return false;
        }
        if (this.getFlyerDefense() != other.getFlyerDefense()) {
            return false;
        }
        if (this.isOverlordSpeed() != other.isOverlordSpeed()) {
            return false;
        }
        if (this.isPlannedOverlordSpeed() != other.isPlannedOverlordSpeed()) {
            return false;
        }
        if (this.isPlannedLurker() != other.isPlannedLurker()) {
            return false;
        }
        if (this.isPlannedMetabolicBoost() != other.isPlannedMetabolicBoost()) {
            return false;
        }
        if (this.isPlannedMuscularAugments() != other.isPlannedMuscularAugments()) {
            return false;
        }
        if (this.isPlannedGroovedSpines() != other.isPlannedGroovedSpines()) {
            return false;
        }
        if (this.isPlannedCarapaceUpgrades() != other.isPlannedCarapaceUpgrades()) {
            return false;
        }
        if (this.isPlannedRangedUpgrades() != other.isPlannedRangedUpgrades()) {
            return false;
        }
        if (this.isPlannedMeleeUpgrades() != other.isPlannedMeleeUpgrades()) {
            return false;
        }
        if (this.isPlannedFlyerAttack() != other.isPlannedFlyerAttack()) {
            return false;
        }
        return this.isPlannedFlyerDefense() == other.isPlannedFlyerDefense();
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TechProgression;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSpawningPool() ? 79 : 97);
        result = result * 59 + (this.isHydraliskDen() ? 79 : 97);
        result = result * 59 + (this.isLair() ? 79 : 97);
        result = result * 59 + (this.isSpire() ? 79 : 97);
        result = result * 59 + (this.isQueensNest() ? 79 : 97);
        result = result * 59 + (this.isHive() ? 79 : 97);
        result = result * 59 + this.getEvolutionChambers();
        result = result * 59 + (this.isPlannedSpawningPool() ? 79 : 97);
        result = result * 59 + (this.isPlannedDen() ? 79 : 97);
        result = result * 59 + (this.isPlannedLair() ? 79 : 97);
        result = result * 59 + (this.isPlannedSpire() ? 79 : 97);
        result = result * 59 + (this.isPlannedQueensNest() ? 79 : 97);
        result = result * 59 + (this.isPlannedHive() ? 79 : 97);
        result = result * 59 + this.getPlannedEvolutionChambers();
        result = result * 59 + (this.isLurker() ? 79 : 97);
        result = result * 59 + (this.isMetabolicBoost() ? 79 : 97);
        result = result * 59 + (this.isMuscularAugments() ? 79 : 97);
        result = result * 59 + (this.isGroovedSpines() ? 79 : 97);
        result = result * 59 + this.getCarapaceUpgrades();
        result = result * 59 + this.getRangedUpgrades();
        result = result * 59 + this.getMeleeUpgrades();
        result = result * 59 + this.getFlyerAttack();
        result = result * 59 + this.getFlyerDefense();
        result = result * 59 + (this.isOverlordSpeed() ? 79 : 97);
        result = result * 59 + (this.isPlannedOverlordSpeed() ? 79 : 97);
        result = result * 59 + (this.isPlannedLurker() ? 79 : 97);
        result = result * 59 + (this.isPlannedMetabolicBoost() ? 79 : 97);
        result = result * 59 + (this.isPlannedMuscularAugments() ? 79 : 97);
        result = result * 59 + (this.isPlannedGroovedSpines() ? 79 : 97);
        result = result * 59 + (this.isPlannedCarapaceUpgrades() ? 79 : 97);
        result = result * 59 + (this.isPlannedRangedUpgrades() ? 79 : 97);
        result = result * 59 + (this.isPlannedMeleeUpgrades() ? 79 : 97);
        result = result * 59 + (this.isPlannedFlyerAttack() ? 79 : 97);
        result = result * 59 + (this.isPlannedFlyerDefense() ? 79 : 97);
        return result;
    }

    @Generated
    public String toString() {
        return "TechProgression(spawningPool=" + this.isSpawningPool() + ", hydraliskDen=" + this.isHydraliskDen() + ", lair=" + this.isLair() + ", spire=" + this.isSpire() + ", queensNest=" + this.isQueensNest() + ", hive=" + this.isHive() + ", evolutionChambers=" + this.getEvolutionChambers() + ", plannedSpawningPool=" + this.isPlannedSpawningPool() + ", plannedDen=" + this.isPlannedDen() + ", plannedLair=" + this.isPlannedLair() + ", plannedSpire=" + this.isPlannedSpire() + ", plannedQueensNest=" + this.isPlannedQueensNest() + ", plannedHive=" + this.isPlannedHive() + ", plannedEvolutionChambers=" + this.getPlannedEvolutionChambers() + ", lurker=" + this.isLurker() + ", metabolicBoost=" + this.isMetabolicBoost() + ", muscularAugments=" + this.isMuscularAugments() + ", groovedSpines=" + this.isGroovedSpines() + ", carapaceUpgrades=" + this.getCarapaceUpgrades() + ", rangedUpgrades=" + this.getRangedUpgrades() + ", meleeUpgrades=" + this.getMeleeUpgrades() + ", flyerAttack=" + this.getFlyerAttack() + ", flyerDefense=" + this.getFlyerDefense() + ", overlordSpeed=" + this.isOverlordSpeed() + ", plannedOverlordSpeed=" + this.isPlannedOverlordSpeed() + ", plannedLurker=" + this.isPlannedLurker() + ", plannedMetabolicBoost=" + this.isPlannedMetabolicBoost() + ", plannedMuscularAugments=" + this.isPlannedMuscularAugments() + ", plannedGroovedSpines=" + this.isPlannedGroovedSpines() + ", plannedCarapaceUpgrades=" + this.isPlannedCarapaceUpgrades() + ", plannedRangedUpgrades=" + this.isPlannedRangedUpgrades() + ", plannedMeleeUpgrades=" + this.isPlannedMeleeUpgrades() + ", plannedFlyerAttack=" + this.isPlannedFlyerAttack() + ", plannedFlyerDefense=" + this.isPlannedFlyerDefense() + ")";
    }

    @Generated
    public TechProgression() {
    }
}

