/*
 * Decompiled with CFR 0.152.
 */
package info;

import bwapi.Game;
import bwapi.Player;
import bwapi.Position;
import bwapi.Race;
import bwapi.TechType;
import bwapi.TilePosition;
import bwapi.Unit;
import bwapi.UnitType;
import bwapi.UpgradeType;
import bwem.BWEM;
import bwem.Base;
import bwem.Mineral;
import config.Config;
import info.BaseData;
import info.ResourceCount;
import info.ScoutData;
import info.TechProgression;
import info.UnitTypeCount;
import info.map.BuildingPlanner;
import info.map.GameMap;
import info.tracking.ObservedUnitTracker;
import info.tracking.StrategyTracker;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import learning.Decisions;
import lombok.Generated;
import macro.plan.Plan;
import macro.plan.PlanState;
import strategy.buildorder.BuildOrder;
import unit.managed.ManagedUnit;
import util.Time;

public class GameState {
    private Game game;
    private Config config;
    private Player self;
    private BWEM bwem;
    private Race opponentRace;
    private int mineralWorkers;
    private int geyserWorkers;
    private int larvaDeadlockDetectedFrame;
    private HashMap<Unit, ManagedUnit> managedUnitLookup = new HashMap();
    private HashSet<ManagedUnit> managedUnits = new HashSet();
    private HashSet<ManagedUnit> assignedManagedWorkers = new HashSet();
    private HashSet<ManagedUnit> gatherers = new HashSet();
    private HashSet<ManagedUnit> mineralGatherers = new HashSet();
    private HashSet<ManagedUnit> gasGatherers = new HashSet();
    private HashMap<Unit, HashSet<ManagedUnit>> geyserAssignments = new HashMap();
    private HashMap<Unit, HashSet<ManagedUnit>> mineralAssignments = new HashMap();
    private HashSet<ManagedUnit> larva = new HashSet();
    private boolean enemyHasCloakedUnits = false;
    private boolean enemyHasHostileFlyers = false;
    private boolean isLarvaDeadlocked = false;
    private boolean isAllIn = false;
    private HashSet<Plan> plansScheduled = new HashSet();
    private HashSet<Plan> plansBuilding = new HashSet();
    private HashSet<Plan> plansMorphing = new HashSet();
    private HashSet<Plan> plansComplete = new HashSet();
    private HashSet<Plan> plansImpossible = new HashSet();
    private HashMap<Unit, Plan> assignedPlannedItems = new HashMap();
    private int plannedWorkers;
    private int plannedHatcheries = 1;
    private HashMap<Base, HashSet<ManagedUnit>> gatherersAssignedToBase = new HashMap();
    private HashMap<Base, HashSet<Unit>> baseToThreatLookup = new HashMap();
    private boolean defensiveSunk = false;
    private BuildOrder activeBuildOrder;
    private boolean transitionBuildOrder = false;
    private UnitTypeCount unitTypeCount = new UnitTypeCount();
    private TechProgression techProgression = new TechProgression();
    private ResourceCount resourceCount;
    private BaseData baseData;
    private ScoutData scoutData;
    private ObservedUnitTracker observedUnitTracker = new ObservedUnitTracker();
    private StrategyTracker strategyTracker;
    private GameMap gameMap;
    private BuildingPlanner buildingPlanner;

    public GameState(Game game, BWEM bwem) {
        this.game = game;
        this.self = game.self();
        this.bwem = bwem;
        this.resourceCount = new ResourceCount(this.self);
        this.baseData = new BaseData(bwem.getMap().getBases());
        this.scoutData = new ScoutData();
        this.config = new Config();
    }

    public void onStart(Decisions decisions, Race opponentRace) {
        this.activeBuildOrder = decisions.getOpener();
        this.opponentRace = opponentRace;
        this.strategyTracker = new StrategyTracker(this.game, opponentRace, this.observedUnitTracker);
    }

    public void onFrame() {
        this.strategyTracker.onFrame();
        this.clearVisibleEnemyWorkerLocations();
    }

    private void clearVisibleEnemyWorkerLocations() {
        Set<Position> lastKnownWorkerPositions = this.observedUnitTracker.getLastKnownPositionsOfLivingUnits(UnitType.Terran_SCV, UnitType.Protoss_Probe, UnitType.Zerg_Drone);
        Set<Position> visibleWorkerPositions = lastKnownWorkerPositions.stream().filter(p -> p != null).filter(p -> this.game.isVisible(p.toTilePosition())).collect(Collectors.toSet());
        if (!visibleWorkerPositions.isEmpty()) {
            this.observedUnitTracker.clearLastKnownLocationsAt(visibleWorkerPositions);
        }
    }

    public int numGatherers() {
        return this.gatherers.size();
    }

    public int numLarva() {
        return this.larva.size();
    }

    public int frameCanAffordUnit(UnitType unit, int currentFrame) {
        return this.resourceCount.frameCanAffordUnit(unit, currentFrame, this.mineralGatherers.size(), this.gasGatherers.size());
    }

    public Base reserveBase() {
        return this.baseData.reserveBase();
    }

    public void claimBase(Unit hatchery) {
        if (this.baseData.isBase(hatchery)) {
            return;
        }
        Base newBase = this.baseData.claimBase(hatchery);
        this.addBaseToGameState(hatchery, newBase);
    }

    public void addBaseToGameState(Unit hatchery, Base base) {
        if (base == null) {
            return;
        }
        this.gatherersAssignedToBase.put(base, new HashSet());
        this.baseData.addBase(hatchery, base);
        for (Mineral mineral : base.getMinerals()) {
            this.mineralAssignments.put(mineral.getUnit(), new HashSet());
        }
    }

    public void addMainBase(Unit hatchery, Base base) {
        this.baseData.initializeMainBase(base, this.gameMap);
        this.addBaseToGameState(hatchery, base);
    }

    public void addMacroHatchery(Unit hatchery) {
        this.baseData.addMacroHatchery(hatchery);
    }

    public void removeHatchery(Unit hatchery) {
        if (this.baseData.isBase(hatchery)) {
            Base base = this.baseData.get(hatchery);
            this.gatherersAssignedToBase.remove(base);
            this.baseToThreatLookup.remove(base);
        }
        this.baseData.removeHatchery(hatchery);
    }

    public void cancelPlan(Unit unit, Plan plan) {
        this.plansBuilding.remove(plan);
        this.plansMorphing.remove(plan);
        this.plansImpossible.remove(plan);
        plan.setState(PlanState.CANCELLED);
        this.assignedPlannedItems.remove(unit);
        switch (plan.getType()) {
            case UNIT: {
                this.unitTypeCount.unplanUnit(plan.getPlannedUnit());
                this.resourceCount.unreserveUnit(plan.getPlannedUnit());
                break;
            }
            case BUILDING: {
                TilePosition tp;
                UnitType buildingType = plan.getPlannedUnit();
                this.unitTypeCount.unplanUnit(buildingType);
                this.resourceCount.unreserveUnit(buildingType);
                if (plan.getBuildPosition() != null) {
                    this.buildingPlanner.unreservePlannedBuildingTiles(plan.getBuildPosition(), buildingType);
                }
                if ((tp = plan.getBuildPosition()) != null && this.baseData.isBaseTilePosition(tp)) {
                    Base base = this.baseData.baseAtTilePosition(tp);
                    this.baseData.cancelReserveBase(base);
                }
                this.clearPlannedTechFlags(buildingType);
                break;
            }
            case UPGRADE: {
                this.resourceCount.unreserveUpgrade(plan.getPlannedUpgrade());
                this.clearPlannedUpgradeFlags(plan.getPlannedUpgrade());
                break;
            }
            case TECH: {
                this.resourceCount.unreserveTechResearch(plan.getPlannedTechType());
                this.clearPlannedTechResearchFlags(plan.getPlannedTechType());
            }
        }
    }

    private void clearPlannedTechFlags(UnitType buildingType) {
        switch (buildingType) {
            case Zerg_Spawning_Pool: {
                this.techProgression.setPlannedSpawningPool(false);
                break;
            }
            case Zerg_Hydralisk_Den: {
                this.techProgression.setPlannedDen(false);
                break;
            }
            case Zerg_Lair: {
                this.techProgression.setPlannedLair(false);
                break;
            }
            case Zerg_Spire: {
                this.techProgression.setPlannedSpire(false);
                break;
            }
            case Zerg_Queens_Nest: {
                this.techProgression.setPlannedQueensNest(false);
                break;
            }
            case Zerg_Hive: {
                this.techProgression.setPlannedHive(false);
                break;
            }
            case Zerg_Evolution_Chamber: {
                this.techProgression.setPlannedEvolutionChambers(this.techProgression.getPlannedEvolutionChambers() - 1);
            }
        }
    }

    private void clearPlannedUpgradeFlags(UpgradeType upgradeType) {
        switch (upgradeType) {
            case Metabolic_Boost: {
                this.techProgression.setPlannedMetabolicBoost(false);
                break;
            }
            case Muscular_Augments: {
                this.techProgression.setPlannedMuscularAugments(false);
                break;
            }
            case Grooved_Spines: {
                this.techProgression.setPlannedGroovedSpines(false);
                break;
            }
            case Zerg_Carapace: {
                this.techProgression.setPlannedCarapaceUpgrades(false);
                break;
            }
            case Zerg_Missile_Attacks: {
                this.techProgression.setPlannedRangedUpgrades(false);
                break;
            }
            case Zerg_Melee_Attacks: {
                this.techProgression.setPlannedMeleeUpgrades(false);
                break;
            }
            case Zerg_Flyer_Attacks: {
                this.techProgression.setPlannedFlyerAttack(false);
                break;
            }
            case Zerg_Flyer_Carapace: {
                this.techProgression.setPlannedFlyerDefense(false);
                break;
            }
            case Pneumatized_Carapace: {
                this.techProgression.setPlannedOverlordSpeed(false);
            }
        }
    }

    private void clearPlannedTechResearchFlags(TechType techType) {
        switch (techType) {
            case Lurker_Aspect: {
                this.techProgression.setPlannedLurker(false);
            }
        }
    }

    public void completePlan(Unit unit, Plan plan) {
        this.plansBuilding.remove(plan);
        this.plansMorphing.remove(plan);
        plan.setState(PlanState.COMPLETE);
        this.plansComplete.add(plan);
        this.assignedPlannedItems.remove(unit);
    }

    public void setImpossiblePlan(Plan plan) {
        this.plansImpossible.add(plan);
        switch (plan.getType()) {
            case UNIT: {
                this.unitTypeCount.unplanUnit(plan.getPlannedUnit());
                this.resourceCount.unreserveUnit(plan.getPlannedUnit());
                break;
            }
            case BUILDING: {
                this.unitTypeCount.unplanUnit(plan.getPlannedUnit());
                this.resourceCount.unreserveUnit(plan.getPlannedUnit());
                UnitType buildingType = plan.getPlannedUnit();
                if (buildingType != UnitType.Zerg_Hatchery) break;
                this.removePlannedHatchery(1);
            }
        }
    }

    public boolean canPlanLair() {
        return this.needLair() && this.techProgression.canPlanLair() && this.hasMinHatchForLair() && this.ourUnitCount(UnitType.Zerg_Extractor) > 0;
    }

    public boolean canPlanHive() {
        return this.needHive() && this.techProgression.canPlanHive();
    }

    public boolean canPlanQueensNest() {
        return this.needHive() && this.techProgression.canPlanQueensNest();
    }

    private boolean needLair() {
        return this.activeBuildOrder.needLair() || this.techProgression.needLairForNextEvolutionChamberUpgrades() || this.needHive();
    }

    private boolean needHive() {
        return this.techProgression.needHiveForUpgrades();
    }

    private boolean hasMinHatchForLair() {
        int numHatch = this.baseData.numHatcheries();
        if (this.opponentRace == Race.Zerg) {
            return numHatch > 0;
        }
        return numHatch > 1;
    }

    public boolean needGeyserWorkers() {
        return this.getGeyserWorkers() < 3 * this.getGeyserAssignments().size();
    }

    public int needGeyserWorkersAmount() {
        return 3 * this.getGeyserAssignments().size() - this.getGeyserWorkers();
    }

    public void clearAssignments(ManagedUnit managedUnit) {
        if (this.assignedManagedWorkers.contains(managedUnit)) {
            for (HashSet<ManagedUnit> mineralWorkers : this.mineralAssignments.values()) {
                if (!mineralWorkers.contains(managedUnit)) continue;
                --this.mineralWorkers;
                mineralWorkers.remove(managedUnit);
            }
            for (HashSet<ManagedUnit> geyserWorkers : this.geyserAssignments.values()) {
                if (!geyserWorkers.contains(managedUnit)) continue;
                --this.geyserWorkers;
                geyserWorkers.remove(managedUnit);
            }
        }
        this.larva.remove(managedUnit);
        this.gatherers.remove(managedUnit);
        this.mineralGatherers.remove(managedUnit);
        this.gasGatherers.remove(managedUnit);
        this.assignedManagedWorkers.remove(managedUnit);
        for (HashSet<ManagedUnit> managedUnitAssignments : this.gatherersAssignedToBase.values()) {
            managedUnitAssignments.remove(managedUnit);
        }
    }

    public List<ManagedUnit> getManagedUnitsByType(UnitType type) {
        return this.managedUnits.stream().filter(m -> m.getUnitType() == type).collect(Collectors.toList());
    }

    public void updateRace(Race race) {
        this.opponentRace = race;
        this.strategyTracker.updateRace(race);
    }

    public Time getGameTime() {
        return new Time(this.game.getFrameCount());
    }

    public void addPlannedWorker(int numWorkers) {
        this.plannedWorkers += numWorkers;
    }

    public void removePlannedWorker(int numWorkers) {
        this.plannedWorkers -= numWorkers;
    }

    public void addPlannedHatchery(int numHatcheries) {
        this.plannedHatcheries += numHatcheries;
    }

    public void removePlannedHatchery(int numHatcheries) {
        this.plannedHatcheries -= numHatcheries;
    }

    public boolean canPlanDrone() {
        int expectedWorkers = this.expectedWorkers();
        int hatchCount = this.ourUnitCount(UnitType.Zerg_Hatchery, UnitType.Zerg_Lair, UnitType.Zerg_Hive);
        int plannedWorkerConstraint = hatchCount * 3;
        return this.plannedWorkers < plannedWorkerConstraint && this.numWorkers() < 80 && this.numWorkers() < expectedWorkers;
    }

    public int numWorkers() {
        return this.mineralWorkers + this.geyserWorkers;
    }

    private int expectedWorkers() {
        int base = 5;
        int expectedMineralWorkers = this.baseData.currentBaseCount() * 7;
        int expectedGasWorkers = this.geyserAssignments.size() * 3;
        Race race = this.opponentRace;
        switch (race) {
            case Zerg: {
                return expectedMineralWorkers + expectedGasWorkers;
            }
        }
        return 5 + expectedMineralWorkers + expectedGasWorkers;
    }

    public boolean canPlanExtractor() {
        return !this.isAllIn && this.techProgression.canPlanExtractor() && this.baseData.canReserveExtractor() && (this.baseData.numExtractor() < 1 || this.needExtractor());
    }

    private boolean needExtractor() {
        return this.baseData.numExtractor() < 1 || this.resourceCount.needExtractor();
    }

    public int ourUnitCount(UnitType unitType) {
        return this.unitTypeCount.get(unitType);
    }

    public int ourMorphingCount(UnitType unitType) {
        return (int)this.plansMorphing.stream().filter(plan -> plan.getPlannedUnit() == unitType).count();
    }

    public int ourLivingUnitCount(UnitType unitType) {
        return this.unitTypeCount.livingCount(unitType);
    }

    public int ourUnitCount(UnitType ... unitTypes) {
        int i = 0;
        UnitType[] unitTypeArray = unitTypes;
        int n = unitTypes.length;
        int n2 = 0;
        while (n2 < n) {
            UnitType unitType = unitTypeArray[n2];
            i += this.ourUnitCount(unitType);
            ++n2;
        }
        return i;
    }

    public int enemyUnitCount(UnitType unitType) {
        return this.observedUnitTracker.getCountOfLivingUnits(unitType);
    }

    public int getSupply() {
        return this.game.self().supplyUsed();
    }

    public TilePosition getTechBuildingLocation(UnitType unitType) {
        Base main = this.baseData.getMainBase();
        TilePosition position = this.buildingPlanner.getLocationForTechBuilding(main, unitType);
        this.buildingPlanner.reservePlannedBuildingTiles(position, unitType);
        return position;
    }

    public Set<Base> basesNeedingSunken(int target) {
        HashSet<Base> neededBases = new HashSet<Base>();
        for (Base base : this.baseData.getMyBases()) {
            if (!this.baseData.isEligibleForSunkenColony(base) || this.baseData.sunkensPerBase(base) >= target) continue;
            neededBases.add(base);
        }
        return neededBases;
    }

    public boolean canPlanUnit(UnitType unitType) {
        switch (unitType) {
            case Zerg_Zergling: {
                return this.techProgression.isSpawningPool();
            }
        }
        return false;
    }

    public boolean canPlanUpgrade(UpgradeType upgradeType) {
        switch (upgradeType) {
            case Metabolic_Boost: {
                return this.ourUnitCount(UnitType.Zerg_Extractor) > 0 && this.techProgression.isSpawningPool() && this.techProgression.canPlanMetabolicBoost();
            }
        }
        return false;
    }

    public Set<Position> getAerielStaticDefenseCoverage() {
        HashSet<Position> coveredPositions = new HashSet<Position>();
        HashMap<UnitType, Integer> staticDefenseRanges = new HashMap<UnitType, Integer>();
        switch (this.opponentRace) {
            case Terran: {
                staticDefenseRanges.put(UnitType.Terran_Missile_Turret, UnitType.Terran_Missile_Turret.airWeapon().maxRange() + 32);
                staticDefenseRanges.put(UnitType.Terran_Bunker, UnitType.Terran_Marine.groundWeapon().maxRange() + 64);
                break;
            }
            case Protoss: {
                staticDefenseRanges.put(UnitType.Protoss_Photon_Cannon, UnitType.Protoss_Photon_Cannon.groundWeapon().maxRange() + 32);
                break;
            }
            case Zerg: {
                staticDefenseRanges.put(UnitType.Zerg_Spore_Colony, UnitType.Zerg_Spore_Colony.airWeapon().maxRange() + 32);
                break;
            }
            default: {
                return coveredPositions;
            }
        }
        for (Map.Entry entry : staticDefenseRanges.entrySet()) {
            UnitType defenseType = (UnitType)((Object)entry.getKey());
            int range = (Integer)entry.getValue();
            Set<Position> defensePositions = this.observedUnitTracker.getLastKnownPositionsOfLivingUnits(defenseType);
            for (Position defensePos : defensePositions) {
                if (defensePos == null) continue;
                int x = defensePos.getX() - range;
                while (x <= defensePos.getX() + range) {
                    int y = defensePos.getY() - range;
                    while (y <= defensePos.getY() + range) {
                        Position testPos = new Position(x, y);
                        double distance = Math.sqrt(Math.pow(x - defensePos.getX(), 2.0) + Math.pow(y - defensePos.getY(), 2.0));
                        if (distance <= (double)range) {
                            coveredPositions.add(testPos);
                        }
                        y += 8;
                    }
                    x += 8;
                }
            }
        }
        return coveredPositions;
    }

    public Set<Position> getStaticDefenseCoverage() {
        HashSet<Position> coveredPositions = new HashSet<Position>();
        HashMap<UnitType, Integer> staticDefenseRanges = new HashMap<UnitType, Integer>();
        switch (this.opponentRace) {
            case Terran: {
                staticDefenseRanges.put(UnitType.Terran_Missile_Turret, UnitType.Terran_Missile_Turret.airWeapon().maxRange());
                staticDefenseRanges.put(UnitType.Terran_Bunker, UnitType.Terran_Marine.groundWeapon().maxRange() + 32);
                break;
            }
            case Protoss: {
                staticDefenseRanges.put(UnitType.Protoss_Photon_Cannon, UnitType.Protoss_Photon_Cannon.groundWeapon().maxRange());
                break;
            }
            case Zerg: {
                staticDefenseRanges.put(UnitType.Zerg_Spore_Colony, UnitType.Zerg_Spore_Colony.airWeapon().maxRange());
                staticDefenseRanges.put(UnitType.Zerg_Sunken_Colony, UnitType.Zerg_Sunken_Colony.groundWeapon().maxRange());
                break;
            }
            default: {
                return coveredPositions;
            }
        }
        for (Map.Entry entry : staticDefenseRanges.entrySet()) {
            UnitType defenseType = (UnitType)((Object)entry.getKey());
            int range = (Integer)entry.getValue();
            Set<Position> defensePositions = this.observedUnitTracker.getLastKnownPositionsOfLivingUnits(defenseType);
            for (Position defensePos : defensePositions) {
                if (defensePos == null) continue;
                int x = defensePos.getX() - range;
                while (x <= defensePos.getX() + range) {
                    int y = defensePos.getY() - range;
                    while (y <= defensePos.getY() + range) {
                        Position testPos = new Position(x, y);
                        double distance = Math.sqrt(Math.pow(x - defensePos.getX(), 2.0) + Math.pow(y - defensePos.getY(), 2.0));
                        if (distance <= (double)range) {
                            coveredPositions.add(testPos);
                        }
                        y += 8;
                    }
                    x += 8;
                }
            }
        }
        return coveredPositions;
    }

    public Set<Position> getLastKnownLocationOfEnemyWorkers() {
        switch (this.opponentRace) {
            case Terran: {
                return this.observedUnitTracker.getLastKnownPositionsOfLivingUnits(UnitType.Terran_SCV);
            }
            case Zerg: {
                return this.observedUnitTracker.getLastKnownPositionsOfLivingUnits(UnitType.Zerg_Drone);
            }
            case Protoss: {
                return this.observedUnitTracker.getLastKnownPositionsOfLivingUnits(UnitType.Protoss_Probe);
            }
        }
        return new HashSet<Position>();
    }

    public Set<Unit> getDetectedEnemyUnits() {
        return this.observedUnitTracker.getDetectedUnits();
    }

    public Set<Unit> getEnemyBuildings() {
        return this.observedUnitTracker.getBuilding();
    }

    public Set<Position> getLastKnownPositionsOfBuildings() {
        return this.observedUnitTracker.getLastKnownPositionsOfBuildings();
    }

    public Set<Unit> getVisibleEnemyUnits() {
        return this.observedUnitTracker.getVisibleEnemyUnits();
    }

    public Position getSquadRallyPoint() {
        if (this.baseData.hasNaturalExpansion()) {
            return this.baseData.naturalExpansionPosition().toPosition();
        }
        return this.baseData.mainBasePosition().toPosition();
    }

    public int enemyResourceDepotCount() {
        switch (this.opponentRace) {
            case Terran: {
                return this.enemyUnitCount(UnitType.Terran_Command_Center);
            }
            case Protoss: {
                return this.enemyUnitCount(UnitType.Protoss_Nexus);
            }
            case Zerg: {
                return this.enemyUnitCount(UnitType.Zerg_Hatchery) + this.enemyUnitCount(UnitType.Zerg_Lair) + this.enemyUnitCount(UnitType.Zerg_Hive);
            }
        }
        return 0;
    }

    @Generated
    public Game getGame() {
        return this.game;
    }

    @Generated
    public Config getConfig() {
        return this.config;
    }

    @Generated
    public Player getSelf() {
        return this.self;
    }

    @Generated
    public BWEM getBwem() {
        return this.bwem;
    }

    @Generated
    public Race getOpponentRace() {
        return this.opponentRace;
    }

    @Generated
    public int getMineralWorkers() {
        return this.mineralWorkers;
    }

    @Generated
    public int getGeyserWorkers() {
        return this.geyserWorkers;
    }

    @Generated
    public int getLarvaDeadlockDetectedFrame() {
        return this.larvaDeadlockDetectedFrame;
    }

    @Generated
    public HashMap<Unit, ManagedUnit> getManagedUnitLookup() {
        return this.managedUnitLookup;
    }

    @Generated
    public HashSet<ManagedUnit> getManagedUnits() {
        return this.managedUnits;
    }

    @Generated
    public HashSet<ManagedUnit> getAssignedManagedWorkers() {
        return this.assignedManagedWorkers;
    }

    @Generated
    public HashSet<ManagedUnit> getGatherers() {
        return this.gatherers;
    }

    @Generated
    public HashSet<ManagedUnit> getMineralGatherers() {
        return this.mineralGatherers;
    }

    @Generated
    public HashSet<ManagedUnit> getGasGatherers() {
        return this.gasGatherers;
    }

    @Generated
    public HashMap<Unit, HashSet<ManagedUnit>> getGeyserAssignments() {
        return this.geyserAssignments;
    }

    @Generated
    public HashMap<Unit, HashSet<ManagedUnit>> getMineralAssignments() {
        return this.mineralAssignments;
    }

    @Generated
    public HashSet<ManagedUnit> getLarva() {
        return this.larva;
    }

    @Generated
    public boolean isEnemyHasCloakedUnits() {
        return this.enemyHasCloakedUnits;
    }

    @Generated
    public boolean isEnemyHasHostileFlyers() {
        return this.enemyHasHostileFlyers;
    }

    @Generated
    public boolean isLarvaDeadlocked() {
        return this.isLarvaDeadlocked;
    }

    @Generated
    public boolean isAllIn() {
        return this.isAllIn;
    }

    @Generated
    public HashSet<Plan> getPlansScheduled() {
        return this.plansScheduled;
    }

    @Generated
    public HashSet<Plan> getPlansBuilding() {
        return this.plansBuilding;
    }

    @Generated
    public HashSet<Plan> getPlansMorphing() {
        return this.plansMorphing;
    }

    @Generated
    public HashSet<Plan> getPlansComplete() {
        return this.plansComplete;
    }

    @Generated
    public HashSet<Plan> getPlansImpossible() {
        return this.plansImpossible;
    }

    @Generated
    public HashMap<Unit, Plan> getAssignedPlannedItems() {
        return this.assignedPlannedItems;
    }

    @Generated
    public int getPlannedWorkers() {
        return this.plannedWorkers;
    }

    @Generated
    public int getPlannedHatcheries() {
        return this.plannedHatcheries;
    }

    @Generated
    public HashMap<Base, HashSet<ManagedUnit>> getGatherersAssignedToBase() {
        return this.gatherersAssignedToBase;
    }

    @Generated
    public HashMap<Base, HashSet<Unit>> getBaseToThreatLookup() {
        return this.baseToThreatLookup;
    }

    @Generated
    public boolean isDefensiveSunk() {
        return this.defensiveSunk;
    }

    @Generated
    public BuildOrder getActiveBuildOrder() {
        return this.activeBuildOrder;
    }

    @Generated
    public boolean isTransitionBuildOrder() {
        return this.transitionBuildOrder;
    }

    @Generated
    public UnitTypeCount getUnitTypeCount() {
        return this.unitTypeCount;
    }

    @Generated
    public TechProgression getTechProgression() {
        return this.techProgression;
    }

    @Generated
    public ResourceCount getResourceCount() {
        return this.resourceCount;
    }

    @Generated
    public BaseData getBaseData() {
        return this.baseData;
    }

    @Generated
    public ScoutData getScoutData() {
        return this.scoutData;
    }

    @Generated
    public ObservedUnitTracker getObservedUnitTracker() {
        return this.observedUnitTracker;
    }

    @Generated
    public StrategyTracker getStrategyTracker() {
        return this.strategyTracker;
    }

    @Generated
    public GameMap getGameMap() {
        return this.gameMap;
    }

    @Generated
    public BuildingPlanner getBuildingPlanner() {
        return this.buildingPlanner;
    }

    @Generated
    public void setGame(Game game) {
        this.game = game;
    }

    @Generated
    public void setConfig(Config config) {
        this.config = config;
    }

    @Generated
    public void setSelf(Player self) {
        this.self = self;
    }

    @Generated
    public void setBwem(BWEM bwem) {
        this.bwem = bwem;
    }

    @Generated
    public void setOpponentRace(Race opponentRace) {
        this.opponentRace = opponentRace;
    }

    @Generated
    public void setMineralWorkers(int mineralWorkers) {
        this.mineralWorkers = mineralWorkers;
    }

    @Generated
    public void setGeyserWorkers(int geyserWorkers) {
        this.geyserWorkers = geyserWorkers;
    }

    @Generated
    public void setLarvaDeadlockDetectedFrame(int larvaDeadlockDetectedFrame) {
        this.larvaDeadlockDetectedFrame = larvaDeadlockDetectedFrame;
    }

    @Generated
    public void setManagedUnitLookup(HashMap<Unit, ManagedUnit> managedUnitLookup) {
        this.managedUnitLookup = managedUnitLookup;
    }

    @Generated
    public void setManagedUnits(HashSet<ManagedUnit> managedUnits) {
        this.managedUnits = managedUnits;
    }

    @Generated
    public void setAssignedManagedWorkers(HashSet<ManagedUnit> assignedManagedWorkers) {
        this.assignedManagedWorkers = assignedManagedWorkers;
    }

    @Generated
    public void setGatherers(HashSet<ManagedUnit> gatherers) {
        this.gatherers = gatherers;
    }

    @Generated
    public void setMineralGatherers(HashSet<ManagedUnit> mineralGatherers) {
        this.mineralGatherers = mineralGatherers;
    }

    @Generated
    public void setGasGatherers(HashSet<ManagedUnit> gasGatherers) {
        this.gasGatherers = gasGatherers;
    }

    @Generated
    public void setGeyserAssignments(HashMap<Unit, HashSet<ManagedUnit>> geyserAssignments) {
        this.geyserAssignments = geyserAssignments;
    }

    @Generated
    public void setMineralAssignments(HashMap<Unit, HashSet<ManagedUnit>> mineralAssignments) {
        this.mineralAssignments = mineralAssignments;
    }

    @Generated
    public void setLarva(HashSet<ManagedUnit> larva) {
        this.larva = larva;
    }

    @Generated
    public void setEnemyHasCloakedUnits(boolean enemyHasCloakedUnits) {
        this.enemyHasCloakedUnits = enemyHasCloakedUnits;
    }

    @Generated
    public void setEnemyHasHostileFlyers(boolean enemyHasHostileFlyers) {
        this.enemyHasHostileFlyers = enemyHasHostileFlyers;
    }

    @Generated
    public void setLarvaDeadlocked(boolean isLarvaDeadlocked) {
        this.isLarvaDeadlocked = isLarvaDeadlocked;
    }

    @Generated
    public void setAllIn(boolean isAllIn) {
        this.isAllIn = isAllIn;
    }

    @Generated
    public void setPlansScheduled(HashSet<Plan> plansScheduled) {
        this.plansScheduled = plansScheduled;
    }

    @Generated
    public void setPlansBuilding(HashSet<Plan> plansBuilding) {
        this.plansBuilding = plansBuilding;
    }

    @Generated
    public void setPlansMorphing(HashSet<Plan> plansMorphing) {
        this.plansMorphing = plansMorphing;
    }

    @Generated
    public void setPlansComplete(HashSet<Plan> plansComplete) {
        this.plansComplete = plansComplete;
    }

    @Generated
    public void setPlansImpossible(HashSet<Plan> plansImpossible) {
        this.plansImpossible = plansImpossible;
    }

    @Generated
    public void setAssignedPlannedItems(HashMap<Unit, Plan> assignedPlannedItems) {
        this.assignedPlannedItems = assignedPlannedItems;
    }

    @Generated
    public void setPlannedWorkers(int plannedWorkers) {
        this.plannedWorkers = plannedWorkers;
    }

    @Generated
    public void setPlannedHatcheries(int plannedHatcheries) {
        this.plannedHatcheries = plannedHatcheries;
    }

    @Generated
    public void setGatherersAssignedToBase(HashMap<Base, HashSet<ManagedUnit>> gatherersAssignedToBase) {
        this.gatherersAssignedToBase = gatherersAssignedToBase;
    }

    @Generated
    public void setBaseToThreatLookup(HashMap<Base, HashSet<Unit>> baseToThreatLookup) {
        this.baseToThreatLookup = baseToThreatLookup;
    }

    @Generated
    public void setDefensiveSunk(boolean defensiveSunk) {
        this.defensiveSunk = defensiveSunk;
    }

    @Generated
    public void setActiveBuildOrder(BuildOrder activeBuildOrder) {
        this.activeBuildOrder = activeBuildOrder;
    }

    @Generated
    public void setTransitionBuildOrder(boolean transitionBuildOrder) {
        this.transitionBuildOrder = transitionBuildOrder;
    }

    @Generated
    public void setUnitTypeCount(UnitTypeCount unitTypeCount) {
        this.unitTypeCount = unitTypeCount;
    }

    @Generated
    public void setTechProgression(TechProgression techProgression) {
        this.techProgression = techProgression;
    }

    @Generated
    public void setResourceCount(ResourceCount resourceCount) {
        this.resourceCount = resourceCount;
    }

    @Generated
    public void setBaseData(BaseData baseData) {
        this.baseData = baseData;
    }

    @Generated
    public void setScoutData(ScoutData scoutData) {
        this.scoutData = scoutData;
    }

    @Generated
    public void setObservedUnitTracker(ObservedUnitTracker observedUnitTracker) {
        this.observedUnitTracker = observedUnitTracker;
    }

    @Generated
    public void setStrategyTracker(StrategyTracker strategyTracker) {
        this.strategyTracker = strategyTracker;
    }

    @Generated
    public void setGameMap(GameMap gameMap) {
        this.gameMap = gameMap;
    }

    @Generated
    public void setBuildingPlanner(BuildingPlanner buildingPlanner) {
        this.buildingPlanner = buildingPlanner;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GameState)) {
            return false;
        }
        GameState other = (GameState)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMineralWorkers() != other.getMineralWorkers()) {
            return false;
        }
        if (this.getGeyserWorkers() != other.getGeyserWorkers()) {
            return false;
        }
        if (this.getLarvaDeadlockDetectedFrame() != other.getLarvaDeadlockDetectedFrame()) {
            return false;
        }
        if (this.isEnemyHasCloakedUnits() != other.isEnemyHasCloakedUnits()) {
            return false;
        }
        if (this.isEnemyHasHostileFlyers() != other.isEnemyHasHostileFlyers()) {
            return false;
        }
        if (this.isLarvaDeadlocked() != other.isLarvaDeadlocked()) {
            return false;
        }
        if (this.isAllIn() != other.isAllIn()) {
            return false;
        }
        if (this.getPlannedWorkers() != other.getPlannedWorkers()) {
            return false;
        }
        if (this.getPlannedHatcheries() != other.getPlannedHatcheries()) {
            return false;
        }
        if (this.isDefensiveSunk() != other.isDefensiveSunk()) {
            return false;
        }
        if (this.isTransitionBuildOrder() != other.isTransitionBuildOrder()) {
            return false;
        }
        Game this$game = this.getGame();
        Game other$game = other.getGame();
        if (this$game == null ? other$game != null : !this$game.equals(other$game)) {
            return false;
        }
        Config this$config = this.getConfig();
        Config other$config = other.getConfig();
        if (this$config == null ? other$config != null : !this$config.equals(other$config)) {
            return false;
        }
        Player this$self = this.getSelf();
        Player other$self = other.getSelf();
        if (this$self == null ? other$self != null : !((Object)this$self).equals(other$self)) {
            return false;
        }
        BWEM this$bwem = this.getBwem();
        BWEM other$bwem = other.getBwem();
        if (this$bwem == null ? other$bwem != null : !this$bwem.equals(other$bwem)) {
            return false;
        }
        Race this$opponentRace = this.getOpponentRace();
        Race other$opponentRace = other.getOpponentRace();
        if (this$opponentRace == null ? other$opponentRace != null : !((Object)((Object)this$opponentRace)).equals((Object)other$opponentRace)) {
            return false;
        }
        HashMap<Unit, ManagedUnit> this$managedUnitLookup = this.getManagedUnitLookup();
        HashMap<Unit, ManagedUnit> other$managedUnitLookup = other.getManagedUnitLookup();
        if (this$managedUnitLookup == null ? other$managedUnitLookup != null : !((Object)this$managedUnitLookup).equals(other$managedUnitLookup)) {
            return false;
        }
        HashSet<ManagedUnit> this$managedUnits = this.getManagedUnits();
        HashSet<ManagedUnit> other$managedUnits = other.getManagedUnits();
        if (this$managedUnits == null ? other$managedUnits != null : !((Object)this$managedUnits).equals(other$managedUnits)) {
            return false;
        }
        HashSet<ManagedUnit> this$assignedManagedWorkers = this.getAssignedManagedWorkers();
        HashSet<ManagedUnit> other$assignedManagedWorkers = other.getAssignedManagedWorkers();
        if (this$assignedManagedWorkers == null ? other$assignedManagedWorkers != null : !((Object)this$assignedManagedWorkers).equals(other$assignedManagedWorkers)) {
            return false;
        }
        HashSet<ManagedUnit> this$gatherers = this.getGatherers();
        HashSet<ManagedUnit> other$gatherers = other.getGatherers();
        if (this$gatherers == null ? other$gatherers != null : !((Object)this$gatherers).equals(other$gatherers)) {
            return false;
        }
        HashSet<ManagedUnit> this$mineralGatherers = this.getMineralGatherers();
        HashSet<ManagedUnit> other$mineralGatherers = other.getMineralGatherers();
        if (this$mineralGatherers == null ? other$mineralGatherers != null : !((Object)this$mineralGatherers).equals(other$mineralGatherers)) {
            return false;
        }
        HashSet<ManagedUnit> this$gasGatherers = this.getGasGatherers();
        HashSet<ManagedUnit> other$gasGatherers = other.getGasGatherers();
        if (this$gasGatherers == null ? other$gasGatherers != null : !((Object)this$gasGatherers).equals(other$gasGatherers)) {
            return false;
        }
        HashMap<Unit, HashSet<ManagedUnit>> this$geyserAssignments = this.getGeyserAssignments();
        HashMap<Unit, HashSet<ManagedUnit>> other$geyserAssignments = other.getGeyserAssignments();
        if (this$geyserAssignments == null ? other$geyserAssignments != null : !((Object)this$geyserAssignments).equals(other$geyserAssignments)) {
            return false;
        }
        HashMap<Unit, HashSet<ManagedUnit>> this$mineralAssignments = this.getMineralAssignments();
        HashMap<Unit, HashSet<ManagedUnit>> other$mineralAssignments = other.getMineralAssignments();
        if (this$mineralAssignments == null ? other$mineralAssignments != null : !((Object)this$mineralAssignments).equals(other$mineralAssignments)) {
            return false;
        }
        HashSet<ManagedUnit> this$larva = this.getLarva();
        HashSet<ManagedUnit> other$larva = other.getLarva();
        if (this$larva == null ? other$larva != null : !((Object)this$larva).equals(other$larva)) {
            return false;
        }
        HashSet<Plan> this$plansScheduled = this.getPlansScheduled();
        HashSet<Plan> other$plansScheduled = other.getPlansScheduled();
        if (this$plansScheduled == null ? other$plansScheduled != null : !((Object)this$plansScheduled).equals(other$plansScheduled)) {
            return false;
        }
        HashSet<Plan> this$plansBuilding = this.getPlansBuilding();
        HashSet<Plan> other$plansBuilding = other.getPlansBuilding();
        if (this$plansBuilding == null ? other$plansBuilding != null : !((Object)this$plansBuilding).equals(other$plansBuilding)) {
            return false;
        }
        HashSet<Plan> this$plansMorphing = this.getPlansMorphing();
        HashSet<Plan> other$plansMorphing = other.getPlansMorphing();
        if (this$plansMorphing == null ? other$plansMorphing != null : !((Object)this$plansMorphing).equals(other$plansMorphing)) {
            return false;
        }
        HashSet<Plan> this$plansComplete = this.getPlansComplete();
        HashSet<Plan> other$plansComplete = other.getPlansComplete();
        if (this$plansComplete == null ? other$plansComplete != null : !((Object)this$plansComplete).equals(other$plansComplete)) {
            return false;
        }
        HashSet<Plan> this$plansImpossible = this.getPlansImpossible();
        HashSet<Plan> other$plansImpossible = other.getPlansImpossible();
        if (this$plansImpossible == null ? other$plansImpossible != null : !((Object)this$plansImpossible).equals(other$plansImpossible)) {
            return false;
        }
        HashMap<Unit, Plan> this$assignedPlannedItems = this.getAssignedPlannedItems();
        HashMap<Unit, Plan> other$assignedPlannedItems = other.getAssignedPlannedItems();
        if (this$assignedPlannedItems == null ? other$assignedPlannedItems != null : !((Object)this$assignedPlannedItems).equals(other$assignedPlannedItems)) {
            return false;
        }
        HashMap<Base, HashSet<ManagedUnit>> this$gatherersAssignedToBase = this.getGatherersAssignedToBase();
        HashMap<Base, HashSet<ManagedUnit>> other$gatherersAssignedToBase = other.getGatherersAssignedToBase();
        if (this$gatherersAssignedToBase == null ? other$gatherersAssignedToBase != null : !((Object)this$gatherersAssignedToBase).equals(other$gatherersAssignedToBase)) {
            return false;
        }
        HashMap<Base, HashSet<Unit>> this$baseToThreatLookup = this.getBaseToThreatLookup();
        HashMap<Base, HashSet<Unit>> other$baseToThreatLookup = other.getBaseToThreatLookup();
        if (this$baseToThreatLookup == null ? other$baseToThreatLookup != null : !((Object)this$baseToThreatLookup).equals(other$baseToThreatLookup)) {
            return false;
        }
        BuildOrder this$activeBuildOrder = this.getActiveBuildOrder();
        BuildOrder other$activeBuildOrder = other.getActiveBuildOrder();
        if (this$activeBuildOrder == null ? other$activeBuildOrder != null : !((Object)this$activeBuildOrder).equals(other$activeBuildOrder)) {
            return false;
        }
        UnitTypeCount this$unitTypeCount = this.getUnitTypeCount();
        UnitTypeCount other$unitTypeCount = other.getUnitTypeCount();
        if (this$unitTypeCount == null ? other$unitTypeCount != null : !this$unitTypeCount.equals(other$unitTypeCount)) {
            return false;
        }
        TechProgression this$techProgression = this.getTechProgression();
        TechProgression other$techProgression = other.getTechProgression();
        if (this$techProgression == null ? other$techProgression != null : !((Object)this$techProgression).equals(other$techProgression)) {
            return false;
        }
        ResourceCount this$resourceCount = this.getResourceCount();
        ResourceCount other$resourceCount = other.getResourceCount();
        if (this$resourceCount == null ? other$resourceCount != null : !this$resourceCount.equals(other$resourceCount)) {
            return false;
        }
        BaseData this$baseData = this.getBaseData();
        BaseData other$baseData = other.getBaseData();
        if (this$baseData == null ? other$baseData != null : !this$baseData.equals(other$baseData)) {
            return false;
        }
        ScoutData this$scoutData = this.getScoutData();
        ScoutData other$scoutData = other.getScoutData();
        if (this$scoutData == null ? other$scoutData != null : !this$scoutData.equals(other$scoutData)) {
            return false;
        }
        ObservedUnitTracker this$observedUnitTracker = this.getObservedUnitTracker();
        ObservedUnitTracker other$observedUnitTracker = other.getObservedUnitTracker();
        if (this$observedUnitTracker == null ? other$observedUnitTracker != null : !this$observedUnitTracker.equals(other$observedUnitTracker)) {
            return false;
        }
        StrategyTracker this$strategyTracker = this.getStrategyTracker();
        StrategyTracker other$strategyTracker = other.getStrategyTracker();
        if (this$strategyTracker == null ? other$strategyTracker != null : !this$strategyTracker.equals(other$strategyTracker)) {
            return false;
        }
        GameMap this$gameMap = this.getGameMap();
        GameMap other$gameMap = other.getGameMap();
        if (this$gameMap == null ? other$gameMap != null : !this$gameMap.equals(other$gameMap)) {
            return false;
        }
        BuildingPlanner this$buildingPlanner = this.getBuildingPlanner();
        BuildingPlanner other$buildingPlanner = other.getBuildingPlanner();
        return !(this$buildingPlanner == null ? other$buildingPlanner != null : !this$buildingPlanner.equals(other$buildingPlanner));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GameState;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMineralWorkers();
        result = result * 59 + this.getGeyserWorkers();
        result = result * 59 + this.getLarvaDeadlockDetectedFrame();
        result = result * 59 + (this.isEnemyHasCloakedUnits() ? 79 : 97);
        result = result * 59 + (this.isEnemyHasHostileFlyers() ? 79 : 97);
        result = result * 59 + (this.isLarvaDeadlocked() ? 79 : 97);
        result = result * 59 + (this.isAllIn() ? 79 : 97);
        result = result * 59 + this.getPlannedWorkers();
        result = result * 59 + this.getPlannedHatcheries();
        result = result * 59 + (this.isDefensiveSunk() ? 79 : 97);
        result = result * 59 + (this.isTransitionBuildOrder() ? 79 : 97);
        Game $game = this.getGame();
        result = result * 59 + ($game == null ? 43 : $game.hashCode());
        Config $config = this.getConfig();
        result = result * 59 + ($config == null ? 43 : $config.hashCode());
        Player $self = this.getSelf();
        result = result * 59 + ($self == null ? 43 : ((Object)$self).hashCode());
        BWEM $bwem = this.getBwem();
        result = result * 59 + ($bwem == null ? 43 : $bwem.hashCode());
        Race $opponentRace = this.getOpponentRace();
        result = result * 59 + ($opponentRace == null ? 43 : ((Object)((Object)$opponentRace)).hashCode());
        HashMap<Unit, ManagedUnit> $managedUnitLookup = this.getManagedUnitLookup();
        result = result * 59 + ($managedUnitLookup == null ? 43 : ((Object)$managedUnitLookup).hashCode());
        HashSet<ManagedUnit> $managedUnits = this.getManagedUnits();
        result = result * 59 + ($managedUnits == null ? 43 : ((Object)$managedUnits).hashCode());
        HashSet<ManagedUnit> $assignedManagedWorkers = this.getAssignedManagedWorkers();
        result = result * 59 + ($assignedManagedWorkers == null ? 43 : ((Object)$assignedManagedWorkers).hashCode());
        HashSet<ManagedUnit> $gatherers = this.getGatherers();
        result = result * 59 + ($gatherers == null ? 43 : ((Object)$gatherers).hashCode());
        HashSet<ManagedUnit> $mineralGatherers = this.getMineralGatherers();
        result = result * 59 + ($mineralGatherers == null ? 43 : ((Object)$mineralGatherers).hashCode());
        HashSet<ManagedUnit> $gasGatherers = this.getGasGatherers();
        result = result * 59 + ($gasGatherers == null ? 43 : ((Object)$gasGatherers).hashCode());
        HashMap<Unit, HashSet<ManagedUnit>> $geyserAssignments = this.getGeyserAssignments();
        result = result * 59 + ($geyserAssignments == null ? 43 : ((Object)$geyserAssignments).hashCode());
        HashMap<Unit, HashSet<ManagedUnit>> $mineralAssignments = this.getMineralAssignments();
        result = result * 59 + ($mineralAssignments == null ? 43 : ((Object)$mineralAssignments).hashCode());
        HashSet<ManagedUnit> $larva = this.getLarva();
        result = result * 59 + ($larva == null ? 43 : ((Object)$larva).hashCode());
        HashSet<Plan> $plansScheduled = this.getPlansScheduled();
        result = result * 59 + ($plansScheduled == null ? 43 : ((Object)$plansScheduled).hashCode());
        HashSet<Plan> $plansBuilding = this.getPlansBuilding();
        result = result * 59 + ($plansBuilding == null ? 43 : ((Object)$plansBuilding).hashCode());
        HashSet<Plan> $plansMorphing = this.getPlansMorphing();
        result = result * 59 + ($plansMorphing == null ? 43 : ((Object)$plansMorphing).hashCode());
        HashSet<Plan> $plansComplete = this.getPlansComplete();
        result = result * 59 + ($plansComplete == null ? 43 : ((Object)$plansComplete).hashCode());
        HashSet<Plan> $plansImpossible = this.getPlansImpossible();
        result = result * 59 + ($plansImpossible == null ? 43 : ((Object)$plansImpossible).hashCode());
        HashMap<Unit, Plan> $assignedPlannedItems = this.getAssignedPlannedItems();
        result = result * 59 + ($assignedPlannedItems == null ? 43 : ((Object)$assignedPlannedItems).hashCode());
        HashMap<Base, HashSet<ManagedUnit>> $gatherersAssignedToBase = this.getGatherersAssignedToBase();
        result = result * 59 + ($gatherersAssignedToBase == null ? 43 : ((Object)$gatherersAssignedToBase).hashCode());
        HashMap<Base, HashSet<Unit>> $baseToThreatLookup = this.getBaseToThreatLookup();
        result = result * 59 + ($baseToThreatLookup == null ? 43 : ((Object)$baseToThreatLookup).hashCode());
        BuildOrder $activeBuildOrder = this.getActiveBuildOrder();
        result = result * 59 + ($activeBuildOrder == null ? 43 : ((Object)$activeBuildOrder).hashCode());
        UnitTypeCount $unitTypeCount = this.getUnitTypeCount();
        result = result * 59 + ($unitTypeCount == null ? 43 : $unitTypeCount.hashCode());
        TechProgression $techProgression = this.getTechProgression();
        result = result * 59 + ($techProgression == null ? 43 : ((Object)$techProgression).hashCode());
        ResourceCount $resourceCount = this.getResourceCount();
        result = result * 59 + ($resourceCount == null ? 43 : $resourceCount.hashCode());
        BaseData $baseData = this.getBaseData();
        result = result * 59 + ($baseData == null ? 43 : $baseData.hashCode());
        ScoutData $scoutData = this.getScoutData();
        result = result * 59 + ($scoutData == null ? 43 : $scoutData.hashCode());
        ObservedUnitTracker $observedUnitTracker = this.getObservedUnitTracker();
        result = result * 59 + ($observedUnitTracker == null ? 43 : $observedUnitTracker.hashCode());
        StrategyTracker $strategyTracker = this.getStrategyTracker();
        result = result * 59 + ($strategyTracker == null ? 43 : $strategyTracker.hashCode());
        GameMap $gameMap = this.getGameMap();
        result = result * 59 + ($gameMap == null ? 43 : $gameMap.hashCode());
        BuildingPlanner $buildingPlanner = this.getBuildingPlanner();
        result = result * 59 + ($buildingPlanner == null ? 43 : $buildingPlanner.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "GameState(game=" + this.getGame() + ", config=" + this.getConfig() + ", self=" + this.getSelf() + ", bwem=" + this.getBwem() + ", opponentRace=" + (Object)((Object)this.getOpponentRace()) + ", mineralWorkers=" + this.getMineralWorkers() + ", geyserWorkers=" + this.getGeyserWorkers() + ", larvaDeadlockDetectedFrame=" + this.getLarvaDeadlockDetectedFrame() + ", managedUnitLookup=" + this.getManagedUnitLookup() + ", managedUnits=" + this.getManagedUnits() + ", assignedManagedWorkers=" + this.getAssignedManagedWorkers() + ", gatherers=" + this.getGatherers() + ", mineralGatherers=" + this.getMineralGatherers() + ", gasGatherers=" + this.getGasGatherers() + ", geyserAssignments=" + this.getGeyserAssignments() + ", mineralAssignments=" + this.getMineralAssignments() + ", larva=" + this.getLarva() + ", enemyHasCloakedUnits=" + this.isEnemyHasCloakedUnits() + ", enemyHasHostileFlyers=" + this.isEnemyHasHostileFlyers() + ", isLarvaDeadlocked=" + this.isLarvaDeadlocked() + ", isAllIn=" + this.isAllIn() + ", plansScheduled=" + this.getPlansScheduled() + ", plansBuilding=" + this.getPlansBuilding() + ", plansMorphing=" + this.getPlansMorphing() + ", plansComplete=" + this.getPlansComplete() + ", plansImpossible=" + this.getPlansImpossible() + ", assignedPlannedItems=" + this.getAssignedPlannedItems() + ", plannedWorkers=" + this.getPlannedWorkers() + ", plannedHatcheries=" + this.getPlannedHatcheries() + ", gatherersAssignedToBase=" + this.getGatherersAssignedToBase() + ", baseToThreatLookup=" + this.getBaseToThreatLookup() + ", defensiveSunk=" + this.isDefensiveSunk() + ", activeBuildOrder=" + this.getActiveBuildOrder() + ", transitionBuildOrder=" + this.isTransitionBuildOrder() + ", unitTypeCount=" + this.getUnitTypeCount() + ", techProgression=" + this.getTechProgression() + ", resourceCount=" + this.getResourceCount() + ", baseData=" + this.getBaseData() + ", scoutData=" + this.getScoutData() + ", observedUnitTracker=" + this.getObservedUnitTracker() + ", strategyTracker=" + this.getStrategyTracker() + ", gameMap=" + this.getGameMap() + ", buildingPlanner=" + this.getBuildingPlanner() + ")";
    }
}

