/*
 * Decompiled with CFR 0.152.
 */
package info;

import bwapi.Game;
import bwapi.Unit;
import bwapi.UnitType;
import bwem.BWEM;
import bwem.Base;
import info.GameState;
import java.util.List;

public class BaseManager {
    private BWEM bwem;
    private Game game;
    private GameState gameState;

    public BaseManager(BWEM bwem, Game game, GameState gameState) {
        this.bwem = bwem;
        this.game = game;
        this.gameState = gameState;
        this.init();
    }

    private void init() {
        Unit initialHatch = null;
        for (Unit unit : this.game.getAllUnits()) {
            if (this.game.self() != unit.getPlayer() || unit.getType() != UnitType.Zerg_Hatchery) continue;
            initialHatch = unit;
        }
        List<Base> allBases = this.bwem.getMap().getBases();
        Base mainBase = this.closestBaseToUnit(initialHatch, allBases);
        this.gameState.addMainBase(initialHatch, mainBase);
    }

    public void onUnitDestroy(Unit unit) {
        if (unit.getType() == UnitType.Zerg_Hatchery) {
            this.gameState.removeHatchery(unit);
        }
    }

    private Base closestBaseToUnit(Unit unit, List<Base> baseList) {
        Base closestBase = null;
        int closestDistance = Integer.MAX_VALUE;
        for (Base b : baseList) {
            int distance = unit.getDistance(b.getLocation().toPosition());
            if (distance >= closestDistance) continue;
            closestBase = b;
            closestDistance = distance;
        }
        return closestBase;
    }
}

