/*
 * Decompiled with CFR 0.152.
 */
package bwta;

import bwapi.Position;
import bwapi.TilePosition;
import bwapi.Unit;
import bwem.Base;
import bwem.Neutral;
import bwta.BWTA;
import bwta.Region;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class BaseLocation {
    private final Base base;
    private final Position position;
    private final TilePosition tilePosition;
    private final int minerals;
    private final int gas;
    private final List<Unit> mineralSet;
    private final List<Unit> geyserSet;
    private final boolean island;
    private final boolean mineralOnly;
    private final boolean startLocation;

    BaseLocation(Base base) {
        this.base = base;
        this.position = base.getCenter();
        this.tilePosition = base.getLocation();
        this.minerals = 1;
        this.gas = 1;
        this.mineralSet = base.getMinerals().stream().map(Neutral::getUnit).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
        this.geyserSet = base.getGeysers().stream().map(Neutral::getUnit).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
        this.island = base.getArea().getAccessibleNeighbors().isEmpty();
        this.mineralOnly = !this.mineralSet.isEmpty() && this.geyserSet.isEmpty();
        this.startLocation = base.isStartingLocation();
    }

    public Position getPosition() {
        return this.position;
    }

    public TilePosition getTilePosition() {
        return this.tilePosition;
    }

    public Region getRegion() {
        return BWTA.regionMap.get(this.base.getArea());
    }

    public int minerals() {
        return this.minerals;
    }

    public int gas() {
        return this.gas;
    }

    public List<Unit> getMinerals() {
        return this.mineralSet;
    }

    public List<Unit> getGeysers() {
        return this.geyserSet;
    }

    public double getGroundDistance(BaseLocation other) {
        return BWTA.getGroundDistance(this.tilePosition, other.tilePosition);
    }

    public double getAirDistance(BaseLocation other) {
        return this.position.getDistance(other.position);
    }

    public boolean isIsland() {
        return this.island;
    }

    public boolean isMineralOnly() {
        return this.mineralOnly;
    }

    public boolean isStartLocation() {
        return this.startLocation;
    }

    public boolean equals(Object o) {
        if (!(o instanceof BaseLocation)) {
            return false;
        }
        return this.base.equals(((BaseLocation)o).base);
    }

    public int hashCode() {
        return this.base.hashCode();
    }
}

