/*
 * Decompiled with CFR 0.152.
 */
package bwapi;

import bwapi.Order;
import bwapi.Player;
import bwapi.Race;
import bwapi.Unit;
import bwapi.UnitSizeType;
import bwapi.UnitType;
import bwapi.UpgradeType;
import bwapi.WeaponType;
import java.util.function.Predicate;

public interface UnitFilter
extends Predicate<Unit> {
    public static final UnitFilter IsTransPort = u -> u.getType().spaceProvided() > 0 && u.getType() != UnitType.Terran_Bunker;
    public static final UnitFilter CanProduce = u -> u.getType().canProduce();
    public static final UnitFilter CanAttack = u -> u.getType().canAttack();
    public static final UnitFilter CanMove = u -> u.getType().canMove();
    public static final UnitFilter IsFlyer = u -> u.getType().isFlyer();
    public static final UnitFilter IsFlying = Unit::isFlying;
    public static final UnitFilter RegeneratesHP = u -> u.getType().regeneratesHP();
    public static final UnitFilter IsSpellcaster = u -> u.getType().isSpellcaster();
    public static final UnitFilter HasPermanentCloak = u -> u.getType().hasPermanentCloak();
    public static final UnitFilter IsOrganic = u -> u.getType().isOrganic();
    public static final UnitFilter IsMechanical = u -> u.getType().isMechanical();
    public static final UnitFilter IsRobotic = u -> u.getType().isRobotic();
    public static final UnitFilter IsDetector = u -> u.getType().isDetector();
    public static final UnitFilter IsResourceContainer = u -> u.getType().isResourceContainer();
    public static final UnitFilter IsResourceDepot = u -> u.getType().isResourceDepot();
    public static final UnitFilter IsRefinery = u -> u.getType().isRefinery();
    public static final UnitFilter IsWorker = u -> u.getType().isWorker();
    public static final UnitFilter RequiresPsi = u -> u.getType().requiresPsi();
    public static final UnitFilter RequiresCreep = u -> u.getType().requiresCreep();
    public static final UnitFilter IsBurrowable = u -> u.getType().isBurrowable();
    public static final UnitFilter IsCloakable = u -> u.getType().isCloakable();
    public static final UnitFilter IsBuilding = u -> u.getType().isBuilding();
    public static final UnitFilter IsAddon = u -> u.getType().isAddon();
    public static final UnitFilter IsFlyingBuilding = u -> u.getType().isFlyingBuilding();
    public static final UnitFilter IsNeutral = u -> u.getType().isNeutral();
    public static final UnitFilter IsHero = u -> u.getType().isHero();
    public static final UnitFilter IsPowerup = u -> u.getType().isPowerup();
    public static final UnitFilter IsBeacon = u -> u.getType().isBeacon();
    public static final UnitFilter IsFlagBeacon = u -> u.getType().isFlagBeacon();
    public static final UnitFilter IsSpecialBuilding = u -> u.getType().isSpecialBuilding();
    public static final UnitFilter IsSpell = u -> u.getType().isSpell();
    public static final UnitFilter ProducesLarva = u -> u.getType().producesLarva();
    public static final UnitFilter IsMineralField = u -> u.getType().isMineralField();
    public static final UnitFilter IsCritter = u -> u.getType().isCritter();
    public static final UnitFilter CanBuildAddon = u -> u.getType().canBuildAddon();
    public static final UnitFilter Exists = Unit::exists;
    public static final UnitFilter IsAttacking = Unit::isAttacking;
    public static final UnitFilter IsBeingConstructed = Unit::isBeingConstructed;
    public static final UnitFilter IsBeingGathered = Unit::isBeingGathered;
    public static final UnitFilter IsBeingHealed = Unit::isBeingHealed;
    public static final UnitFilter IsBlind = Unit::isBlind;
    public static final UnitFilter IsBraking = Unit::isBraking;
    public static final UnitFilter IsBurrowed = Unit::isBurrowed;
    public static final UnitFilter IsCarryingGas = Unit::isCarryingGas;
    public static final UnitFilter IsCarryingMinerals = Unit::isCarryingMinerals;
    public static final UnitFilter IsCarryingSomething = u -> u.isCarryingMinerals() || u.isCarryingGas();
    public static final UnitFilter IsCloaked = Unit::isCloaked;
    public static final UnitFilter IsCompleted = Unit::isCompleted;
    public static final UnitFilter IsConstructing = Unit::isConstructing;
    public static final UnitFilter IsDefenseMatrixed = Unit::isDefenseMatrixed;
    public static final UnitFilter IsDetected = Unit::isDetected;
    public static final UnitFilter IsEnsnared = Unit::isEnsnared;
    public static final UnitFilter IsFollowing = Unit::isFollowing;
    public static final UnitFilter IsGatheringGas = Unit::isGatheringGas;
    public static final UnitFilter IsGatheringMinerals = Unit::isGatheringMinerals;
    public static final UnitFilter IsHallucination = Unit::isHallucination;
    public static final UnitFilter IsHoldingPosition = Unit::isHoldingPosition;
    public static final UnitFilter IsIdle = Unit::isIdle;
    public static final UnitFilter IsInterruptible = Unit::isInterruptible;
    public static final UnitFilter IsInvincible = Unit::isInvincible;
    public static final UnitFilter IsIrradiated = Unit::isIrradiated;
    public static final UnitFilter IsLifted = Unit::isLifted;
    public static final UnitFilter IsLoaded = Unit::isLoaded;
    public static final UnitFilter IsLockedDown = Unit::isLockedDown;
    public static final UnitFilter IsMaelstrommed = Unit::isMaelstrommed;
    public static final UnitFilter IsMorphing = Unit::isMorphing;
    public static final UnitFilter IsMoving = Unit::isMoving;
    public static final UnitFilter IsParasited = Unit::isParasited;
    public static final UnitFilter IsPatrolling = Unit::isPatrolling;
    public static final UnitFilter IsPlagued = Unit::isPlagued;
    public static final UnitFilter IsRepairing = Unit::isRepairing;
    public static final UnitFilter IsResearching = Unit::isResearching;
    public static final UnitFilter IsSieged = Unit::isSieged;
    public static final UnitFilter IsStartingAttack = Unit::isStartingAttack;
    public static final UnitFilter IsStasised = Unit::isStasised;
    public static final UnitFilter IsStimmed = Unit::isStimmed;
    public static final UnitFilter IsStuck = Unit::isStuck;
    public static final UnitFilter IsTraining = Unit::isTraining;
    public static final UnitFilter IsUnderAttack = Unit::isUnderAttack;
    public static final UnitFilter IsUnderDarkSwarm = Unit::isUnderDarkSwarm;
    public static final UnitFilter IsUnderDisruptionWeb = Unit::isUnderDisruptionWeb;
    public static final UnitFilter IsUnderStorm = Unit::isUnderStorm;
    public static final UnitFilter IsPowered = Unit::isPowered;
    public static final UnitFilter IsVisible = Unit::isVisible;

    public static UnitFilter HP(Predicate<Integer> c) {
        return u -> c.test(u.getHitPoints());
    }

    public static UnitFilter MaxHP(Predicate<Integer> c) {
        return u -> c.test(u.getType().maxHitPoints());
    }

    public static UnitFilter HP_Percent(Predicate<Integer> c) {
        return u -> c.test(u.getType().maxHitPoints() != 0 ? u.getHitPoints() * 100 / u.getType().maxHitPoints() : 0);
    }

    public static UnitFilter Shields(Predicate<Integer> c) {
        return u -> c.test(u.getShields());
    }

    public static UnitFilter MaxShields(Predicate<Integer> c) {
        return u -> c.test(u.getType().maxShields());
    }

    public static UnitFilter Shields_Percent(Predicate<Integer> c) {
        return u -> c.test(u.getType().maxShields() != 0 ? u.getShields() * 100 / u.getType().maxShields() : 0);
    }

    public static UnitFilter Energy(Predicate<Integer> c) {
        return u -> c.test(u.getEnergy());
    }

    public static UnitFilter MaxEnergy(Predicate<Integer> c) {
        return u -> c.test(u.getPlayer().maxEnergy(u.getType()));
    }

    public static UnitFilter Energy_Percent(Predicate<Integer> c) {
        return u -> c.test(u.getPlayer().maxEnergy(u.getType()) != 0 ? u.getEnergy() * 100 / u.getPlayer().maxEnergy(u.getType()) : 0);
    }

    public static UnitFilter Armor(Predicate<Integer> c) {
        return u -> c.test(u.getPlayer().armor(u.getType()));
    }

    public static UnitFilter ArmorUpgrade(Predicate<UpgradeType> c) {
        return u -> c.test(u.getType().armorUpgrade());
    }

    public static UnitFilter MineralPrice(Predicate<Integer> c) {
        return u -> c.test(u.getType().mineralPrice());
    }

    public static UnitFilter GasPrice(Predicate<Integer> c) {
        return u -> c.test(u.getType().gasPrice());
    }

    public static UnitFilter BuildTime(Predicate<Integer> c) {
        return u -> c.test(u.getType().buildTime());
    }

    public static UnitFilter SupplyRequired(Predicate<Integer> c) {
        return u -> c.test(u.getType().supplyRequired());
    }

    public static UnitFilter SupplyProvided(Predicate<Integer> c) {
        return u -> c.test(u.getType().supplyProvided());
    }

    public static UnitFilter SpaceRequired(Predicate<Integer> c) {
        return u -> c.test(u.getType().spaceRequired());
    }

    public static UnitFilter SpaceRemaining(Predicate<Integer> c) {
        return u -> c.test(u.getSpaceRemaining());
    }

    public static UnitFilter SpaceProvided(Predicate<Integer> c) {
        return u -> c.test(u.getType().spaceProvided());
    }

    public static UnitFilter BuildScore(Predicate<Integer> c) {
        return u -> c.test(u.getType().buildScore());
    }

    public static UnitFilter DestroyScore(Predicate<Integer> c) {
        return u -> c.test(u.getType().destroyScore());
    }

    public static UnitFilter TopSpeed(Predicate<Double> c) {
        return u -> c.test(u.getPlayer().topSpeed(u.getType()));
    }

    public static UnitFilter SightRange(Predicate<Integer> c) {
        return u -> c.test(u.getPlayer().sightRange(u.getType()));
    }

    public static UnitFilter MaxWeaponCooldown(Predicate<Integer> c) {
        return u -> c.test(u.getPlayer().weaponDamageCooldown(u.getType()));
    }

    public static UnitFilter SizeType(Predicate<UnitSizeType> c) {
        return u -> c.test(u.getType().size());
    }

    public static UnitFilter GroundWeapon(Predicate<WeaponType> c) {
        return u -> c.test(u.getType().groundWeapon());
    }

    public static UnitFilter AirWeapon(Predicate<WeaponType> c) {
        return u -> c.test(u.getType().airWeapon());
    }

    public static UnitFilter GetType(Predicate<UnitType> c) {
        return u -> c.test(u.getType());
    }

    public static UnitFilter GetRace(Predicate<Race> c) {
        return u -> c.test(u.getType().getRace());
    }

    public static UnitFilter GetPlayer(Predicate<Player> c) {
        return u -> c.test(u.getPlayer());
    }

    public static UnitFilter Resources(Predicate<Integer> c) {
        return u -> c.test(u.getResources());
    }

    public static UnitFilter ResourceGroup(Predicate<Integer> c) {
        return u -> c.test(u.getResourceGroup());
    }

    public static UnitFilter AcidSporeCount(Predicate<Integer> c) {
        return u -> c.test(u.getAcidSporeCount());
    }

    public static UnitFilter InterceptorCount(Predicate<Integer> c) {
        return u -> c.test(u.getInterceptorCount());
    }

    public static UnitFilter ScarabCount(Predicate<Integer> c) {
        return u -> c.test(u.getScarabCount());
    }

    public static UnitFilter SpiderMineCount(Predicate<Integer> c) {
        return u -> c.test(u.getSpiderMineCount());
    }

    public static UnitFilter WeaponCooldown(Predicate<Integer> c) {
        return u -> c.test(u.getGroundWeaponCooldown());
    }

    public static UnitFilter SpellCooldown(Predicate<Integer> c) {
        return u -> c.test(u.getSpellCooldown());
    }

    public static UnitFilter DefenseMatrixPoints(Predicate<Integer> c) {
        return u -> c.test(u.getDefenseMatrixPoints());
    }

    public static UnitFilter DefenseMatrixTime(Predicate<Integer> c) {
        return u -> c.test(u.getDefenseMatrixTimer());
    }

    public static UnitFilter EnsnareTime(Predicate<Integer> c) {
        return u -> c.test(u.getEnsnareTimer());
    }

    public static UnitFilter IrradiateTime(Predicate<Integer> c) {
        return u -> c.test(u.getIrradiateTimer());
    }

    public static UnitFilter LockdownTime(Predicate<Integer> c) {
        return u -> c.test(u.getLockdownTimer());
    }

    public static UnitFilter MaelstromTime(Predicate<Integer> c) {
        return u -> c.test(u.getMaelstromTimer());
    }

    public static UnitFilter OrderTime(Predicate<Integer> c) {
        return u -> c.test(u.getOrderTimer());
    }

    public static UnitFilter PlagueTimer(Predicate<Integer> c) {
        return u -> c.test(u.getPlagueTimer());
    }

    public static UnitFilter RemoveTime(Predicate<Integer> c) {
        return u -> c.test(u.getRemoveTimer());
    }

    public static UnitFilter StasisTime(Predicate<Integer> c) {
        return u -> c.test(u.getStasisTimer());
    }

    public static UnitFilter StimTime(Predicate<Integer> c) {
        return u -> c.test(u.getStimTimer());
    }

    public static UnitFilter BuildType(Predicate<UnitType> c) {
        return u -> c.test(u.getBuildType());
    }

    public static UnitFilter RemainingBuildTime(Predicate<Integer> c) {
        return u -> c.test(u.getRemainingBuildTime());
    }

    public static UnitFilter RemainingTrainTime(Predicate<Integer> c) {
        return u -> c.test(u.getRemainingTrainTime());
    }

    public static UnitFilter Target(Predicate<Unit> c) {
        return u -> c.test(u.getTarget());
    }

    public static UnitFilter CurrentOrder(Predicate<Order> c) {
        return u -> c.test(u.getOrder());
    }

    public static UnitFilter SecondaryOrder(Predicate<Order> c) {
        return u -> c.test(u.getSecondaryOrder());
    }

    public static UnitFilter OrderTarget(Predicate<Unit> c) {
        return u -> c.test(u.getOrderTarget());
    }

    public static UnitFilter GetLeft(Predicate<Integer> c) {
        return u -> c.test(u.getLeft());
    }

    public static UnitFilter GetTop(Predicate<Integer> c) {
        return u -> c.test(u.getTop());
    }

    public static UnitFilter GetRight(Predicate<Integer> c) {
        return u -> c.test(u.getRight());
    }

    public static UnitFilter GetBottom(Predicate<Integer> c) {
        return u -> c.test(u.getBottom());
    }
}

