/*
 * Decompiled with CFR 0.152.
 */
package bwapi;

import bwapi.Game;
import bwapi.Unit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

class ConnectedUnitCache {
    private int lastUpdate = -1;
    private final Map<Unit, List<Unit>> connectedUnits = new HashMap<Unit, List<Unit>>();
    private final Function<Unit, Unit> condition;
    private final Game game;

    ConnectedUnitCache(Game game, Function<Unit, Unit> condition) {
        this.game = game;
        this.condition = condition;
    }

    List<Unit> getConnected(Unit unit) {
        int frame = this.game.getFrameCount();
        if (this.lastUpdate < frame) {
            this.connectedUnits.values().forEach(List::clear);
            for (Unit u : this.game.getAllUnits()) {
                Unit owner = this.condition.apply(u);
                if (owner == null) continue;
                if (!this.connectedUnits.containsKey(owner)) {
                    this.connectedUnits.put(owner, new ArrayList());
                }
                this.connectedUnits.get(owner).add(u);
            }
            this.lastUpdate = frame;
        }
        if (!this.connectedUnits.containsKey(unit)) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.connectedUnits.get(unit));
    }

    void reset() {
        this.lastUpdate = -1;
        this.connectedUnits.clear();
    }
}

