#pragma once

#include <BWAPI.h>
#include <chrono>
#include <random>
#include <fstream>


enum struct Maps {
  None,
  TutorialBootCamp,
  Wasteland,
  BackwaterStation,
  DesperateAlliance,
  TheJacobsInstallation,
  Revolution,
  NoradII
};

enum struct ClientInfo {
  ResourceGroup,
  BuildType,
  BuildLocationX,
  BuildLocationY,
  MorphingInto,
  SunkenCount,
  MacroHatchCount,
  BunkerCount,
  AssignedRegion,
  Job,
  JobX,
  JobY,
  Panic,
  AssignedCount,
  Flags,
  SquadLeader,
  Cannons,
  CameraScore,
  CameraX,
  CameraY,
  Sleep,
  AssignedDepot,
  AssignedDetection,
  JobUnit,
  InTransport,
  QueuedTransport,
  BuildOrder,
  Data,
  UnitAI,
  AssignedBunker
};

enum struct JobType {
  None,
  Defend,
  Attack,
  HelpExpand,
  Taxi,
  Move,
  HoldDefend,
  Scout
};

struct Job {
public:
  Job(JobType type, BWAPI::TilePosition tilePosition, BWAPI::Position position, BWAPI::Unit targetUnit, BWAPI::Unit requestingUnit) :
    type(type),
    tilePosition(tilePosition),
    position(position),
    targetUnit(targetUnit),
    requestingUnit(requestingUnit) {}
  Job() :
    type(JobType::None),
    tilePosition(BWAPI::TilePositions::None),
    position(BWAPI::Positions::None),
    targetUnit(nullptr),
    requestingUnit(nullptr) {}
  JobType type;
  BWAPI::TilePosition tilePosition;
  BWAPI::Position position;
  BWAPI::Unit targetUnit;
  BWAPI::Unit requestingUnit;
};

struct BaseLocation {
public:
  int ID = -1;
  BWAPI::TilePosition location = BWAPI::TilePositions::Origin;
  std::vector<std::pair<std::shared_ptr<BaseLocation>, int>> neighbors;
  BWAPI::Region region = nullptr;
};

struct Allowed {
public:
  std::map<BWAPI::TechType, bool> techs;
  std::map<BWAPI::UnitType, bool> units;
  std::map<BWAPI::UpgradeType, bool> upgrades;
};

struct Counts {
public:
  std::map<BWAPI::UnitType, int> complete;
  std::map<BWAPI::UnitType, int> incomplete;
  std::map<BWAPI::UnitType, int> raw;
};

struct Data {
public:
  void updateTracking();
  bool rawCountEquals(BWAPI::UnitType type, int count, int multiplier = 1);
  bool completeCountEquals(BWAPI::UnitType type, int count, int multiplier = 1);
  bool completeCountGreaterThanOrEquals(BWAPI::UnitType type, int count, int multiplier = 1);
  bool completeCountGreaterThan(BWAPI::UnitType type, int count, int multiplier = 1);
  bool rawCountLessThan(BWAPI::UnitType type, int count, int multiplier = 1);
  bool rawCountLessThanOrEquals(BWAPI::UnitType type, int count, int multiplier = 1);
  bool rawCountGreaterThanOrEquals(BWAPI::UnitType type, int count, int multiplier = 1);
  bool incompleteCountEquals(BWAPI::UnitType type, int count, int multiplier = 1);
  int rawHatcheryCount();
  int rawLairCount();
  int rawGroundColonyCount();
  int completeLairCount();
  bool startLogging();
  void logInformation(BWAPI::Unit unit, std::string info);
  void endLogging();

  Allowed allowed;
  std::vector<BWAPI::Unitset> attackerUnitSets;
  std::map<int, BaseLocation> baseLocations;
  int buildRange = -1;
  int cameraCooldown = 23 * 10;
  BWAPI::Position cameraTarget = BWAPI::Positions::None;
  int commandCount = 0;
  BWAPI::Order lastOrder;
  bool controlCamera = true;
  Counts counts;
  std::map<int, BWAPI::Regionset> defenderRegions;
  std::map<int, BWAPI::Unitset> defenderUnitSets;
  std::map<int, BWAPI::Unit> enemyBuildings;
  bool expand;
  std::vector<bool> flags;
  int gas;
  std::map<int, BWAPI::Unitset> gasWorkers;
  bool islandMap = false;
  std::vector<Job> jobList;
  std::map<int, int> maxMineralWorkers;
  int minerals;
  std::map<int, int> mineralWorkers;
  BWAPI::Unitset productionBuildings;
  BWAPI::Unitset refineries;
  BWAPI::Unitset resourceDepots;
  std::vector<BWAPI::TilePosition> attackLocations;
  int supplyConstruction;
  int supplyTotal;
  int supplyUsed;
  BWAPI::Unitset techBuildings;
  BWAPI::Unitset upgradeBuildings;
  std::map<int, int> feedbackCooldowns;
  Maps map;
  std::ofstream logFile;
  bool scouted = false;
  int getRandomInteger(int min, int max) {
    std::uniform_int_distribution<int> randomNumber(min, max);
    return randomNumber(mt);
  }
  std::map<std::string, Maps> mapHashes = {
    {"b7a5f742eb6d679a6eac34897571b96279e64248", Maps::TutorialBootCamp},
    {"810b96843d153c1ffc32acb25832eb7c3146a4f5", Maps::Wasteland},
    {"0120510404aae1d7fdb3b961c208b56828effdd6", Maps::BackwaterStation},
    {"6d5620b0e0f5cc5faa3dbfa7f8eef24dbe3e34c8", Maps::DesperateAlliance},
    {"2ea611007a3eb2a31cd9342b98e6ef29c6415c33", Maps::TheJacobsInstallation},
    {"21257f5349965063b67269d5add5455918f18182", Maps::Revolution},
    {"afef894d1667b67009015d037d8ed0203e2f9f3b", Maps::NoradII}
  };
private:
  //rng
  std::mt19937 mt = std::mt19937{ static_cast<unsigned int>(std::chrono::system_clock::now().time_since_epoch().count()) };
};