#include "data.h"

#include "unitmicro.h"

#include <queue>

using namespace BWAPI::UnitTypes;

bool Data::rawCountEquals(BWAPI::UnitType type, int count, int multiplier) {
  return counts.raw[type] * multiplier == count;
}

bool Data::completeCountEquals(BWAPI::UnitType type, int count, int multiplier) {
  return counts.complete[type] * multiplier == count;
}

bool Data::completeCountGreaterThanOrEquals(BWAPI::UnitType type, int count, int multiplier) {
  return count <= counts.complete[type] * multiplier;
}

bool Data::completeCountGreaterThan(BWAPI::UnitType type, int count, int multiplier) {
  return count < counts.complete[type] * multiplier;
}

bool Data::rawCountLessThan(BWAPI::UnitType type, int count, int multiplier) {
  return counts.raw[type] * multiplier < count;
}

bool Data::rawCountLessThanOrEquals( BWAPI::UnitType type, int count, int multiplier) {
  return counts.raw[type] * multiplier <= count;
}

bool Data::rawCountGreaterThanOrEquals(BWAPI::UnitType type, int count, int multiplier) {
  return count <= counts.raw[type] * multiplier;
}

bool Data::incompleteCountEquals(BWAPI::UnitType type, int count, int multiplier) {
  return counts.incomplete[type] * multiplier == count;
}

int Data::rawHatcheryCount() {
  return counts.raw[Zerg_Hatchery] + counts.raw[Zerg_Lair] + counts.raw[Zerg_Hive];
}

int Data::rawLairCount() {
  return counts.raw[Zerg_Lair] + counts.raw[Zerg_Hive];
}

int Data::rawGroundColonyCount() {
  return counts.raw[Zerg_Creep_Colony] + counts.raw[Zerg_Sunken_Colony];
}

int Data::completeLairCount() {
  return counts.complete[Zerg_Lair] + counts.raw[Zerg_Hive];
}

bool Data::startLogging() {
  logFile.open("./bwapi-data/write/logFile.csv");
  if (logFile.is_open()) {
    logFile << "Frame,Unit ID,Type,Note" << std::endl;
    return true;
  }
  return false;
}

void Data::logInformation(BWAPI::Unit unit, std::string info) {
  if (!logFile.is_open()) {
    return;
  }
  logFile << BWAPI::Broodwar->getFrameCount() << "," << unit->getID() << "," << unit->getType().getName() << "," << info << std::endl;
}

void Data::endLogging() {
  logFile.close();
}

void Data::updateTracking() {
  {
    auto self = BWAPI::Broodwar->self();
    minerals = self->minerals();
    gas = self->gas();
    supplyUsed = self->supplyUsed();
    supplyTotal = self->supplyTotal();
    supplyConstruction = 0;
    counts.complete.clear();
    counts.incomplete.clear();
    counts.raw.clear();

    if (BWAPI::Broodwar->getFrameCount() == 0) {
      map = mapHashes[BWAPI::Broodwar->mapHash()];


      buildRange = BWAPI::Broodwar->mapWidth() > BWAPI::Broodwar->mapHeight() ? BWAPI::Broodwar->mapWidth() / 4 : BWAPI::Broodwar->mapHeight() / 4;

      /*for (const auto& startLocation : BWAPI::Broodwar->getStartLocations()) {
        BaseLocation newBaseLocation;
        auto resource = BWAPI::Broodwar->getClosestUnit(BWAPI::Position{ startLocation }, BWAPI::Filter::IsResourceContainer, 500);
        if (resource) {
          newBaseLocation.ID = resource->getResourceGroup();
          newBaseLocation.location = startLocation;
          newBaseLocation.region = BWAPI::Broodwar->getRegionAt(BWAPI::Position{ newBaseLocation.location });
          baseLocations[newBaseLocation.ID] = newBaseLocation;
          if (map == Maps::None) {
            attackLocations.push_back(startLocation);
          }
        }
      }*/



      {
        auto begin = BWAPI::Broodwar->getStartLocations().begin();
        auto itr = begin;
        itr++;
        while (itr != BWAPI::Broodwar->getStartLocations().end()) {
          if (BWAPI::Broodwar->getRegionAt(BWAPI::Position{ *itr })->getRegionGroupID() != BWAPI::Broodwar->getRegionAt(BWAPI::Position{ *begin })->getRegionGroupID()) {
            islandMap = true;
          }
          itr++;
        }
      }
      std::map<int, BWAPI::Unitset> resourcesByGroup;
      for (auto& unit : BWAPI::Broodwar->getAllUnits()) {
        if (unit->getPlayer()->isNeutral()
          && (unit->getType().isMineralField()
            || unit->getType() == BWAPI::UnitTypes::Resource_Vespene_Geyser))
          resourcesByGroup[unit->getResourceGroup()].insert(unit);
      }

      auto canBuildHere = [](BWAPI::TilePosition position, BWAPI::UnitType type, bool checkExplored) {
        // lt = left top, rb = right bottom
        BWAPI::TilePosition lt = position;
        BWAPI::TilePosition rb = lt + type.tileSize();

        // Map limit check
        if (!lt.isValid() || !(BWAPI::Position(rb) - BWAPI::Position(1, 1)).isValid())
          return false;

        // Tile buildability check
        for (int x = lt.x; x < rb.x; ++x)
        {
          for (int y = lt.y; y < rb.y; ++y)
          {
            // Check if tile is buildable/unoccupied and explored.
            if (!BWAPI::Broodwar->isBuildable(x, y) || (checkExplored && !BWAPI::Broodwar->isExplored(x, y)))
              return false; // @TODO: Error code for !isExplored ??
          }
        }

        // Resource Check (CC, Nex, Hatch)
        if (type.isResourceDepot())
        {
          for (BWAPI::Unit m : BWAPI::Broodwar->getStaticMinerals())
          {
            BWAPI::TilePosition tp = m->getInitialTilePosition();
            if ((BWAPI::Broodwar->isVisible(tp) || BWAPI::Broodwar->isVisible(tp.x + 1, tp.y)) && !m->exists())
              continue; // tile position is visible, but mineral is not => mineral does not exist
            if (tp.x > lt.x - 5 &&
              tp.y > lt.y - 4 &&
              tp.x < lt.x + 7 &&
              tp.y < lt.y + 6)
              return false;
          }
          for (BWAPI::Unit g : BWAPI::Broodwar->getStaticGeysers())
          {
            BWAPI::TilePosition tp = g->getInitialTilePosition();
            if (tp.x > lt.x - 7 &&
              tp.y > lt.y - 5 &&
              tp.x < lt.x + 7 &&
              tp.y < lt.y + 6)
              return false;
          }
        }

        return true;
      };
      for (auto& [resourceGroup, unitset] : resourcesByGroup) {
        BWAPI::Unit anchorUnit = nullptr;
        BWAPI::Unitset mineralUnits;
        BWAPI::Unitset gasUnits;
        for (auto& unit : unitset) {
          if (unit->getType().isMineralField()) {
            mineralUnits.insert(unit);
          }
          else if (unit->getType().isRefinery() || unit->getType() == BWAPI::UnitTypes::Resource_Vespene_Geyser) {
            gasUnits.insert(unit);
          }
        }

        if (gasUnits.size()) {
          anchorUnit = *gasUnits.begin();
        }
        else {
          int furthestDistance = -1;
          for (auto unit : mineralUnits) {
            auto potentialDistance = unit->getDistance(mineralUnits.getPosition());
            if (furthestDistance < potentialDistance) {
              furthestDistance = unit->getDistance(mineralUnits.getPosition());
              anchorUnit = unit;
            }
          }
        }

        auto anchorPosition = anchorUnit->getTilePosition();
        int ground = BWAPI::Broodwar->getGroundHeight(anchorPosition);
        std::queue<BWAPI::TilePosition> validPositions;
        for (int x = -7; x < 8; x++) {
          for (int y = -6; y < 6; y++) {
            if (-6 < y && y < 5 && x != -7 && x != 7) {
              continue;
            }
            if (-7 < x && x < 7 && y != -6 && y != 5) {
              continue;
            }
            BWAPI::TilePosition positionToCheck = BWAPI::TilePosition{ x, y } + anchorPosition;
            if (canBuildHere(positionToCheck, BWAPI::UnitTypes::Terran_Command_Center, false)) {
              validPositions.push(positionToCheck);
            }
          }
        }

        /*struct node {
          BWAPI::TilePosition tilePosition;
          int cost;
        };
        std::queue<node> Q;
        std::queue<BWAPI::TilePosition> validPositions;
        std::map<BWAPI::TilePosition, bool> checked;
        Q.push(node{ anchorPosition, 0 });
        checked[anchorPosition] = true;
        while (Q.size()) {
          auto v = Q.front();
          Q.pop();
          if (v.tilePosition.isValid()
            && BWAPI::Broodwar->getGroundHeight(v.tilePosition) == ground) {
            if (canBuildHere(v.tilePosition, BWAPI::UnitTypes::Terran_Command_Center, false)) {
              validPositions.push(v.tilePosition);
            }
            else {
              for (int x = 1; -2 < x; x--) {
                for (int y = 1; -2 < y; y--) {
                  auto toCheck = v.tilePosition + BWAPI::TilePosition{ x, y };
                  if (!checked[toCheck]) {
                    Q.push(node{ toCheck, v.cost + 1 });
                    checked[toCheck] = true;
                  }
                }
              }
            }
          }
        }*/
        int closestDistance = INT_MAX;
        BWAPI::TilePosition closestPosition = BWAPI::TilePositions::None;
        int lookfor = resourceGroup;
        int closestAvgMineralDistance = INT_MAX;
        BWAPI::Unit closestAvgMineral = nullptr;
        for (auto unit : mineralUnits) {
          if (unit->getDistance(mineralUnits.getPosition()) < closestAvgMineralDistance) {
            closestAvgMineralDistance = unit->getDistance(mineralUnits.getPosition());
            closestAvgMineral = unit;
          }
        }
        if (!closestAvgMineral) {
          closestAvgMineral = *gasUnits.begin();
        }
        while (validPositions.size()) {
          auto potentialPosition = validPositions.front();
          validPositions.pop();

          auto potentialDistance = closestAvgMineral->getDistance(BWAPI::Position{ potentialPosition });
          if (potentialDistance < closestDistance) {
            closestPosition = potentialPosition;
            closestDistance = potentialDistance;
          }
        }
        if (closestPosition != BWAPI::TilePositions::None) {
          BaseLocation newBaseLocation;
          newBaseLocation.ID = resourceGroup;
          newBaseLocation.location = closestPosition;
          newBaseLocation.region = BWAPI::Broodwar->getRegionAt(BWAPI::Position{ newBaseLocation.location });
          baseLocations[newBaseLocation.ID] = newBaseLocation;
          if (map == Maps::None) {
            attackLocations.push_back(closestPosition);
          }
        }
        /*if (baseLocations[resourceGroup].location != BWAPI::TilePositions::Origin) {
          continue;
        }
        else {
          BaseLocation newBaseLocation;
          BWAPI::TilePosition averageTilePosition = { 0, 0 };
          int divisor = 0;
          for (auto& unit : unitset) {
            unit->getType().isRefinery() || unit->getType() == BWAPI::UnitTypes::Resource_Vespene_Geyser ? averageTilePosition += unit->getTilePosition() * 4 : averageTilePosition += unit->getTilePosition();
            unit->getType().isRefinery() || unit->getType() == BWAPI::UnitTypes::Resource_Vespene_Geyser ? divisor += 4 : divisor++;
          }
          averageTilePosition /= divisor;
          BWAPI::TilePosition baseLocation = BWAPI::Broodwar->getBuildLocation(BWAPI::UnitTypes::Terran_Command_Center, averageTilePosition);
          if (baseLocation.isValid()) {
            newBaseLocation.ID = resourceGroup;
            newBaseLocation.location = baseLocation;
            newBaseLocation.region = BWAPI::Broodwar->getRegionAt(BWAPI::Position{ newBaseLocation.location });
            baseLocations[newBaseLocation.ID] = newBaseLocation;
            if (map == Maps::None) {
              attackLocations.push_back(baseLocation);
            }
          }
        }*/
      }
      // Find and connect neighbors
      for (auto& [id, baseLocation] : baseLocations) {
        BWAPI::Region region = BWAPI::Broodwar->getRegionAt(BWAPI::Position{ baseLocation.location });
        struct node {
        public:
          BWAPI::Region region;
          int cost;
        };
        std::queue<node> Q;
        std::map<BWAPI::Region, bool> checked;
        Q.push(node{ region, 0 });
        checked[region] = true;
        region = nullptr;
        while (Q.size()) {
          auto v = Q.front();
          Q.pop();
          for (auto& [id2, baseLocation2] : baseLocations) {
            if (id != id2
              && v.region == baseLocation2.region) {
              baseLocation.neighbors.push_back(std::make_pair(std::make_shared<BaseLocation>(baseLocations[id2]), v.cost));
            }
          }
          for (auto r : v.region->getNeighbors()) {
            if (!checked[r]
              && r->getRegionGroupID() == v.region->getRegionGroupID()
              && r->isAccessible()) {
              Q.push(node{ r, v.cost + 1 });
              checked[r] = true;
            }
          }
        }
      }
      if (map != Maps::None) {
        switch (map) {
        case Maps::BackwaterStation:
          attackLocations.push_back(BWAPI::TilePosition{ 5, 3 });
          attackLocations.push_back(BWAPI::TilePosition{ 55, 1 });
          break;
        case Maps::TheJacobsInstallation:
          attackLocations.push_back(BWAPI::TilePosition{ 69, 120 });
          attackLocations.push_back(BWAPI::TilePosition{ 26, 116 });
          attackLocations.push_back(BWAPI::TilePosition{ 13, 71 });
          attackLocations.push_back(BWAPI::TilePosition{ 45, 63 });
          attackLocations.push_back(BWAPI::TilePosition{ 28, 41 });
          attackLocations.push_back(BWAPI::TilePosition{ 13, 35 });
          attackLocations.push_back(BWAPI::TilePosition{ 29, 5 });
          attackLocations.push_back(BWAPI::TilePosition{ 75, 62 });
          break;
        case Maps::Revolution:
          attackLocations.push_back(BWAPI::TilePosition{ 4, 38 });
          attackLocations.push_back(BWAPI::TilePosition{ 22, 56 });
          attackLocations.push_back(BWAPI::TilePosition{ 47, 19 });
          break;
        case Maps::NoradII:
          attackLocations.push_back(BWAPI::TilePosition{ 8, 78 });
          break;
        default:
          break;
        }
      }
    }

    if (map == Maps::Revolution
      && (BWAPI::Broodwar->self()->getClientInfo<int>(static_cast<int>(ClientInfo::Flags)) & 0x1)
      && attackLocations.size() == 3) {
      attackLocations.clear();
      attackLocations.push_back(BWAPI::TilePosition{ 90, 78 });
      attackLocations.push_back(BWAPI::TilePosition{ 63, 92 });
      attackLocations.push_back(BWAPI::TilePosition{ 3, 76 });
      attackLocations.push_back(BWAPI::TilePosition{ 2, 91 });
      auto itr = attackerUnitSets.begin();
      while (itr != attackerUnitSets.end()) {
        itr->setClientInfo(static_cast<int>(JobType::None), static_cast<int>(ClientInfo::Job));
        itr = attackerUnitSets.erase(itr);
      }
    }
    else if (map == Maps::NoradII
      && (BWAPI::Broodwar->self()->getClientInfo<int>(static_cast<int>(ClientInfo::Flags)) & 0x1)
      && attackLocations.size() == 1) {
      attackLocations.clear();
      attackLocations.push_back(BWAPI::TilePosition{ 31, 35 });
      attackLocations.push_back(BWAPI::TilePosition{ 61, 75 });
      auto itr = attackerUnitSets.begin();
      while (itr != attackerUnitSets.end()) {
        itr->setClientInfo(static_cast<int>(JobType::None), static_cast<int>(ClientInfo::Job));
        itr = attackerUnitSets.erase(itr);
      }
    }

    for (auto& unit : BWAPI::Broodwar->getAllUnits()) {
      if (unit->getPlayer() == BWAPI::Broodwar->self()) {
        if (unit->getType() == BWAPI::UnitTypes::Zerg_Egg) {
          supplyConstruction += unit->getTrainingQueue().begin()->supplyProvided();
          counts.raw[*unit->getTrainingQueue().begin()]++;
          counts.incomplete[*unit->getTrainingQueue().begin()]++;
          if (*unit->getTrainingQueue().begin() == BWAPI::UnitTypes::Zerg_Zergling
            || *unit->getTrainingQueue().begin() == BWAPI::UnitTypes::Zerg_Scourge) {
            counts.raw[*unit->getTrainingQueue().begin()]++;
            counts.incomplete[*unit->getTrainingQueue().begin()]++;
          }
        }

        if (unit->getType() == BWAPI::UnitTypes::Zerg_Lurker_Egg) {
          counts.raw[BWAPI::UnitTypes::Zerg_Lurker]++;
          counts.incomplete[BWAPI::UnitTypes::Zerg_Lurker]++;
        }

        if ((unit->getType() == BWAPI::UnitTypes::Protoss_Shuttle
          || unit->getType() == BWAPI::UnitTypes::Terran_Dropship
          || unit->getType() == BWAPI::UnitTypes::Zerg_Overlord)
          && unit->getClientInfo<int>(static_cast<int>(ClientInfo::Sleep)) == 0) {
          auto inTransportTracked = unit->getClientInfo<int>(static_cast<int>(ClientInfo::InTransport));
          auto inTransportActual = unit->getType().spaceProvided() - unit->getSpaceRemaining();
          if (inTransportTracked < inTransportActual) {
            auto queuedTransport = unit->getClientInfo<int>(static_cast<int>(ClientInfo::QueuedTransport));
            queuedTransport = unit->getSpaceRemaining() - inTransportTracked;
            if (queuedTransport < 0) {
              queuedTransport = 0;
            }
            unit->setClientInfo<int>(queuedTransport, static_cast<int>(ClientInfo::QueuedTransport));
            unit->setClientInfo<int>(inTransportActual, static_cast<int>(ClientInfo::InTransport));
          }
          else if (inTransportActual < inTransportTracked) {
            unit->setClientInfo<int>(inTransportActual, static_cast<int>(ClientInfo::InTransport));
          }
        }

        if (unit->getType() == BWAPI::UnitTypes::Zerg_Larva) {
          auto type = unit->getClientInfo<BWAPI::UnitType>(static_cast<int>(ClientInfo::MorphingInto));
          if (type != BWAPI::UnitTypes::None) {
            counts.raw[type]++;
            counts.incomplete[type]++;
            if (type == BWAPI::UnitTypes::Zerg_Zergling
              || type == BWAPI::UnitTypes::Zerg_Scourge) {
              counts.raw[type]++;
              counts.incomplete[type]++;
            }
            counts.raw[unit->getType()]--;
            counts.complete[unit->getType()]--;
            supplyConstruction += type.supplyProvided();
          }
        }

        if ((unit->isMorphing()
          && unit->getType() == BWAPI::UnitTypes::Zerg_Hatchery)
          || !unit->isCompleted())
          supplyConstruction += unit->getType().supplyProvided();

        counts.raw[unit->getType()]++;
        if (unit->isCompleted())
          counts.complete[unit->getType()]++;
        else
          counts.incomplete[unit->getType()]++;

        if (unit->getType().isWorker()) {
          if (static_cast<JobType>(unit->getClientInfo<int>(static_cast<int>(ClientInfo::Job))) == JobType::HoldDefend) {
            continue;
          }
          auto location = BWAPI::TilePosition{ unit->getClientInfo<int>(static_cast<int>(ClientInfo::BuildLocationX)), unit->getClientInfo<int>(static_cast<int>(ClientInfo::BuildLocationY)) };
          if (location.isValid()) {
            auto buildType = unit->getClientInfo<BWAPI::UnitType>(static_cast<int>(ClientInfo::BuildType));
            auto inRectangle = BWAPI::Broodwar->getUnitsInRectangle(BWAPI::Position{ location }, BWAPI::Position{ location + buildType.tileSize() }, BWAPI::Filter::IsBuilding && !BWAPI::Filter::IsCompleted);
            if (inRectangle.size()) {
              unit->setClientInfo(BWAPI::TilePositions::None.x, static_cast<int>(ClientInfo::BuildLocationX));
              unit->setClientInfo(BWAPI::TilePositions::None.y, static_cast<int>(ClientInfo::BuildLocationY));
              unit->setClientInfo(static_cast<int>(BWAPI::UnitTypes::None), static_cast<int>(ClientInfo::BuildType));
              if (buildType.isResourceDepot()) {
                for (auto building : inRectangle) {
                  if (building->getType().isResourceDepot()) {
                    unit->setClientInfo(building, static_cast<int>(ClientInfo::AssignedDepot));
                  }
                }
              }
            }
            else {
              supplyConstruction += buildType.supplyProvided();
              minerals -= buildType.mineralPrice();
              gas -= buildType.gasPrice();
            }
          }
        }
        else if (unit->getType().isResourceDepot()) {
          if (unit->getType().getRace() == BWAPI::Races::Zerg
            && unit->getClientInfo<int>(static_cast<int>(ClientInfo::ResourceGroup)) != -1) {
            auto sunkens = unit->getUnitsInRadius(buildRange * 32, BWAPI::Filter::GetType == BWAPI::UnitTypes::Zerg_Sunken_Colony && BWAPI::Filter::GetPlayer == BWAPI::Broodwar->self());
            unit->setClientInfo(sunkens.size(), static_cast<int>(ClientInfo::SunkenCount));
            auto macroHatches = unit->getUnitsInRadius(buildRange * 32, BWAPI::Filter::IsResourceDepot && BWAPI::Filter::GetRace == BWAPI::Races::Zerg);
            unit->setClientInfo(macroHatches.size(), static_cast<int>(ClientInfo::MacroHatchCount));
          }
          else if (unit->getType().getRace() == BWAPI::Races::Terran) {
            auto bunkers = unit->getUnitsInRadius(buildRange * 32, BWAPI::Filter::GetType == BWAPI::UnitTypes::Terran_Bunker && BWAPI::Filter::GetPlayer == BWAPI::Broodwar->self());
            unit->setClientInfo(bunkers.size(), static_cast<int>(ClientInfo::BunkerCount));
          }
        }
        auto clientInfo = static_cast<int>(ClientInfo::UnitAI);
        switch (unit->getType().getID()) {
        case BWAPI::UnitTypes::Terran_SCV:
        case BWAPI::UnitTypes::Zerg_Drone:
        case BWAPI::UnitTypes::Protoss_Probe:
          unit->setClientInfo(&workerAI, clientInfo);
          break;
        case BWAPI::UnitTypes::Terran_Marine:
        case BWAPI::UnitTypes::Terran_Firebat:
        case BWAPI::UnitTypes::Hero_Jim_Raynor_Marine:
        case BWAPI::UnitTypes::Hero_Gui_Montag:
          unit->setClientInfo(&stimmableAI, clientInfo);
          break;
        case BWAPI::UnitTypes::Terran_Medic:
          unit->setClientInfo(&medicAI, clientInfo);
          break;
        case BWAPI::UnitTypes::Terran_Ghost:
          unit->setClientInfo(&ghostAI, clientInfo);
          break;
        case BWAPI::UnitTypes::Terran_Vulture:
        case BWAPI::UnitTypes::Hero_Jim_Raynor_Vulture:
          unit->setClientInfo(&vultureAI, clientInfo);
          break;
        case BWAPI::UnitTypes::Terran_Goliath:
        case BWAPI::UnitTypes::Terran_Valkyrie:
        case BWAPI::UnitTypes::Protoss_Zealot:
        case BWAPI::UnitTypes::Protoss_Dragoon:
          unit->setClientInfo(&unitWithWeaponsAI, clientInfo);
          break;
        case BWAPI::UnitTypes::Terran_Siege_Tank_Tank_Mode:
        case BWAPI::UnitTypes::Terran_Siege_Tank_Siege_Mode:
          unit->setClientInfo(&tankAI, clientInfo);
          break;
        case BWAPI::UnitTypes::Terran_Wraith:
          unit->setClientInfo(&wraithAI, clientInfo);
          break;
        case BWAPI::UnitTypes::Terran_Science_Vessel:
          unit->setClientInfo(&vesselAI, clientInfo);
          break;
        case BWAPI::UnitTypes::Terran_Battlecruiser:
          unit->setClientInfo(&battlecruiserAI, clientInfo);
          break;
        case BWAPI::UnitTypes::Terran_Comsat_Station:
          unit->setClientInfo(&comsatAI, clientInfo);
          break;
        case BWAPI::UnitTypes::Zerg_Zergling:
        case BWAPI::UnitTypes::Zerg_Scourge:
        case BWAPI::UnitTypes::Zerg_Ultralisk:
        case BWAPI::UnitTypes::Zerg_Guardian:
        case BWAPI::UnitTypes::Zerg_Devourer:
        case BWAPI::UnitTypes::Protoss_Scout:
        case BWAPI::UnitTypes::Protoss_Archon:
          unit->setClientInfo(&unitWithWeaponsAI, clientInfo);
          break;
        case BWAPI::UnitTypes::Zerg_Hydralisk:
          unit->setClientInfo(&hydraliskAI, clientInfo);
          break;
        case BWAPI::UnitTypes::Zerg_Lurker_Egg:
          unit->setClientInfo(&lurkerEggAI, clientInfo);
          break;
        case BWAPI::UnitTypes::Zerg_Lurker:
          unit->setClientInfo(&lurkerAI, clientInfo);
          break;
        case BWAPI::UnitTypes::Zerg_Mutalisk:
          unit->setClientInfo(&mutaliskAI, clientInfo);
          break;
        case BWAPI::UnitTypes::Zerg_Queen:
          unit->setClientInfo(&queenAI, clientInfo);
          break;
        case BWAPI::UnitTypes::Zerg_Defiler:
          unit->setClientInfo(&defilerAI, clientInfo);
          break;
        case BWAPI::UnitTypes::Zerg_Overlord:
          unit->setClientInfo(&overlordAI, clientInfo);
          break;
        case BWAPI::UnitTypes::Protoss_High_Templar:
          unit->setClientInfo(&templarAI, clientInfo);
          break;
        case BWAPI::UnitTypes::Protoss_Dark_Templar:
          unit->setClientInfo(&darkTemplarAI, clientInfo);
          break;
        case BWAPI::UnitTypes::Protoss_Observer:
          unit->setClientInfo(&patrolDetectorAI, clientInfo);
          break;
        case BWAPI::UnitTypes::Protoss_Carrier:
          unit->setClientInfo(&carrierAI, clientInfo);
          break;
        case BWAPI::UnitTypes::Protoss_Arbiter:
          unit->setClientInfo(&arbiterAI, clientInfo);
          break;
        case BWAPI::UnitTypes::Protoss_Corsair:
          unit->setClientInfo(&corsairAI, clientInfo);
          break;
        case BWAPI::UnitTypes::Protoss_Dark_Archon:
          unit->setClientInfo(&darkArchonAI, clientInfo);
          break;
        default:
          unit->setClientInfo(nullptr, clientInfo);
          break;
        }
      }
      else if (unit->getPlayer()->isEnemy(BWAPI::Broodwar->self())
        && unit->getType().isBuilding()
        && !unit->getType().isBeacon()) {
        unit->setClientInfo(unit->getTilePosition().x, static_cast<int>(ClientInfo::BuildLocationX));
        unit->setClientInfo(unit->getTilePosition().y, static_cast<int>(ClientInfo::BuildLocationY));
        enemyBuildings[unit->getID()] = unit;
      }
    }
  }
}