#pragma once
#include <array>
#include <BWAPI.h>
#include <fstream>
#include <memory>
#include <string>
#include <vector>

#include "data.h"



struct bwapidatadisplay {
public:
  bwapidatadisplay() { data = std::make_shared<Data>(); }
  bool loggingOn();
  void onFrame();
  void startLogging();
  void stopLogging();
private:
  void buildOrder();
  void camera();
  bool canUseTech(BWAPI::Unit unit, BWAPI::TechType tech);
  void checkUnits();
  BWAPI::TilePosition getBuildLocation(BWAPI::UnitType buildType, BWAPI::TilePosition desiredPosition, int range);
  BWAPI::Unit getClosestNotMacroResourceDepot(BWAPI::Unit unit);
  bool issueOrder(BWAPI::Unit unit, BWAPI::Order orderType, BWAPI::Position targetPosition = BWAPI::Positions::None, BWAPI::Unit targetUnit = nullptr);
  void macro();
  void micro();
  void printInfo();
  void requestTaxi(BWAPI::Unit unit, BWAPI::Position target);
  void updateAttacks();
  void updateJobs();
  void updateTracking();
  void updateUnitSets();  

  std::shared_ptr<Data> data;

  //debug flags
  bool printCounts = false;
  bool printAllows = true;
  bool printJobs = false;
  bool printUnitSets = false;
  bool printOrders = false;
  bool printBuildOrders = false;
  bool printIDs = false;
  bool printStatus = false;
  bool printBaseInformation = false;
  bool printAssignedDepots = false;
};