#include "bwapidatadisplay.h"
#include <math.h>
#include <sstream>
#include <queue>

#include "buildorder.h"

bool bwapidatadisplay::loggingOn() {
  return data->logFile.is_open();
}

void bwapidatadisplay::onFrame() {
  /*if (BWAPI::Broodwar->getFrameCount() == 0) {
    //BWAPI::Broodwar->sendText("there is no cow level");
    BWAPI::Broodwar->sendText("black sheep wall");
  }
  /*std::map<int, BWAPI::Unitset> resourceswithgas;
  std::map<int, BWAPI::Unitset> resourceswithoutgas;
  for (auto& unit : BWAPI::Broodwar->getStaticNeutralUnits()) {
    if (!unit->getType().isMineralField() && unit->getType() != BWAPI::UnitTypes::Resource_Vespene_Geyser) {
      continue;
    }

    if (unit->getType().isMineralField()) {
      resourceswithgas[unit->getResourceGroup()].insert(unit);
      resourceswithoutgas[unit->getResourceGroup()].insert(unit);
    }
    if (unit->getType() == BWAPI::UnitTypes::Resource_Vespene_Geyser) {
      resourceswithgas[unit->getResourceGroup()].insert(unit);
    }
  }
  for (auto group : resourceswithgas) {
    BWAPI::Broodwar->drawBoxMap(group.second.getPosition() + BWAPI::Position{ -16, -16 }, group.second.getPosition() + BWAPI::Position{ 16, 16 }, BWAPI::Colors::Green, true);
  }
  for (auto group : resourceswithoutgas) {
    BWAPI::Broodwar->drawBoxMap(group.second.getPosition() + BWAPI::Position{ -16, -16 }, group.second.getPosition() + BWAPI::Position{ 16, 16 }, BWAPI::Colors::Purple, true);
  }*/
  
  for (auto& unit : BWAPI::Broodwar->getSelectedUnits()) {
    BWAPI::Broodwar->drawTextMap(unit->getPosition(), "%i, %i", unit->getTilePosition().x, unit->getTilePosition().y);
  }
  camera();
  updateTracking();
  updateUnitSets();
  checkUnits();
  updateJobs();
  buildOrder();
  printInfo();
  macro();
  micro();
  updateAttacks();
}

void bwapidatadisplay::buildOrder() {
  auto myBuild = BWAPI::Broodwar->self()->getClientInfo<void(*)(std::shared_ptr<Data>)>(static_cast<int>(ClientInfo::BuildOrder));
  myBuild(data);
}

void bwapidatadisplay::camera() {
  if (!data->controlCamera || !BWAPI::Broodwar->getFrameCount())
    return;

  if (data->cameraCooldown) {
    if(!BWAPI::Broodwar->getUnitsInRectangle(BWAPI::Broodwar->getScreenPosition(), BWAPI::Broodwar->getScreenPosition() + BWAPI::Position{ 640, 400 }, BWAPI::Filter::GetType != BWAPI::UnitTypes::Zerg_Larva).size())
      data->cameraCooldown = 0;
    else
      data->cameraCooldown--;
  }

  auto centerAdjust = BWAPI::Position{ -320, -200 };
  if (data->cameraTarget == BWAPI::Positions::None) {
    data->cameraTarget = BWAPI::Position{ BWAPI::Broodwar->self()->getStartLocation() };
  }

  auto isOffScreen = [](BWAPI::Position position) {
    auto topLeftCorner = BWAPI::Broodwar->getScreenPosition();
    auto difference = position - topLeftCorner;
    return difference.x < 0 || difference.y < 0 || 640 < difference.x || 400 < difference.y;
  };

  //BWAPI::Broodwar->drawBoxMap(data->cameraTarget, data->cameraTarget + BWAPI::Position{ 32, 32 }, BWAPI::Colors::Red, false);

  auto currentCamera = BWAPI::Broodwar->getScreenPosition();

  //BWAPI::Broodwar->drawDotScreen(BWAPI::Position{ centerAdjust.x * -1, centerAdjust.y * -1 }, BWAPI::Colors::Red);

  for (auto& region : BWAPI::Broodwar->getAllRegions()) {
    region->setClientInfo(0, static_cast<int>(ClientInfo::CameraScore));
    int score = 0;
    BWAPI::Position averageUnitPosition = BWAPI::Position{ 0, 0 };
    int averageDivisor = 0;
    for (auto& unit : region->getUnits()) {
      if (unit->getPlayer()->isNeutral())
        continue;

      if (!unit->getType().isBuilding()
        && !unit->isCompleted()
        && unit->getType().getRace() != BWAPI::Races::Zerg)
        continue;

      if (unit->getType() == BWAPI::UnitTypes::Zerg_Larva)
        continue;

      double affiliationModifier = unit->getPlayer()->isEnemy(BWAPI::Broodwar->self()) ? 0.75 : unit->getPlayer()->isAlly(BWAPI::Broodwar->self()) ? 0.50 : 1;
      if (!unit->isCompleted()) {
        auto incompleteness = 100 * unit->getHitPoints() / unit->getType().maxHitPoints();
        if (incompleteness < 50 || 95 < incompleteness)
          score += 5;
        else
          score += 2;
      }
      if (unit->isUnderAttack()) {
        if (unit->isCompleted())
          score += 10;
        else
          score += 15;
      }
      if (unit->isAttacking()) {
        score += 10;
      }
      if (unit->isMoving()
        && !unit->isGatheringMinerals()
        && !unit->isGatheringGas()
        && !(unit->isConstructing()
          && unit->getBuildUnit() != nullptr)) {
        score += 2;
      }
      if (unit->isTraining()
        || (unit->isMorphing() && !unit->getType().isBuilding())) {
        score += 1;
      }
      if (static_cast<JobType>(unit->getClientInfo<int>(static_cast<int>(ClientInfo::Job))) == JobType::Attack) {
        score += 3;
      }
      score = score * affiliationModifier;
      averageUnitPosition += unit->getPosition();
      averageDivisor++;
    }
    region->setClientInfo(score, static_cast<int>(ClientInfo::CameraScore));
    if (averageDivisor)
      averageUnitPosition = averageUnitPosition / averageDivisor;
    else
      averageUnitPosition = region->getCenter();
    region->setClientInfo(averageUnitPosition.x, static_cast<int>(ClientInfo::CameraX));
    region->setClientInfo(averageUnitPosition.y, static_cast<int>(ClientInfo::CameraY));
  }
  for (auto& bullet : BWAPI::Broodwar->getBullets()) {
    if (bullet->getType() == BWAPI::BulletTypes::Psionic_Storm) {
      auto region = BWAPI::Broodwar->getRegionAt(bullet->getTargetPosition());
      if (region) {
        region->setClientInfo(region->getClientInfo<int>(static_cast<int>(ClientInfo::CameraScore)) + 5 * region->getUnits().size(), static_cast<int>(ClientInfo::CameraScore));
      }
    }
  }
  for (auto& dot : BWAPI::Broodwar->getNukeDots()) {
    auto region = BWAPI::Broodwar->getRegionAt(dot);
    if (region) {
      region->setClientInfo(region->getClientInfo<int>(static_cast<int>(ClientInfo::CameraScore)) + 20 * BWAPI::Broodwar->getUnitsInRadius(dot, 96).size(), static_cast<int>(ClientInfo::CameraScore));
    }
  }
  int bestScore = 0;
  BWAPI::Position target = BWAPI::Position{ 0, 0 };
  for (auto& region : BWAPI::Broodwar->getAllRegions()) {
    auto score = region->getClientInfo<int>(static_cast<int>(ClientInfo::CameraScore));
    if (bestScore < score) {
      auto potentialTarget = BWAPI::Position{ region->getClientInfo<int>(static_cast<int>(ClientInfo::CameraX)), region->getClientInfo<int>(static_cast<int>(ClientInfo::CameraY)) };
      if (!isOffScreen(potentialTarget) || !data->cameraCooldown) {
        bestScore = score;
        target = potentialTarget;
      }
    }
  }

  if (target != BWAPI::Positions::None && target != BWAPI::Positions::Origin
    && (std::abs(data->cameraTarget.x - target.x) > 15 || std::abs(data->cameraTarget.y - target.y) > 15)) {
    data->cameraTarget = target;
  }

  if (!data->cameraTarget.isValid())
    data->cameraTarget.makeValid();

  if (isOffScreen(data->cameraTarget)) {
    data->cameraCooldown = 23 * 10;
  }

  auto movePosition = (data->cameraTarget + centerAdjust) - currentCamera;
  if (std::abs(movePosition.x) > BWAPI::Broodwar->mapWidth() * 32 / 20) {
    if (0 < movePosition.x)
      movePosition.x = BWAPI::Broodwar->mapWidth() * 32 / 20;
    else if (movePosition.x < 0)
      movePosition.x = -1 * BWAPI::Broodwar->mapWidth() * 32 / 20;
  }
  if (std::abs(movePosition.y) > BWAPI::Broodwar->mapHeight() * 32 / 20) {
    if (0 < movePosition.y)
      movePosition.y = BWAPI::Broodwar->mapHeight() * 32 / 20;
    else if (movePosition.y < 0)
      movePosition.y = -1 * BWAPI::Broodwar->mapHeight() * 32 / 20;
  }
  target = currentCamera + movePosition;
  if (!target.isValid()) {
    target.makeValid();
  }
  BWAPI::Broodwar->setScreenPosition(target);
}

bool bwapidatadisplay::canUseTech(BWAPI::Unit unit, BWAPI::TechType tech) {
  using namespace BWAPI::TechTypes;
  using namespace BWAPI::UnitTypes;
  auto self = BWAPI::Broodwar->self();
  auto type = unit->getType();
  switch (tech) {
  case Stim_Packs:
    return ((type == Terran_Marine || type == Terran_Firebat) && self->hasResearched(Stim_Packs)) || type == Hero_Jim_Raynor_Marine || type == Hero_Gui_Montag;
  case Lockdown:
    return type == Hero_Infested_Duran || (type == Terran_Ghost && self->hasResearched(Lockdown)) || type == Hero_Alexei_Stukov || type == Hero_Samir_Duran || type == Hero_Sarah_Kerrigan;
  case EMP_Shockwave:
    return (type == Terran_Science_Vessel && self->hasResearched(EMP_Shockwave)) || type == Hero_Magellan;
  case Spider_Mines:
    return 0 < unit->getSpiderMineCount() && ((type == Terran_Vulture && self->hasResearched(Spider_Mines)) || type == Hero_Jim_Raynor_Vulture);
  case Scanner_Sweep:
    return type == Terran_Comsat_Station;
  case Tank_Siege_Mode:
    return ((type == Terran_Siege_Tank_Siege_Mode || type == Terran_Siege_Tank_Tank_Mode) && self->hasResearched(Tank_Siege_Mode)) || type == Hero_Edmund_Duke_Siege_Mode || type == Hero_Edmund_Duke_Tank_Mode;
  case Defensive_Matrix:
    return type == Terran_Science_Vessel || type == Hero_Magellan;
  case Irradiate:
    return (type == Terran_Science_Vessel && self->hasResearched(Irradiate)) || type == Hero_Magellan;
  case Yamato_Gun:
    return (type == Terran_Battlecruiser && self->hasResearched(Yamato_Gun)) || type == Hero_Gerard_DuGalle || type == Hero_Hyperion || type == Hero_Norad_II;
  case Cloaking_Field:
    return (type == Terran_Wraith && self->hasResearched(Cloaking_Field)) || type == Hero_Tom_Kazansky;
  case Personnel_Cloaking:
    return type == Hero_Infested_Duran || type == Hero_Infested_Kerrigan || (type == Terran_Ghost && self->hasResearched(Personnel_Cloaking)) || type == Hero_Samir_Duran || type == Hero_Sarah_Kerrigan;
  case Burrowing:
    return ((type == Zerg_Infested_Terran || type == Zerg_Drone || type == Zerg_Hydralisk || type == Zerg_Zergling || type == Zerg_Defiler) && self->hasResearched(Burrowing)) || type == Zerg_Lurker || type == Hero_Devouring_One || type == Hero_Hunter_Killer || type == Hero_Unclean_One;
  case Infestation:
    return type == Zerg_Queen || type == Hero_Matriarch;
  case Spawn_Broodlings:
    return (type == Zerg_Queen && self->hasResearched(Spawn_Broodlings)) || type == Hero_Matriarch;
  case Dark_Swarm:
    return type == Zerg_Defiler || type == Hero_Unclean_One;
  case Plague:
    return (type == Zerg_Defiler && self->hasResearched(Plague)) || type == Hero_Unclean_One;
  case Consume:
    return (type == Zerg_Defiler && self->hasResearched(Consume)) || type == Hero_Infested_Duran || type == Hero_Infested_Kerrigan || type == Hero_Unclean_One;
  case Ensnare:
    return (type == Zerg_Queen && self->hasResearched(Ensnare)) || type == Hero_Infested_Kerrigan || type == Hero_Matriarch;
  case Parasite:
    return type == Zerg_Queen || type == Hero_Matriarch;
  case Psionic_Storm:
    return type == Hero_Infested_Kerrigan || (type == Protoss_High_Templar && self->hasResearched(Psionic_Storm)) || type == Hero_Tassadar;
  case Hallucination:
    return (type == Protoss_High_Templar && self->hasResearched(Hallucination)) || type == Hero_Tassadar;
  case Recall:
    return (type == Protoss_Arbiter && self->hasResearched(Recall)) || type == Hero_Danimoth;
  case Stasis_Field:
    return (type == Protoss_Arbiter && self->hasResearched(Stasis_Field)) || type == Hero_Danimoth;
  case Archon_Warp:
    return type == Protoss_High_Templar;
  case Restoration:
    return type == Terran_Medic && self->hasResearched(Restoration);
  case Disruption_Web:
    return (type == Protoss_Corsair && self->hasResearched(Disruption_Web)) || type == Hero_Raszagal;
  case Mind_Control:
    return type == Protoss_Dark_Archon && self->hasResearched(Mind_Control);
  case Dark_Archon_Meld:
    return type == Protoss_Dark_Templar;
  case Feedback:
    return type == Protoss_Dark_Archon;
  case Optical_Flare:
    return type == Terran_Medic && self->hasResearched(Optical_Flare);
  case Maelstrom:
    return type == Protoss_Dark_Archon && self->hasResearched(Maelstrom);
  case Lurker_Aspect:
    return type == Zerg_Hydralisk && self->hasResearched(Lurker_Aspect);
  case Healing:
    return type == Terran_Medic;
  case BWAPI::TechTypes::None:
    return false;
  case Nuclear_Strike:
    return type == Terran_Ghost;
  default:
    return false;
  }
}

void bwapidatadisplay::checkUnits() {
  for (auto unit : BWAPI::Broodwar->getAllUnits()) {
    if (unit->getPlayer() != BWAPI::Broodwar->self() && !unit->getPlayer()->isNeutral())
      continue;

    if (unit->getType().isResourceDepot()) {
      data->resourceDepots.insert(unit);
      data->productionBuildings.insert(unit);
      auto closestResource = unit->getClosestUnit(BWAPI::Filter::IsResourceContainer, 500);
      unit->setClientInfo(-1, static_cast<int>(ClientInfo::ResourceGroup));
      if (!closestResource)
        continue;
      bool setResourceGroup = true;
      for (auto& resourceDepot : data->resourceDepots) {
        if (resourceDepot->getClientInfo<int>(static_cast<int>(ClientInfo::ResourceGroup)) == closestResource->getResourceGroup()) {
          setResourceGroup = false;
          break;
        }
      }
      if (setResourceGroup) {
        unit->setClientInfo(closestResource->getResourceGroup(), static_cast<int>(ClientInfo::ResourceGroup));

        BWAPI::Region region = unit->getRegion();
        std::queue<BWAPI::Region> Q;
        std::map<BWAPI::Region, bool> checked;
        Q.push(region);
        checked[region] = true;
        region = nullptr;
        while (Q.size()) {
          auto v = Q.front();
          Q.pop();
          data->defenderRegions[closestResource->getResourceGroup()].insert(v);
          for (auto r : v->getNeighbors()) {
            if (!checked[r]
              && r->getUnits(BWAPI::Filter::IsBuilding && BWAPI::Filter::GetPlayer == BWAPI::Broodwar->self()).size()) {
              Q.push(r);
              checked[r] = true;
            }
          }
        }
      }
      continue;
    }

    if (unit->getType() == BWAPI::UnitTypes::Zerg_Larva
      && unit->getClientInfo<BWAPI::UnitType>(static_cast<int>(ClientInfo::MorphingInto)) == BWAPI::UnitTypes::Terran_Marine)
      unit->setClientInfo(static_cast<int>(BWAPI::UnitTypes::None), static_cast<int>(ClientInfo::MorphingInto));

    if (unit->getType().isWorker()) {
      auto buildType = unit->getClientInfo<BWAPI::UnitType>(static_cast<int>(ClientInfo::BuildType));
      if (!buildType.isBuilding()) {
        unit->setClientInfo(static_cast<int>(BWAPI::UnitTypes::None), static_cast<int>(ClientInfo::BuildType));
        unit->setClientInfo(BWAPI::TilePositions::None.x, static_cast<int>(ClientInfo::BuildLocationX));
        unit->setClientInfo(BWAPI::TilePositions::None.y, static_cast<int>(ClientInfo::BuildLocationY));
      }
      else {
        data->counts.raw[buildType]++;
        data->counts.incomplete[buildType]++;
      }
      if (unit->isGatheringMinerals()) {
        auto target = unit->getTarget();
        if (!target) {
          auto closestMineral = unit->getClosestUnit(BWAPI::Filter::IsMineralField, 500);
          if (!closestMineral)
            continue;
          data->mineralWorkers[closestMineral->getResourceGroup()]++;
          continue;
        }
        if (target->getType().isResourceDepot()) {
          auto resourceGroup = target->getClientInfo<int>(static_cast<int>(ClientInfo::ResourceGroup));
          if (resourceGroup != -1) {
            data->mineralWorkers[target->getClientInfo<int>(static_cast<int>(ClientInfo::ResourceGroup))]++;
          }
          else {
            auto closestMineral = unit->getClosestUnit(BWAPI::Filter::IsMineralField, 500);
            if (!closestMineral)
              continue;
            data->mineralWorkers[closestMineral->getResourceGroup()]++;
            continue;
          }
        }
        else {
          data->mineralWorkers[target->getResourceGroup()]++;
        }
      }
      continue;
    }

    if (unit->getType().isBuilding() && (unit->getType().buildsWhat().size() || unit->getType().upgradesWhat().size() || unit->getType().researchesWhat().size())) {
      data->productionBuildings.insert(unit);
    }

    if (unit->getType().isRefinery()) {
      data->refineries.insert(unit);
    }

    if (unit->getType().isMineralField()) {
      data->maxMineralWorkers[unit->getResourceGroup()] += 2;
    }
  }
}

BWAPI::Unit bwapidatadisplay::getClosestNotMacroResourceDepot(BWAPI::Unit unit) {
  BWAPI::Unit closestDepot = nullptr;
  int closestDistance = INT_MAX;
  for (auto& resourceDepot : data->resourceDepots) {
    if (resourceDepot->getClientInfo<int>(static_cast<int>(ClientInfo::ResourceGroup)) == -1)
      continue;

    auto distance = unit->getDistance(resourceDepot);
    if (distance < closestDistance) {
      closestDistance = distance;
      closestDepot = resourceDepot;
    }
  }
  return closestDepot;
}

BWAPI::TilePosition bwapidatadisplay::getBuildLocation(BWAPI::UnitType buildType, BWAPI::TilePosition desiredPosition, int range) {
  if (!buildType.isBuilding())
    return BWAPI::TilePositions::None;

  if (buildType.isRefinery()) {
    auto geyser = BWAPI::Broodwar->getClosestUnit(BWAPI::Position{ desiredPosition }, BWAPI::Filter::GetType == BWAPI::UnitTypes::Resource_Vespene_Geyser, 800);
    if (!geyser)
      return BWAPI::TilePositions::None;
    else
      return geyser->getTilePosition();
  }

  struct node {
    BWAPI::TilePosition tilePosition;
    int cost;
  };

  if (buildType.getRace() == BWAPI::Races::Terran
    && buildType.tileSize() == BWAPI::TilePosition{ 3, 2 }
    && buildType != BWAPI::UnitTypes::Terran_Bunker) {
    for (auto unit : BWAPI::Broodwar->self()->getUnits()) {
      if (unit->getType().tileSize() != BWAPI::TilePosition{ 3, 2 })
        continue;
      bool use = true;

      auto buildingsLocation = unit->getTilePosition();
      BWAPI::TilePosition checkLocation;
      for (int y = 0; y != 2;) {
        for (int x = -1; x != 2; x++) {
          checkLocation = buildingsLocation + BWAPI::TilePosition{ x * 3, y * 2 };
          auto closestResource = BWAPI::Broodwar->getClosestUnit(BWAPI::Position{ checkLocation }, BWAPI::Filter::IsResourceContainer, 96);
          if (closestResource)
            use = false;
          if (use) {
            if (BWAPI::Broodwar->canBuildHere(checkLocation, buildType)) {
              for (auto boxedUnit : BWAPI::Broodwar->getUnitsInRectangle(BWAPI::Position{ checkLocation + BWAPI::TilePosition{ -1, 0 } }
                , BWAPI::Position{ checkLocation + BWAPI::TilePosition{ 4, 3 } }
                , BWAPI::Filter::IsBuilding)) {
                if (boxedUnit->getType().tileSize() != BWAPI::TilePosition{ 3, 2 }) {
                  use = false;
                }
                if (!use) {
                  use = true;
                  break;
                }
              }
            }
            else {
              use = false;
            }
            if (use) {
              for (auto& u : BWAPI::Broodwar->getUnitsInRectangle(BWAPI::Position{ checkLocation + BWAPI::TilePosition{ -2, -1 } }, BWAPI::Position{ checkLocation }, BWAPI::Filter::IsBuilding)) {
                if (u->getType().canBuildAddon()) {
                  use = false;
                  break;
                }
              }
              if (use) {
                return checkLocation;
              }
              else {
                use = true;
              }
            }
            else {
              use = true;
            }
          }
        }
        use = true;
        switch (y) {
        case 0:
          y = 1;
          break;
        case 1:
          y = -1;
          break;
        case -1:
          y = 2;
          break;
        }
      }
    }
  }
  std::queue<node> Q;
  std::map<BWAPI::TilePosition, bool> checked;
  Q.push(node{ desiredPosition, 0 });
  checked[desiredPosition] = true;
  while (Q.size()) {
    auto v = Q.front();
    Q.pop();
    if (v.tilePosition.isValid()) {
      bool use = true;
      if (BWAPI::Broodwar->canBuildHere(v.tilePosition, buildType)) {
        if (buildType.getRace() == BWAPI::Races::Protoss) {
          if (buildType == BWAPI::UnitTypes::Protoss_Pylon) {
            if (BWAPI::Broodwar->hasPower(v.tilePosition)) {
              use = false;
            }
            else if (!BWAPI::Broodwar->canBuildHere(v.tilePosition + BWAPI::TilePosition{ -1, 0 }, BWAPI::UnitTypes::Terran_Barracks)
              || !BWAPI::Broodwar->canBuildHere(v.tilePosition + BWAPI::TilePosition{ -1, -1 }, BWAPI::UnitTypes::Terran_Barracks)) {
              use = false;
            }
            else {
              auto closestResource = BWAPI::Broodwar->getClosestUnit(BWAPI::Position{ v.tilePosition }, BWAPI::Filter::IsResourceContainer, 96);
              if (closestResource)
                use = false;
            }
          }
          else {
            if (!BWAPI::Broodwar->hasPower(v.tilePosition, buildType)) {
              use = false;
            }
            if (use) {
              auto closestResource = BWAPI::Broodwar->getClosestUnit(BWAPI::Position{ v.tilePosition }, BWAPI::Filter::IsResourceContainer, 96);
              if (closestResource)
                use = false;
              if (use) {
                if (buildType == BWAPI::UnitTypes::Protoss_Photon_Cannon) {
                  if (BWAPI::Broodwar->getUnitsInRectangle(BWAPI::Position{ v.tilePosition }, BWAPI::Position{ v.tilePosition + buildType.tileSize() }, BWAPI::Filter::IsBuilding).size()) {
                    use = false;
                  }
                }
                else {
                  if (BWAPI::Broodwar->getUnitsInRectangle(BWAPI::Position{ v.tilePosition + BWAPI::TilePosition{ -1, -1 } }, BWAPI::Position{ v.tilePosition + BWAPI::TilePosition{ buildType.tileSize().x + 1, buildType.tileSize().y + 1 } }, BWAPI::Filter::IsBuilding).size()) {
                    use = false;
                  }
                }
              }
            }
          }
        }
        else if (buildType.getRace() == BWAPI::Races::Terran) {
          auto closestResource = BWAPI::Broodwar->getClosestUnit(BWAPI::Position{ v.tilePosition }, BWAPI::Filter::IsResourceContainer, 96);
          if (closestResource)
            use = false;
          if (use) {
            if (buildType == BWAPI::UnitTypes::Terran_Bunker) {
              auto vPosition = BWAPI::Position { v.tilePosition };
              auto region = BWAPI::Broodwar->getRegionAt(vPosition.x, vPosition.y);
              if (region->getDefensePriority() < 2)
                use = false;
            }
            if (use) {
              for (auto& u : BWAPI::Broodwar->getUnitsInRectangle(BWAPI::Position{ v.tilePosition + BWAPI::TilePosition{ -2, -1 } }, BWAPI::Position{ v.tilePosition }, BWAPI::Filter::IsBuilding)) {
                if (u->getType().canBuildAddon()) {
                  use = false;
                  break;
                }
              }
            }
            if (use)
            {
              auto size = buildType.tileSize();
              if (BWAPI::Broodwar->mapWidth() - v.tilePosition.x - 1 < 3)
                use = false;

              if (use) {
                if (BWAPI::Broodwar->getUnitsInRectangle(BWAPI::Position{ v.tilePosition + BWAPI::TilePosition{ -2, -2 } }, BWAPI::Position{ v.tilePosition + BWAPI::TilePosition{ buildType.tileSize().x + 2, buildType.tileSize().y + 1 } }, BWAPI::Filter::IsBuilding).size()) {
                  use = false;
                }
              }
            }
          }
        }
        else if (buildType.getRace() == BWAPI::Races::Zerg) {
          auto closestResource = BWAPI::Broodwar->getClosestUnit(BWAPI::Position{ v.tilePosition }, BWAPI::Filter::IsResourceContainer, 96);
          if (closestResource)
            use = false;

          if (use) {
            if (buildType == BWAPI::UnitTypes::Zerg_Creep_Colony) {
              if (v.tilePosition.x == 0 || v.tilePosition.x == BWAPI::Broodwar->mapWidth() - 1 || v.tilePosition.y == 0 || v.tilePosition.y == BWAPI::Broodwar->mapHeight() - 1)
                use = false;
              
              if (use)
              {
                bool creepOK = false;
                for (int x = -1; x < 2; x++) {
                  for (int y = -1; y < 2; y++) {
                    if (!BWAPI::Broodwar->hasCreep(v.tilePosition + BWAPI::TilePosition{ x, y }))
                      creepOK = true;
                  }
                }
                if (!creepOK)
                  use = false;
              }
            }
            else {
              if (BWAPI::Broodwar->getUnitsInRectangle(BWAPI::Position{ v.tilePosition + BWAPI::TilePosition{ -1, -1 } }, BWAPI::Position{ v.tilePosition + BWAPI::TilePosition{ buildType.tileSize().x + 1, buildType.tileSize().y + 1 } }, BWAPI::Filter::IsBuilding).size()) {
                use = false;
              }
            }
          }
        }
        else {
          return BWAPI::Broodwar->getBuildLocation(buildType, desiredPosition, range);
        }
      }
      else
        use = false;
      if (use)
        return v.tilePosition;
      else if (v.cost <= range) {
        for (int x = -1; x < 2; x++) {
          for (int y = -1; y < 2; y++) {
            if (!checked[v.tilePosition + BWAPI::TilePosition{ x, y }]) {
              checked[v.tilePosition + BWAPI::TilePosition{ x, y }] = true;
              Q.push(node{ v.tilePosition + BWAPI::TilePosition{ x, y }, v.cost + 1 });
            }
          }
        }
      }
    }
  }
  return BWAPI::TilePositions::None;
}

void bwapidatadisplay::macro() {
  auto self = BWAPI::Broodwar->self();
  if (data->supplyTotal + data->supplyConstruction - data->supplyUsed <= 2 * data->productionBuildings.size()
    && data->supplyTotal < 400) {
    if (self->getRace() == BWAPI::Races::Zerg) {
      for (auto& unit : data->resourceDepots) {
        if (unit->getLarva().size()
          && (!BWAPI::UnitTypes::Zerg_Overlord.mineralPrice() || BWAPI::UnitTypes::Zerg_Overlord.mineralPrice() < data->minerals)
          && (!BWAPI::UnitTypes::Zerg_Overlord.gasPrice() || BWAPI::UnitTypes::Zerg_Overlord.gasPrice() < data->gas)) {
          auto larva = *unit->getLarva().begin();
          larva->morph(BWAPI::UnitTypes::Zerg_Overlord);
          larva->setClientInfo(BWAPI::Broodwar->getLatencyFrames(), static_cast<int>(ClientInfo::Sleep));
          data->supplyConstruction += BWAPI::UnitTypes::Zerg_Overlord.supplyProvided();
          data->minerals -= BWAPI::UnitTypes::Zerg_Overlord.mineralPrice();
          data->gas -= BWAPI::UnitTypes::Zerg_Overlord.gasPrice();
          break;
        }
      }
    }
    else {
      for (auto& unit : data->resourceDepots) {
        auto builder = unit->getClosestUnit(BWAPI::Filter::IsWorker && ((BWAPI::Filter::IsGatheringMinerals && !BWAPI::Filter::IsCarryingSomething) || BWAPI::Filter::IsIdle), 500);
        if (!builder)
          continue;

        for (auto& supplyType : builder->getType().buildsWhat()) {
          if (!supplyType.supplyProvided() || supplyType.isResourceDepot())
            continue;

          if (supplyType == BWAPI::UnitTypes::Protoss_Pylon) {
            for (auto& depot : data->resourceDepots) {
              auto pylons = depot->getUnitsInRadius(32 * data->buildRange, BWAPI::Filter::GetType == BWAPI::UnitTypes::Protoss_Pylon && BWAPI::Filter::GetPlayer == self);
              if (pylons.size() < 2
                && depot != unit) {
                continue;
              }
            }
          }

          if ((!supplyType.mineralPrice() || supplyType.mineralPrice() < data->minerals)
            && (!supplyType.gasPrice() || supplyType.gasPrice() < data->gas)) {
            auto location = getBuildLocation(supplyType, unit->getTilePosition(), data->buildRange);
            if (location.isValid()) {
              if (!builder->build(supplyType, location)) {
                if (!issueOrder(unit, BWAPI::Orders::Move, BWAPI::Position{ location })) {
                  issueOrder(unit, BWAPI::Orders::Stop);
                }
              }
              else
                builder->setClientInfo(BWAPI::Broodwar->getLatencyFrames(), static_cast<int>(ClientInfo::Sleep));
              builder->setClientInfo(location.x, static_cast<int>(ClientInfo::BuildLocationX));
              builder->setClientInfo(location.y, static_cast<int>(ClientInfo::BuildLocationY));
              builder->setClientInfo(static_cast<int>(supplyType), static_cast<int>(ClientInfo::BuildType));
              data->supplyConstruction += supplyType.supplyProvided();
              data->minerals -= supplyType.mineralPrice();
              data->gas -= supplyType.gasPrice();
            }
          }
        }
      }
    }
  }

  for (auto resourceDepot : data->resourceDepots) {
    if (resourceDepot->getClientInfo<int>(static_cast<int>(ClientInfo::ResourceGroup)) == -1)
      continue;

    auto builder = resourceDepot->getClosestUnit(BWAPI::Filter::IsWorker && BWAPI::Filter::IsGatheringMinerals, 500);
    if (!builder)
      continue;

    for (auto& buildType : builder->getType().buildsWhat()) {
      if (data->allowed.units[buildType]
        && (!buildType.mineralPrice() || buildType.mineralPrice() < data->minerals)
        && (!buildType.gasPrice() || buildType.gasPrice() < data->gas)) {
        BWAPI::TilePosition location;
        auto baseID = 0;
        BWAPI::TilePosition closestBase = BWAPI::TilePositions::None;
        if (buildType.isResourceDepot() && data->expand) {
          auto& const currentBase = data->baseLocations[resourceDepot->getClientInfo<int>(static_cast<int>(ClientInfo::ResourceGroup))];
          //sanity check
          if (currentBase.location == BWAPI::TilePositions::Origin)
            continue;

          int closestDistance = INT_MAX;
          for (auto& prospectiveBase : currentBase.neighbors) {
            if (BWAPI::Broodwar->getUnitsInRadius(BWAPI::Position{ prospectiveBase.first->location }, 200, BWAPI::Filter::IsResourceDepot).size())
              continue;

            if (prospectiveBase.second < closestDistance) {
              closestDistance = prospectiveBase.second;
              closestBase = prospectiveBase.first->location;
              baseID = prospectiveBase.first->ID;
            }
          }
        }
        if (closestBase.isValid())
          location = closestBase;
        else if (buildType.isResourceDepot() && data->expand) { // checking for island expansions
          auto& currentBase = data->baseLocations[resourceDepot->getClientInfo<int>(static_cast<int>(ClientInfo::ResourceGroup))];
          int closestDistance = INT_MAX;
          for (auto& [id, prospectiveBase] : data->baseLocations) {
            if (prospectiveBase.ID == currentBase.ID)
              continue;
            else {
              auto prospectiveRegion = BWAPI::Broodwar->getRegionAt(BWAPI::Position{ prospectiveBase.location });
              auto currentRegion = BWAPI::Broodwar->getRegionAt(BWAPI::Position{ currentBase.location });
              if (prospectiveRegion && currentRegion && prospectiveRegion->getRegionGroupID() == currentRegion->getRegionGroupID())
                continue;
            }

            if (BWAPI::Broodwar->getUnitsInRadius(BWAPI::Position{ prospectiveBase.location }, 200, BWAPI::Filter::IsResourceDepot).size())
              continue;

            auto prospectiveDistance = currentBase.location.getDistance(prospectiveBase.location);
            if ( prospectiveDistance < closestDistance) {
              closestDistance = prospectiveDistance;
              closestBase = prospectiveBase.location;
              baseID = prospectiveBase.ID;
            }
          }
        }
        if (closestBase.isValid())
          location = closestBase;
        else if (buildType.isResourceDepot() && data->expand)
          continue;
        else if (buildType == BWAPI::UnitTypes::Zerg_Creep_Colony) {
          auto sunkenCount = resourceDepot->getClientInfo<int>(static_cast<int>(ClientInfo::SunkenCount));
          auto macroHatchCount = resourceDepot->getClientInfo<int>(static_cast<int>(ClientInfo::MacroHatchCount));
          if (macroHatchCount * 2 + 2 <= sunkenCount)
            continue;
          location = getBuildLocation(buildType, resourceDepot->getTilePosition(), data->buildRange);
        }
        else if (buildType == BWAPI::UnitTypes::Terran_Bunker) {
          auto bunkerCount = resourceDepot->getClientInfo<int>(static_cast<int>(ClientInfo::BunkerCount));
          if (2 <= bunkerCount)
            continue;
          location = getBuildLocation(buildType, resourceDepot->getTilePosition(), data->buildRange);
        }
        else if (buildType == BWAPI::UnitTypes::Protoss_Photon_Cannon) {
          auto pylons = BWAPI::Broodwar->getUnitsInRadius(resourceDepot->getPosition(), 32 * data->buildRange, BWAPI::Filter::GetType == BWAPI::UnitTypes::Protoss_Pylon && BWAPI::Filter::GetPlayer == self);
          BWAPI::Unit bestPylon = nullptr;
          for (auto pylon : pylons) {
            if (!bestPylon) {
              bestPylon = pylon;
            }
            else {
              if (pylon->getClientInfo<int>(static_cast<int>(ClientInfo::Cannons)) < bestPylon->getClientInfo<int>(static_cast<int>(ClientInfo::Cannons))) {
                bestPylon = pylon;
              }
            }
          }
          if (bestPylon) {
            location = getBuildLocation(buildType, bestPylon->getTilePosition(), data->buildRange);
            bestPylon->setClientInfo(bestPylon->getClientInfo<int>(static_cast<int>(ClientInfo::Cannons)) + 1, static_cast<int>(ClientInfo::Cannons));
          }
          else
            location = BWAPI::TilePositions::None;
        }
        else
          location = getBuildLocation(buildType, resourceDepot->getTilePosition(), data->buildRange);
        if (location.isValid()) {
          if (buildType.isResourceDepot() && data->expand) {
            for (auto& [id, defenders] : data->defenderUnitSets) {
              auto itr = defenders.begin();
              while (itr != defenders.end()
                && data->defenderUnitSets[baseID].size() < defenders.size()) {
                if (static_cast<JobType>((*itr)->getClientInfo<int>(static_cast<int>(ClientInfo::Job))) != JobType::HoldDefend) {
                  (*itr)->setClientInfo(0, static_cast<int>(ClientInfo::AssignedRegion));
                  (*itr)->setClientInfo(static_cast<int>(JobType::HelpExpand), static_cast<int>(ClientInfo::Job));
                  (*itr)->setClientInfo(location.x, static_cast<int>(ClientInfo::JobX));
                  (*itr)->setClientInfo(location.y, static_cast<int>(ClientInfo::JobY));
                  data->defenderUnitSets[baseID].insert(*itr);
                  itr = defenders.erase(itr);
                }
                else {
                  itr++;
                }
              }
            }
            builder->setClientInfo(nullptr, static_cast<int>(ClientInfo::AssignedDepot));
          }
          if (!builder->build(buildType, location)) {
            if (!issueOrder(builder, BWAPI::Orders::Move, BWAPI::Position{ location })) {
              issueOrder(builder, BWAPI::Orders::Stop);
            }
          }
          else
            builder->setClientInfo(BWAPI::Broodwar->getLatencyFrames(), static_cast<int>(ClientInfo::Sleep));
          builder->setClientInfo(location.x, static_cast<int>(ClientInfo::BuildLocationX));
          builder->setClientInfo(location.y, static_cast<int>(ClientInfo::BuildLocationY));
          builder->setClientInfo(static_cast<int>(buildType), static_cast<int>(ClientInfo::BuildType));
          std::cout << "Attempint to build " << buildType.getName() << ". Minerals: " << data->minerals << " Gas: " << data->gas;
          data->supplyConstruction += buildType.supplyProvided();
          data->minerals -= buildType.mineralPrice();
          data->gas -= buildType.gasPrice();
          data->allowed.units[buildType] = false;
        }
      }
    }
  }
  for (auto& unit : data->productionBuildings) {
    if (!unit->isIdle()
      && unit->getType() != BWAPI::UnitTypes::Zerg_Hatchery
      && unit->getType() != BWAPI::UnitTypes::Zerg_Lair
      && unit->getType() != BWAPI::UnitTypes::Zerg_Hive)
      continue;

    if (unit->getClientInfo<int>(static_cast<int>(ClientInfo::Sleep)))
      continue;

    auto buildingUnit = unit;
    auto unitType = unit->getType();
    auto unitTypeToBuild = BWAPI::UnitTypes::None;
    auto upgradeToBuild = BWAPI::UpgradeTypes::None;
    auto researchToBuild = BWAPI::TechTypes::None;
    bool considerUnits = true;

    if (unitType.producesLarva()
      && unit->getLarva().size()) {
      buildingUnit = *unit->getLarva().begin();
      unitType = buildingUnit->getType();
    }

    for (auto& unitTypeToConsider : unitType.buildsWhat()) {
      if (unitTypeToConsider == BWAPI::UnitTypes::Zerg_Queens_Nest
        && data->allowed.units[unitTypeToConsider])
        data->allowed.units[unitTypeToConsider] = true;
      if (unitTypeToConsider.isWorker()) {
        if (!data->allowed.units[unitTypeToConsider])
          continue;

        auto resourceGroup = unit->getClientInfo<int>(static_cast<int>(ClientInfo::ResourceGroup));
        if ( resourceGroup == -1
          || data->maxMineralWorkers[resourceGroup] <= data->mineralWorkers[resourceGroup])
          continue;
          
        if ((!unitTypeToConsider.mineralPrice() || unitTypeToConsider.mineralPrice() < data->minerals)
          && (!unitTypeToConsider.gasPrice() || unitTypeToConsider.gasPrice() < data->gas)
          && data->supplyUsed + unitTypeToConsider.supplyRequired() <= data->supplyTotal)
          unitTypeToBuild = unitTypeToConsider;
      }
      else if (!unitTypeToBuild.isWorker()
        && data->allowed.units[unitTypeToConsider]
        && (!unitTypeToConsider.mineralPrice() || unitTypeToConsider.mineralPrice() < data->minerals)
        && (!unitTypeToConsider.gasPrice() || unitTypeToConsider.gasPrice() < data->gas)
        && data->supplyUsed + unitTypeToConsider.supplyRequired() <= data->supplyTotal
        && unitTypeToBuild.mineralPrice() + unitTypeToBuild.gasPrice() < unitTypeToConsider.mineralPrice() + unitTypeToConsider.gasPrice()) {
        bool good = true;
        for (auto& req : unitTypeToConsider.requiredUnits()) {
          if (req.first.isAddon()) {
            if (unit->getType() == BWAPI::UnitTypes::Terran_Factory) {
              if (req.first == BWAPI::UnitTypes::Terran_Machine_Shop
                && !unit->getAddon())
                good = false;
            }
          }
        }
        if (good)
          unitTypeToBuild = unitTypeToConsider;
      }
    }
    for (auto& upgradeToConsider : unitType.upgradesWhat()) {
      if (data->allowed.upgrades[upgradeToConsider]
        && upgradeToConsider.mineralPrice() < data->minerals
        && upgradeToConsider.gasPrice() < data->gas
        && upgradeToBuild.mineralPrice() + upgradeToBuild.gasPrice() < upgradeToConsider.mineralPrice() + upgradeToConsider.gasPrice()
        && !unit->isUpgrading()
        && !unit->isResearching()
        && !unit->isMorphing())
        upgradeToBuild = upgradeToConsider;
    }
    for (auto& researchToConsider : unitType.researchesWhat()) {
      if (data->allowed.techs[researchToConsider]
        && researchToConsider.mineralPrice() < data->minerals
        && researchToConsider.gasPrice() < data->gas
        && researchToBuild.mineralPrice() + researchToBuild.gasPrice() < researchToConsider.mineralPrice() + researchToConsider.gasPrice()
        && !unit->isUpgrading()
        && !unit->isResearching()
        && !unit->isMorphing())
        researchToBuild = researchToConsider;
    }
    auto researchCost = researchToBuild.mineralPrice() + researchToBuild.gasPrice();
    auto upgradeCost = upgradeToBuild.mineralPrice() + upgradeToBuild.gasPrice();
    auto unitCost = unitTypeToBuild.mineralPrice() + unitTypeToBuild.gasPrice();
    if (researchCost < upgradeCost)
      researchToBuild = BWAPI::TechTypes::None;
    else
      upgradeToBuild = BWAPI::UpgradeTypes::None;

    if (upgradeCost < unitCost)
      upgradeToBuild = BWAPI::UpgradeTypes::None;
    else
      unitTypeToBuild = BWAPI::UnitTypes::None;

    if (researchCost < unitCost)
      researchToBuild = BWAPI::TechTypes::None;
    else
      unitTypeToBuild = BWAPI::UnitTypes::None;

    if (unitTypeToBuild != BWAPI::UnitTypes::None) {
      if (unitType == BWAPI::UnitTypes::Zerg_Larva &&
        unit->getClientInfo<BWAPI::UnitType>(static_cast<int>(ClientInfo::MorphingInto)) == BWAPI::UnitTypes::None) {
        unit->morph(unitTypeToBuild);
        unit->setClientInfo(BWAPI::Broodwar->getLatencyFrames(), static_cast<int>(ClientInfo::Sleep));
        unit->setClientInfo(static_cast<int>(ClientInfo::MorphingInto), static_cast<int>(unitType));
      }
      else {
        if (unitTypeToBuild.isAddon()) {
          unit->buildAddon(unitTypeToBuild);
        }
        else {
          unit->train(unitTypeToBuild);
        }
        unit->setClientInfo(BWAPI::Broodwar->getLatencyFrames(), static_cast<int>(ClientInfo::Sleep));
      }
      data->minerals -= unitTypeToBuild.mineralPrice();
      data->gas -= unitTypeToBuild.gasPrice();
      data->supplyUsed += unitTypeToBuild.supplyRequired();
    }
    else if (upgradeToBuild != BWAPI::UpgradeTypes::None) {
      unit->upgrade(upgradeToBuild);
      data->minerals -= upgradeToBuild.mineralPrice();
      data->gas -= upgradeToBuild.gasPrice();
    }
    else if (researchToBuild != BWAPI::TechTypes::None) {
      unit->research(researchToBuild);
      data->minerals -= researchToBuild.mineralPrice();
      data->gas -= researchToBuild.gasPrice();
    }
  }
}

bool bwapidatadisplay::issueOrder(BWAPI::Unit unit, BWAPI::Order orderType, BWAPI::Position targetPosition, BWAPI::Unit targetUnit) {
  bool result = false;
  if (!unit)
    return result;

  if (targetPosition != BWAPI::Positions::None
    && !unit->getType().isFlyer()) {
    auto targetRegion = BWAPI::Broodwar->getRegionAt(targetPosition);
    auto unitRegion = unit->getRegion();
    if (targetRegion && unitRegion && targetRegion->getRegionGroupID() != unitRegion->getRegionGroupID()) {
      auto transport = unit->getClosestUnit([](BWAPI::Unit unit) {
        return (unit->getType() == BWAPI::UnitTypes::Protoss_Shuttle
          || unit->getType() == BWAPI::UnitTypes::Terran_Dropship
          || unit->getType() == BWAPI::UnitTypes::Zerg_Overlord && BWAPI::Broodwar->self()->getUpgradeLevel(BWAPI::UpgradeTypes::Pneumatized_Carapace))
          && (8 - unit->getSpaceRemaining()) + unit->getClientInfo<int>(static_cast<int>(ClientInfo::QueuedTransport)) < 8
          && 100 < unit->getDistance(BWAPI::Position{ unit->getClientInfo<int>(static_cast<int>(ClientInfo::JobX)), unit->getClientInfo<int>(static_cast<int>(ClientInfo::JobY)) });
        });
      if (transport) {
        result = unit->rightClick(transport);
        if (result) {
          transport->setClientInfo(transport->getClientInfo<int>(static_cast<int>(ClientInfo::QueuedTransport)) + unit->getType().spaceRequired(), static_cast<int>(ClientInfo::QueuedTransport));
          transport->setClientInfo(static_cast<int>(JobType::Taxi), static_cast<int>(ClientInfo::Job));
          transport->setClientInfo(targetPosition.x, static_cast<int>(ClientInfo::JobX));
          transport->setClientInfo(targetPosition.y, static_cast<int>(ClientInfo::JobY));
          transport->setClientInfo(7, static_cast<int>(ClientInfo::Sleep));
        }
      }
      else {
        return false;
      }
    }
  }

  if (!result) {
    switch (orderType) {
    case BWAPI::Orders::AttackUnit:
      if (targetUnit) {
        result = unit->attack(targetUnit);
      }
      break;
    case BWAPI::Orders::MoveToGas:
      if (targetUnit && targetUnit->getType().isRefinery()) {
        result = unit->gather(targetUnit);
      }
      break;
    case BWAPI::Orders::MoveToMinerals:
      if (targetUnit && targetUnit->getType().isMineralField()) {
        result = unit->gather(targetUnit);
      }
      break;
    case BWAPI::Orders::Move:
      if (targetPosition != BWAPI::Positions::None) {
        result = unit->move(targetPosition);
      }
      break;
    case BWAPI::Orders::PickupTransport:
      if (targetUnit) {
        result = unit->load(targetUnit);
      }
      break;
    case BWAPI::Orders::Repair:
      if (targetUnit) {
        result = unit->repair(targetUnit);
      }
      break;
    case BWAPI::Orders::Stop:
      result = unit->stop();
      break;
    case BWAPI::Orders::Unload:
      if (targetPosition != BWAPI::Positions::None) {
        if (100 < unit->getDistance(targetPosition)) {
          result = unit->move(targetPosition);
        }
        else {
          unit->unloadAll();
        }
      }
      break;
    default:
      break;
    }
  }
  if (result) {
    unit->setClientInfo(BWAPI::Broodwar->getLatencyFrames(), static_cast<int>(ClientInfo::Sleep));
  }
  return result;
}

void bwapidatadisplay::micro() {
  auto self = BWAPI::Broodwar->self();
  auto useTech = [](BWAPI::Unit unit, BWAPI::TechType tech, BWAPI::Unit target = nullptr, BWAPI::Position targetPosition = BWAPI::Positions::None) {
    if (target) {
      unit->useTech(tech, target);
    }
    else if (targetPosition != BWAPI::Positions::None) {
      unit->useTech(tech, targetPosition);
    }
    else {
      unit->useTech(tech);
    }
    unit->setClientInfo(BWAPI::Broodwar->getLatencyFrames(), static_cast<int>(ClientInfo::Sleep));
  };
  auto energyPercent = [](BWAPI::Unit unit) {
    return 100 * unit->getEnergy() / unit->getType().maxEnergy();
  };
  auto panic = [this](BWAPI::Unit unit) {
    auto enemy = unit->getClosestUnit(BWAPI::Filter::IsEnemy && BWAPI::Filter::OrderTarget == unit);
    if (enemy) {
      issueOrder(unit, BWAPI::Orders::Move, BWAPI::Position{ static_cast<int>(unit->getPosition().x + 100 * std::cos(enemy->getAngle())), static_cast<int>(unit->getPosition().y + 100 * std::sin(enemy->getAngle())) });
      unit->setClientInfo(BWAPI::Broodwar->getLatencyFrames(), static_cast<int>(ClientInfo::Sleep));
      unit->setClientInfo(true, static_cast<int>(ClientInfo::Panic));
    }
  };
  auto acquireAndAttackTarget = [this, useTech](BWAPI::Unit unit) {
    if (unit->getType() == BWAPI::UnitTypes::Terran_Medic) {
      BWAPI::Unit healTarget = nullptr;
      healTarget = unit->getClosestUnit((BWAPI::Filter::GetPlayer == BWAPI::Broodwar->self() || BWAPI::Filter::IsAlly)
        && BWAPI::Filter::HP_Percent < 100
        && !BWAPI::Filter::IsMechanical
        && !BWAPI::Filter::IsBeingHealed);
      if (healTarget && healTarget != unit->getTarget()) {
        useTech(unit, BWAPI::TechTypes::Healing, healTarget);
        return true;
      }
    }
    else {
      BWAPI::Unit enemy = nullptr;
      if (unit->getType().groundWeapon() != BWAPI::WeaponTypes::None
        && unit->getType().airWeapon() != BWAPI::WeaponTypes::None) {
        enemy = unit->getClosestUnit(
          BWAPI::Filter::IsEnemy
          && BWAPI::Filter::IsDetected
          && (BWAPI::Filter::GroundWeapon != BWAPI::WeaponTypes::None || BWAPI::Filter::AirWeapon != BWAPI::WeaponTypes::None)
          && !BWAPI::Filter::IsWorker
          , unit->getType().isBuilding() ? unit->getType().groundWeapon().maxRange() : unit->getType().sightRange());
        if (!enemy) {
          enemy = unit->getClosestUnit(
            BWAPI::Filter::IsEnemy
            && BWAPI::Filter::IsDetected
            , unit->getType().isBuilding() ? unit->getType().groundWeapon().maxRange() : unit->getType().sightRange());
        }
        if (!enemy) {
          enemy = unit->getClosestUnit(
            BWAPI::Filter::IsCritter
            , unit->getType().isBuilding() ? unit->getType().groundWeapon().maxRange() : unit->getType().sightRange());
        }
      }
      else if (unit->getType().groundWeapon() != BWAPI::WeaponTypes::None) {
        enemy = unit->getClosestUnit(
          BWAPI::Filter::IsEnemy
          && BWAPI::Filter::IsDetected
          && !BWAPI::Filter::IsFlyer
          && !BWAPI::Filter::IsWorker
          && (BWAPI::Filter::GroundWeapon != BWAPI::WeaponTypes::None || BWAPI::Filter::AirWeapon != BWAPI::WeaponTypes::None)
          , unit->getType().isBuilding() ? unit->getType().groundWeapon().maxRange() : unit->getType().sightRange());
        if (!enemy) {
          enemy = unit->getClosestUnit(
            BWAPI::Filter::IsEnemy
            && BWAPI::Filter::IsDetected
            && !BWAPI::Filter::IsFlyer
            , unit->getType().isBuilding() ? unit->getType().groundWeapon().maxRange() : unit->getType().sightRange());
        }
        if (!enemy) {
          enemy = unit->getClosestUnit(
            BWAPI::Filter::IsCritter
            && !BWAPI::Filter::IsFlyer
            , unit->getType().isBuilding() ? unit->getType().groundWeapon().maxRange() : unit->getType().sightRange());
        }
      }
      else if (unit->getType().airWeapon() != BWAPI::WeaponTypes::None) {
        enemy = unit->getClosestUnit(
          BWAPI::Filter::IsEnemy
          && BWAPI::Filter::IsDetected
          && BWAPI::Filter::IsFlyer
          && (BWAPI::Filter::GroundWeapon != BWAPI::WeaponTypes::None || BWAPI::Filter::AirWeapon != BWAPI::WeaponTypes::None)
          , unit->getType().isBuilding() ? unit->getType().groundWeapon().maxRange() : unit->getType().sightRange());
        if (!enemy) {
          enemy = unit->getClosestUnit(
            BWAPI::Filter::IsEnemy
            && BWAPI::Filter::IsDetected
            && BWAPI::Filter::IsFlyer
            , unit->getType().isBuilding() ? unit->getType().groundWeapon().maxRange() : unit->getType().sightRange());
        }
        if (!enemy) {
          enemy = unit->getClosestUnit(
            BWAPI::Filter::IsCritter
            && BWAPI::Filter::IsFlyer
            , unit->getType().isBuilding() ? unit->getType().groundWeapon().maxRange() : unit->getType().sightRange());
        }
      }
      if (enemy && enemy != unit->getOrderTarget()) {
        return issueOrder(unit, BWAPI::Orders::AttackUnit, BWAPI::Positions::None, enemy);
      }
    }
    return false;
  };
  for (auto& unit : self->getUnits()) {
    if (unit->getClientInfo<int>(static_cast<int>(ClientInfo::Sleep))) {
      unit->setClientInfo(unit->getClientInfo<int>(static_cast<int>(ClientInfo::Sleep)) - 1, static_cast<int>(ClientInfo::Sleep));
      continue;
    }
    if (unit->isStasised()
      || unit->isLockedDown()) {
      continue;
    }
    auto aiFunction = unit->getClientInfo<void(*)(BWAPI::Unit, std::shared_ptr<Data>)>(static_cast<int>(ClientInfo::UnitAI));
    if (aiFunction != nullptr) {
      aiFunction(unit, data);
      continue;
    }

    //techs
    {
      using namespace BWAPI::TechTypes;
      using namespace BWAPI::UnitTypes;
      if (canUseTech(unit, Stim_Packs)
        && unit->isAttacking()
        && 100 * unit->getHitPoints() / unit->getType().maxHitPoints() == 100) {
        useTech(unit, Stim_Packs);
        continue;
      }
      if (canUseTech(unit, Spider_Mines)
        && unit->getSpiderMineCount()
        && static_cast<JobType>(unit->getClientInfo<int>(static_cast<int>(ClientInfo::Job))) == JobType::None
        && unit->isIdle()
        && unit->getClientInfo<int>(static_cast<int>(ClientInfo::AssignedRegion))) {
        auto region = unit->getRegion();
        std::queue<BWAPI::Region> Q;
        std::map<BWAPI::Region, bool> checked;
        Q.push(region);
        checked[region] = true;
        region = nullptr;
        bool usedTech = false;
        while (Q.size()) {
          auto v = Q.front();
          Q.pop();
          for (auto r : v->getNeighbors()) {
            if (!checked[r]
              && r->getUnits(BWAPI::Filter::IsBuilding && BWAPI::Filter::GetPlayer == BWAPI::Broodwar->self()).size()
              && !r->getUnits(BWAPI::Filter::GetType == BWAPI::UnitTypes::Terran_Vulture_Spider_Mine && BWAPI::Filter::GetPlayer == self).size()) {
              useTech(unit, Spider_Mines, nullptr, r->getCenter());
              usedTech = true;
              break;
            }
            else if (!checked[r]) {
              Q.push(r);
              checked[r] = true;
            }
          }
          if (usedTech) {
            break;
          }
        }
        if (usedTech) {
          continue;
        }
      }
      if (canUseTech(unit, Personnel_Cloaking)
        && !unit->isCloaked()
        && unit->isUnderAttack()
        && Personnel_Cloaking.energyCost() + 20 < unit->getEnergy()) {
        useTech(unit, Personnel_Cloaking);
        continue;
      }
      if (canUseTech(unit, Lockdown)
        && unit->isUnderAttack()
        && Lockdown.energyCost() < unit->getEnergy()) {
        auto target = unit->getClosestUnit([self, unit](BWAPI::Unit u) {
          if (u->getPlayer()->isEnemy(self)
            && u->getType().isMechanical()
            && !u->getType().isBuilding()
            && u->getOrderTarget() == unit) {
            for (auto bullet : BWAPI::Broodwar->getBullets()) {
              if (bullet->getType() == BWAPI::BulletTypes::EMP_Missile
                && bullet->getTarget() == u) {
                return false;
              }
            }
            return true;
          }
        });
        if (target) {
          useTech(unit, Lockdown, target);
          continue;
        }
      }
      if (canUseTech(unit, Archon_Warp)
        && unit->isIdle()
        && data->allowed.units[Protoss_Archon]
        && unit->getEnergy() < Psionic_Storm.energyCost()) {
        auto target = unit->getClosestUnit(BWAPI::Filter::GetType == Protoss_High_Templar && BWAPI::Filter::GetPlayer == self && BWAPI::Filter::CurrentOrder != BWAPI::Orders::ArchonWarp);
        if (target && target != unit->getOrderTarget()) {
          useTech(unit, Archon_Warp, target);
          continue;
        }
      }
      if (canUseTech(unit, Disruption_Web)
        && unit->isUnderAttack()) {
        auto closestGroundEnemy = unit->getClosestUnit(BWAPI::Filter::IsEnemy && !BWAPI::Filter::IsFlyer && BWAPI::Filter::AirWeapon != BWAPI::WeaponTypes::None && !BWAPI::Filter::IsUnderDisruptionWeb);
        if (closestGroundEnemy != unit->getOrderTarget()) {
          useTech(unit, Disruption_Web, closestGroundEnemy);
          continue;
        }
      }
      if (canUseTech(unit, Psionic_Storm)
        && Psionic_Storm.energyCost() < unit->getEnergy()
        && (unit->isUnderAttack()
          || 75 < energyPercent(unit))) {
        auto target = unit->getClosestUnit(BWAPI::Filter::IsEnemy && !BWAPI::Filter::IsBuilding);
        if (target && target != unit->getOrderTarget()) {
          useTech(unit, Psionic_Storm, target);
          continue;
        }
      }
      if (canUseTech(unit, Hallucination)
        && Hallucination.energyCost() < unit->getEnergy()
        && unit->isIdle()
        && 75 < energyPercent(unit)) {
        auto target = unit->getClosestUnit(BWAPI::Filter::GetPlayer == self && !BWAPI::Filter::IsBuilding);
        if (target && target != unit->getOrderTarget()) {
          useTech(unit, Hallucination, target);
          continue;
        }
      }
      if (canUseTech(unit, Dark_Archon_Meld)
        && 3 <= data->counts.complete[Protoss_Dark_Templar]
        && 2 < data->counts.raw[Protoss_Dark_Archon]) {
        auto target = unit->getClosestUnit(BWAPI::Filter::GetType == Protoss_Dark_Templar && BWAPI::Filter::GetPlayer == self && BWAPI::Filter::CurrentOrder != BWAPI::Orders::DarkArchonMeld);
        if (target && target != unit->getOrderTarget()) {
          useTech(unit, Dark_Archon_Meld, target);
          continue;
        }
      }
      if (canUseTech(unit, Mind_Control)
        && Mind_Control.energyCost() < unit->getEnergy()
        && unit->isUnderAttack()) {
        BWAPI::Unit target = nullptr;
        for (auto& potentialTarget : unit->getUnitsInRadius(unit->getType().sightRange(), BWAPI::Filter::IsEnemy && !BWAPI::Filter::IsBuilding)) {
          if (!target)
            target = potentialTarget;
          else {
            if ((potentialTarget->getType().isDetector() || potentialTarget->getType() == Zerg_Overlord) && target->getType().maxHitPoints() + target->getType().maxShields() < 300) {
              target = potentialTarget;
            }
            else if (target->getType().maxHitPoints() + target->getType().maxShields() < potentialTarget->getType().maxHitPoints() + potentialTarget->getType().maxShields()) {
              target = potentialTarget;
            }
          }
        }
        if (target && target != unit->getOrderTarget()) {
          useTech(unit, Mind_Control, target);
          continue;
        }
      }
      if (canUseTech(unit, Maelstrom)
        && Maelstrom.energyCost() < unit->getEnergy()
        && (unit->isUnderAttack()
          || 75 < energyPercent(unit))) {
        auto target = unit->getClosestUnit(BWAPI::Filter::IsEnemy && !BWAPI::Filter::IsMechanical && !BWAPI::Filter::IsBuilding);
        if (target && target != unit->getOrderTarget()) {
          useTech(unit, Maelstrom, target);
          continue;
        }
      }
      //Recall
      if (canUseTech(unit, Stasis_Field)
        && Stasis_Field.energyCost() < unit->getEnergy()
        && (unit->isUnderAttack()
          || 75 < energyPercent(unit))) {
        auto target = unit->getClosestUnit(BWAPI::Filter::IsEnemy && !BWAPI::Filter::IsBuilding);
        if (target && target != unit->getOrderTarget()) {
          useTech(unit, Stasis_Field, target);
          continue;
        }
      }

      if (canUseTech(unit, Optical_Flare)
        && Optical_Flare.energyCost() < unit->getEnergy() - 25) {
        auto target = unit->getClosestUnit(BWAPI::Filter::IsEnemy && BWAPI::Filter::IsDetector && !BWAPI::Filter::IsBlind && !BWAPI::Filter::IsBuilding);
        if (target && target != unit->getOrderTarget()) {
          useTech(unit, Optical_Flare, target);
          continue;
        }
      }
    }
    // sub Unit Productions
    {
      using namespace BWAPI::UnitTypes;
      using namespace BWAPI::UpgradeTypes;
      if (unit->getType() == Protoss_Carrier
        && unit->getInterceptorCount() < self->getUpgradeLevel(Carrier_Capacity) == 1 ? 8 : 4
        && !unit->isTraining()
        && Protoss_Interceptor.mineralPrice() < data->minerals
        && Protoss_Interceptor.gasPrice() < data->gas) {
        if (unit->train(Protoss_Interceptor)) {
          data->minerals -= Protoss_Interceptor.mineralPrice();
          data->gas -= Protoss_Interceptor.gasPrice();
          unit->setClientInfo(BWAPI::Broodwar->getLatencyFrames(), static_cast<int>(ClientInfo::Sleep));
          continue;
        }
      }
    }

    if (0 < unit->getType().maxShields()
      && (unit->getTarget() && unit->getTarget()->getType() != BWAPI::UnitTypes::Protoss_Shield_Battery && unit->getTarget()->getPlayer() == self)
      && static_cast<JobType>(unit->getClientInfo<int>(static_cast<int>(ClientInfo::Job))) != JobType::Attack
      && static_cast<JobType>(unit->getClientInfo<int>(static_cast<int>(ClientInfo::Job))) != JobType::Taxi
      && 100 * unit->getShields() / unit->getType().maxShields() < 10
      && 100 * unit->getHitPoints() / unit->getType().maxHitPoints() < 50) {
      auto battery = unit->getClosestUnit(BWAPI::Filter::GetPlayer == self
        && BWAPI::Filter::GetType == BWAPI::UnitTypes::Protoss_Shield_Battery
        && BWAPI::Filter::Energy_Percent > 10);
      if (battery) {
        unit->rightClick(battery);
        unit->setClientInfo(BWAPI::Broodwar->getLatencyFrames(), static_cast<int>(ClientInfo::Job));
      }
    }

    if (unit->getClientInfo<bool>(static_cast<int>(ClientInfo::Panic))) {
      if (unit->isIdle()) {
        unit->setClientInfo(false, static_cast<int>(ClientInfo::Panic));
      }
      else {
        continue;
      }
    }

    if (unit->getType() == BWAPI::UnitTypes::Protoss_Shuttle
      || unit->getType() == BWAPI::UnitTypes::Terran_Dropship) {

      if (static_cast<JobType>(unit->getClientInfo<int>(static_cast<int>(ClientInfo::Job))) == JobType::Taxi) {
        if (unit->isIdle()) {
          auto rider = unit->getClosestUnit(BWAPI::Filter::GetPlayer == self && BWAPI::Filter::OrderTarget == unit);
          if (rider &&
            rider->getType().spaceRequired() <= unit->getSpaceRemaining()) {
            issueOrder(unit, BWAPI::Orders::PickupTransport, BWAPI::Positions::None, rider);
            continue;
          }
          else {
            auto position = BWAPI::Position{ unit->getClientInfo<int>(static_cast<int>(ClientInfo::JobX)), unit->getClientInfo<int>(static_cast<int>(ClientInfo::JobY)) };
            issueOrder(unit, BWAPI::Orders::Unload, position);
          }
          if (unit->getType().spaceProvided() == unit->getSpaceRemaining()) {
            unit->setClientInfo(static_cast<int>(JobType::None), static_cast<int>(ClientInfo::Job));
            unit->setClientInfo(0, static_cast<int>(ClientInfo::JobX));
            unit->setClientInfo(0, static_cast<int>(ClientInfo::JobY));
          }
        }
        continue;
      }
      if (unit->isIdle()) {
        auto closestDepot = getClosestNotMacroResourceDepot(unit);
        if (closestDepot && 75 < unit->getDistance(closestDepot)) {
          issueOrder(unit, BWAPI::Orders::Move, closestDepot->getPosition() + BWAPI::Position{ data->getRandomInteger(-50, 50), data->getRandomInteger(-50, 50) });
          continue;
        }
      }
    }

    if (unit->getType() == BWAPI::UnitTypes::Protoss_Observer) {
      auto assignedResourceDepot = unit->getClientInfo<BWAPI::Unit>(static_cast<int>(ClientInfo::AssignedDepot));
      if (!assignedResourceDepot || !assignedResourceDepot->exists()) {
        assignedResourceDepot = getClosestNotMacroResourceDepot(unit);
        unit->setClientInfo(assignedResourceDepot, static_cast<int>(ClientInfo::AssignedDepot));
      }

      if (unit->isUnderAttack() && !unit->getClientInfo<bool>(static_cast<int>(ClientInfo::Panic))) {
        panic(unit);
        continue;
      }
      auto target = unit->getClientInfo<BWAPI::Unit>(static_cast<int>(ClientInfo::AssignedDetection));
      if (target && target->exists()) {
        if (target->isDetected()
          && unit->getDistance(target) < unit->getType().sightRange() / 2) {
          issueOrder(unit, BWAPI::Orders::Stop);
          continue;
        }
        else {
          issueOrder(unit, BWAPI::Orders::Move, target->getPosition());
          continue;
        }
      }
      else {
        unit->setClientInfo(nullptr, static_cast<int>(ClientInfo::AssignedDetection));
      }

      if (static_cast<JobType>(unit->getClientInfo<int>(static_cast<int>(ClientInfo::Job))) == JobType::Attack) {
        auto itr = data->attackerUnitSets.begin();
        while (itr != data->attackerUnitSets.end()) {
          BWAPI::Position avgPosition = BWAPI::Positions::None;
          bool found = false;
          for (auto unitItr = itr->begin(); unitItr != itr->end(); unitItr++) {
            if ((*unitItr) == unit) {
              found = true;
            }
            else {
              avgPosition = avgPosition + (*unitItr)->getPosition();
            }
          }
          if (found) {
            if (itr->size() == 1) {
              data->attackerUnitSets.erase(itr);
              unit->setClientInfo(static_cast<int>(JobType::None), static_cast<int>(ClientInfo::Job));
            }
            else {
              avgPosition = avgPosition / (itr->size() - 1);
              issueOrder(unit, BWAPI::Orders::Move, avgPosition);
            }
            continue;
          }
          else {
            itr++;
          }
        }
      }

      if (assignedResourceDepot) {
        if (unit->isIdle()) {
          auto region = unit->getRegion();
          bool hasOwnBuildings = false;
          BWAPI::Regionset potentialRegions;
          for (auto& neighbor : region->getNeighbors()) {
            for (auto& regionUnit : region->getUnits()) {
              if (regionUnit->getType().isBuilding() && regionUnit->getPlayer() == self) {
                hasOwnBuildings = true;
                break;
              }
            }
            if (hasOwnBuildings) {
              potentialRegions.insert(neighbor);
            }
          }
          if (!potentialRegions.size()) {
            issueOrder(unit, BWAPI::Orders::Move, assignedResourceDepot->getPosition());
            continue;
          }
          else {
            auto choice = data->getRandomInteger(0, potentialRegions.size() - 1);
            auto itr = potentialRegions.begin();
            while (choice) {
              itr++;
              choice--;
            }
            issueOrder(unit, BWAPI::Orders::Move, (*itr)->getCenter());
            continue;
          }
        }
      }
    }
    else if (unit->getType().isRefinery()) {
      if (!unit->isCompleted()) {
        if (!data->gasWorkers[unit->getID()].size()
          && unit->getBuildUnit()) {
          data->gasWorkers[unit->getID()].insert(unit->getBuildUnit());
        }
        continue;
      }

      for (auto& worker : data->gasWorkers[unit->getID()]) {
        if (!worker->exists()) {
          data->gasWorkers[unit->getID()].erase(worker);
          break;
        }
        if (worker->isIdle()) {
          if (worker->isCarryingGas())
            worker->returnCargo();
          else
            issueOrder(worker, BWAPI::Orders::MoveToGas, BWAPI::Positions::None, unit);
        }
      }

      if (data->gasWorkers[unit->getID()].size() < 4) {
        if (data->maxMineralWorkers[unit->getResourceGroup()] / 2 < data->mineralWorkers[unit->getResourceGroup()]) {
          auto worker = unit->getClosestUnit(BWAPI::Filter::IsGatheringMinerals && !BWAPI::Filter::IsCarryingMinerals, 500);
          if (worker) {
            issueOrder(worker, BWAPI::Orders::MoveToGas, BWAPI::Positions::None, unit);
            data->gasWorkers[unit->getID()].insert(worker);
          }
        }
        else if (data->mineralWorkers[unit->getResourceGroup()] < data->maxMineralWorkers[unit->getResourceGroup()] / 4) {
          for (auto& worker : data->gasWorkers[unit->getID()]) {
            issueOrder(worker, BWAPI::Orders::Stop);
            data->gasWorkers[unit->getID()].erase(worker);
            break;
          }
        }
      }
    }
    else if (unit->getType().isWorker()
      && static_cast<JobType>(unit->getClientInfo<int>(static_cast<int>(ClientInfo::Job))) != JobType::HoldDefend) {
      if (unit->isUnderAttack()
        && !unit->getBuildUnit()) {
        auto target = unit->getTarget();
        if (!target
          || !target->getPlayer()->isEnemy(self)) {
          target = unit->getClosestUnit(BWAPI::Filter::IsEnemy
            && BWAPI::Filter::Target == unit
            && (BWAPI::Filter::GetType == BWAPI::UnitTypes::Zerg_Zergling
              || BWAPI::Filter::GetType == BWAPI::UnitTypes::Zerg_Drone
              || BWAPI::Filter::GetType == BWAPI::UnitTypes::Terran_SCV
              || BWAPI::Filter::GetType == BWAPI::UnitTypes::Protoss_Probe));
          if (target && unit->getDistance(target) <= unit->getType().groundWeapon().maxRange() + 75) {
            issueOrder(unit, BWAPI::Orders::AttackUnit, BWAPI::Positions::None, target);
            continue;
          }
          else {
            panic(unit);
            continue;
          }
        }
      }
      else {
        if (unit->isIdle()) {
          auto buildType = unit->getClientInfo<BWAPI::UnitType>(static_cast<int>(ClientInfo::BuildType));
          if (buildType.isBuilding()) {
            auto location = BWAPI::TilePosition{ unit->getClientInfo<int>(static_cast<int>(ClientInfo::BuildLocationX)), unit->getClientInfo<int>(static_cast<int>(ClientInfo::BuildLocationY)) };
            if (!unit->build(buildType, location)) {
              auto moveableUnits = BWAPI::Broodwar->getUnitsInRectangle(BWAPI::Position{ location }, BWAPI::Position{ location + buildType.tileSize() }, BWAPI::Filter::CanMove && BWAPI::Filter::GetPlayer == BWAPI::Broodwar->self());
              if (moveableUnits.size()) {
                moveableUnits.move(BWAPI::Position{ location } + BWAPI::Position{ data->getRandomInteger(128, 188), data->getRandomInteger(100, 150) });
                moveableUnits.setClientInfo(100, static_cast<int>(ClientInfo::Sleep));
              }
              issueOrder(unit, BWAPI::Orders::Move, BWAPI::Position{ location });
            }
            unit->setClientInfo(BWAPI::Broodwar->getLatencyFrames(), static_cast<int>(ClientInfo::Sleep));
            continue;
          }
          BWAPI::Unit assignedDepot = unit->getClientInfo<BWAPI::Unit>(static_cast<int>(ClientInfo::AssignedDepot));
          if (assignedDepot && assignedDepot->isCompleted()) {
            auto closestMineral = assignedDepot->getClosestUnit(BWAPI::Filter::IsMineralField, 500);
            if (closestMineral) {
              issueOrder(unit, BWAPI::Orders::MoveToMinerals, BWAPI::Positions::None, closestMineral);
              continue;
            }
            else {
              int lowestWorkerCount = INT_MAX;
              BWAPI::Unit closestDepot = nullptr;
              for (auto& [id, workers] : data->mineralWorkers) {
                if (data->maxMineralWorkers[id]
                  && workers < lowestWorkerCount) {
                  lowestWorkerCount = workers;
                  for (auto& depot : data->resourceDepots) {
                    if (depot->getClientInfo<int>(static_cast<int>(ClientInfo::ResourceGroup)) == id) {
                      auto closestMineral = assignedDepot->getClosestUnit(BWAPI::Filter::IsMineralField, 500);
                      closestDepot = depot;
                    }
                  }
                }
              }
              if (closestDepot) {
                auto closestMineral = closestDepot->getClosestUnit(BWAPI::Filter::IsMineralField, 500);
                if (closestMineral) {
                  issueOrder(unit, BWAPI::Orders::MoveToMinerals, BWAPI::Positions::None, closestMineral);
                  unit->setClientInfo(closestDepot, static_cast<int>(ClientInfo::AssignedDepot));
                  data->mineralWorkers[closestDepot->getClientInfo<int>(static_cast<int>(ClientInfo::ResourceGroup))]++;
                  data->mineralWorkers[assignedDepot->getClientInfo<int>(static_cast<int>(ClientInfo::ResourceGroup))]--;
                  continue;
                }
              }
              auto closestRefinery = assignedDepot->getClosestUnit(BWAPI::Filter::IsRefinery, 500);
              if (closestRefinery) {
                issueOrder(unit, BWAPI::Orders::MoveToGas, BWAPI::Positions::None, closestRefinery);
                continue;
              }
            }
          }
          else if (!assignedDepot
            && static_cast<JobType>(unit->getClientInfo<int>(static_cast<int>(ClientInfo::Job))) != JobType::HoldDefend) {
            int lowestWorkerPercent = INT_MAX;
            int lowestID = -1;
            for (auto& [id, workers] : data->mineralWorkers) {
              if (0 < data->maxMineralWorkers[id]) {
                auto tempPercent = 100 * workers / data->maxMineralWorkers[id];
                if (tempPercent < lowestWorkerPercent) {
                  lowestWorkerPercent = tempPercent;
                  lowestID = id;
                }
              }
            }
            if (lowestID != -1) {
              for (auto& depot : data->resourceDepots) {
                if (depot->getClientInfo<int>(static_cast<int>(ClientInfo::ResourceGroup)) == lowestID) {
                  unit->setClientInfo(depot, static_cast<int>(ClientInfo::AssignedDepot));
                  data->mineralWorkers[lowestID]++;
                  break;
                }
              }
            }
          }
          //else if (static_cast<JobType>(unit->getClientInfo<int>(static_cast<int>(ClientInfo::Job))) != JobType::HoldDefend) {

          //}
        }
      }
    }
    else if (unit->getType().isBuilding()) {
      if (static_cast<JobType>(unit->getClientInfo<int>(static_cast<int>(ClientInfo::Job))) == JobType::Defend) {
        auto enemyUnits = unit->getUnitsInRadius(BWAPI::WeaponTypes::Arclite_Shock_Cannon.maxRange(), BWAPI::Filter::IsEnemy && !BWAPI::Filter::IsBuilding);
        if (!enemyUnits.size()) {
          auto itr = data->jobList.begin();
          while (itr != data->jobList.end()) {
            if (itr->requestingUnit == unit) {
              data->jobList.erase(itr);
              unit->setClientInfo(static_cast<int>(JobType::None), static_cast<int>(ClientInfo::Job));
              itr = data->jobList.end();
            }
            else {
              itr++;
            }
          }
        }
      }
      else if (unit->isUnderAttack()
        && static_cast<JobType>(unit->getClientInfo<int>(static_cast<int>(ClientInfo::Job))) != JobType::HoldDefend) {
        data->jobList.push_back(Job{ JobType::Defend, unit->getTilePosition(), unit->getPosition(), nullptr, unit });
        unit->setClientInfo(static_cast<int>(JobType::Defend), static_cast<int>(ClientInfo::Job));
      }

      if (!unit->isCompleted()) {
        if (unit->getType().getRace() == BWAPI::Races::Terran) {
          if (!unit->getBuildUnit()) {
            auto builder = unit->getClosestUnit(BWAPI::Filter::GetType == BWAPI::UnitTypes::Terran_SCV
              && BWAPI::Filter::GetPlayer == self
              && (BWAPI::Filter::IsGatheringMinerals || BWAPI::Filter::IsGatheringGas)
              && !BWAPI::Filter::IsCarryingSomething);
            if (builder
              && builder->getRegion()
              && unit->getRegion()
              && builder->getRegion()->getRegionGroupID() == unit->getRegion()->getRegionGroupID()) {
              builder->rightClick(unit);
              builder->setClientInfo(BWAPI::Broodwar->getLatencyFrames(), static_cast<int>(ClientInfo::Sleep));
            }
          }
        }
        if (unit->isUnderAttack()
          && 100 * unit->getHitPoints() / unit->getType().maxHitPoints() < 10) {
          unit->getType().getRace() == BWAPI::Races::Zerg ? unit->cancelMorph() : unit->cancelConstruction();
          unit->setClientInfo(BWAPI::Broodwar->getLatencyFrames(), static_cast<int>(ClientInfo::Sleep));
        }
        continue;
      }

      if (unit->getType().isMechanical()
        && !unit->getType().isWorker()
        && unit->getType().getRace() == BWAPI::Races::Terran
        && 100 * unit->getHitPoints() / unit->getType().maxHitPoints() < 90) {
        auto job = static_cast<JobType>(unit->getClientInfo<int>(static_cast<int>(ClientInfo::Job)));
        if (unit->getType().isBuilding()
          || job == JobType::None
          || job == JobType::HoldDefend) {
          auto repairers = unit->getUnitsInRadius(999999
            , BWAPI::Filter::OrderTarget == unit
            && BWAPI::Filter::GetPlayer == self
            && BWAPI::Filter::CurrentOrder == BWAPI::Orders::Repair);
          if (!repairers.size()) {
            auto repairer = unit->getClosestUnit([unit] (BWAPI::Unit u) {
              return (!u->isCarryingGas() && !u->isCarryingMinerals())
                && u->getType() == BWAPI::UnitTypes::Terran_SCV
                && (static_cast<JobType>(unit->getClientInfo<int>(static_cast<int>(ClientInfo::Job))) != JobType::HoldDefend ? static_cast<JobType>(u->getClientInfo<int>(static_cast<int>(ClientInfo::Job))) != JobType::HoldDefend && u->isGatheringMinerals() : static_cast<JobType>(u->getClientInfo<int>(static_cast<int>(ClientInfo::Job))) == JobType::HoldDefend);
              });
            if (repairer
              && data->minerals
              && (unit->getType().gasPrice() > 0 ? data->gas : true)) {
              issueOrder(repairer, BWAPI::Orders::Repair, BWAPI::Positions::None, unit);
              unit->setClientInfo<int>(BWAPI::Broodwar->getLatencyFrames(), static_cast<int>(ClientInfo::Sleep));
              continue;
            }
          }
        }
      }

      if (unit->getType().groundWeapon() != BWAPI::WeaponTypes::None
        || unit->getType().airWeapon() != BWAPI::WeaponTypes::None
        && unit->isIdle()) {
        if (acquireAndAttackTarget(unit)) {
          continue;
        }
      }
      if (unit->getType() == BWAPI::UnitTypes::Terran_Bunker) {
        if (unit->getSpaceRemaining()) {
          if (unit->getClosestUnit(BWAPI::Filter::OrderTarget == unit && BWAPI::Filter::GetPlayer == self))
            continue;
          else {
            bool hasFirebat = false;
            for (auto loadedUnit : unit->getLoadedUnits()) {
              if (loadedUnit->getType() == BWAPI::UnitTypes::Terran_Firebat) {
                hasFirebat = true;
                break;
              }
            }
            BWAPI::UnitType typeToLoad = BWAPI::UnitTypes::Terran_Marine;
            bool holdDefend = static_cast<JobType>(unit->getClientInfo<int>(static_cast<int>(ClientInfo::Job))) == JobType::HoldDefend;
            if (!hasFirebat)
              typeToLoad = BWAPI::UnitTypes::Terran_Firebat;
            auto unitToLoad = unit->getClosestUnit([self, typeToLoad, holdDefend](BWAPI::Unit unit) {
              return (holdDefend ? static_cast<JobType>(unit->getClientInfo<int>(static_cast<int>(ClientInfo::Job))) == JobType::HoldDefend : static_cast<JobType>(unit->getClientInfo<int>(static_cast<int>(ClientInfo::Job))) == JobType::None)
                && unit->getType() == typeToLoad
                && unit->getPlayer() == self
                && unit->getOrder() != BWAPI::Orders::EnterTransport;
              }, data->buildRange * 32);
            if (!unitToLoad && typeToLoad != BWAPI::UnitTypes::Terran_Marine) {
              unitToLoad = unit->getClosestUnit([self, holdDefend](BWAPI::Unit unit) {
                return (holdDefend ? static_cast<JobType>(unit->getClientInfo<int>(static_cast<int>(ClientInfo::Job))) == JobType::HoldDefend : static_cast<JobType>(unit->getClientInfo<int>(static_cast<int>(ClientInfo::Job))) == JobType::None)
                  && unit->getType() == BWAPI::UnitTypes::Terran_Marine
                  && unit->getPlayer() == self
                  && unit->getOrder() != BWAPI::Orders::EnterTransport;
                }, data->buildRange * 32);
            }
            if (unitToLoad) {
              unit->load(unitToLoad);
              unit->setClientInfo(BWAPI::Broodwar->getLatencyFrames(), static_cast<int>(ClientInfo::Sleep));
              continue;
            }
          }
        }
      }
    }
    else if (unit->getType().groundWeapon() != BWAPI::WeaponTypes::None
      || unit->getType().airWeapon() != BWAPI::WeaponTypes::None
      || unit->getType() == BWAPI::UnitTypes::Protoss_Carrier
      || unit->getType() == BWAPI::UnitTypes::Terran_Medic) {
      auto assignedRegion = unit->getClientInfo<BWAPI::Region>(static_cast<int>(ClientInfo::AssignedRegion));
      auto job = static_cast<JobType>(unit->getClientInfo<int>(static_cast<int>(ClientInfo::Job)));
      if (job != JobType::Move
        && acquireAndAttackTarget(unit)) {
        continue;
      }

      if (job == JobType::HelpExpand) {
        BWAPI::TilePosition location = { unit->getClientInfo<int>(static_cast<int>(ClientInfo::JobX)), unit->getClientInfo<int>(static_cast<int>(ClientInfo::JobY)) };
        BWAPI::Position locationPosition = BWAPI::Position{ location };
        auto unitsAtLocation = BWAPI::Broodwar->getUnitsInRectangle(locationPosition, locationPosition + BWAPI::Position{ 64, 64 }, BWAPI::Filter::GetPlayer == self && BWAPI::Filter::IsResourceDepot);
        if (unitsAtLocation.size()) {
          unit->setClientInfo(static_cast<int>(JobType::None), static_cast<int>(ClientInfo::Job));
          unit->setClientInfo(0, static_cast<int>(ClientInfo::JobX));
          unit->setClientInfo(0, static_cast<int>(ClientInfo::JobY));
          unit->setClientInfo((*unitsAtLocation.begin()), static_cast<int>(ClientInfo::AssignedDepot));
          continue;
        }
        if (unit->isIdle()) {
          if (100 < unit->getDistance(locationPosition)) {
            int tries = 0;
            while (tries < 50) {
              auto movePosition = locationPosition + BWAPI::Position{ data->getRandomInteger(-100, 100), data->getRandomInteger(-100, 100) };
              auto difference = movePosition - locationPosition;
              if (difference.x < 64 && 0 < difference.x && difference.y < 64 && 0 < difference.y) {
                tries++;
              }
              else {
                issueOrder(unit, BWAPI::Orders::Move, movePosition);
                tries = 50;
              }
            }
          }
        }
        continue;
      }
      else if (job == JobType::HoldDefend) {
        if (unit->getType().isMechanical()
          && unit->getType().getRace() == BWAPI::Races::Terran
          && 100 * unit->getHitPoints() / unit->getType().maxHitPoints() < 90) {
          auto repairers = unit->getUnitsInRadius(999999
            , BWAPI::Filter::OrderTarget == unit
            && BWAPI::Filter::GetPlayer == self
            && BWAPI::Filter::CurrentOrder == BWAPI::Orders::Repair);
          if (!repairers.size()) {
            auto repairer = unit->getClosestUnit([](BWAPI::Unit u) {
              return u->getType() == BWAPI::UnitTypes::Terran_SCV
                && static_cast<JobType>(u->getClientInfo<int>(static_cast<int>(ClientInfo::Job))) == JobType::HoldDefend
                && u->getOrder() != BWAPI::Orders::Repair;
              });
            if (repairer
              && data->minerals
              && (unit->getType().gasPrice() > 0 ? data->gas > 0 : true))
              issueOrder(repairer, BWAPI::Orders::Repair, BWAPI::Positions::None, unit);
            unit->setClientInfo<int>(BWAPI::Broodwar->getLatencyFrames(), static_cast<int>(ClientInfo::Sleep));
            continue;
          }
        }
        if (unit->getType().isWorker()) {
          auto assignedDepot = unit->getClientInfo<BWAPI::Unit>(static_cast<int>(ClientInfo::AssignedDepot));
          if (assignedDepot) {
            unit->stop();
            unit->setClientInfo(nullptr, static_cast<int>(ClientInfo::AssignedDepot));
            continue;
          }
        }
        auto holdPosition = BWAPI::Position{ unit->getClientInfo<int>(static_cast<int>(ClientInfo::JobX)), unit->getClientInfo<int>(static_cast<int>(ClientInfo::JobY)) };
        if (50 < unit->getDistance(holdPosition)
          && unit->getOrder() != BWAPI::Orders::EnterTransport
          && unit->getOrder() != BWAPI::Orders::Repair) {
          issueOrder(unit, BWAPI::Orders::Move, holdPosition);
          continue;
        }
      }
      else if (job == JobType::Move) {
        if (unit->isIdle()) {
          issueOrder(unit, BWAPI::Orders::Move, BWAPI::Position{ BWAPI::TilePosition{ unit->getClientInfo<int>(static_cast<int>(ClientInfo::JobX)), unit->getClientInfo<int>(static_cast<int>(ClientInfo::JobY)) } });
          continue;
        }
      }
      else if (job == JobType::Attack) {
        auto squadLeader = unit->getClientInfo<bool>(static_cast<int>(ClientInfo::SquadLeader));
        auto target = BWAPI::Position{ unit->getClientInfo<int>(static_cast<int>(ClientInfo::JobX)), unit->getClientInfo<int>(static_cast<int>(ClientInfo::JobY)) };
        auto acquireNewTarget = [unit, this]() {
          int closestDistance = INT_MAX;
          BWAPI::Unit closestUnit = nullptr;
          for (auto& [__, building] : data->enemyBuildings) {
            BWAPI::Position location = BWAPI::Position{ building->getClientInfo<int>(static_cast<int>(ClientInfo::BuildLocationX)), building->getClientInfo<int>(static_cast<int>(ClientInfo::BuildLocationY)) };
            auto distance = unit->getDistance(location);
            if (distance < closestDistance
              && unit->getType().sightRange() - 20 <= distance) {
              closestDistance = distance;
              closestUnit = building;
            }
          }
          if (closestUnit) {
            unit->setClientInfo(closestUnit->getClientInfo<int>(static_cast<int>(ClientInfo::BuildLocationX)), static_cast<int>(ClientInfo::JobX));
            unit->setClientInfo(closestUnit->getClientInfo<int>(static_cast<int>(ClientInfo::BuildLocationY)), static_cast<int>(ClientInfo::JobY));
            return;
          }
          else {
            auto itr = data->attackLocations.begin();
            auto hasTransports = [this]() {
              using namespace BWAPI::UnitTypes;
              return 0 <= data->counts.complete[Protoss_Shuttle] || 0 <= data->counts.complete[Terran_Dropship] || BWAPI::Broodwar->self()->getUpgradeLevel(BWAPI::UpgradeTypes::Ventral_Sacs) == 1;
            };
            while (itr != data->attackLocations.end()) {
              if (BWAPI::Broodwar->isVisible(*itr)
                || (BWAPI::Broodwar->getRegionAt(BWAPI::Position{ *itr })->getRegionGroupID() != unit->getRegion()->getRegionGroupID()
                  && !hasTransports())) {
                itr++;
                continue;
              }
              else {
                BWAPI::Position target = BWAPI::Position{ *itr };
                unit->setClientInfo(target.x, static_cast<int>(ClientInfo::JobX));
                unit->setClientInfo(target.y, static_cast<int>(ClientInfo::JobY));
                issueOrder(unit, BWAPI::Orders::Move, target);
                auto addToEnd = *itr;
                itr = data->attackLocations.erase(itr);
                data->attackLocations.push_back(addToEnd);
                itr = data->attackLocations.end();
                continue;
              }
            }
          }
        };
        if (unit->isLoaded()) {
          if (unit->getTransport()->getType() == BWAPI::UnitTypes::Terran_Bunker) {
            unit->getTransport()->unload(unit);
            unit->getTransport()->setClientInfo(BWAPI::Broodwar->getLatencyFrames(), static_cast<int>(ClientInfo::Sleep));
            unit->setClientInfo(BWAPI::Broodwar->getLatencyFrames(), static_cast<int>(ClientInfo::Sleep));
            continue;
          }
        }
        if (unit->isIdle()) {
          if (squadLeader
            && unit->getDistance(target) < unit->getType().sightRange() - 20) {
            acquireNewTarget();
          }
          else if (target.x != 0) {
            issueOrder(unit, BWAPI::Orders::Move, target);
            if (BWAPI::Broodwar->isVisible(BWAPI::TilePosition{ target })) {
              unit->setClientInfo(0, static_cast<int>(ClientInfo::JobX));
              unit->setClientInfo(0, static_cast<int>(ClientInfo::JobY));
            }
            continue;
          }
          else {
            if (squadLeader) {
              acquireNewTarget();
            }
            else {
              // get target from squad leader
              for (auto& unitSet : data->attackerUnitSets) {
                BWAPI::Unit leader = nullptr;
                bool found = false;
                for (auto& attacker : unitSet) {
                  if (attacker->getClientInfo<bool>(static_cast<int>(ClientInfo::SquadLeader))) {
                    leader = attacker;
                  }
                  if (attacker == unit) {
                    found = true;
                  }
                }
                if (found
                  && leader) {
                  unit->setClientInfo(leader->getClientInfo<int>(static_cast<int>(ClientInfo::JobX)), static_cast<int>(ClientInfo::JobX));
                  unit->setClientInfo(leader->getClientInfo<int>(static_cast<int>(ClientInfo::JobY)), static_cast<int>(ClientInfo::JobY));
                  continue;
                }
              }
            }
          }
        }
      }
      else if (job == JobType::Defend) {
        if (unit->isIdle()) {
          bool found = false;
          auto requestedUnit = unit->getClientInfo<BWAPI::Unit>(static_cast<int>(ClientInfo::JobUnit));
          for (auto& checkJob : data->jobList) {
            if (checkJob.requestingUnit == requestedUnit) {
              found = true;
              break;
            }
          }
          if (!found
            || !requestedUnit) {
            unit->setClientInfo(static_cast<int>(JobType::None), static_cast<int>(ClientInfo::Job));
            unit->setClientInfo(nullptr, static_cast<int>(ClientInfo::JobUnit));
            issueOrder(unit, BWAPI::Orders::Stop);
            continue;
          }
          else {
            auto enemySet = requestedUnit->getUnitsInRadius(BWAPI::WeaponTypes::Arclite_Shock_Cannon.maxRange(), BWAPI::Filter::IsEnemy && !BWAPI::Filter::IsBuilding);
            for (auto& enemy : enemySet) {
              if (!enemy->getType().isFlyer() && unit->getType().groundWeapon() != BWAPI::WeaponTypes::None
                && (enemy->isDetected())) {
                issueOrder(unit, BWAPI::Orders::Move, enemy->getPosition());
                continue;
              }
              if (enemy->getType().isFlyer() && unit->getType().airWeapon() != BWAPI::WeaponTypes::None
                && (enemy->isDetected())) {
                issueOrder(unit, BWAPI::Orders::Move, enemy->getPosition());
                continue;
              }
            }
          }
        }
      }
      else if (unit->isIdle()
        && assignedRegion
        && unit->getRegion() != assignedRegion) {
        issueOrder(unit, BWAPI::Orders::Move, assignedRegion->getCenter());
        continue;
      }
      else if (!assignedRegion
        && (unit->isIdle() || unit->getOrder() == BWAPI::Orders::BunkerGuard)
        && !unit->getType().isBuilding()) {
        auto depot = unit->getClientInfo<BWAPI::Unit>(static_cast<int>(ClientInfo::AssignedDepot));

        if (!depot) {
          depot = getClosestNotMacroResourceDepot(unit);
          if (depot) {
            unit->setClientInfo(depot, static_cast<int>(ClientInfo::AssignedDepot));
            data->defenderUnitSets[depot->getClientInfo<int>(static_cast<int>(ClientInfo::ResourceGroup))].insert(unit);
          }
        }
        if (depot) {
          BWAPI::Region region = nullptr;
          for (auto& r : data->defenderRegions[depot->getClientInfo<int>(static_cast<int>(ClientInfo::ResourceGroup))]) {
            if (!region)
              region = r;
            else if (r->getClientInfo<int>(static_cast<int>(ClientInfo::AssignedCount)) < region->getClientInfo<int>(static_cast<int>(ClientInfo::AssignedCount))) {
              region = r;
            }
          }
          if (region) {
            region->setClientInfo(region->getClientInfo<int>(static_cast<int>(ClientInfo::AssignedCount)) + 1, static_cast<int>(ClientInfo::AssignedCount));
            unit->setClientInfo(region, static_cast<int>(ClientInfo::AssignedRegion));
            continue;
          }
        }
      }
    }
  }
}

void bwapidatadisplay::printInfo() {
  if (printStatus) {
    for (auto& unit : BWAPI::Broodwar->getAllUnits()) {
      if (!unit->getPlayer()->isNeutral()
        && !unit->isLoaded()
        && unit->getType() != BWAPI::UnitTypes::Spell_Scanner_Sweep) {
        if (unit->isCompleted()) {
          int boxes = unit->getType().width() / 3;
          auto perBox = 100.0 / (static_cast<double>(boxes) * 100.0);
          BWAPI::Color colorToUse = BWAPI::Colors::Green;
          auto percent = static_cast<double>(unit->getHitPoints()) / static_cast<double>(unit->getType().maxHitPoints());
          auto shieldPercent = 0.0;
          if (unit->getType().maxShields() > 0) {
            shieldPercent = static_cast<double>(unit->getShields()) / static_cast<double>(unit->getType().maxShields());
            auto drawPercent = 0.0;
            for (int i = 0; i < boxes; i++) {
              BWAPI::Color boxColor = BWAPI::Colors::Grey;
              if (drawPercent < shieldPercent) {
                boxColor = BWAPI::Colors::Blue;
              }
              BWAPI::Broodwar->drawBoxMap(unit->getPosition() + BWAPI::Position{ -2 * (boxes / 2 - i) , unit->getType().height() / 2 }, unit->getPosition() + BWAPI::Position{ -2 * (boxes / 2 - i) + 3, unit->getType().height() / 2 + 4 }, boxColor, true);
              BWAPI::Broodwar->drawBoxMap(unit->getPosition() + BWAPI::Position{ -2 * (boxes / 2 - i) , unit->getType().height() / 2 }, unit->getPosition() + BWAPI::Position{ -2 * (boxes / 2 - i) + 3, unit->getType().height() / 2 + 4 }, BWAPI::Colors::Black, false);
              drawPercent += perBox;
            }
          }
          if (percent < 1.0 / 3.0) {
            colorToUse = BWAPI::Colors::Red;
          }
          else if (percent < 2.0 / 3.0) {
            colorToUse = BWAPI::Colors::Yellow;
          }
          auto drawPercent = 0.0;
          for (int i = 0; i < boxes; i++) {
            BWAPI::Color boxColor = BWAPI::Colors::Grey;
            if (drawPercent < percent) {
              boxColor = colorToUse;
            }
            BWAPI::Broodwar->drawBoxMap(unit->getPosition() + BWAPI::Position{ -2 * (boxes / 2 - i) , unit->getType().maxShields() > 0 ? unit->getType().height() / 2 + 4 : unit->getType().height() / 2 }, unit->getPosition() + BWAPI::Position{ -2 * (boxes / 2 - i) + 3, unit->getType().maxShields() > 0 ? unit->getType().height() / 2 + 8 : unit->getType().height() / 2 + 4 }, boxColor, true);
            BWAPI::Broodwar->drawBoxMap(unit->getPosition() + BWAPI::Position{ -2 * (boxes / 2 - i) , unit->getType().maxShields() > 0 ? unit->getType().height() / 2 + 4 : unit->getType().height() / 2 }, unit->getPosition() + BWAPI::Position{ -2 * (boxes / 2 - i) + 3, unit->getType().maxShields() > 0 ? unit->getType().height() / 2 + 8 : unit->getType().height() / 2 + 4 }, BWAPI::Colors::Black, false);
            drawPercent += perBox;
          }
          auto energyPercent = 0.0;
          if (0 < unit->getType().maxEnergy()) {
            energyPercent = static_cast<double>(unit->getEnergy()) / static_cast<double>(unit->getType().maxEnergy());
            auto drawPercent = 0.0;
            for (int i = 0; i < boxes; i++) {
              BWAPI::Color boxColor = BWAPI::Colors::Grey;
              if (drawPercent < energyPercent) {
                boxColor = BWAPI::Colors::Purple;
              }
              BWAPI::Broodwar->drawBoxMap(unit->getPosition() + BWAPI::Position{ -2 * (boxes / 2 - i) , unit->getType().maxShields() > 0 ? unit->getType().height() / 2 + 8 : unit->getType().height() / 2 + 4 }, unit->getPosition() + BWAPI::Position{ -2 * (boxes / 2 - i) + 3, unit->getType().maxShields() > 0 ? unit->getType().height() / 2 + 12 : unit->getType().height() / 2 + 8 }, boxColor, true);
              BWAPI::Broodwar->drawBoxMap(unit->getPosition() + BWAPI::Position{ -2 * (boxes / 2 - i) , unit->getType().maxShields() > 0 ? unit->getType().height() / 2 + 8 : unit->getType().height() / 2 + 4 }, unit->getPosition() + BWAPI::Position{ -2 * (boxes / 2 - i) + 3, unit->getType().maxShields() > 0 ? unit->getType().height() / 2 + 12 : unit->getType().height() / 2 + 8 }, BWAPI::Colors::Black, false);
              drawPercent += perBox;
            }
          }
        }
      }
    }
  }
  
  if (printBaseInformation) {
    for (auto& [resourceGroup, baseLocation] : data->baseLocations) {
      BWAPI::Broodwar->drawBoxMap(BWAPI::Position{ baseLocation.location }, BWAPI::Position{ BWAPI::Position{ baseLocation.location } + BWAPI::Position{ BWAPI::UnitTypes::Terran_Command_Center.tileSize() } }, BWAPI::Colors::White);
    }

    for (auto& resourceDepot : data->resourceDepots) {
      if (resourceDepot->isBeingConstructed())
        continue;

      auto textColor = BWAPI::Text::Green;
      auto resourceGroup = resourceDepot->getClientInfo<int>(static_cast<int>(ClientInfo::ResourceGroup));
      if (data->mineralWorkers[resourceGroup] < data->maxMineralWorkers[resourceGroup])
        textColor = BWAPI::Text::Red;
      BWAPI::Broodwar->drawTextMap(resourceDepot->getPosition() + BWAPI::Position{ 0, 20 }, "%c%d/%c%d", textColor, data->mineralWorkers[resourceGroup], BWAPI::Text::White, data->maxMineralWorkers[resourceGroup]);
    }

    for (auto& refinery : data->refineries) {
      if (refinery->isBeingConstructed())
        continue;

      auto textColor = BWAPI::Text::Green;
      if (data->gasWorkers[refinery->getID()].size() < 4)
        textColor = BWAPI::Text::Red;
      BWAPI::Broodwar->drawTextMap(refinery->getPosition() + BWAPI::Position{ 0, 20 }, "%c%d/%c4", textColor, data->gasWorkers[refinery->getID()].size(), BWAPI::Text::White);
    }
  }

  if (printIDs) {
    for (auto& unit : BWAPI::Broodwar->getAllUnits()) {
      BWAPI::Broodwar->drawTextMap(unit->getPosition() + BWAPI::Position{ 0, -32 }, "ID: %i", unit->getID());
    }
  }

  if (printCounts) {
    int longestLength = 0;
    for (auto& [type, raw] : data->counts.raw) {
      if (!raw)
        continue;

      if (longestLength < type.toString().length())
        longestLength = type.toString().length();
    }
    int y = 24;
    BWAPI::Broodwar->drawTextScreen(BWAPI::Position{ 400, 12 }, "Name:");
    BWAPI::Broodwar->drawTextScreen(BWAPI::Position{ 400 + 6 * longestLength, 12 }, "Raw:");
    BWAPI::Broodwar->drawTextScreen(BWAPI::Position{ 424 + 6 * longestLength, 12 }, "Complete:");
    BWAPI::Broodwar->drawTextScreen(BWAPI::Position{ 454 + 6 * longestLength, 12 }, "Incomplete:");
    for (auto& [type, raw] : data->counts.raw) {
      if (!raw)
        continue;
      BWAPI::Broodwar->drawTextScreen(BWAPI::Position{ 400, y }, "%s", type.c_str());
      BWAPI::Broodwar->drawTextScreen(BWAPI::Position{ 400 + 6 * longestLength, y }, "%i", raw);
      BWAPI::Broodwar->drawTextScreen(BWAPI::Position{ 424 + 6 * longestLength, y }, "%i", data->counts.complete[type]);
      BWAPI::Broodwar->drawTextScreen(BWAPI::Position{ 454 + 6 * longestLength, y }, "%i", data->counts.incomplete[type]);
      y += 12;
    }
  }

  /*for (auto region : BWAPI::Broodwar->getAllRegions()) {
    BWAPI::Broodwar->drawTextMap(region->getCenter(), "%i", region->getUnits(BWAPI::Filter::IsBuilding && BWAPI::Filter::GetPlayer == BWAPI::Broodwar->self()).size());
    BWAPI::Broodwar->drawTextMap(region->getCenter() + BWAPI::Position{ 0, 12 }, "%i", region->getUnits(BWAPI::Filter::GetType == BWAPI::UnitTypes::Terran_Vulture_Spider_Mine && BWAPI::Filter::GetPlayer == BWAPI::Broodwar->self()).size());
    
    for (auto neighbor : region->getNeighbors()) {
      BWAPI::Broodwar->drawLineMap(neighbor->getCenter(), region->getCenter(), BWAPI::Colors::Orange);
    }
  }*/

  if (printAllows) {
    int y = 24;
    for (const auto& [type, allow] : data->allowed.units) {
      if (allow) {
        BWAPI::Broodwar->drawTextScreen(BWAPI::Position{ 10, y }, "%s", type.c_str());
        y += 12;
      }
    }
    for (const auto& [type, allow] : data->allowed.upgrades) {
      if (allow) {
        BWAPI::Broodwar->drawTextScreen(BWAPI::Position{ 10, y }, "%s", type.c_str());
        y += 12;
      }
    }
    for (const auto& [type, allow] : data->allowed.techs) {
      if (allow) {
        BWAPI::Broodwar->drawTextScreen(BWAPI::Position{ 10, y }, "%s", type.c_str());
        y += 12;
      }
    }
  }

  if (printJobs) {
    for (auto& unit : BWAPI::Broodwar->self()->getUnits()) {
      std::stringstream job;
      auto jobType = static_cast<JobType>(unit->getClientInfo<int>(static_cast<int>(ClientInfo::Job)));
      switch (jobType) {
      case JobType::None:
        job << "N";
        break;
      case JobType::Defend:
        job << "D";
        break;
      case JobType::Attack:
        job << "A";
        break;
      case JobType::HelpExpand:
        job << "HE";
        break;
      case JobType::Taxi:
        job << "T";
        break;
      case JobType::HoldDefend:
        job << "HD";
        break;
      case JobType::Scout:
        job << "S";
        break;
      }
      BWAPI::Broodwar->drawTextMap(unit->getPosition(), "%s", job.str().c_str());
    }
  }

  if (printUnitSets) {
    std::map<BWAPI::UnitType, int> unitSetCount;
    int y = 12;
    for (auto& [id, unitSet] : data->defenderUnitSets) {
      for (auto& unit : unitSet) {
        unitSetCount[unit->getType()]++;
      }
      for (auto& [type, count] : unitSetCount) {
        BWAPI::Broodwar->drawTextScreen(BWAPI::Position{ 140, y }, "%i: %s: %i", id, type.c_str(), count);
        y += 12;
      }
      unitSetCount.clear();
    }
  }

  if (printOrders) {
    for (auto& unit : BWAPI::Broodwar->self()->getUnits()) {
      if (!unit->isGatheringMinerals()
        && !unit->isGatheringGas()
        && !unit->isIdle()) {
        BWAPI::Broodwar->drawLineMap(unit->getPosition(), unit->getTargetPosition(), BWAPI::Colors::Blue);
        BWAPI::Broodwar->drawTextMap(unit->getPosition() + BWAPI::Position{ 0, -10 }, "%s", unit->getOrder().c_str());
      }
    }
  }

  if (printBuildOrders) {
    for (auto& unit : BWAPI::Broodwar->self()->getUnits()) {
      if (!unit->getType().isWorker())
        continue;

      if (static_cast<BWAPI::UnitType>(unit->getClientInfo<int>(static_cast<int>(ClientInfo::BuildType))) != BWAPI::UnitTypes::None) {
        auto x = unit->getClientInfo<int>(static_cast<int>(ClientInfo::BuildLocationX));
        auto y = unit->getClientInfo<int>(static_cast<int>(ClientInfo::BuildLocationY));
        BWAPI::Broodwar->drawLine(BWAPI::CoordinateType::Map, unit->getPosition().x, unit->getPosition().y, x * 32, y * 32, BWAPI::Colors::Red);
        BWAPI::Broodwar->drawBoxMap(BWAPI::Position{ BWAPI::TilePosition{ x, y } }, BWAPI::Position{ BWAPI::TilePosition{ x, y } + static_cast<BWAPI::UnitType>(unit->getClientInfo<int>(static_cast<int>(ClientInfo::BuildType))).tileSize() }, BWAPI::Colors::Red);
        BWAPI::Broodwar->drawTextMap(BWAPI::Position{ BWAPI::TilePosition{ x, y} } + BWAPI::Position{ 0, -10 }, "%s", static_cast<BWAPI::UnitType>(unit->getClientInfo<int>(static_cast<int>(ClientInfo::BuildType))).c_str());
      }
    }
  }

  if (printAssignedDepots) {
    for (auto& u : BWAPI::Broodwar->self()->getUnits()) {
      auto assignedDepot = u->getClientInfo<BWAPI::Unit>(static_cast<int>(ClientInfo::AssignedDepot));
      if (assignedDepot) {
        BWAPI::Broodwar->drawLineMap(u->getPosition(), assignedDepot->getPosition(), BWAPI::Colors::Green);
      }
    }
  }
}

void bwapidatadisplay::requestTaxi(BWAPI::Unit unit, BWAPI::Position target) {
  if (!unit || !unit->exists())
    return;

  auto taxi = unit->getClosestUnit([unit, target](BWAPI::Unit unitTaxi) {
    return unitTaxi->canLoad(unit)
      && (unitTaxi->getOrder().getID() != BWAPI::Orders::MoveUnload
        && unitTaxi->getOrder().getID() != BWAPI::Orders::Unload)
      && (unitTaxi->getClientInfo<int>(static_cast<int>(ClientInfo::JobX)) == 0 || unitTaxi->getClientInfo<int>(static_cast<int>(ClientInfo::JobX)) == target.x);
    });
  if (taxi) {
    unit->rightClick(taxi);
    taxi->setClientInfo(target.x, static_cast<int>(ClientInfo::JobX));
    taxi->setClientInfo(target.y, static_cast<int>(ClientInfo::JobY));
  }
}

void bwapidatadisplay::startLogging() {
  data->startLogging();
}

void bwapidatadisplay::stopLogging() {
  data->endLogging();
}

void bwapidatadisplay::updateAttacks() {
  auto self = BWAPI::Broodwar->self();
  if (data->map != Maps::None) {
    switch (data->map) {
    case Maps::BackwaterStation:
      if (12 <= data->counts.complete[BWAPI::UnitTypes::Terran_Marine]
        && !(self->getClientInfo<int>(static_cast<int>(ClientInfo::Flags)) & 0x1)
        && !data->attackerUnitSets.size()) {
        BWAPI::Unitset newAttackerUnitset;
        int marineCount = 0;
        for (auto& [id, units] : data->defenderUnitSets) {
          auto itr = units.begin();
          while (itr != units.end()) {
            if ((*itr)->getType() == BWAPI::UnitTypes::Terran_Marine
              && marineCount < 12) {
              marineCount++;
              (*itr)->setClientInfo(static_cast<int>(JobType::Attack), static_cast<int>(ClientInfo::Job));
              newAttackerUnitset.insert(*itr);
              itr = units.erase(itr);
            }
            else {
              itr++;
            }
          }
        }
        data->attackerUnitSets.push_back(newAttackerUnitset);
        self->setClientInfo(self->getClientInfo<int>(static_cast<int>(ClientInfo::Flags)) | 0x1, static_cast<int>(ClientInfo::Flags));
      }
      else if (20 <= data->counts.complete[BWAPI::UnitTypes::Terran_Marine]
        && 10 <= data->counts.complete[BWAPI::UnitTypes::Terran_Firebat]
        && (self->getClientInfo<int>(static_cast<int>(ClientInfo::Flags)) & 0x1)
        && !data->attackerUnitSets.size()) {
        BWAPI::Unitset newAttackerUnitset;
        int marineCount = 0;
        int firebatCount = 0;
        for (auto& [id, units] : data->defenderUnitSets) {
          auto itr = units.begin();
          while (itr != units.end()) {
            if ((*itr)->getType() == BWAPI::UnitTypes::Terran_Marine
              && marineCount < 20) {
              marineCount++;
              (*itr)->setClientInfo(static_cast<int>(JobType::Attack), static_cast<int>(ClientInfo::Job));
              newAttackerUnitset.insert(*itr);
              itr = units.erase(itr);
            }
            else if ((*itr)->getType() == BWAPI::UnitTypes::Terran_Firebat
              && firebatCount < 10) {
              firebatCount++;
              (*itr)->setClientInfo(static_cast<int>(JobType::Attack), static_cast<int>(ClientInfo::Job));
              newAttackerUnitset.insert(*itr);
              itr = units.erase(itr);
            }
            else {
              itr++;
            }
          }
        }
        data->attackerUnitSets.push_back(newAttackerUnitset);
      }
      break;
    case Maps::TheJacobsInstallation:
      if (!data->attackerUnitSets.size()) {
        BWAPI::Unitset newAttackerUnitset;
        for (auto unit : BWAPI::Broodwar->getAllUnits()) {
          if (unit->getPlayer() == self
            || unit->getType() == BWAPI::UnitTypes::Hero_Jim_Raynor_Marine) {
            newAttackerUnitset.insert(unit);
            unit->setClientInfo(static_cast<int>(JobType::Attack), static_cast<int>(ClientInfo::Job));
          }
        }
        data->attackerUnitSets.push_back(newAttackerUnitset);
      }
      break;
    case Maps::Revolution:
      if (BWAPI::Broodwar->getFrameCount() == 0) {
        BWAPI::Unitset newAttackerUnitset;
        for (auto unit : BWAPI::Broodwar->getAllUnits()) {
          if (unit->getPlayer() == self
            || unit->getType() == BWAPI::UnitTypes::Hero_Jim_Raynor_Vulture) {
            newAttackerUnitset.insert(unit);
            unit->setClientInfo(static_cast<int>(JobType::Attack), static_cast<int>(ClientInfo::Job));
          }
        }
        data->attackerUnitSets.push_back(newAttackerUnitset);
      }
      else if (data->counts.raw[BWAPI::UnitTypes::Hero_Sarah_Kerrigan]
        && data->attackerUnitSets.size() == 1
        && data->counts.raw[BWAPI::UnitTypes::Terran_Command_Center] < 1) {
        BWAPI::Unitset newAttackerUnitset;
        for (auto unit : BWAPI::Broodwar->getAllUnits()) {
          if (unit->getType() == BWAPI::UnitTypes::Hero_Sarah_Kerrigan) {
            newAttackerUnitset.insert(unit);
            unit->setClientInfo(static_cast<int>(JobType::Move), static_cast<int>(ClientInfo::Job));
            unit->setClientInfo(85, static_cast<int>(ClientInfo::JobX));
            unit->setClientInfo(16, static_cast<int>(ClientInfo::JobY));
          }
        }
        data->attackerUnitSets.push_back(newAttackerUnitset);
      }
      else if (1 <= data->counts.raw[BWAPI::UnitTypes::Terran_Command_Center]
        && !(self->getClientInfo<int>(static_cast<int>(ClientInfo::Flags)) & 0x1)) {
        auto itr = data->attackerUnitSets.begin();
        while (itr != data->attackerUnitSets.end()) {
          itr->setClientInfo(static_cast<int>(JobType::None), static_cast<int>(ClientInfo::Job));
          itr->setClientInfo(0, static_cast<int>(ClientInfo::JobX));
          itr->setClientInfo(0, static_cast<int>(ClientInfo::JobY));
          itr = data->attackerUnitSets.erase(itr);
        }
        self->setClientInfo(self->getClientInfo<int>(static_cast<int>(ClientInfo::Flags)) | 0x1, static_cast<int>(ClientInfo::Flags));
      }
      else if (21 <= data->counts.complete[BWAPI::UnitTypes::Terran_Marine]
        && 4 <= data->counts.complete[BWAPI::UnitTypes::Terran_Vulture]
        && 4 <= data->counts.complete[BWAPI::UnitTypes::Terran_Dropship]
        && (self->getClientInfo<int>(static_cast<int>(ClientInfo::Flags)) & 0x1)
        && !(self->getClientInfo<int>(static_cast<int>(ClientInfo::Flags)) & 0x2)
        && !data->attackerUnitSets.size()) {
        BWAPI::Unitset newAttackerUnitset;
        int marineCount = 0;
        int vultureCount = 0;
        for (auto& [id, units] : data->defenderUnitSets) {
          auto itr = units.begin();
          while (itr != units.end()) {
            if ((*itr)->getType() == BWAPI::UnitTypes::Terran_Marine
              && marineCount < 21) {
              marineCount++;
              (*itr)->setClientInfo(static_cast<int>(JobType::Attack), static_cast<int>(ClientInfo::Job));
              newAttackerUnitset.insert(*itr);
              itr = units.erase(itr);
            }
            else if ((*itr)->getType() == BWAPI::UnitTypes::Terran_Vulture
              && vultureCount < 4) {
              vultureCount++;
              (*itr)->setClientInfo(static_cast<int>(JobType::Attack), static_cast<int>(ClientInfo::Job));
              newAttackerUnitset.insert(*itr);
              itr = units.erase(itr);
            }
            else {
              itr++;
            }
          }
        }
        data->attackerUnitSets.push_back(newAttackerUnitset);
        self->setClientInfo(self->getClientInfo<int>(static_cast<int>(ClientInfo::Flags)) | 0x2, static_cast<int>(ClientInfo::Flags));
      }
      else if (16 <= data->counts.complete[BWAPI::UnitTypes::Terran_Marine]
        && 12 <= data->counts.complete[BWAPI::UnitTypes::Terran_Wraith]
        && 2 <= data->counts.complete[BWAPI::UnitTypes::Terran_Dropship]
        && (self->getClientInfo<int>(static_cast<int>(ClientInfo::Flags)) & 0x1)
        //&& !(self->getClientInfo<int>(static_cast<int>(ClientInfo::Flags)) & 0x2)
        && !data->attackerUnitSets.size()) {
        BWAPI::Unitset newAttackerUnitset;
        int marineCount = 0;
        int wraithCount = 0;
        for (auto& [id, units] : data->defenderUnitSets) {
          auto itr = units.begin();
          while (itr != units.end()) {
            if ((*itr)->getType() == BWAPI::UnitTypes::Terran_Marine
              && marineCount < 16) {
              marineCount++;
              (*itr)->setClientInfo(static_cast<int>(JobType::Attack), static_cast<int>(ClientInfo::Job));
              newAttackerUnitset.insert(*itr);
              itr = units.erase(itr);
            }
            else if ((*itr)->getType() == BWAPI::UnitTypes::Terran_Wraith
              && wraithCount < 12) {
              wraithCount++;
              (*itr)->setClientInfo(static_cast<int>(JobType::Attack), static_cast<int>(ClientInfo::Job));
              newAttackerUnitset.insert(*itr);
              itr = units.erase(itr);
            }
            else {
              itr++;
            }
          }
        }
        data->attackerUnitSets.push_back(newAttackerUnitset);
      }
      break;
    case Maps::NoradII:
      if (self->getClientInfo<int>(static_cast<int>(ClientInfo::Flags)) & 0x1
        && !(self->getClientInfo<int>(static_cast<int>(ClientInfo::Flags)) & 0x8)) {
        for (auto unit : self->getUnits()) {
          if (unit->getType() != BWAPI::UnitTypes::Special_Crashed_Norad_II) {
            continue;
          }

          unit->setClientInfo(static_cast<int>(JobType::HoldDefend), static_cast<int>(ClientInfo::Job));
          unit->setClientInfo(unit->getPosition().x, static_cast<int>(ClientInfo::JobX));
          unit->setClientInfo(unit->getPosition().y, static_cast<int>(ClientInfo::JobY));
          for (auto defender : unit->getUnitsInRadius(400, BWAPI::Filter::GetPlayer == self)) {
            defender->setClientInfo(static_cast<int>(JobType::HoldDefend), static_cast<int>(ClientInfo::Job));
            defender->setClientInfo(defender->getPosition().x, static_cast<int>(ClientInfo::JobX));
            defender->setClientInfo(defender->getPosition().y, static_cast<int>(ClientInfo::JobY));
          }
          self->setClientInfo(self->getClientInfo<int>(static_cast<int>(ClientInfo::Flags)) | 0x8, static_cast<int>(ClientInfo::Flags));
          break;
        }
      }
      if (BWAPI::Broodwar->getFrameCount() == 0) {
        BWAPI::Unitset newAttackerUnitset;
        for (auto unit : BWAPI::Broodwar->getAllUnits()) {
          if ((unit->getPlayer() == self
            || unit->getType() == BWAPI::UnitTypes::Hero_Jim_Raynor_Vulture)
            && !unit->getType().isWorker()) {
            newAttackerUnitset.insert(unit);
            unit->setClientInfo(static_cast<int>(JobType::Attack), static_cast<int>(ClientInfo::Job));
          }
        }
        data->attackerUnitSets.push_back(newAttackerUnitset);
        
      }
      else if (1 <= data->counts.raw[BWAPI::UnitTypes::Terran_Command_Center]
        && !(self->getClientInfo<int>(static_cast<int>(ClientInfo::Flags)) & 0x1)) {
        auto itr = data->attackerUnitSets.begin();
        while (itr != data->attackerUnitSets.end()) {
          itr->setClientInfo(static_cast<int>(JobType::None), static_cast<int>(ClientInfo::Job));
          itr->setClientInfo(0, static_cast<int>(ClientInfo::JobX));
          itr->setClientInfo(0, static_cast<int>(ClientInfo::JobY));
          itr = data->attackerUnitSets.erase(itr);
        }
        self->setClientInfo(self->getClientInfo<int>(static_cast<int>(ClientInfo::Flags)) | 0x1, static_cast<int>(ClientInfo::Flags));
      }
      else if (24 <= data->counts.complete[BWAPI::UnitTypes::Terran_Goliath]
        && (self->getClientInfo<int>(static_cast<int>(ClientInfo::Flags)) & 0x1)
        && !(self->getClientInfo<int>(static_cast<int>(ClientInfo::Flags)) & 0x2)
        && !data->attackerUnitSets.size()) {
        BWAPI::Unitset newAttackerUnitset;
        int goliathCount = 0;
        for (auto& [id, units] : data->defenderUnitSets) {
          auto itr = units.begin();
          while (itr != units.end()) {
            if ((*itr)->getType() == BWAPI::UnitTypes::Terran_Goliath
              && goliathCount < 24) {
              goliathCount++;
              (*itr)->setClientInfo(static_cast<int>(JobType::Attack), static_cast<int>(ClientInfo::Job));
              newAttackerUnitset.insert(*itr);
              itr = units.erase(itr);
            }
            else {
              itr++;
            }
          }
        }
        data->attackerUnitSets.push_back(newAttackerUnitset);
        self->setClientInfo(self->getClientInfo<int>(static_cast<int>(ClientInfo::Flags)) | 0x2, static_cast<int>(ClientInfo::Flags));
      }
      else if (36 <= data->counts.complete[BWAPI::UnitTypes::Terran_Goliath]
        && (self->getClientInfo<int>(static_cast<int>(ClientInfo::Flags)) & 0x1)
        && (self->getClientInfo<int>(static_cast<int>(ClientInfo::Flags)) & 0x2)
        && !data->attackerUnitSets.size()) {
        BWAPI::Unitset newAttackerUnitset;
        int goliathCount = 0;
        for (auto& [id, units] : data->defenderUnitSets) {
          auto itr = units.begin();
          while (itr != units.end()) {
            if ((*itr)->getType() == BWAPI::UnitTypes::Terran_Goliath
              && goliathCount < 36) {
              goliathCount++;
              (*itr)->setClientInfo(static_cast<int>(JobType::Attack), static_cast<int>(ClientInfo::Job));
              newAttackerUnitset.insert(*itr);
              itr = units.erase(itr);
            }
            else if ((*itr)->getType() == BWAPI::UnitTypes::Hero_Jim_Raynor_Vulture) {
              (*itr)->setClientInfo(static_cast<int>(JobType::Attack), static_cast<int>(ClientInfo::Job));
              newAttackerUnitset.insert(*itr);
              itr = units.erase(itr);
            }
            else {
              itr++;
            }
          }
        }
        data->attackerUnitSets.push_back(newAttackerUnitset);
      }
      else if (self->getClientInfo<int>(static_cast<int>(ClientInfo::Flags)) & 0x4) {
        auto itr = data->attackerUnitSets.begin();
        while (itr != data->attackerUnitSets.end()) {
          auto uItr = itr->begin();
          while (uItr != itr->end()) {
            if ((*uItr)->getType() == BWAPI::UnitTypes::Hero_Jim_Raynor_Vulture) {
              (*uItr)->setClientInfo(static_cast<int>(JobType::Move), static_cast<int>(ClientInfo::Job));
              (*uItr)->setClientInfo(69, static_cast<int>(ClientInfo::JobX));
              (*uItr)->setClientInfo(70, static_cast<int>(ClientInfo::JobY));
              uItr = itr->erase(uItr);
              uItr = itr->end();
            }
            else {
              uItr++;
            }
          }
        }
        for (auto unit : self->getUnits()) {
          if (unit->getType() != BWAPI::UnitTypes::Terran_Dropship) {
            continue;
          }

          unit->setClientInfo(static_cast<int>(JobType::Move), static_cast<int>(ClientInfo::Job));
          unit->setClientInfo(69, static_cast<int>(ClientInfo::JobX));
          unit->setClientInfo(70, static_cast<int>(ClientInfo::JobY));
        }
      }
      else if (!(self->getClientInfo<int>(static_cast<int>(ClientInfo::Flags)) & 0x4)) {
        for (auto unit : self->getUnits()) {
          if (unit->getType() != BWAPI::UnitTypes::Special_Crashed_Norad_II) {
            continue;
          }

          auto raynor = unit->getClosestUnit(BWAPI::Filter::GetType == BWAPI::UnitTypes::Hero_Jim_Raynor_Vulture, 100);
          if (raynor) {
            self->setClientInfo(self->getClientInfo<int>(static_cast<int>(ClientInfo::Flags)) | 0x4, static_cast<int>(ClientInfo::Flags));
          }
        }
      }
      break;
    default:
      break;
    }
  }
  if (!data->islandMap) {
    if (390 <= data->supplyUsed
      && data->attackerUnitSets.size() == 0) {
      BWAPI::Unitset newAttackerUnitset;
      int overlordCount = 0;
      int observerCount = 0;
      for (auto& [id, units] : data->defenderUnitSets) {
        auto itr = units.begin();
        while (itr != units.end()) {
          if ((*itr)->getType() == BWAPI::UnitTypes::Zerg_Hydralisk) {
            (*itr)->setClientInfo(static_cast<int>(JobType::Attack), static_cast<int>(ClientInfo::Job));
            newAttackerUnitset.insert(*itr);
            itr = units.erase(itr);
          }
          else if ((*itr)->getType() == BWAPI::UnitTypes::Zerg_Lurker) {
            (*itr)->setClientInfo(static_cast<int>(JobType::Attack), static_cast<int>(ClientInfo::Job));
            newAttackerUnitset.insert(*itr);
            itr = units.erase(itr);
          }
          else if ((*itr)->getType() == BWAPI::UnitTypes::Zerg_Overlord
            && overlordCount < 1) {
            overlordCount++;
            (*itr)->setClientInfo(static_cast<int>(JobType::Attack), static_cast<int>(ClientInfo::Job));
            newAttackerUnitset.insert(*itr);
            itr = units.erase(itr);
          }
          else if ((*itr)->getType() == BWAPI::UnitTypes::Zerg_Mutalisk) {
            (*itr)->setClientInfo(static_cast<int>(JobType::Attack), static_cast<int>(ClientInfo::Job));
            newAttackerUnitset.insert(*itr);
            itr = units.erase(itr);
          }
          else if ((*itr)->getType() == BWAPI::UnitTypes::Zerg_Devourer) {
            (*itr)->setClientInfo(static_cast<int>(JobType::Attack), static_cast<int>(ClientInfo::Job));
            newAttackerUnitset.insert(*itr);
            itr = units.erase(itr);
          }
          else if ((*itr)->getType() == BWAPI::UnitTypes::Zerg_Guardian) {
            (*itr)->setClientInfo(static_cast<int>(JobType::Attack), static_cast<int>(ClientInfo::Job));
            newAttackerUnitset.insert(*itr);
            itr = units.erase(itr);
          }
          else if ((*itr)->getType() == BWAPI::UnitTypes::Zerg_Scourge) {
            (*itr)->setClientInfo(static_cast<int>(JobType::Attack), static_cast<int>(ClientInfo::Job));
            newAttackerUnitset.insert(*itr);
            itr = units.erase(itr);
          }
          else if ((*itr)->getType() == BWAPI::UnitTypes::Zerg_Ultralisk) {
            (*itr)->setClientInfo(static_cast<int>(JobType::Attack), static_cast<int>(ClientInfo::Job));
            newAttackerUnitset.insert(*itr);
            itr = units.erase(itr);
          }
          else if ((*itr)->getType() == BWAPI::UnitTypes::Zerg_Defiler) {
            (*itr)->setClientInfo(static_cast<int>(JobType::Attack), static_cast<int>(ClientInfo::Job));
            newAttackerUnitset.insert(*itr);
            itr = units.erase(itr);
          }
          else if ((*itr)->getType() == BWAPI::UnitTypes::Protoss_Zealot) {
            (*itr)->setClientInfo(static_cast<int>(JobType::Attack), static_cast<int>(ClientInfo::Job));
            newAttackerUnitset.insert(*itr);
            itr = units.erase(itr);
          }
          else if ((*itr)->getType() == BWAPI::UnitTypes::Protoss_Dragoon) {
            (*itr)->setClientInfo(static_cast<int>(JobType::Attack), static_cast<int>(ClientInfo::Job));
            newAttackerUnitset.insert(*itr);
            itr = units.erase(itr);
          }
          else if ((*itr)->getType() == BWAPI::UnitTypes::Protoss_Dark_Templar) {
            (*itr)->setClientInfo(static_cast<int>(JobType::Attack), static_cast<int>(ClientInfo::Job));
            newAttackerUnitset.insert(*itr);
            itr = units.erase(itr);
          }
          else if ((*itr)->getType() == BWAPI::UnitTypes::Protoss_Scout) {
            (*itr)->setClientInfo(static_cast<int>(JobType::Attack), static_cast<int>(ClientInfo::Job));
            newAttackerUnitset.insert(*itr);
            itr = units.erase(itr);
          }
          else if ((*itr)->getType() == BWAPI::UnitTypes::Protoss_Corsair) {
            (*itr)->setClientInfo(static_cast<int>(JobType::Attack), static_cast<int>(ClientInfo::Job));
            newAttackerUnitset.insert(*itr);
            itr = units.erase(itr);
          }
          else if ((*itr)->getType() == BWAPI::UnitTypes::Protoss_Carrier) {
            (*itr)->setClientInfo(static_cast<int>(JobType::Attack), static_cast<int>(ClientInfo::Job));
            newAttackerUnitset.insert(*itr);
            itr = units.erase(itr);
          }
          else if ((*itr)->getType() == BWAPI::UnitTypes::Protoss_Arbiter) {
            (*itr)->setClientInfo(static_cast<int>(JobType::Attack), static_cast<int>(ClientInfo::Job));
            newAttackerUnitset.insert(*itr);
            itr = units.erase(itr);
          }
          else if ((*itr)->getType() == BWAPI::UnitTypes::Protoss_Observer
            && observerCount < 1) {
            observerCount++;
            (*itr)->setClientInfo(static_cast<int>(JobType::Attack), static_cast<int>(ClientInfo::Job));
            newAttackerUnitset.insert(*itr);
            itr = units.erase(itr);
          }
          else if ((*itr)->getType() == BWAPI::UnitTypes::Terran_Battlecruiser) {
            (*itr)->setClientInfo(static_cast<int>(JobType::Attack), static_cast<int>(ClientInfo::Job));
            newAttackerUnitset.insert(*itr);
            itr = units.erase(itr);
          }
          else if ((*itr)->getType() == BWAPI::UnitTypes::Terran_Wraith) {
            (*itr)->setClientInfo(static_cast<int>(JobType::Attack), static_cast<int>(ClientInfo::Job));
            newAttackerUnitset.insert(*itr);
            itr = units.erase(itr);
          }
          else if ((*itr)->getType() == BWAPI::UnitTypes::Terran_Valkyrie) {
            (*itr)->setClientInfo(static_cast<int>(JobType::Attack), static_cast<int>(ClientInfo::Job));
            newAttackerUnitset.insert(*itr);
            itr = units.erase(itr);
          }
          else if (((*itr)->getType() == BWAPI::UnitTypes::Terran_Siege_Tank_Tank_Mode
            || (*itr)->getType() == BWAPI::UnitTypes::Terran_Siege_Tank_Siege_Mode)) {
            (*itr)->setClientInfo(static_cast<int>(JobType::Attack), static_cast<int>(ClientInfo::Job));
            newAttackerUnitset.insert(*itr);
            itr = units.erase(itr);
          }
          else if ((*itr)->getType() == BWAPI::UnitTypes::Terran_Goliath) {
            (*itr)->setClientInfo(static_cast<int>(JobType::Attack), static_cast<int>(ClientInfo::Job));
            newAttackerUnitset.insert(*itr);
            itr = units.erase(itr);
          }
          else if ((*itr)->getType() == BWAPI::UnitTypes::Terran_Ghost) {
            (*itr)->setClientInfo(static_cast<int>(JobType::Attack), static_cast<int>(ClientInfo::Job));
            newAttackerUnitset.insert(*itr);
            itr = units.erase(itr);
          }
          else if ((*itr)->getType() == BWAPI::UnitTypes::Terran_Marine) {
            (*itr)->setClientInfo(static_cast<int>(JobType::Attack), static_cast<int>(ClientInfo::Job));
            newAttackerUnitset.insert(*itr);
            itr = units.erase(itr);
          }
          else if ((*itr)->getType() == BWAPI::UnitTypes::Terran_Medic) {
            (*itr)->setClientInfo(static_cast<int>(JobType::Attack), static_cast<int>(ClientInfo::Job));
            newAttackerUnitset.insert(*itr);
            itr = units.erase(itr);
          }
          else if ((*itr)->getType() == BWAPI::UnitTypes::Terran_Firebat) {
            (*itr)->setClientInfo(static_cast<int>(JobType::Attack), static_cast<int>(ClientInfo::Job));
            newAttackerUnitset.insert(*itr);
            itr = units.erase(itr);
          }
          else if ((*itr)->getType() == BWAPI::UnitTypes::Terran_Vulture) {
            (*itr)->setClientInfo(static_cast<int>(JobType::Attack), static_cast<int>(ClientInfo::Job));
            newAttackerUnitset.insert(*itr);
            itr = units.erase(itr);
          }
          else {
            itr++;
          }
        }
      }
      data->attackerUnitSets.push_back(newAttackerUnitset);
    }
    else if (20 <= data->counts.complete[BWAPI::UnitTypes::Zerg_Hydralisk]
      && 2 <= data->counts.complete[BWAPI::UnitTypes::Zerg_Lurker]
      && !(self->getClientInfo<int>(static_cast<int>(ClientInfo::Flags)) & 0x1)) {
      BWAPI::Unitset newAttackerUnitset;
      int hydraliskCount = 0;
      int lurkerCount = 0;
      int overlordCount = 0;
      for (auto& [id, units] : data->defenderUnitSets) {
        auto itr = units.begin();
        while (itr != units.end()) {
          if ((*itr)->getType() == BWAPI::UnitTypes::Zerg_Hydralisk
            && hydraliskCount < 20) {
            hydraliskCount++;
            (*itr)->setClientInfo(static_cast<int>(JobType::Attack), static_cast<int>(ClientInfo::Job));
            newAttackerUnitset.insert(*itr);
            itr = units.erase(itr);
          }
          else if ((*itr)->getType() == BWAPI::UnitTypes::Zerg_Lurker
            && lurkerCount < 2) {
            lurkerCount++;
            (*itr)->setClientInfo(static_cast<int>(JobType::Attack), static_cast<int>(ClientInfo::Job));
            newAttackerUnitset.insert(*itr);
            itr = units.erase(itr);
          }
          else if ((*itr)->getType() == BWAPI::UnitTypes::Zerg_Overlord
            && overlordCount < 1) {
            overlordCount++;
            (*itr)->setClientInfo(static_cast<int>(JobType::Attack), static_cast<int>(ClientInfo::Job));
            newAttackerUnitset.insert(*itr);
            itr = units.erase(itr);
          }
          else {
            itr++;
          }
        }
      }
      data->attackerUnitSets.push_back(newAttackerUnitset);
      self->setClientInfo(self->getClientInfo<int>(static_cast<int>(ClientInfo::Flags)) | 0x1, static_cast<int>(ClientInfo::Flags));
    }
    else if (9 <= data->counts.complete[BWAPI::UnitTypes::Zerg_Mutalisk]
      && 4 <= data->counts.complete[BWAPI::UnitTypes::Zerg_Devourer]
      && 4 <= data->counts.complete[BWAPI::UnitTypes::Zerg_Guardian]
      && 8 <= data->counts.complete[BWAPI::UnitTypes::Zerg_Scourge]
      && !(self->getClientInfo<int>(static_cast<int>(ClientInfo::Flags)) & 0x2)) {
      BWAPI::Unitset newAttackerUnitset;
      int mutaliskCount = 0;
      int devourerCount = 0;
      int guardianCount = 0;
      int scourgeCount = 0;
      int overlordCount = 0;
      for (auto& [id, units] : data->defenderUnitSets) {
        auto itr = units.begin();
        while (itr != units.end()) {
          if ((*itr)->getType() == BWAPI::UnitTypes::Zerg_Mutalisk
            && mutaliskCount < 20) {
            mutaliskCount++;
            (*itr)->setClientInfo(static_cast<int>(JobType::Attack), static_cast<int>(ClientInfo::Job));
            newAttackerUnitset.insert(*itr);
            itr = units.erase(itr);
          }
          else if ((*itr)->getType() == BWAPI::UnitTypes::Zerg_Devourer
            && devourerCount < 2) {
            devourerCount++;
            (*itr)->setClientInfo(static_cast<int>(JobType::Attack), static_cast<int>(ClientInfo::Job));
            newAttackerUnitset.insert(*itr);
            itr = units.erase(itr);
          }
          else if ((*itr)->getType() == BWAPI::UnitTypes::Zerg_Guardian
            && guardianCount < 2) {
            guardianCount++;
            (*itr)->setClientInfo(static_cast<int>(JobType::Attack), static_cast<int>(ClientInfo::Job));
            newAttackerUnitset.insert(*itr);
            itr = units.erase(itr);
          }
          else if ((*itr)->getType() == BWAPI::UnitTypes::Zerg_Scourge
            && scourgeCount < 2) {
            scourgeCount++;
            (*itr)->setClientInfo(static_cast<int>(JobType::Attack), static_cast<int>(ClientInfo::Job));
            newAttackerUnitset.insert(*itr);
            itr = units.erase(itr);
          }
          else if ((*itr)->getType() == BWAPI::UnitTypes::Zerg_Overlord
            && overlordCount < 1) {
            overlordCount++;
            (*itr)->setClientInfo(static_cast<int>(JobType::Attack), static_cast<int>(ClientInfo::Job));
            newAttackerUnitset.insert(*itr);
            itr = units.erase(itr);
          }
          else {
            itr++;
          }
        }
      }
      data->attackerUnitSets.push_back(newAttackerUnitset);
      self->setClientInfo(self->getClientInfo<int>(static_cast<int>(ClientInfo::Flags)) | 0x2, static_cast<int>(ClientInfo::Flags));
    }
    else if (60 <= data->counts.complete[BWAPI::UnitTypes::Zerg_Zergling]
      && !(self->getClientInfo<int>(static_cast<int>(ClientInfo::Flags)) & 0x4)
      && data->attackerUnitSets.size() == 0) {
      BWAPI::Unitset newAttackerUnitset;
      int zerglingCount = 0;
      int overlordCount = 0;
      for (auto& [id, units] : data->defenderUnitSets) {
        auto itr = units.begin();
        while (itr != units.end()) {
          if ((*itr)->getType() == BWAPI::UnitTypes::Zerg_Zergling
            && zerglingCount < 60) {
            zerglingCount++;
            (*itr)->setClientInfo(static_cast<int>(JobType::Attack), static_cast<int>(ClientInfo::Job));
            newAttackerUnitset.insert(*itr);
            itr = units.erase(itr);
          }
          else if ((*itr)->getType() == BWAPI::UnitTypes::Zerg_Overlord
            && overlordCount < 1) {
            overlordCount++;
            (*itr)->setClientInfo(static_cast<int>(JobType::Attack), static_cast<int>(ClientInfo::Job));
            newAttackerUnitset.insert(*itr);
            itr = units.erase(itr);
          }
          else {
            itr++;
          }
        }
      }
      data->attackerUnitSets.push_back(newAttackerUnitset);
      //self->setClientInfo(self->getClientInfo<int>(static_cast<int>(ClientInfo::Flags)) | 0x4, static_cast<int>(ClientInfo::Flags));
    }
    if (12 <= data->counts.complete[BWAPI::UnitTypes::Protoss_Zealot]
      && !(self->getClientInfo<int>(static_cast<int>(ClientInfo::Flags)) & 0x1)) {
      BWAPI::Unitset newAttackerUnitset;
      int zealotCount = 0;
      for (auto& [id, units] : data->defenderUnitSets) {
        auto itr = units.begin();
        while (itr != units.end()) {
          if ((*itr)->getType() == BWAPI::UnitTypes::Protoss_Zealot
            && zealotCount < 12) {
            zealotCount++;
            (*itr)->setClientInfo(static_cast<int>(JobType::Attack), static_cast<int>(ClientInfo::Job));
            newAttackerUnitset.insert(*itr);
            itr = units.erase(itr);
          }
          else {
            itr++;
          }
        }
      }
      data->attackerUnitSets.push_back(newAttackerUnitset);
      self->setClientInfo(self->getClientInfo<int>(static_cast<int>(ClientInfo::Flags)) | 0x1, static_cast<int>(ClientInfo::Flags));
    }
    else if (12 <= data->counts.complete[BWAPI::UnitTypes::Protoss_Zealot]
      && 6 <= data->counts.complete[BWAPI::UnitTypes::Protoss_Dragoon]
      && 2 <= data->counts.complete[BWAPI::UnitTypes::Protoss_Dark_Templar]
      && 1 <= data->counts.complete[BWAPI::UnitTypes::Protoss_Observer]
      && (self->getClientInfo<int>(static_cast<int>(ClientInfo::Flags)) & 0x1)
      && !(self->getClientInfo<int>(static_cast<int>(ClientInfo::Flags)) & 0x2)) {
      BWAPI::Unitset newAttackerUnitset;
      int zealotCount = 0;
      int dragoonCount = 0;
      int darktemplarCount = 0;
      for (auto& [id, units] : data->defenderUnitSets) {
        auto itr = units.begin();
        while (itr != units.end()) {
          if ((*itr)->getType() == BWAPI::UnitTypes::Protoss_Zealot
            && zealotCount < 12) {
            zealotCount++;
            (*itr)->setClientInfo(static_cast<int>(JobType::Attack), static_cast<int>(ClientInfo::Job));
            newAttackerUnitset.insert(*itr);
            itr = units.erase(itr);
          }
          else if ((*itr)->getType() == BWAPI::UnitTypes::Protoss_Dragoon
            && dragoonCount < 6) {
            dragoonCount++;
            (*itr)->setClientInfo(static_cast<int>(JobType::Attack), static_cast<int>(ClientInfo::Job));
            newAttackerUnitset.insert(*itr);
            itr = units.erase(itr);
          }
          else if ((*itr)->getType() == BWAPI::UnitTypes::Protoss_Dark_Templar
            && darktemplarCount < 6) {
            darktemplarCount++;
            (*itr)->setClientInfo(static_cast<int>(JobType::Attack), static_cast<int>(ClientInfo::Job));
            newAttackerUnitset.insert(*itr);
            itr = units.erase(itr);
          }
          else {
            itr++;
          }
        }
      }
      data->attackerUnitSets.push_back(newAttackerUnitset);
      self->setClientInfo(self->getClientInfo<int>(static_cast<int>(ClientInfo::Flags)) | 0x2, static_cast<int>(ClientInfo::Flags));
    }
    else if (12 <= data->counts.complete[BWAPI::UnitTypes::Protoss_Zealot]
      && 8 <= data->counts.complete[BWAPI::UnitTypes::Protoss_Scout]
      && 4 <= data->counts.complete[BWAPI::UnitTypes::Protoss_Corsair]
      && 1 <= data->counts.complete[BWAPI::UnitTypes::Protoss_Observer]
      && (self->getClientInfo<int>(static_cast<int>(ClientInfo::Flags)) & 0x1)
      && (self->getClientInfo<int>(static_cast<int>(ClientInfo::Flags)) & 0x2)
      && !(self->getClientInfo<int>(static_cast<int>(ClientInfo::Flags)) & 0x4)) {
      BWAPI::Unitset newAttackerUnitset;
      int zealotCount = 0;
      int scoutCount = 0;
      int corsairCount = 0;
      for (auto& [id, units] : data->defenderUnitSets) {
        auto itr = units.begin();
        while (itr != units.end()) {
          if ((*itr)->getType() == BWAPI::UnitTypes::Protoss_Zealot
            && zealotCount < 12) {
            zealotCount++;
            (*itr)->setClientInfo(static_cast<int>(JobType::Attack), static_cast<int>(ClientInfo::Job));
            newAttackerUnitset.insert(*itr);
            itr = units.erase(itr);
          }
          else if ((*itr)->getType() == BWAPI::UnitTypes::Protoss_Scout
            && scoutCount < 8) {
            scoutCount++;
            (*itr)->setClientInfo(static_cast<int>(JobType::Attack), static_cast<int>(ClientInfo::Job));
            newAttackerUnitset.insert(*itr);
            itr = units.erase(itr);
          }
          else if ((*itr)->getType() == BWAPI::UnitTypes::Protoss_Corsair
            && corsairCount < 6) {
            corsairCount++;
            (*itr)->setClientInfo(static_cast<int>(JobType::Attack), static_cast<int>(ClientInfo::Job));
            newAttackerUnitset.insert(*itr);
            itr = units.erase(itr);
          }
          else {
            itr++;
          }
        }
      }
      data->attackerUnitSets.push_back(newAttackerUnitset);
      self->setClientInfo(self->getClientInfo<int>(static_cast<int>(ClientInfo::Flags)) | 0x4, static_cast<int>(ClientInfo::Flags));
    }
    else if (10 <= data->counts.complete[BWAPI::UnitTypes::Protoss_Scout]
      && 8 <= data->counts.complete[BWAPI::UnitTypes::Protoss_Corsair]
      && 4 <= data->counts.complete[BWAPI::UnitTypes::Protoss_Carrier]
      && 1 <= data->counts.complete[BWAPI::UnitTypes::Protoss_Observer]
      && (self->getClientInfo<int>(static_cast<int>(ClientInfo::Flags)) & 0x1)
      && (self->getClientInfo<int>(static_cast<int>(ClientInfo::Flags)) & 0x2)
      && (self->getClientInfo<int>(static_cast<int>(ClientInfo::Flags)) & 0x4)
      && !(self->getClientInfo<int>(static_cast<int>(ClientInfo::Flags)) & 0x8)
      && data->attackerUnitSets.size() == 0) {
      BWAPI::Unitset newAttackerUnitset;
      int scoutCount = 0;
      int corsairCount = 0;
      int carrierCount = 0;
      for (auto& [id, units] : data->defenderUnitSets) {
        auto itr = units.begin();
        while (itr != units.end()) {
          if ((*itr)->getType() == BWAPI::UnitTypes::Protoss_Scout
            && scoutCount < 10) {
            scoutCount++;
            (*itr)->setClientInfo(static_cast<int>(JobType::Attack), static_cast<int>(ClientInfo::Job));
            newAttackerUnitset.insert(*itr);
            itr = units.erase(itr);
          }
          else if ((*itr)->getType() == BWAPI::UnitTypes::Protoss_Corsair
            && corsairCount < 8) {
            corsairCount++;
            (*itr)->setClientInfo(static_cast<int>(JobType::Attack), static_cast<int>(ClientInfo::Job));
            newAttackerUnitset.insert(*itr);
            itr = units.erase(itr);
          }
          else if ((*itr)->getType() == BWAPI::UnitTypes::Protoss_Carrier
            && carrierCount < 4) {
            carrierCount++;
            (*itr)->setClientInfo(static_cast<int>(JobType::Attack), static_cast<int>(ClientInfo::Job));
            newAttackerUnitset.insert(*itr);
            itr = units.erase(itr);
          }
          else {
            itr++;
          }
        }
      }
      data->attackerUnitSets.push_back(newAttackerUnitset);
      //self->setClientInfo(self->getClientInfo<int>(static_cast<int>(ClientInfo::Flags)) | 0x8, static_cast<int>(ClientInfo::Flags));
    }
    auto zergOrProtossEnemy = []() {
      for (auto enemy : BWAPI::Broodwar->enemies()) {
        if (enemy->getRace() != BWAPI::Races::Terran) {
          return true;
        }
      }
      return false;
    };
    if ((zergOrProtossEnemy() ? (10 <= data->counts.complete[BWAPI::UnitTypes::Terran_Marine]
      && 4 <= data->counts.complete[BWAPI::UnitTypes::Terran_Firebat]
      && 3 <= data->counts.complete[BWAPI::UnitTypes::Terran_Medic]) :
      (12 <= data->counts.complete[BWAPI::UnitTypes::Terran_Marine]
      && 3 <= data->counts.complete[BWAPI::UnitTypes::Terran_Medic]))
      && !(self->getClientInfo<int>(static_cast<int>(ClientInfo::Flags)) & 0x1)) {
      BWAPI::Unitset newAttackerUnitset;
      int marineCount = 0;
      int firebatCount = 0;
      int medicCount = 0;
      for (auto& [id, units] : data->defenderUnitSets) {
        auto itr = units.begin();
        while (itr != units.end()) {
          if (((*itr)->getType() == BWAPI::UnitTypes::Terran_Marine)
            && (zergOrProtossEnemy() ? marineCount < 10 : marineCount < 12)) {
            marineCount++;
            (*itr)->setClientInfo(static_cast<int>(JobType::Attack), static_cast<int>(ClientInfo::Job));
            newAttackerUnitset.insert(*itr);
            itr = units.erase(itr);
          }
          else if ((*itr)->getType() == BWAPI::UnitTypes::Terran_Firebat
            && zergOrProtossEnemy()
            && firebatCount < 4) {
            firebatCount++;
            (*itr)->setClientInfo(static_cast<int>(JobType::Attack), static_cast<int>(ClientInfo::Job));
            newAttackerUnitset.insert(*itr);
            itr = units.erase(itr);
          }
          else if ((*itr)->getType() == BWAPI::UnitTypes::Terran_Medic
            && medicCount < 3) {
            medicCount++;
            (*itr)->setClientInfo(static_cast<int>(JobType::Attack), static_cast<int>(ClientInfo::Job));
            newAttackerUnitset.insert(*itr);
            itr = units.erase(itr);
          }
          else {
            itr++;
          }
        }
      }
      data->attackerUnitSets.push_back(newAttackerUnitset);
      self->setClientInfo(self->getClientInfo<int>(static_cast<int>(ClientInfo::Flags)) | 0x1, static_cast<int>(ClientInfo::Flags));
    }
    else if (5 <= data->counts.complete[BWAPI::UnitTypes::Terran_Siege_Tank_Tank_Mode] + data->counts.complete[BWAPI::UnitTypes::Terran_Siege_Tank_Siege_Mode]
      && 12 <= data->counts.complete[BWAPI::UnitTypes::Terran_Marine]
      && 3 <= data->counts.complete[BWAPI::UnitTypes::Terran_Marine]
      && self->getClientInfo<int>(static_cast<int>(ClientInfo::Flags)) & 0x1
      && !(self->getClientInfo<int>(static_cast<int>(ClientInfo::Flags)) & 0x2)) {
      BWAPI::Unitset newAttackerUnitset;
      int tankCount = 0;
      int marineCount = 0;
      int medicCount = 0;
      for (auto& [id, units] : data->defenderUnitSets) {
        auto itr = units.begin();
        while (itr != units.end()) {
          if (((*itr)->getType() == BWAPI::UnitTypes::Terran_Siege_Tank_Tank_Mode
            || (*itr)->getType() == BWAPI::UnitTypes::Terran_Siege_Tank_Siege_Mode)
            && tankCount < 5) {
            tankCount++;
            (*itr)->setClientInfo(static_cast<int>(JobType::Attack), static_cast<int>(ClientInfo::Job));
            newAttackerUnitset.insert(*itr);
            itr = units.erase(itr);
          }
          else if ((*itr)->getType() == BWAPI::UnitTypes::Terran_Marine
            && marineCount < 12) {
            marineCount++;
            (*itr)->setClientInfo(static_cast<int>(JobType::Attack), static_cast<int>(ClientInfo::Job));
            newAttackerUnitset.insert(*itr);
            itr = units.erase(itr);
          }
          else if ((*itr)->getType() == BWAPI::UnitTypes::Terran_Medic
            && medicCount < 3) {
            medicCount++;
            (*itr)->setClientInfo(static_cast<int>(JobType::Attack), static_cast<int>(ClientInfo::Job));
            newAttackerUnitset.insert(*itr);
            itr = units.erase(itr);
          }
          else {
            itr++;
          }
        }
      }
      data->attackerUnitSets.push_back(newAttackerUnitset);
      self->setClientInfo(self->getClientInfo<int>(static_cast<int>(ClientInfo::Flags)) | 0x2, static_cast<int>(ClientInfo::Flags));
    }
    else if (4 <= data->counts.complete[BWAPI::UnitTypes::Terran_Battlecruiser]
      && 6 <= data->counts.complete[BWAPI::UnitTypes::Terran_Wraith]
      && 2 <= data->counts.complete[BWAPI::UnitTypes::Terran_Valkyrie]
      && 3 <= data->counts.complete[BWAPI::UnitTypes::Terran_Siege_Tank_Tank_Mode] + data->counts.complete[BWAPI::UnitTypes::Terran_Siege_Tank_Siege_Mode]
      && 2 <= data->counts.complete[BWAPI::UnitTypes::Terran_Goliath]
      && 3 <= data->counts.complete[BWAPI::UnitTypes::Terran_Ghost]
      && 10 <= data->counts.complete[BWAPI::UnitTypes::Terran_Marine]
      && 2 <= data->counts.complete[BWAPI::UnitTypes::Terran_Medic]
      && self->getClientInfo<int>(static_cast<int>(ClientInfo::Flags)) & 0x2
      && !data->attackerUnitSets.size()) {
      BWAPI::Unitset newAttackerUnitset;
      int battlecruiserCount = 0;
      int wraithCount = 0;
      int valkyrieCount = 0;
      int tankCount = 0;
      int goliathCount = 0;
      int ghostCount = 0;
      int marineCount = 0;
      int medicCount = 0;
      for (auto& [id, units] : data->defenderUnitSets) {
        auto itr = units.begin();
        while (itr != units.end()) {
          if ((*itr)->getType() == BWAPI::UnitTypes::Terran_Battlecruiser
            && battlecruiserCount < 4) {
            battlecruiserCount++;
            (*itr)->setClientInfo(static_cast<int>(JobType::Attack), static_cast<int>(ClientInfo::Job));
            newAttackerUnitset.insert(*itr);
            itr = units.erase(itr);
          }
          else if ((*itr)->getType() == BWAPI::UnitTypes::Terran_Wraith
            && wraithCount < 6) {
            wraithCount++;
            (*itr)->setClientInfo(static_cast<int>(JobType::Attack), static_cast<int>(ClientInfo::Job));
            newAttackerUnitset.insert(*itr);
            itr = units.erase(itr);
          }
          else if ((*itr)->getType() == BWAPI::UnitTypes::Terran_Valkyrie
            && valkyrieCount < 2) {
            valkyrieCount++;
            (*itr)->setClientInfo(static_cast<int>(JobType::Attack), static_cast<int>(ClientInfo::Job));
            newAttackerUnitset.insert(*itr);
            itr = units.erase(itr);
          }
          else if (((*itr)->getType() == BWAPI::UnitTypes::Terran_Siege_Tank_Tank_Mode
            || (*itr)->getType() == BWAPI::UnitTypes::Terran_Siege_Tank_Siege_Mode)
            && tankCount < 3) {
            tankCount++;
            (*itr)->setClientInfo(static_cast<int>(JobType::Attack), static_cast<int>(ClientInfo::Job));
            newAttackerUnitset.insert(*itr);
            itr = units.erase(itr);
          }
          else if ((*itr)->getType() == BWAPI::UnitTypes::Terran_Goliath
            && goliathCount < 2) {
            goliathCount++;
            (*itr)->setClientInfo(static_cast<int>(JobType::Attack), static_cast<int>(ClientInfo::Job));
            newAttackerUnitset.insert(*itr);
            itr = units.erase(itr);
          }
          else if ((*itr)->getType() == BWAPI::UnitTypes::Terran_Ghost
            && ghostCount < 3) {
            ghostCount++;
            (*itr)->setClientInfo(static_cast<int>(JobType::Attack), static_cast<int>(ClientInfo::Job));
            newAttackerUnitset.insert(*itr);
            itr = units.erase(itr);
          }
          else if ((*itr)->getType() == BWAPI::UnitTypes::Terran_Marine
            && marineCount < 10) {
            marineCount++;
            (*itr)->setClientInfo(static_cast<int>(JobType::Attack), static_cast<int>(ClientInfo::Job));
            newAttackerUnitset.insert(*itr);
            itr = units.erase(itr);
          }
          else if ((*itr)->getType() == BWAPI::UnitTypes::Terran_Medic
            && medicCount < 2) {
            medicCount++;
            (*itr)->setClientInfo(static_cast<int>(JobType::Attack), static_cast<int>(ClientInfo::Job));
            newAttackerUnitset.insert(*itr);
            itr = units.erase(itr);
          }
          else {
            itr++;
          }
        }
        data->attackerUnitSets.push_back(newAttackerUnitset);
      }
    }
  }
  else {
    if (4 <= data->counts.complete[BWAPI::UnitTypes::Protoss_Zealot]
      && 1 <= data->counts.complete[BWAPI::UnitTypes::Protoss_Shuttle]
      && !(self->getClientInfo<int>(static_cast<int>(ClientInfo::Flags)) & 0x1)
      && !(self->getClientInfo<int>(static_cast<int>(ClientInfo::Flags)) & 0x2)) {
      BWAPI::Unitset newAttackerUnitset;
      int zealotCount = 0;
      for (auto& [id, units] : data->defenderUnitSets) {
        auto itr = units.begin();
        while (itr != units.end()) {
          if ((*itr)->getType() == BWAPI::UnitTypes::Protoss_Zealot
            && zealotCount < 4) {
            zealotCount++;
            (*itr)->setClientInfo(static_cast<int>(JobType::Attack), static_cast<int>(ClientInfo::Job));
            newAttackerUnitset.insert(*itr);
            itr = units.erase(itr);
          }
          else {
            itr++;
          }
        }
      }
      data->attackerUnitSets.push_back(newAttackerUnitset);
      self->setClientInfo(self->getClientInfo<int>(static_cast<int>(ClientInfo::Flags)) | 0x1, static_cast<int>(ClientInfo::Flags));
    }
    else if (12 <= data->counts.complete[BWAPI::UnitTypes::Protoss_Zealot]
      && 3 <= data->counts.complete[BWAPI::UnitTypes::Protoss_Shuttle]
      && (self->getClientInfo<int>(static_cast<int>(ClientInfo::Flags)) & 0x1)
      && !(self->getClientInfo<int>(static_cast<int>(ClientInfo::Flags)) & 0x2)) {
      BWAPI::Unitset newAttackerUnitset;
      int zealotCount = 0;
      for (auto& [id, units] : data->defenderUnitSets) {
        auto itr = units.begin();
        while (itr != units.end()) {
          if ((*itr)->getType() == BWAPI::UnitTypes::Protoss_Zealot
            && zealotCount < 12) {
            zealotCount++;
            (*itr)->setClientInfo(static_cast<int>(JobType::Attack), static_cast<int>(ClientInfo::Job));
            newAttackerUnitset.insert(*itr);
            itr = units.erase(itr);
          }
          else {
            itr++;
          }
        }
      }
      data->attackerUnitSets.push_back(newAttackerUnitset);
      self->setClientInfo(self->getClientInfo<int>(static_cast<int>(ClientInfo::Flags)) | 0x2, static_cast<int>(ClientInfo::Flags));
    }
    else if (11 <= data->counts.complete[BWAPI::UnitTypes::Protoss_Scout]
      && 5 <= data->counts.complete[BWAPI::UnitTypes::Protoss_Corsair]
      && 6 <= data->counts.complete[BWAPI::UnitTypes::Protoss_Carrier]
      && (self->getClientInfo<int>(static_cast<int>(ClientInfo::Flags)) & 0x1)
      && (self->getClientInfo<int>(static_cast<int>(ClientInfo::Flags)) & 0x2)) {
      BWAPI::Unitset newAttackerUnitset;
      int zealotCount = 0;
      for (auto& [id, units] : data->defenderUnitSets) {
        auto itr = units.begin();
        while (itr != units.end()) {
          if ((*itr)->getType() == BWAPI::UnitTypes::Protoss_Zealot
            && zealotCount < 12) {
            zealotCount++;
            (*itr)->setClientInfo(static_cast<int>(JobType::Attack), static_cast<int>(ClientInfo::Job));
            newAttackerUnitset.insert(*itr);
            itr = units.erase(itr);
          }
          else {
            itr++;
          }
        }
      }
      data->attackerUnitSets.push_back(newAttackerUnitset);
    }
  }
}

void bwapidatadisplay::updateJobs() {
  auto itr = data->jobList.begin();
  while (itr != data->jobList.end()) {
    if (itr->type == JobType::Defend) {
      if (!itr->requestingUnit || !itr->requestingUnit->exists()) {
        itr = data->jobList.erase(itr);
        continue;
      }

      auto closestResourceDepot = getClosestNotMacroResourceDepot(itr->requestingUnit);
      if (closestResourceDepot && closestResourceDepot->exists()) {
        bool assigned = false;
        for (auto& [id, unitSet] : data->defenderUnitSets) {
          if (id == closestResourceDepot->getClientInfo<int>(static_cast<int>(ClientInfo::ResourceGroup))
            && unitSet.size()) {
            for (auto unit : unitSet) {
              if (static_cast<JobType>(unit->getClientInfo<int>(static_cast<int>(ClientInfo::Job))) == JobType::None) {
                unit->setClientInfo(static_cast<int>(JobType::Defend), static_cast<int>(ClientInfo::Job));
                unit->setClientInfo(itr->requestingUnit, static_cast<int>(ClientInfo::JobUnit));
              }
            }
            assigned = true;
            break;
          }
        }
        if (!assigned) {
          int fromid = -1;
          for (auto& [id, unitSet] : data->defenderUnitSets) {
            if (unitSet.size()
              && static_cast<JobType>((*unitSet.begin())->getClientInfo<int>(static_cast<int>(ClientInfo::Job))) == JobType::None) {
              fromid = id;
              break;
            }
          }
          if (fromid != -1) {
            auto toid = closestResourceDepot->getClientInfo<int>(static_cast<int>(ClientInfo::ResourceGroup));
            for (auto unitItr = data->defenderUnitSets[fromid].begin(); unitItr != data->defenderUnitSets[fromid].end();) {
              data->defenderUnitSets[toid].insert(*unitItr);
              unitItr = data->defenderUnitSets[fromid].erase(unitItr);
            }
            data->defenderUnitSets[toid].setClientInfo(static_cast<int>(JobType::Defend), static_cast<int>(ClientInfo::Job));
            data->defenderUnitSets[toid].setClientInfo(itr->requestingUnit, static_cast<int>(ClientInfo::JobUnit));
            data->defenderUnitSets[toid].setClientInfo(0, static_cast<int>(ClientInfo::AssignedRegion));
            data->defenderUnitSets[toid].setClientInfo(closestResourceDepot, static_cast<int>(ClientInfo::AssignedDepot));
            continue;
          }
        }
      }
    }
    else if (itr->type == JobType::Scout) {
      bool assigned = false;
      for (auto unit : BWAPI::Broodwar->self()->getUnits()) {
        if (unit->getType().isWorker()
          && unit->isGatheringMinerals()
          && !unit->isCarryingMinerals()) {
          unit->setClientInfo(JobType::Scout, static_cast<int>(ClientInfo::Job));
          unit->setClientInfo(0, static_cast<int>(ClientInfo::JobX));
          unit->stop();
          assigned = true;
          break;
        }
      }
      if (assigned) {
        itr = data->jobList.erase(itr);
        continue;
      }
    }
    itr++;
  }

  for (auto unit : BWAPI::Broodwar->getAllUnits()) {
    if (!unit->getPlayer()->isEnemy(BWAPI::Broodwar->self())) {
      continue;
    }
    if ((!unit->isCloaked() && !unit->isBurrowed()) || unit->isDetected()) {
      continue;
    }
    if (!unit->getClientInfo<BWAPI::Unit>(static_cast<int>(ClientInfo::AssignedDetection))) {
      bool assignDetector = true;
      for (auto nearbyDetectable : unit->getUnitsInRadius(BWAPI::UnitTypes::Protoss_Observer.sightRange()
        , BWAPI::Filter::IsEnemy
        && (BWAPI::Filter::IsCloaked || BWAPI::Filter::IsBurrowed))) {
        auto assignedDetector = nearbyDetectable->getClientInfo<BWAPI::Unit>(static_cast<int>(ClientInfo::AssignedDetection));
        if (assignedDetector && assignedDetector->exists()) {
          assignDetector = false;
          break;
        }
      }
      if (assignDetector) {
        auto detector = unit->getClosestUnit([](BWAPI::Unit unit) {
          return (((unit->getType().isDetector() && unit->getType().canMove() && !unit->isStasised() && !unit->isLockedDown()) || unit->getType() == BWAPI::UnitTypes::Terran_Comsat_Station) && !unit->getClientInfo<BWAPI::Unit>(static_cast<int>(ClientInfo::AssignedDetection)));
          });
        if (detector) {
          detector->setClientInfo(unit, static_cast<int>(ClientInfo::AssignedDetection));
          unit->setClientInfo(detector, static_cast<int>(ClientInfo::AssignedDetection));
        }
        else {
          unit->setClientInfo(nullptr, static_cast<int>(ClientInfo::AssignedDetection));
        }
      }
    }
    else {
      auto detector = unit->getClientInfo<BWAPI::Unit>(static_cast<int>(ClientInfo::AssignedDetection));
      if (!detector->exists() || detector->isStasised() || detector->isLockedDown()) {
        unit->setClientInfo(nullptr, static_cast<int>(ClientInfo::AssignedDetection));
        if (detector->exists()) {
          detector->setClientInfo(nullptr, static_cast<int>(ClientInfo::AssignedDetection));
        }
      }
    }
  }
}

void bwapidatadisplay::updateTracking() {
  data->updateTracking();
  if (BWAPI::Broodwar->getFrameCount() == 0) {
    auto race = BWAPI::Broodwar->self()->getRace();
    if (data->map == Maps::TutorialBootCamp) {
      BWAPI::Broodwar->self()->setClientInfo(&TutorialBootCamp, static_cast<int>(ClientInfo::BuildOrder));
      //auto func = BWAPI::Broodwar->self()->getClientInfo<void(*)(std::shared_ptr<Data>)>(static_cast<int>(ClientInfo::BuildOrder));
      //func(data);
    }
    else if (data->map == Maps::Wasteland) {
      BWAPI::Broodwar->self()->setClientInfo(&Wasteland, static_cast<int>(ClientInfo::BuildOrder));
    }
    else if (data->map == Maps::BackwaterStation) {
      BWAPI::Broodwar->self()->setClientInfo(&BackwaterStation, static_cast<int>(ClientInfo::BuildOrder));
    }
    else if (data->map == Maps::DesperateAlliance) {
      BWAPI::Broodwar->self()->setClientInfo(&DesperateAlliance, static_cast<int>(ClientInfo::BuildOrder));
    }
    else if (data->map == Maps::Revolution) {
      BWAPI::Broodwar->self()->setClientInfo(&Revolution, static_cast<int>(ClientInfo::BuildOrder));
    }
    else if (data->map == Maps::NoradII) {
      BWAPI::Broodwar->self()->setClientInfo(&NoradII, static_cast<int>(ClientInfo::BuildOrder));
    }
    else if (race == BWAPI::Races::Protoss) {
      if (!data->islandMap) {
        BWAPI::Broodwar->self()->setClientInfo(&ProtossMeleeExp, static_cast<int>(ClientInfo::BuildOrder));
      }
      else {
        BWAPI::Broodwar->self()->setClientInfo(&ProtossMeleeIslandExp, static_cast<int>(ClientInfo::BuildOrder));
      }
    }
    else if (race == BWAPI::Races::Terran) {
      if (!data->islandMap) {
        BWAPI::Broodwar->self()->setClientInfo(&TerranMeleeExp, static_cast<int>(ClientInfo::BuildOrder));
      }
      else {
        BWAPI::Broodwar->self()->setClientInfo(&TerranMeleeIslandExp, static_cast<int>(ClientInfo::BuildOrder));
      }
    }
    else if (race == BWAPI::Races::Zerg) {
      if (!data->islandMap) {
        BWAPI::Broodwar->self()->setClientInfo(&ZergMeleeExp, static_cast<int>(ClientInfo::BuildOrder));
      }
      else {
        BWAPI::Broodwar->self()->setClientInfo(&ZergMeleeIslandExp, static_cast<int>(ClientInfo::BuildOrder));
      }
    }
  }
}


void bwapidatadisplay::updateUnitSets() {
  /*for (auto& group : data->mineralWorkers) {
    group.second = 0;
  }*/
  for (auto& group : data->maxMineralWorkers) {
    group.second = 0;
    data->mineralWorkers[group.first] = 0;
  }

  auto itr = data->resourceDepots.begin();
  while (itr != data->resourceDepots.end()) {
    if (!*itr || !(*itr)->exists()) {
      itr = data->resourceDepots.erase(itr);
    }
    else {
      itr++;
    }
  }

  itr = data->productionBuildings.begin();
  while (itr != data->productionBuildings.end()) {
    if (!*itr || !(*itr)->exists()) {
      itr = data->productionBuildings.erase(itr);
    }
    else {
      itr++;
    }
  }

  itr = data->refineries.begin();
  while (itr != data->refineries.end()) {
    if (!*itr || !(*itr)->exists()) {
      itr = data->refineries.erase(itr);
    }
    else {
      itr++;
    }
  }

  for (auto& [id, unitSet] : data->defenderUnitSets) {
    itr = unitSet.begin();
    while (itr != unitSet.end()) {
      if (!*itr || !(*itr)->exists()) {
        itr = unitSet.erase(itr);
      }
      else {
        itr++;
      }
    }
  }

  auto attackerItr = data->attackerUnitSets.begin();
  bool detector = false;
  while (attackerItr != data->attackerUnitSets.end()) {
    itr = attackerItr->begin();
    while (itr != attackerItr->end()) {
      if (!*itr || !(*itr)->exists()) {
        itr = attackerItr->erase(itr);
      }
      else {
        if ((*itr)->getType().isDetector()) {
          detector = true;
        }
          itr++;
      }
    }
    if (attackerItr->size()) {
      (*attackerItr->begin())->setClientInfo(true, static_cast<int>(ClientInfo::SquadLeader));
      if (!detector) {
        auto detectionUnit = (*attackerItr->begin())->getClosestUnit([](BWAPI::Unit unit) {
          return !unit->getClientInfo<BWAPI::Unit>(static_cast<int>(ClientInfo::AssignedDetection))
            && unit->getType().isDetector()
            && unit->getType().canMove()
            && !unit->isStasised()
            && !unit->isLockedDown();
          });
        if (detectionUnit) {
          attackerItr->insert(detectionUnit);
        }
      }
      attackerItr++;
    }
    else {
      attackerItr = data->attackerUnitSets.erase(attackerItr);
    }
  }

  auto unitItr = data->enemyBuildings.begin();
  while (unitItr != data->enemyBuildings.end()) {
    if (!(*unitItr).second || (BWAPI::Broodwar->isVisible(BWAPI::TilePosition{ (*unitItr).second->getClientInfo<int>(static_cast<int>(ClientInfo::BuildLocationX)), (*unitItr).second->getClientInfo<int>(static_cast<int>(ClientInfo::BuildLocationY)) }) && !(*unitItr).second->exists())) {
      unitItr = data->enemyBuildings.erase(unitItr);
    }
    else {
      unitItr++;
    }
  }

/*  itr = upgradeBuildings.begin();
  while (itr != data->productionBuildings.end()) {
    if (!*itr || !(*itr)->exists()) {
      itr = upgradeBuildings.erase(itr);
    }
    else {
      itr++;
    }
  }

  itr = techBuildings.begin();
  while (itr != data->productionBuildings.end()) {
    if (!*itr || !(*itr)->exists()) {
      itr = techBuildings.erase(itr);
    }
    else {
      itr++;
    }
  }*/
}