/*
 * Decompiled with CFR 0.152.
 */
package util;

import bwapi.Position;
import bwapi.Unit;
import bwapi.UnitType;
import java.util.List;

public final class Filter {
    public static Unit closestUnit(Unit unit, List<Unit> unitList) {
        if (unitList.size() == 1) {
            return unitList.get(0);
        }
        Unit closestUnit = null;
        int closestDistance = Integer.MAX_VALUE;
        for (Unit u : unitList) {
            int distance = unit.getDistance(u);
            if (distance >= closestDistance) continue;
            closestUnit = u;
            closestDistance = distance;
        }
        return closestUnit;
    }

    public static Unit closestHostileUnit(Unit unit, List<Unit> unitList) {
        if (unitList.size() == 1) {
            return unitList.get(0);
        }
        boolean hasSeenEnemyOrHostileBuilding = false;
        Unit closestUnit = null;
        int closestDistance = Integer.MAX_VALUE;
        for (Unit u : unitList) {
            int distance;
            UnitType type = u.getType();
            boolean isHostileBuilding = Filter.isHostileBuilding(type);
            if (!(hasSeenEnemyOrHostileBuilding || type.isBuilding() && !isHostileBuilding)) {
                hasSeenEnemyOrHostileBuilding = true;
            }
            if (hasSeenEnemyOrHostileBuilding && type.isBuilding() && !isHostileBuilding || (distance = unit.getDistance(u.getPosition())) >= closestDistance) continue;
            closestUnit = u;
            closestDistance = distance;
        }
        if (closestUnit == null) {
            return null;
        }
        return closestUnit;
    }

    public static Unit closestHostileUnit(Position p, List<Unit> unitList) {
        if (unitList.size() == 1) {
            return unitList.get(0);
        }
        boolean hasSeenEnemyOrHostileBuilding = false;
        Unit closestUnit = null;
        double closestDistance = Double.MAX_VALUE;
        for (Unit u : unitList) {
            double distance;
            UnitType type = u.getType();
            boolean isHostileBuilding = Filter.isHostileBuilding(type);
            if (!(hasSeenEnemyOrHostileBuilding || type.isBuilding() && !isHostileBuilding)) {
                hasSeenEnemyOrHostileBuilding = true;
            }
            if (hasSeenEnemyOrHostileBuilding && type.isBuilding() && !isHostileBuilding || !((distance = p.getDistance(u.getPosition())) < closestDistance)) continue;
            closestUnit = u;
            closestDistance = distance;
        }
        if (closestUnit == null) {
            return null;
        }
        return closestUnit;
    }

    public static boolean isHostileBuilding(UnitType unitType) {
        if (!unitType.isBuilding()) {
            return false;
        }
        return unitType == UnitType.Terran_Bunker || unitType == UnitType.Terran_Missile_Turret || unitType == UnitType.Zerg_Sunken_Colony || unitType == UnitType.Zerg_Spore_Colony || unitType == UnitType.Protoss_Photon_Cannon;
    }

    public static boolean isHostileBuildingToGround(UnitType unitType) {
        if (!unitType.isBuilding()) {
            return false;
        }
        return unitType == UnitType.Terran_Bunker || unitType == UnitType.Zerg_Sunken_Colony || unitType == UnitType.Protoss_Photon_Cannon;
    }

    public static boolean isLowPriorityCombatTarget(UnitType unitType) {
        return unitType == UnitType.Zerg_Larva || unitType == UnitType.Zerg_Lurker_Egg || unitType == UnitType.Zerg_Cocoon || unitType == UnitType.Zerg_Egg;
    }
}

