/*
 * Decompiled with CFR 0.152.
 */
package unit.squad;

import bwapi.Color;
import bwapi.Game;
import bwapi.Position;
import bwapi.Race;
import bwapi.Text;
import bwapi.TilePosition;
import bwapi.Unit;
import bwapi.UnitType;
import bwapi.WalkPosition;
import bwem.Base;
import info.GameState;
import info.InformationManager;
import info.ScoutData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.bk.ass.sim.BWMirrorAgentFactory;
import org.bk.ass.sim.Simulator;
import unit.managed.ManagedUnit;
import unit.managed.UnitRole;
import unit.squad.AssCombatSimulator;
import unit.squad.CombatSimulator;
import unit.squad.MutaliskSquad;
import unit.squad.ScourgeSquad;
import unit.squad.Squad;
import unit.squad.SquadStatus;
import unit.squad.ZerglingSquad;
import util.Filter;
import util.UnitDistanceComparator;

public class SquadManager {
    private Game game;
    private GameState gameState;
    private BWMirrorAgentFactory agentFactory;
    private InformationManager informationManager;
    private Squad overlords = new Squad();
    private HashSet<Squad> fightSquads = new HashSet();
    private HashMap<Base, Squad> defenseSquads = new HashMap();
    private final CombatSimulator defaultCombatSimulator;
    private HashSet<ManagedUnit> disbanded = new HashSet();

    public SquadManager(Game game, GameState gameState, InformationManager informationManager) {
        this.game = game;
        this.gameState = gameState;
        this.informationManager = informationManager;
        this.agentFactory = new BWMirrorAgentFactory();
        this.defaultCombatSimulator = new AssCombatSimulator();
    }

    public void updateFightSquads() {
        this.debugPainters();
        this.removeEmptySquads();
        this.mergeSquads();
        this.assignOverlordsToSquads();
        HashSet<Squad> removed = new HashSet<Squad>();
        for (Squad fightSquad : this.fightSquads) {
            fightSquad.onFrame();
            if (fightSquad.shouldDisband()) {
                this.disbanded.addAll(this.disbandSquad(fightSquad));
                removed.add(fightSquad);
            }
            if (fightSquad instanceof MutaliskSquad) {
                MutaliskSquad mutaliskSquad = (MutaliskSquad)fightSquad;
                mutaliskSquad.executeTactics(this.gameState);
                continue;
            }
            if (fightSquad instanceof ScourgeSquad) {
                ScourgeSquad scourgeSquad = (ScourgeSquad)fightSquad;
                scourgeSquad.executeTactics(this.gameState);
                continue;
            }
            this.evaluateSquadRole(fightSquad);
        }
        this.fightSquads.removeAll(removed);
    }

    public void updateOverlordSquad() {
        TilePosition mainBaseLocation = this.gameState.getBaseData().mainBasePosition();
        if (this.overlords.getRallyPoint() == null) {
            this.overlords.setRallyPoint(mainBaseLocation.toPosition());
        }
        for (ManagedUnit managedUnit : this.overlords.getMembers()) {
            if (managedUnit.getUnit().getDistance(mainBaseLocation.toPosition()) < 16) {
                managedUnit.setRole(UnitRole.IDLE);
                continue;
            }
            managedUnit.setRole(UnitRole.RETREAT);
            managedUnit.setRetreatTarget(mainBaseLocation.toPosition());
        }
    }

    public void updateDefenseSquads() {
        this.ensureDefenderSquadsHaveTargets();
    }

    public List<ManagedUnit> assignGathererDefenders(Base base, HashSet<ManagedUnit> baseUnits, List<Unit> hostileUnits) {
        this.ensureDefenseSquad(base);
        Squad defenseSquad = this.defenseSquads.get(base);
        ArrayList<ManagedUnit> reassignedGatherers = new ArrayList<ManagedUnit>();
        if (baseUnits.size() < 3 || baseUnits.size() - reassignedGatherers.size() < 3) {
            return reassignedGatherers;
        }
        for (ManagedUnit gatherer : baseUnits) {
            Boolean canClear = this.canDefenseSquadClearThreat(defenseSquad, hostileUnits);
            if (canClear.booleanValue()) break;
            defenseSquad.addUnit(gatherer);
            reassignedGatherers.add(gatherer);
        }
        for (ManagedUnit managedUnit : reassignedGatherers) {
            managedUnit.setRole(UnitRole.DEFEND);
            this.assignDefenderTarget(managedUnit, hostileUnits);
        }
        return reassignedGatherers;
    }

    public List<ManagedUnit> disbandDefendSquad(Base base) {
        this.ensureDefenseSquad(base);
        Squad defenseSquad = this.defenseSquads.get(base);
        ArrayList<ManagedUnit> reassignedDefenders = new ArrayList<ManagedUnit>();
        for (ManagedUnit defender : defenseSquad.getMembers()) {
            reassignedDefenders.add(defender);
        }
        for (ManagedUnit defender : reassignedDefenders) {
            defenseSquad.removeUnit(defender);
        }
        return reassignedDefenders;
    }

    private List<ManagedUnit> disbandSquad(Squad squad) {
        ArrayList<ManagedUnit> members = new ArrayList<ManagedUnit>(squad.getMembers());
        ArrayList<ManagedUnit> nonOverlordMembers = new ArrayList<ManagedUnit>();
        for (ManagedUnit member : members) {
            squad.removeUnit(member);
            if (member.getUnitType() == UnitType.Zerg_Overlord) {
                this.overlords.addUnit(member);
                member.setRole(UnitRole.IDLE);
                continue;
            }
            nonOverlordMembers.add(member);
        }
        return nonOverlordMembers;
    }

    private void ensureDefenseSquad(Base base) {
        if (!this.defenseSquads.containsKey(base)) {
            Squad squad = new Squad();
            squad.setCenter(base.getCenter());
            squad.setRallyPoint(base.getLocation().toPosition());
            this.defenseSquads.put(base, squad);
        }
    }

    private void assignDefenderTarget(ManagedUnit defender, List<Unit> threats) {
        if (defender.getDefendTarget() != null) {
            return;
        }
        threats.sort(new UnitDistanceComparator(defender.getUnit()));
        defender.setDefendTarget(threats.get(0));
    }

    private void ensureDefenderSquadsHaveTargets() {
        for (Base base : this.defenseSquads.keySet()) {
            HashSet<Unit> baseThreats;
            this.ensureDefenseSquad(base);
            Squad squad = this.defenseSquads.get(base);
            if (this.defenseSquads.size() == 0 || (baseThreats = this.gameState.getBaseToThreatLookup().get(base)) == null || baseThreats.size() == 0) continue;
            for (ManagedUnit defender : squad.getMembers()) {
                this.ensureDefenderHasTarget(defender, baseThreats);
            }
        }
    }

    private void ensureDefenderHasTarget(ManagedUnit defender, HashSet<Unit> baseThreats) {
        if (!defender.isReady()) {
            return;
        }
        if (defender.getDefendTarget() != null) {
            return;
        }
        this.assignDefenderTarget(defender, baseThreats.stream().collect(Collectors.toList()));
    }

    private void removeEmptySquads() {
        ArrayList<Squad> emptySquads = new ArrayList<Squad>();
        for (Squad squad : this.fightSquads) {
            if (squad.size() != 0) continue;
            emptySquads.add(squad);
        }
        for (Squad squad : emptySquads) {
            this.fightSquads.remove(squad);
        }
    }

    private void mergeSquads() {
        if (this.game.getFrameCount() % 50 != 0) {
            return;
        }
        ArrayList toMerge = new ArrayList();
        HashSet<Squad> considered = new HashSet<Squad>();
        for (Squad squad : this.fightSquads) {
            for (Squad squad2 : this.fightSquads) {
                if (squad == squad2 || considered.contains(squad) || considered.contains(squad2) || squad.getType() != squad2.getType() || squad.distance(squad2) >= 256) continue;
                HashSet<Squad> mergeSet = new HashSet<Squad>();
                mergeSet.add(squad);
                mergeSet.add(squad2);
                considered.add(squad);
                considered.add(squad2);
                toMerge.add(mergeSet);
            }
        }
        for (Set set : toMerge) {
            UnitType type = ((Squad)set.iterator().next()).getType();
            Squad newSquad = this.newFightSquad(type);
            for (Squad mergingSquad : set) {
                if (newSquad.getType() == null) {
                    newSquad.setType(mergingSquad.getType());
                }
                newSquad.merge(mergingSquad);
                this.fightSquads.remove(mergingSquad);
            }
            this.fightSquads.add(newSquad);
        }
    }

    private List<Unit> enemyUnitsNearSquad(Squad squad) {
        Set<Unit> enemyUnits = this.gameState.getVisibleEnemyUnits();
        ArrayList<Unit> enemies = new ArrayList<Unit>();
        for (Unit u : enemyUnits) {
            double d = u.getPosition().getDistance(squad.getCenter());
            if (d > 256.0) continue;
            enemies.add(u);
        }
        return enemies;
    }

    private void rallySquad(Squad squad) {
        Position rallyPoint = squad.getType() == UnitType.Zerg_Mutalisk ? this.getMutaliskRallyPoint(squad) : (squad.getType() == UnitType.Zerg_Lurker ? this.getLurkerRallyPoint(squad) : this.getRallyPoint(squad));
        for (ManagedUnit managedUnit : squad.getMembers()) {
            managedUnit.setRallyPoint(rallyPoint);
            managedUnit.setRole(UnitRole.RALLY);
        }
    }

    private Position getMutaliskRallyPoint(Squad squad) {
        Set<Position> enemyWorkerLocations = this.gameState.getLastKnownLocationOfEnemyWorkers();
        if (enemyWorkerLocations.isEmpty()) {
            return this.getRallyPoint(squad);
        }
        Position squadCenter = squad.getCenter();
        Position closestWorkerLocation = null;
        double closestDistance = Double.MAX_VALUE;
        for (Position workerLocation : enemyWorkerLocations) {
            double distance = squadCenter.getDistance(workerLocation);
            if (!(distance < closestDistance)) continue;
            closestDistance = distance;
            closestWorkerLocation = workerLocation;
        }
        return closestWorkerLocation;
    }

    private Position getLurkerRallyPoint(Squad squad) {
        Unit closestBuilding;
        Set<Unit> enemyBuildings = this.gameState.getEnemyBuildings();
        if (!enemyBuildings.isEmpty() && (closestBuilding = Filter.closestHostileUnit(squad.getCenter(), new ArrayList<Unit>(enemyBuildings))) != null) {
            Position buildingPos = closestBuilding.getPosition();
            return buildingPos;
        }
        return this.informationManager.getRallyPoint();
    }

    private Position getRallyPoint(Squad squad) {
        List eligibleSquads = this.fightSquads.stream().filter(s -> s != squad).filter(s -> s.getStatus() == SquadStatus.FIGHT).collect(Collectors.toList());
        Base enemyMainBase = this.gameState.getBaseData().getMainEnemyBase();
        if (!eligibleSquads.isEmpty() && enemyMainBase != null) {
            Squad best = null;
            for (Squad s2 : eligibleSquads) {
                if (best == null) {
                    best = s2;
                    continue;
                }
                double bestDistance = best.getCenter().getDistance(enemyMainBase.getCenter());
                double candidateDistance = s2.getCenter().getDistance(enemyMainBase.getCenter());
                if (!(candidateDistance < bestDistance)) continue;
                best = s2;
            }
            return best.getCenter().toTilePosition().toPosition();
        }
        return this.informationManager.getRallyPoint();
    }

    private void evaluateSquadRole(Squad squad) {
        boolean closeThreats;
        SquadStatus squadStatus = squad.getStatus();
        boolean allowWhileRetreat = squad instanceof ZerglingSquad;
        if (squadStatus == SquadStatus.RETREAT && !allowWhileRetreat) {
            return;
        }
        boolean bl = closeThreats = !this.enemyUnitsNearSquad(squad).isEmpty();
        if (!closeThreats && squadStatus == SquadStatus.REGROUP) {
            return;
        }
        int moveOutThreshold = this.calculateMoveOutThreshold(squad);
        if (closeThreats || squad.size() > moveOutThreshold) {
            this.simulateFightSquad(squad);
        } else {
            this.rallySquad(squad);
        }
    }

    private int calculateMoveOutThreshold(Squad squad) {
        SquadStatus squadStatus = squad.getStatus();
        UnitType type = squad.getType();
        if (type == UnitType.Zerg_Mutalisk) {
            if (this.gameState.getOpponentRace() == Race.Zerg) {
                return 2;
            }
            return 4;
        }
        if (type == UnitType.Zerg_Hydralisk) {
            return 10;
        }
        if (type == UnitType.Zerg_Lurker) {
            return 1;
        }
        int staticDefensePenalty = Math.min(this.informationManager.getEnemyHostileToGroundBuildingsCount(), 5);
        int moveOutThreshold = 5 * (1 + staticDefensePenalty);
        if (squadStatus == SquadStatus.FIGHT) {
            moveOutThreshold /= 2;
        }
        return moveOutThreshold;
    }

    private void simulateFightSquad(Squad squad) {
        ScoutData scoutData;
        if (squad instanceof MutaliskSquad || squad instanceof ScourgeSquad) {
            return;
        }
        HashSet<ManagedUnit> managedFighters = squad.getMembers();
        if (squad.getType() == UnitType.Zerg_Lurker) {
            squad.setStatus(SquadStatus.FIGHT);
            for (ManagedUnit managedUnit : managedFighters) {
                managedUnit.setRole(UnitRole.FIGHT);
                this.assignEnemyTarget(managedUnit, squad);
            }
            return;
        }
        Set<Position> enemyBuildingPositions = this.gameState.getLastKnownPositionsOfBuildings();
        Set<Unit> enemyUnits = this.gameState.getDetectedEnemyUnits();
        if (enemyUnits.isEmpty() && enemyBuildingPositions.isEmpty() && !(scoutData = this.gameState.getScoutData()).isEnemyBuildingLocationKnown()) {
            squad.setShouldDisband(true);
            return;
        }
        if (enemyUnits.isEmpty() && !enemyBuildingPositions.isEmpty()) {
            double closestDistance = Double.MAX_VALUE;
            Position closestPosition = null;
            for (Position position : enemyBuildingPositions) {
                double distance = squad.getCenter().getDistance(position);
                if (!(distance < closestDistance)) continue;
                closestDistance = distance;
                closestPosition = position;
            }
            squad.setStatus(SquadStatus.FIGHT);
            for (ManagedUnit managedUnit : squad.getMembers()) {
                managedUnit.setRole(UnitRole.FIGHT);
                managedUnit.setMovementTargetPosition(closestPosition.toTilePosition());
            }
            return;
        }
        int now = this.game.getFrameCount();
        boolean zerglingRetreatLocked = false;
        boolean zerglingFightLocked = false;
        if (squad instanceof ZerglingSquad) {
            ZerglingSquad zs = (ZerglingSquad)squad;
            zerglingRetreatLocked = zs.isRetreatLocked(now);
            zerglingFightLocked = zs.isFightLocked(now);
            if (squad.getStatus() == SquadStatus.RETREAT && zerglingRetreatLocked) {
                HashMap<ManagedUnit, Position> retreatTargets = this.computeZerglingRetreatTargets(squad);
                for (ManagedUnit managedUnit : managedFighters) {
                    managedUnit.setRole(UnitRole.RETREAT);
                    Position rt = retreatTargets.get(managedUnit);
                    managedUnit.setRetreatTarget(rt);
                }
                return;
            }
            if (squad.getStatus() == SquadStatus.FIGHT && zerglingFightLocked) {
                for (ManagedUnit managedUnit : managedFighters) {
                    managedUnit.setRole(UnitRole.FIGHT);
                    this.assignEnemyTarget(managedUnit, squad);
                }
                return;
            }
        }
        CombatSimulator.CombatResult result = this.defaultCombatSimulator.evaluate(squad, this.gameState);
        switch (result) {
            case RETREAT: {
                squad.setStatus(SquadStatus.RETREAT);
                if (squad instanceof ZerglingSquad) {
                    HashMap<ManagedUnit, Position> retreatTargets = this.computeZerglingRetreatTargets(squad);
                    for (ManagedUnit managedUnit : managedFighters) {
                        managedUnit.setRole(UnitRole.RETREAT);
                        managedUnit.setRetreatTarget(retreatTargets.get(managedUnit));
                    }
                } else {
                    for (ManagedUnit managedUnit : managedFighters) {
                        managedUnit.setRole(UnitRole.RETREAT);
                        Position retreatTarget = managedUnit.getRetreatPosition();
                        managedUnit.setRetreatTarget(retreatTarget);
                    }
                }
                if (!(squad instanceof ZerglingSquad)) break;
                ((ZerglingSquad)squad).startRetreatLock(now);
                break;
            }
            case ENGAGE: {
                squad.setStatus(SquadStatus.FIGHT);
                for (ManagedUnit managedUnit : managedFighters) {
                    managedUnit.setRole(UnitRole.FIGHT);
                    this.assignEnemyTarget(managedUnit, squad);
                }
                if (!(squad instanceof ZerglingSquad) || zerglingRetreatLocked) break;
                ((ZerglingSquad)squad).startFightLock(now);
                break;
            }
            case REGROUP: {
                squad.setStatus(SquadStatus.REGROUP);
            }
        }
    }

    private HashMap<ManagedUnit, Position> computeZerglingRetreatTargets(Squad squad) {
        HashMap<ManagedUnit, Position> result = new HashMap<ManagedUnit, Position>();
        Position center = squad.getCenter();
        List<Unit> enemiesNear = this.enemyUnitsNearSquad(squad);
        if (enemiesNear.isEmpty()) {
            for (ManagedUnit mu : squad.getMembers()) {
                result.put(mu, center);
            }
            return result;
        }
        double ex = 0.0;
        double ey = 0.0;
        int cnt = 0;
        for (Unit e : enemiesNear) {
            Position p = e.getPosition();
            ex += (double)p.getX();
            ey += (double)p.getY();
            ++cnt;
        }
        double dx = (double)center.getX() - (ex /= (double)cnt);
        double dy = (double)center.getY() - (ey /= (double)cnt);
        double len = Math.max(1.0, Math.sqrt(dx * dx + dy * dy));
        double scale = 192.0 / len;
        double ax = (double)center.getX() + dx * scale;
        double ay = (double)center.getY() + dy * scale;
        int maxX = this.game.mapWidth() * 32 - 1;
        int maxY = this.game.mapHeight() * 32 - 1;
        ax = Math.max(0.0, Math.min(ax, (double)maxX));
        ay = Math.max(0.0, Math.min(ay, (double)maxY));
        double px = -dy / len;
        double py = dx / len;
        double ux = dx / len;
        double uy = dy / len;
        int i = 0;
        for (ManagedUnit mu : squad.getMembers()) {
            int side = i % 2 == 0 ? 1 : -1;
            double mag = 16 + i / 2 * 8;
            int rx = (int)Math.round(ax + (double)side * px * mag);
            int ry = (int)Math.round(ay + (double)side * py * mag);
            if (!this.game.isWalkable(new WalkPosition(rx = Math.max(0, Math.min(rx, maxX)), ry = Math.max(0, Math.min(ry, maxY))))) {
                int cy;
                int cx;
                int bestX = rx;
                int bestY = ry;
                boolean found = false;
                int t = 256;
                while (t >= 0) {
                    cx = (int)Math.round((double)rx + ux * (double)t);
                    cy = (int)Math.round((double)ry + uy * (double)t);
                    if (this.game.isWalkable(new WalkPosition(cx = Math.max(0, Math.min(cx, maxX)), cy = Math.max(0, Math.min(cy, maxY))))) {
                        bestX = cx;
                        bestY = cy;
                        found = true;
                        break;
                    }
                    t -= 16;
                }
                if (!found) {
                    t = 16;
                    while (t <= 128) {
                        cx = (int)Math.round((double)rx - ux * (double)t);
                        cy = (int)Math.round((double)ry - uy * (double)t);
                        if (this.game.isWalkable(new WalkPosition(cx = Math.max(0, Math.min(cx, maxX)), cy = Math.max(0, Math.min(cy, maxY))))) {
                            bestX = cx;
                            bestY = cy;
                            break;
                        }
                        t += 16;
                    }
                }
                rx = bestX;
                ry = bestY;
            }
            result.put(mu, new Position(rx, ry));
            ++i;
        }
        return result;
    }

    private boolean canDefenseSquadClearThreat(Squad squad, List<Unit> enemyUnits) {
        HashSet<ManagedUnit> managedDefenders = squad.getMembers();
        Simulator simulator = new Simulator.Builder().build();
        for (ManagedUnit managedUnit : managedDefenders) {
            if (managedUnit.getUnit().getType() == UnitType.Unknown) continue;
            simulator.addAgentA(this.agentFactory.of(managedUnit.getUnit()));
        }
        for (Unit enemyUnit : enemyUnits) {
            if (enemyUnit.getType() == UnitType.Unknown || (int)enemyUnit.getPosition().getDistance(squad.getCenter()) > 256) continue;
            try {
                simulator.addAgentB(this.agentFactory.of(enemyUnit));
            }
            catch (ArithmeticException e) {
                return false;
            }
        }
        simulator.simulate(150);
        if (simulator.getAgentsB().isEmpty()) {
            return true;
        }
        if (simulator.getAgentsA().isEmpty()) {
            return false;
        }
        float percentRemaining = (float)simulator.getAgentsA().size() / (float)managedDefenders.size();
        return (double)percentRemaining >= 0.5;
    }

    public void addManagedUnit(ManagedUnit managedUnit) {
        if (managedUnit.getUnitType() == UnitType.Zerg_Overlord) {
            this.addManagedOverlord(managedUnit);
            return;
        }
        this.addManagedFighter(managedUnit);
    }

    public void onUnitDestroy(Unit unit) {
        for (Squad squad : this.fightSquads) {
            if (squad.getTarget() != unit) continue;
            squad.setTarget(null);
        }
    }

    private void addManagedFighter(ManagedUnit managedUnit) {
        UnitType type = managedUnit.getUnitType();
        Squad squad = type == UnitType.Zerg_Mutalisk ? this.findClosestMutaliskSquad(managedUnit) : this.findCloseSquad(managedUnit, type);
        if (squad == null) {
            squad = this.newFightSquad(type);
        }
        squad.addUnit(managedUnit);
        this.simulateFightSquad(squad);
    }

    private Squad findCloseSquad(ManagedUnit managedUnit, UnitType type) {
        for (Squad squad : this.fightSquads) {
            if (squad.getType() != type || squad.distance(managedUnit) >= 256) continue;
            return squad;
        }
        return null;
    }

    private Squad findClosestMutaliskSquad(ManagedUnit managedUnit) {
        Squad closestSquad = null;
        double closestDistance = Double.MAX_VALUE;
        for (Squad squad : this.fightSquads) {
            double distance;
            if (squad.getType() != UnitType.Zerg_Mutalisk || squad.getStatus() != SquadStatus.RALLY && squad.getStatus() != SquadStatus.FIGHT || !((distance = (double)squad.distance(managedUnit)) < closestDistance)) continue;
            closestDistance = distance;
            closestSquad = squad;
        }
        return closestSquad;
    }

    private Squad newFightSquad(UnitType type) {
        Squad newSquad;
        if (type == UnitType.Zerg_Zergling) {
            newSquad = new ZerglingSquad();
            newSquad.setType(type);
        } else if (type == UnitType.Zerg_Mutalisk) {
            newSquad = new MutaliskSquad();
        } else if (type == UnitType.Zerg_Scourge) {
            newSquad = new ScourgeSquad();
        } else {
            newSquad = new Squad();
            newSquad.setType(type);
        }
        newSquad.setStatus(SquadStatus.FIGHT);
        newSquad.setRallyPoint(this.getRallyPoint(newSquad));
        this.fightSquads.add(newSquad);
        return newSquad;
    }

    private void addManagedOverlord(ManagedUnit overlord) {
        this.overlords.addUnit(overlord);
    }

    public void removeManagedUnit(ManagedUnit managedUnit) {
        UnitType unitType = managedUnit.getUnitType();
        if (unitType != null && unitType == UnitType.Zerg_Overlord) {
            this.removeManagedOverlord(managedUnit);
            return;
        }
        this.removeManagedFighter(managedUnit);
    }

    private void removeManagedFighter(ManagedUnit managedUnit) {
        for (Squad squad : this.fightSquads) {
            if (!squad.containsManagedUnit(managedUnit)) continue;
            squad.removeUnit(managedUnit);
            if (managedUnit.getUnitType() == UnitType.Zerg_Overlord) {
                this.overlords.addUnit(managedUnit);
            }
            return;
        }
        for (Base base : this.defenseSquads.keySet()) {
            Squad squad = this.defenseSquads.get(base);
            squad.removeUnit(managedUnit);
        }
    }

    private void removeManagedOverlord(ManagedUnit overlord) {
        this.overlords.removeUnit(overlord);
        overlord.setRole(UnitRole.IDLE);
    }

    private void assignEnemyTarget(ManagedUnit managedUnit, Squad squad) {
        Unit closestEnemy;
        Unit unit = managedUnit.getUnit();
        ArrayList<Unit> enemyUnits = new ArrayList<Unit>();
        enemyUnits.addAll(this.gameState.getVisibleEnemyUnits());
        ArrayList<Unit> filtered = new ArrayList<Unit>();
        for (Unit enemyUnit : enemyUnits) {
            if (unit.getType() == UnitType.Zerg_Lurker && !enemyUnit.isFlying() && enemyUnit.isDetected()) {
                filtered.add(enemyUnit);
                continue;
            }
            if (!unit.canAttack(enemyUnit) || !enemyUnit.isDetected() || Filter.isLowPriorityCombatTarget(enemyUnit.getType())) continue;
            filtered.add(enemyUnit);
        }
        if (filtered.isEmpty()) {
            managedUnit.setMovementTargetPosition(this.informationManager.pollScoutTarget(false));
            return;
        }
        Unit ft = closestEnemy = Filter.closestHostileUnit(unit, filtered);
        if (squad.getType() == UnitType.Zerg_Mutalisk) {
            if (squad.getTarget() == null) {
                squad.setTarget(closestEnemy);
            }
            ft = squad.getTarget();
        }
        managedUnit.setFightTarget(ft);
    }

    private void debugPainters() {
        for (Squad squad : this.fightSquads) {
            this.game.drawCircleMap(squad.getCenter(), squad.radius(), Color.White);
            this.game.drawTextMap(squad.getCenter(), String.format("Radius: %d", squad.radius()), Text.White);
        }
        for (Squad squad : this.defenseSquads.values()) {
            this.game.drawCircleMap(squad.getCenter(), 256, Color.White);
            this.game.drawTextMap(squad.getCenter(), String.format("Defenders: %s", squad.size()), Text.White);
        }
    }

    public Squad largestSquad() {
        if (this.fightSquads.isEmpty()) {
            return null;
        }
        List sorted = this.fightSquads.stream().sorted().collect(Collectors.toList());
        return (Squad)sorted.get(sorted.size() - 1);
    }

    public Set<ManagedUnit> getDisbandedUnits() {
        return this.disbanded;
    }

    private void assignOverlordsToSquads() {
        if (!this.gameState.getTechProgression().isOverlordSpeed()) {
            return;
        }
        this.returnLoneOverlords();
        ArrayList<ManagedUnit> availableOverlords = new ArrayList<ManagedUnit>(this.overlords.getMembers());
        if (availableOverlords.isEmpty()) {
            return;
        }
        List<Squad> targetSquads = this.getHydraliskAndMutaliskSquads();
        if (targetSquads.isEmpty()) {
            return;
        }
        for (Squad squad : targetSquads) {
            if (availableOverlords.isEmpty()) break;
            if (this.squadHasOverlord(squad)) continue;
            ManagedUnit overlord = (ManagedUnit)availableOverlords.remove(0);
            this.overlords.removeUnit(overlord);
            squad.addUnit(overlord);
            overlord.setRole(UnitRole.FIGHT);
        }
    }

    private void returnLoneOverlords() {
        ArrayList<Squad> squadsToRemove = new ArrayList<Squad>();
        for (Squad squad : this.fightSquads) {
            boolean allOverlords = true;
            for (ManagedUnit member : squad.getMembers()) {
                if (member.getUnitType() == UnitType.Zerg_Overlord) continue;
                allOverlords = false;
                break;
            }
            if (!allOverlords || squad.size() <= 0) continue;
            ArrayList<ManagedUnit> overlordsToRemove = new ArrayList<ManagedUnit>(squad.getMembers());
            for (ManagedUnit overlord : overlordsToRemove) {
                squad.removeUnit(overlord);
                this.overlords.addUnit(overlord);
                overlord.setRallyPoint(this.informationManager.getRallyPoint());
                overlord.setRole(UnitRole.RETREAT);
            }
            squadsToRemove.add(squad);
        }
        this.fightSquads.removeAll(squadsToRemove);
    }

    private List<Squad> getHydraliskAndMutaliskSquads() {
        return this.fightSquads.stream().filter(squad -> squad.getType() == UnitType.Zerg_Hydralisk || squad.getType() == UnitType.Zerg_Mutalisk).sorted((s1, s2) -> Integer.compare(s2.size(), s1.size())).collect(Collectors.toList());
    }

    private boolean squadHasOverlord(Squad squad) {
        for (ManagedUnit member : squad.getMembers()) {
            if (member.getUnitType() != UnitType.Zerg_Overlord) continue;
            return true;
        }
        return false;
    }
}

