/*
 * Decompiled with CFR 0.152.
 */
package unit.squad;

import bwapi.Position;
import bwapi.Unit;
import bwapi.UnitType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.UUID;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import unit.managed.ManagedUnit;
import unit.managed.UnitRole;
import unit.squad.SquadStatus;

public class Squad
implements Comparable<Squad> {
    private final String id = UUID.randomUUID().toString();
    private HashSet<ManagedUnit> members = new HashSet();
    private Position rallyPoint;
    private Position center;
    private SquadStatus status;
    private UnitType type = null;
    private Unit target = null;
    private boolean shouldDisband = false;
    private double max_dx = 0.0;
    private double max_dy = 0.0;

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Squad)) {
            return false;
        }
        Squad s = (Squad)other;
        return this.id.equals(s.getId());
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public int radius() {
        double d = Math.sqrt(this.max_dx * this.max_dx + this.max_dy * this.max_dy);
        return (int)d;
    }

    public int distance(Squad other) {
        return (int)this.center.getDistance(other.getCenter());
    }

    public int distance(ManagedUnit managedUnit) {
        try {
            return (int)this.center.getDistance(managedUnit.getUnit().getPosition());
        }
        catch (Exception e) {
            return 0;
        }
    }

    public void onFrame() {
        this.calculateCenter();
        this.checkRegroup();
    }

    public void addUnit(ManagedUnit managedUnit) {
        this.members.add(managedUnit);
    }

    public void removeUnit(ManagedUnit managedUnit) {
        this.members.remove(managedUnit);
    }

    public int size() {
        return this.members.size();
    }

    public boolean containsManagedUnit(ManagedUnit managedUnit) {
        return this.members.contains(managedUnit);
    }

    public void merge(Squad other) {
        for (ManagedUnit managedUnit : other.getMembers()) {
            this.members.add(managedUnit);
        }
    }

    public Position getCenter() {
        if (this.center == null) {
            this.calculateCenter();
        }
        return this.center;
    }

    private void calculateCenter() {
        int y = 0;
        int x = 0;
        for (ManagedUnit managedUnit : this.members) {
            Position position = managedUnit.getUnit().getPosition();
            x += position.getX();
            y += position.getY();
        }
        if (this.members.size() == 0) {
            this.center = new Position(0, 0);
            this.shouldDisband = true;
            return;
        }
        this.center = new Position(x / this.members.size(), y / this.members.size());
    }

    private boolean grouped() {
        boolean lowEccentricity;
        double d;
        if (this.size() < 3) {
            return true;
        }
        ArrayList<Double> distances = new ArrayList<Double>();
        double tot = 0.0;
        this.max_dx = 0.0;
        this.max_dy = 0.0;
        for (ManagedUnit u : this.members) {
            Position p = u.getUnit().getPosition();
            d = this.center.getDistance(p);
            this.max_dx = Math.max(this.max_dx, (double)Math.abs(p.getX() - this.center.getX()));
            this.max_dy = Math.max(this.max_dy, (double)Math.abs(p.getY() - this.center.getY()));
            distances.add(d);
            tot += d;
        }
        double avg = tot / (double)this.size();
        int outliers = 0;
        Iterator iterator = distances.iterator();
        while (iterator.hasNext()) {
            d = (Double)iterator.next();
            if (!(d >= avg * 1.5)) continue;
            ++outliers;
        }
        int x_threshold = 100 + this.size() * this.getType().width();
        int y_threshold = 100 + this.size() * this.getType().height();
        boolean lowOutliers = (double)outliers / (double)this.size() < 0.25;
        boolean bl = lowEccentricity = this.max_dx < (double)x_threshold && this.max_dy < (double)y_threshold;
        return lowOutliers || lowEccentricity;
    }

    private void checkRegroup() {
        boolean grouped = true;
        if (this.status == SquadStatus.REGROUP) {
            if (grouped) {
                this.status = SquadStatus.FIGHT;
                for (ManagedUnit u : this.members) {
                    u.setRole(UnitRole.FIGHT);
                }
                return;
            }
            for (ManagedUnit u : this.members) {
                u.setRallyPoint(this.center);
            }
        }
    }

    @Override
    public int compareTo(@NotNull Squad o) {
        return Integer.compare(this.size(), o.size());
    }

    public boolean shouldDisband() {
        return this.shouldDisband;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public HashSet<ManagedUnit> getMembers() {
        return this.members;
    }

    @Generated
    public Position getRallyPoint() {
        return this.rallyPoint;
    }

    @Generated
    public SquadStatus getStatus() {
        return this.status;
    }

    @Generated
    public UnitType getType() {
        return this.type;
    }

    @Generated
    public Unit getTarget() {
        return this.target;
    }

    @Generated
    public boolean isShouldDisband() {
        return this.shouldDisband;
    }

    @Generated
    public double getMax_dx() {
        return this.max_dx;
    }

    @Generated
    public double getMax_dy() {
        return this.max_dy;
    }

    @Generated
    public void setMembers(HashSet<ManagedUnit> members) {
        this.members = members;
    }

    @Generated
    public void setRallyPoint(Position rallyPoint) {
        this.rallyPoint = rallyPoint;
    }

    @Generated
    public void setCenter(Position center) {
        this.center = center;
    }

    @Generated
    public void setStatus(SquadStatus status) {
        this.status = status;
    }

    @Generated
    public void setType(UnitType type) {
        this.type = type;
    }

    @Generated
    public void setTarget(Unit target) {
        this.target = target;
    }

    @Generated
    public void setShouldDisband(boolean shouldDisband) {
        this.shouldDisband = shouldDisband;
    }

    @Generated
    public void setMax_dx(double max_dx) {
        this.max_dx = max_dx;
    }

    @Generated
    public void setMax_dy(double max_dy) {
        this.max_dy = max_dy;
    }

    @Generated
    public String toString() {
        return "Squad(id=" + this.getId() + ", members=" + this.getMembers() + ", rallyPoint=" + this.getRallyPoint() + ", center=" + this.getCenter() + ", status=" + (Object)((Object)this.getStatus()) + ", type=" + (Object)((Object)this.getType()) + ", target=" + this.getTarget() + ", shouldDisband=" + this.isShouldDisband() + ", max_dx=" + this.getMax_dx() + ", max_dy=" + this.getMax_dy() + ")";
    }

    @Generated
    public Squad() {
    }
}

