/*
 * Decompiled with CFR 0.152.
 */
package unit.squad;

import bwapi.Unit;
import bwapi.UnitType;
import bwapi.WeaponType;
import info.GameState;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import unit.squad.CombatSimulator;
import unit.squad.Squad;

public class MutaliskCombatSimulator
implements CombatSimulator {
    @Override
    public CombatSimulator.CombatResult evaluate(Squad squad, GameState gameState) {
        Set<Unit> enemyUnits = gameState.getDetectedEnemyUnits();
        Set<Unit> enemyBuildings = gameState.getEnemyBuildings();
        ArrayList<Unit> allEnemies = new ArrayList<Unit>();
        for (Unit enemy : enemyUnits) {
            if (!enemy.isDetected() || enemy.isInvincible()) continue;
            allEnemies.add(enemy);
        }
        for (Unit building : enemyBuildings) {
            if (!building.isDetected() || building.isInvincible()) continue;
            allEnemies.add(building);
        }
        if (allEnemies.isEmpty()) {
            return CombatSimulator.CombatResult.ENGAGE;
        }
        return this.evaluateMutaliskEngagement(squad, allEnemies) ? CombatSimulator.CombatResult.ENGAGE : CombatSimulator.CombatResult.RETREAT;
    }

    private boolean evaluateMutaliskEngagement(Squad squad, List<Unit> enemies) {
        int antiAirThreats = 0;
        int antiAirDps = 0;
        for (Unit enemy : enemies) {
            if (!this.isAntiAir(enemy) || !(squad.getCenter().getDistance(enemy.getPosition()) < 160.0)) continue;
            ++antiAirThreats;
            antiAirDps += this.getAntiAirDps(enemy);
        }
        int expectedDamagePerSecond = antiAirDps;
        int squadSize = squad.size();
        int mutaliskHp = squadSize * 120;
        if ((double)(expectedDamagePerSecond * 2) > (double)mutaliskHp * 0.05) {
            return false;
        }
        return !((double)antiAirThreats > (double)squadSize * 1.5);
    }

    private boolean isAntiAir(Unit unit) {
        UnitType type = unit.getType();
        if (type.airWeapon() != WeaponType.None) {
            return true;
        }
        return type == UnitType.Terran_Bunker;
    }

    private int getAntiAirDps(Unit unit) {
        UnitType type = unit.getType();
        WeaponType weapon = type.airWeapon();
        if (weapon == WeaponType.None) {
            return 0;
        }
        int damage = weapon.damageAmount();
        int cooldown = weapon.damageCooldown();
        if (cooldown == 0) {
            return 0;
        }
        int dps = damage * 24 / cooldown;
        return dps;
    }
}

