/*
 * Decompiled with CFR 0.152.
 */
package unit.squad;

import bwapi.Unit;
import bwapi.UnitType;
import info.GameState;
import java.util.Set;
import org.bk.ass.sim.BWMirrorAgentFactory;
import org.bk.ass.sim.Simulator;
import unit.managed.ManagedUnit;
import unit.squad.CombatSimulator;
import unit.squad.Squad;
import util.Filter;

public class AssCombatSimulator
implements CombatSimulator {
    private final BWMirrorAgentFactory agentFactory = new BWMirrorAgentFactory();

    @Override
    public CombatSimulator.CombatResult evaluate(Squad squad, GameState gameState) {
        float percentRemaining;
        Set<Unit> enemyUnits = gameState.getDetectedEnemyUnits();
        Set<Unit> enemyBuildings = gameState.getEnemyBuildings();
        Simulator simulator = new Simulator.Builder().build();
        for (ManagedUnit managedUnit : squad.getMembers()) {
            simulator.addAgentA(this.agentFactory.of(managedUnit.getUnit()));
        }
        for (Unit enemyUnit : enemyUnits) {
            if (enemyUnit.getType() == UnitType.Unknown || (int)enemyUnit.getPosition().getDistance(squad.getCenter()) > 256 || enemyUnit.isBeingConstructed() || enemyUnit.isMorphing() || enemyUnit.getType().isWorker()) continue;
            try {
                simulator.addAgentB(this.agentFactory.of(enemyUnit));
            }
            catch (ArithmeticException e) {
                return CombatSimulator.CombatResult.RETREAT;
            }
        }
        for (Unit enemyBuilding : enemyBuildings) {
            if (!Filter.isHostileBuilding(enemyBuilding.getType()) || (int)enemyBuilding.getPosition().getDistance(squad.getCenter()) > 512 || enemyBuilding.isMorphing() || enemyBuilding.isBeingConstructed()) continue;
            try {
                simulator.addAgentB(this.agentFactory.of(enemyBuilding));
            }
            catch (ArithmeticException e) {
                return CombatSimulator.CombatResult.RETREAT;
            }
        }
        simulator.simulate(150);
        if (simulator.getAgentsA().isEmpty()) {
            return CombatSimulator.CombatResult.RETREAT;
        }
        if (!simulator.getAgentsB().isEmpty() && (double)(percentRemaining = (float)simulator.getAgentsA().size() / (float)squad.getMembers().size()) < 0.4) {
            return CombatSimulator.CombatResult.RETREAT;
        }
        return CombatSimulator.CombatResult.ENGAGE;
    }
}

