/*
 * Decompiled with CFR 0.152.
 */
package unit.managed;

import bwapi.Color;
import bwapi.Game;
import bwapi.Position;
import bwapi.Text;
import bwapi.TilePosition;
import bwapi.Unit;
import bwapi.UnitType;
import bwapi.WalkPosition;
import bwapi.WeaponType;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import macro.plan.Plan;
import macro.plan.PlanState;
import unit.managed.UnitRole;
import util.Filter;

public class ManagedUnit {
    protected static int LOCK_ENEMY_WITHIN_DISTANCE = 25;
    protected Game game;
    protected final int unitID;
    protected Unit unit;
    protected UnitRole role;
    protected UnitType unitType;
    protected Position rallyPoint;
    protected TilePosition movementTargetPosition;
    protected List<TilePosition> pathToTarget;
    protected Position retreatTarget;
    private Position lastRetreatPosition;
    private int framesStuck = 0;
    protected Unit defendTarget;
    protected Unit fightTarget;
    protected Unit gatherTarget;
    protected boolean hasNewGatherTarget;
    protected Plan plan;
    protected int buildAttemptFrame;
    protected boolean canFight = true;
    protected int unreadyUntilFrame = 0;
    protected boolean isReady = true;

    public ManagedUnit(Game game, Unit unit, UnitRole role) {
        this.game = game;
        this.unit = unit;
        this.role = role;
        this.unitType = unit.getType();
        this.unitID = unit.getID();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ManagedUnit)) {
            return false;
        }
        ManagedUnit u = (ManagedUnit)o;
        return this.unitID == u.getUnitID();
    }

    public int hashCode() {
        return this.unitID;
    }

    public boolean isReady() {
        return this.isReady;
    }

    public void setReady(boolean isReady) {
        this.isReady = isReady;
    }

    public boolean canFight() {
        return this.canFight;
    }

    public void setNewGatherTarget(boolean hasNewGatherTarget) {
        this.hasNewGatherTarget = hasNewGatherTarget;
    }

    public void execute() {
        this.debug();
        this.updateState();
        if (!this.isReady) {
            return;
        }
        switch (this.role) {
            case SCOUT: {
                this.scout();
                break;
            }
            case FIGHT: {
                this.fight();
                break;
            }
            case GATHER: {
                this.gather();
                break;
            }
            case BUILD: {
                this.build();
                break;
            }
            case MORPH: {
                this.morph();
                break;
            }
            case RETREAT: {
                this.retreat();
                break;
            }
            case DEFEND: {
                this.defend();
                break;
            }
            case RALLY: 
            case REGROUP: {
                this.rally();
                break;
            }
        }
    }

    public Position getRetreatPosition() {
        int currentY;
        int currentX = this.unit.getX();
        List enemies = this.game.getUnitsInRadius(currentX, currentY = this.unit.getY(), 128).stream().filter(u -> u.getPlayer() != this.game.self()).filter(u -> !u.getType().isBuilding() || Filter.isHostileBuildingToGround(u.getType())).collect(Collectors.toList());
        if (enemies.isEmpty()) {
            return new Position(currentX, currentY);
        }
        int sumDx = 0;
        int sumDy = 0;
        for (Unit enemy : enemies) {
            sumDx += enemy.getX() - currentX;
            sumDy += enemy.getY() - currentY;
        }
        int retreatDx = -sumDx;
        int retreatDy = -sumDy;
        double length = Math.sqrt(retreatDx * retreatDx + retreatDy * retreatDy);
        if (length == 0.0) {
            return new Position(currentX, currentY);
        }
        double scale = 128.0 / length;
        int newX = currentX + (int)((double)retreatDx * scale);
        int newY = currentY + (int)((double)retreatDy * scale);
        Position retreatPos = new Position(newX, newY);
        if (!this.isRetreatPathWalkable(new Position(currentX, currentY), retreatPos)) {
            retreatPos = this.findAlternativeRetreatPosition(new Position(currentX, currentY), retreatPos);
        }
        return retreatPos;
    }

    private boolean isRetreatPathWalkable(Position currentPos, Position retreatTarget) {
        double dy;
        double dx = retreatTarget.getX() - currentPos.getX();
        double distance = Math.sqrt(dx * dx + (dy = (double)(retreatTarget.getY() - currentPos.getY())) * dy);
        if (distance == 0.0) {
            return true;
        }
        dx /= distance;
        dy /= distance;
        double stepSize = 4.0;
        int numSteps = (int)Math.ceil(distance / stepSize);
        numSteps = Math.min(numSteps, 8);
        int i = 1;
        while (i <= numSteps) {
            int checkY;
            double progress = (double)i / (double)numSteps;
            int checkX = currentPos.getX() + (int)(dx * distance * progress);
            Position checkPos = new Position(checkX, checkY = currentPos.getY() + (int)(dy * distance * progress));
            if (!this.game.isWalkable(new WalkPosition(checkPos))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private Position findAlternativeRetreatPosition(Position currentPos, Position originalRetreat) {
        int[] distances;
        List enemies = this.game.getUnitsInRadius(currentPos.getX(), currentPos.getY(), 256).stream().filter(u -> u.getPlayer() != this.game.self()).filter(u -> !u.getType().isBuilding() || Filter.isHostileBuildingToGround(u.getType())).collect(Collectors.toList());
        if (enemies.isEmpty()) {
            return originalRetreat;
        }
        Position bestPosition = null;
        double bestMinEnemyDistance = -1.0;
        int[] nArray = distances = new int[]{128, 96, 64, 48, 32};
        int n = distances.length;
        int n2 = 0;
        while (n2 < n) {
            int distance = nArray[n2];
            int angle = 0;
            while (angle < 360) {
                double rad = Math.toRadians(angle);
                int testX = currentPos.getX() + (int)(Math.cos(rad) * (double)distance);
                int testY = currentPos.getY() + (int)(Math.sin(rad) * (double)distance);
                Position candidatePos = new Position(testX = Math.max(0, Math.min(testX, this.game.mapWidth() * 32 - 1)), testY = Math.max(0, Math.min(testY, this.game.mapHeight() * 32 - 1)));
                if (this.game.isWalkable(new WalkPosition(candidatePos)) && this.isRetreatPathWalkable(currentPos, candidatePos)) {
                    double minDistToEnemy = Double.MAX_VALUE;
                    for (Unit enemy : enemies) {
                        double dist = candidatePos.getDistance(enemy.getPosition());
                        if (!(dist < minDistToEnemy)) continue;
                        minDistToEnemy = dist;
                    }
                    if (minDistToEnemy > bestMinEnemyDistance) {
                        bestMinEnemyDistance = minDistToEnemy;
                        bestPosition = candidatePos;
                    }
                }
                angle += 30;
            }
            ++n2;
        }
        if (bestPosition != null) {
            return bestPosition;
        }
        return this.rallyPoint != null ? this.rallyPoint : currentPos;
    }

    private void debug() {
        Position fightTargetPos;
        Position unitPosition = this.unit.getPosition();
        if (this.role != null) {
            this.game.drawTextMap(unitPosition, this.role.toString(), Text.Default);
        }
        if (this.role == UnitRole.BUILDING) {
            return;
        }
        if (this.movementTargetPosition != null) {
            Position movementPos = this.movementTargetPosition.toPosition();
            this.game.drawLineMap(unitPosition, movementPos, Color.White);
        }
        if (this.retreatTarget != null) {
            this.game.drawLineMap(unitPosition, this.retreatTarget, Color.Purple);
        }
        if (this.fightTarget != null && (fightTargetPos = this.fightTarget.getPosition()) != null) {
            this.game.drawLineMap(unitPosition, fightTargetPos, Color.Red);
        }
        if (this.plan != null && this.plan.getBuildPosition() != null) {
            Position buildPosition = this.plan.getBuildPosition().toPosition();
            this.game.drawLineMap(unitPosition, buildPosition, Color.Cyan);
            int distance = this.unit.getDistance(buildPosition);
            String distanceText = String.format("Distance: %d", distance);
            Position textPosition = unitPosition.add(new Position(8, 8));
            this.game.drawTextMap(textPosition, distanceText, Text.Cyan);
        }
    }

    protected void rally() {
        if (this.rallyPoint == null) {
            return;
        }
        if (this.role == UnitRole.RALLY && this.unit.getDistance(this.rallyPoint) < 32) {
            return;
        }
        if (this.unit.getDistance(this.rallyPoint) < 16) {
            return;
        }
        this.setUnready();
        this.unit.move(this.rallyPoint);
    }

    protected void gather() {
    }

    protected void build() {
        UnitType buildingType;
        Position buildTarget;
        if (this.unit.isBeingConstructed() || this.unit.isMorphing()) {
            return;
        }
        if (this.unit.isCarrying()) {
            this.unit.returnCargo();
            this.setUnready();
            return;
        }
        UnitType plannedUnitType = this.plan.getPlannedUnit();
        if (this.plan.getBuildPosition() == null) {
            TilePosition buildLocation = this.game.getBuildLocation(plannedUnitType, this.unit.getTilePosition());
            this.plan.setBuildPosition(buildLocation);
        }
        if (this.unit.getDistance(buildTarget = this.getBuilderMoveLocation(buildingType = this.plan.getPlannedUnit(), this.plan.getBuildPosition())) > 150 || this.unit.isGatheringMinerals()) {
            this.setUnready();
            this.unit.move(buildTarget);
            return;
        }
        if (this.game.canMake(plannedUnitType, this.unit)) {
            this.setUnready();
            boolean didBuild = this.unit.build(plannedUnitType, this.plan.getBuildPosition());
            if (!didBuild) {
                didBuild = this.unit.morph(plannedUnitType);
            }
            int frameCount = this.game.getFrameCount();
            if (!didBuild && this.buildAttemptFrame == 0) {
                this.buildAttemptFrame = frameCount;
            }
            if (!didBuild && this.buildAttemptFrame + 150 < frameCount) {
                this.plan.setBuildPosition(this.game.getBuildLocation(plannedUnitType, this.unit.getTilePosition()));
            }
            if (didBuild) {
                this.plan.setState(PlanState.MORPHING);
            }
        }
    }

    private Position getBuilderMoveLocation(UnitType building, TilePosition buildTarget) {
        int height = building.tileHeight() * 16;
        int width = building.tileWidth() * 16;
        return buildTarget.toPosition().add(new Position(width, height));
    }

    protected void morph() {
        if (this.unit.isMorphing()) {
            return;
        }
        UnitType unitType = this.plan.getPlannedUnit();
        if (this.game.canMake(unitType, this.unit)) {
            this.setUnready();
            boolean didMorph = this.unit.morph(unitType);
            if (didMorph) {
                this.plan.setState(PlanState.MORPHING);
            }
        }
    }

    protected void setUnready() {
        this.setUnready(11);
    }

    protected void setUnready(int unreadyFrames) {
        this.isReady = false;
        this.unreadyUntilFrame = this.game.getFrameCount() + this.game.getLatencyFrames() + unreadyFrames;
    }

    protected void scout() {
        if (this.movementTargetPosition == null) {
            return;
        }
        this.setUnready();
        this.unit.move(this.movementTargetPosition.toPosition());
    }

    private void updateState() {
        if (this.movementTargetPosition != null) {
            if (this.role == UnitRole.SCOUT && this.game.isVisible(this.movementTargetPosition)) {
                this.movementTargetPosition = null;
            } else if (this.role == UnitRole.FIGHT && this.game.isVisible(this.movementTargetPosition)) {
                this.movementTargetPosition = null;
            }
        }
        if (this.retreatTarget != null && (this.unit.getDistance(this.retreatTarget) < 16 || this.unit.isIdle() || !this.game.isWalkable(new WalkPosition(this.retreatTarget)))) {
            this.retreatTarget = null;
            this.lastRetreatPosition = null;
            this.framesStuck = 0;
        }
        if (!(this.fightTarget == null || this.fightTarget.exists() && this.fightTarget.isTargetable() && this.fightTarget.getType() != UnitType.Resource_Vespene_Geyser)) {
            this.fightTarget = null;
        }
    }

    protected void fight() {
        if (this.unit.isAttackFrame()) {
            return;
        }
        this.setUnready(11);
        if (this.fightTarget != null) {
            if (this.canKite(this.fightTarget)) {
                this.kiteEnemy(this.fightTarget);
            } else {
                this.unit.attack(this.fightTarget);
            }
            return;
        }
        if (this.movementTargetPosition != null) {
            this.unit.move(this.movementTargetPosition.toPosition());
            return;
        }
        this.role = UnitRole.IDLE;
    }

    protected void retreat() {
        if (this.retreatTarget == null) {
            this.role = UnitRole.IDLE;
            return;
        }
        this.setUnready(4);
        Position currentPosition = this.unit.getPosition();
        if (this.lastRetreatPosition != null && currentPosition.getDistance(this.lastRetreatPosition) < 1.0) {
            ++this.framesStuck;
        } else {
            this.lastRetreatPosition = currentPosition;
            this.framesStuck = 0;
        }
        if (this.framesStuck >= 12) {
            this.setRetreatTarget(null);
            this.role = UnitRole.IDLE;
            return;
        }
        if (this.unit.getDistance(this.retreatTarget) < this.getRetreatArrivalDistance()) {
            Position next = this.getRetreatPosition();
            this.setRetreatTarget(next);
            if (next == null) {
                this.role = UnitRole.IDLE;
                return;
            }
        }
        this.unit.move(this.retreatTarget);
    }

    protected int getRetreatArrivalDistance() {
        return 16;
    }

    protected void defend() {
    }

    public void setFightTarget(Unit newFightTarget) {
        if (this.fightTarget != null && !this.fightTarget.getType().isBuilding() && this.fightTarget.getDistance(this.unit) < LOCK_ENEMY_WITHIN_DISTANCE) {
            return;
        }
        this.fightTarget = newFightTarget;
        TilePosition targetTile = newFightTarget.getTilePosition();
        this.movementTargetPosition = this.isValidTilePosition(targetTile) ? targetTile : null;
    }

    protected int weaponRange(Unit enemy) {
        boolean isEnemyAir = enemy.isFlying();
        WeaponType weapon = isEnemyAir ? this.unit.getType().airWeapon() : this.unit.getType().groundWeapon();
        return weapon.maxRange();
    }

    private void kiteEnemy(Unit enemy) {
        boolean outsideKiteThreshold;
        WeaponType enemyWeapon;
        if (enemy == null || !enemy.exists() || !enemy.isVisible()) {
            return;
        }
        boolean isEnemyAir = enemy.isFlying();
        WeaponType weapon = isEnemyAir ? this.unit.getType().airWeapon() : this.unit.getType().groundWeapon();
        WeaponType weaponType = enemyWeapon = this.unit.isFlying() ? enemy.getType().airWeapon() : enemy.getType().groundWeapon();
        if (weapon == null) {
            this.unit.attack(enemy.getPosition());
            return;
        }
        int cooldown = isEnemyAir ? this.unit.getAirWeaponCooldown() : this.unit.getGroundWeaponCooldown();
        Position enemyPos = enemy.getPosition();
        Position myPos = this.unit.getPosition();
        double distance = myPos.getDistance(enemyPos);
        double kiteThreshold = (double)this.weaponRange(enemy) * 0.9;
        if (this.weaponRange(enemy) > enemyWeapon.maxRange()) {
            kiteThreshold = enemyWeapon.maxRange();
        }
        boolean bl = outsideKiteThreshold = distance >= kiteThreshold;
        if (enemy.getType().isBuilding()) {
            this.unit.attack(enemy);
            return;
        }
        if (cooldown == 0) {
            if (outsideKiteThreshold) {
                this.unit.attack(enemy);
            } else {
                this.unit.attack(enemyPos);
            }
        } else {
            int moveDistance = 64;
            double dx = myPos.x - enemyPos.x;
            double dy = myPos.y - enemyPos.y;
            double length = Math.sqrt(dx * dx + dy * dy);
            if (length == 0.0) {
                this.unit.move(new Position(myPos.x + moveDistance, myPos.y));
                return;
            }
            Position kitePosition = new Position((int)((double)myPos.x + (dx /= length) * (double)moveDistance), (int)((double)myPos.y + (dy /= length) * (double)moveDistance));
            this.unit.move(kitePosition);
        }
    }

    private boolean canKite(Unit enemy) {
        WeaponType weapon;
        if (enemy == null || !enemy.exists() || !enemy.isVisible()) {
            return false;
        }
        boolean isEnemyAir = enemy.isFlying();
        WeaponType weaponType = weapon = isEnemyAir ? this.unit.getType().airWeapon() : this.unit.getType().groundWeapon();
        return weapon != null && weapon.maxRange() > 32;
    }

    protected void handleNoTarget() {
        if (this.movementTargetPosition != null && this.isValidTilePosition(this.movementTargetPosition)) {
            this.unit.move(this.movementTargetPosition.toPosition());
            return;
        }
        this.role = UnitRole.IDLE;
    }

    private boolean isValidTilePosition(TilePosition tp) {
        return tp.getX() >= 0 && tp.getY() >= 0 && tp.getX() < this.game.mapWidth() && tp.getY() < this.game.mapHeight();
    }

    protected Unit findClosestEnemyInRange() {
        Unit closest = null;
        double closestDistance = Double.MAX_VALUE;
        for (Unit enemy : this.game.getUnitsInRadius(this.unit.getPosition(), this.weaponRange(this.unit))) {
            double enemyDistance;
            if (!enemy.getPlayer().isEnemy(this.game.self()) || !enemy.isTargetable() || Filter.isLowPriorityCombatTarget(enemy.getType()) || !((enemyDistance = (double)this.unit.getDistance(enemy)) < closestDistance)) continue;
            closest = enemy;
            closestDistance = enemyDistance;
        }
        return closest;
    }

    protected boolean canFightBack(Unit enemy) {
        WeaponType enemyWeapon;
        if (enemy == null || !enemy.exists()) {
            return false;
        }
        WeaponType weaponType = enemyWeapon = this.unit.isFlying() ? enemy.getType().airWeapon() : enemy.getType().groundWeapon();
        return enemyWeapon != null && enemyWeapon.maxRange() > 0;
    }

    protected Unit findThreateningEnemy() {
        for (Unit enemy : this.game.getUnitsInRadius(this.unit.getPosition(), this.weaponRange(this.unit) + 64)) {
            if (!enemy.getPlayer().isEnemy(this.game.self()) || !enemy.isTargetable() || !this.canFightBack(enemy) || Filter.isLowPriorityCombatTarget(enemy.getType())) continue;
            return enemy;
        }
        return null;
    }

    @Generated
    public int getUnitID() {
        return this.unitID;
    }

    @Generated
    public Unit getUnit() {
        return this.unit;
    }

    @Generated
    public void setRole(UnitRole role) {
        this.role = role;
    }

    @Generated
    public UnitRole getRole() {
        return this.role;
    }

    @Generated
    public void setUnitType(UnitType unitType) {
        this.unitType = unitType;
    }

    @Generated
    public UnitType getUnitType() {
        return this.unitType;
    }

    @Generated
    public void setRallyPoint(Position rallyPoint) {
        this.rallyPoint = rallyPoint;
    }

    @Generated
    public Position getRallyPoint() {
        return this.rallyPoint;
    }

    @Generated
    public void setMovementTargetPosition(TilePosition movementTargetPosition) {
        this.movementTargetPosition = movementTargetPosition;
    }

    @Generated
    public TilePosition getMovementTargetPosition() {
        return this.movementTargetPosition;
    }

    @Generated
    public void setRetreatTarget(Position retreatTarget) {
        this.retreatTarget = retreatTarget;
    }

    @Generated
    public void setDefendTarget(Unit defendTarget) {
        this.defendTarget = defendTarget;
    }

    @Generated
    public Unit getDefendTarget() {
        return this.defendTarget;
    }

    @Generated
    public void setGatherTarget(Unit gatherTarget) {
        this.gatherTarget = gatherTarget;
    }

    @Generated
    public void setPlan(Plan plan) {
        this.plan = plan;
    }

    @Generated
    public Plan getPlan() {
        return this.plan;
    }

    @Generated
    public void setCanFight(boolean canFight) {
        this.canFight = canFight;
    }

    @Generated
    public int getUnreadyUntilFrame() {
        return this.unreadyUntilFrame;
    }
}

