/*
 * Decompiled with CFR 0.152.
 */
package unit.managed;

import bwapi.Game;
import bwapi.Position;
import bwapi.TilePosition;
import bwapi.Unit;
import bwapi.UnitType;
import bwapi.UpgradeType;
import bwapi.WeaponType;
import macro.plan.PlanType;
import unit.managed.ManagedUnit;
import unit.managed.UnitRole;

public class Hydralisk
extends ManagedUnit {
    private static final int UPGRADED_RANGE_BONUS = 32;
    private static final int MOVE_DISTANCE = 64;

    public Hydralisk(Game game, Unit unit, UnitRole role) {
        super(game, unit, role);
    }

    @Override
    protected int weaponRange(Unit enemy) {
        boolean isEnemyAir = enemy.isFlying();
        WeaponType weapon = isEnemyAir ? this.unit.getType().airWeapon() : this.unit.getType().groundWeapon();
        int range = weapon.maxRange();
        if (this.game.self().getUpgradeLevel(UpgradeType.Grooved_Spines) > 0) {
            range += 32;
        }
        return range;
    }

    private boolean hasNoValidFightTarget() {
        return this.fightTarget == null || !this.fightTarget.exists() || !this.fightTarget.isVisible();
    }

    private void kiteFromTarget() {
        Position myPos = this.unit.getPosition();
        Position enemyPos = this.fightTarget.getPosition();
        double dx = myPos.x - enemyPos.x;
        double dy = myPos.y - enemyPos.y;
        double length = Math.sqrt(dx * dx + dy * dy);
        Position kitePosition = length == 0.0 ? new Position(myPos.x + 64, myPos.y) : new Position((int)((double)myPos.x + dx / length * 64.0), (int)((double)myPos.y + dy / length * 64.0));
        this.unit.move(kitePosition);
    }

    @Override
    protected void fight() {
        boolean outsideKiteThreshold;
        if (this.unit.isAttackFrame()) {
            return;
        }
        this.setUnready(11);
        if (this.hasNoValidFightTarget()) {
            this.handleNoTarget();
            return;
        }
        boolean isEnemyAir = this.fightTarget.isFlying();
        WeaponType weapon = isEnemyAir ? this.unit.getType().airWeapon() : this.unit.getType().groundWeapon();
        WeaponType enemyWeapon = this.unit.isFlying() ? this.fightTarget.getType().airWeapon() : this.fightTarget.getType().groundWeapon();
        this.setUnready(weapon.damageCooldown());
        int cooldown = isEnemyAir ? this.unit.getAirWeaponCooldown() : this.unit.getGroundWeaponCooldown();
        Position enemyPos = this.fightTarget.getPosition();
        Position myPos = this.unit.getPosition();
        double distance = myPos.getDistance(enemyPos);
        double kiteThreshold = (double)this.weaponRange(this.fightTarget) * 0.9;
        if (this.weaponRange(this.fightTarget) > enemyWeapon.maxRange()) {
            kiteThreshold = enemyWeapon.maxRange();
        }
        boolean bl = outsideKiteThreshold = distance >= kiteThreshold;
        if (this.fightTarget.getType().isBuilding()) {
            this.unit.attack(this.fightTarget);
            return;
        }
        if (cooldown == 0 || outsideKiteThreshold) {
            this.unit.attack(this.fightTarget);
            return;
        }
        this.kiteFromTarget();
    }

    @Override
    public void execute() {
        if (this.plan != null && this.plan.getType() == PlanType.UNIT && this.plan.getPlannedUnit() == UnitType.Zerg_Lurker && this.role != UnitRole.MORPH) {
            this.setRole(UnitRole.MORPH);
        }
        super.execute();
    }

    @Override
    public void setMovementTargetPosition(TilePosition tp) {
        if (this.plan != null && this.plan.getType() == PlanType.UNIT && this.plan.getPlannedUnit() == UnitType.Zerg_Lurker) {
            this.setRole(UnitRole.MORPH);
            return;
        }
        super.setMovementTargetPosition(tp);
    }

    @Override
    protected int getRetreatArrivalDistance() {
        return 24;
    }
}

