/*
 * Decompiled with CFR 0.152.
 */
package strategy;

import bwapi.Race;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import strategy.buildorder.BuildOrder;
import strategy.buildorder.opener.FourPool;
import strategy.buildorder.opener.NinePoolSpeed;
import strategy.buildorder.opener.Overpool;
import strategy.buildorder.opener.ThreeHatchBeforePool;
import strategy.buildorder.opener.TwelveHatch;
import strategy.buildorder.opener.TwelvePool;
import strategy.buildorder.protoss.ThreeHatchHydra;
import strategy.buildorder.protoss.ThreeHatchMuta;
import strategy.buildorder.terran.ThreeHatchLurker;
import strategy.buildorder.terran.TwoHatchMuta;
import strategy.buildorder.zerg.OneHatchSpire;

public class BuildOrderFactory {
    private List<BuildOrder> allBuildOrders = new ArrayList<BuildOrder>();
    private List<BuildOrder> allOpeners = new ArrayList<BuildOrder>();
    private Set<BuildOrder> playableOpeners = new HashSet<BuildOrder>();
    private Race opponentRace;

    public BuildOrderFactory(int numStartingLocations, Race opponentRace) {
        this.opponentRace = opponentRace;
        this.initBuildOrders();
        this.initOpeners(numStartingLocations);
    }

    public Set<String> getOpenerNames() {
        return this.playableOpeners.stream().map(bo -> bo.getName()).collect(Collectors.toSet());
    }

    public Set<String> getAllBuildOrderNames() {
        return this.allBuildOrders.stream().map(bo -> bo.getName()).collect(Collectors.toSet());
    }

    public Set<String> getPlayableNonOpenerNames() {
        return this.allBuildOrders.stream().filter(bo -> !bo.isOpener()).filter(bo -> bo.playsRace(this.opponentRace)).map(bo -> bo.getName()).collect(Collectors.toSet());
    }

    public BuildOrder getByName(String name) {
        return this.allBuildOrders.stream().filter(bo -> Objects.equals(bo.getName(), name)).findFirst().orElse(null);
    }

    public boolean isPlayableOpener(BuildOrder buildOrder) {
        return this.playableOpeners.contains(buildOrder);
    }

    private void initBuildOrders() {
        this.allBuildOrders.add(new FourPool());
        this.allBuildOrders.add(new NinePoolSpeed());
        this.allBuildOrders.add(new Overpool());
        this.allBuildOrders.add(new ThreeHatchBeforePool());
        this.allBuildOrders.add(new TwelveHatch());
        this.allBuildOrders.add(new TwelvePool());
        this.allBuildOrders.add(new ThreeHatchHydra());
        this.allBuildOrders.add(new ThreeHatchMuta());
        this.allBuildOrders.add(new ThreeHatchLurker());
        this.allBuildOrders.add(new TwoHatchMuta());
        this.allBuildOrders.add(new OneHatchSpire());
    }

    private void initOpeners(int numStartingLocations) {
        this.allOpeners = this.allBuildOrders.stream().filter(bo -> bo.isOpener()).collect(Collectors.toList());
        this.playableOpeners = this.allOpeners.stream().filter(bo -> bo.playsRace(this.opponentRace)).collect(Collectors.toSet());
    }
}

