/*
 * Decompiled with CFR 0.152.
 */
package org.bk.ass.sim;

import org.bk.ass.collection.UnorderedCollection;
import org.bk.ass.sim.Agent;
import org.bk.ass.sim.AgentUtil;
import org.bk.ass.sim.Simulator;
import org.bk.ass.sim.Weapon;

public class RetreatBehavior
implements Simulator.Behavior {
    @Override
    public boolean simUnit(int frameSkip, Agent agent, UnorderedCollection<Agent> allies, UnorderedCollection<Agent> enemies) {
        return RetreatBehavior.simFlee(frameSkip, agent, enemies);
    }

    static boolean simFlee(int frames, Agent agent, UnorderedCollection<Agent> enemies) {
        if (agent.burrowed || agent.isStasised || agent.isLockeddown) {
            return false;
        }
        Agent selectedEnemy = null;
        int selectedDistanceSquared = Integer.MAX_VALUE;
        for (int i = enemies.size() - 1; i >= 0; --i) {
            int distanceSq;
            Agent enemy = enemies.get(i);
            Weapon wpn = enemy.weaponVs(agent);
            if (wpn.damageShifted == 0 || (distanceSq = AgentUtil.distanceSquared(agent, enemy)) < wpn.minRangeSquared || distanceSq >= selectedDistanceSquared) continue;
            selectedDistanceSquared = distanceSq;
            selectedEnemy = enemy;
            if (selectedDistanceSquared <= wpn.maxRangeSquared) break;
        }
        if (selectedEnemy == null) {
            return false;
        }
        AgentUtil.moveAwayFrom(frames, agent, selectedEnemy, (float)Math.sqrt(selectedDistanceSquared));
        return true;
    }
}

