/*
 * Decompiled with CFR 0.152.
 */
package org.bk.ass.sim;

import java.util.SplittableRandom;
import org.bk.ass.collection.UnorderedCollection;
import org.bk.ass.sim.Agent;
import org.bk.ass.sim.DamageType;
import org.bk.ass.sim.UnitSize;
import org.bk.ass.sim.Weapon;

public class AgentUtil {
    private static final SplittableRandom rnd = new SplittableRandom();
    public static final int INTERCEPTOR_COOLDOWN = 45;
    public static final int REAVER_COOLDOWN = 60;

    private AgentUtil() {
    }

    public static void moveToward(int frames, Agent agent, Agent target, float distance) {
        float travelled = (float)frames * agent.speed;
        if (distance <= travelled) {
            agent.vx = target.x - agent.x;
            agent.vy = target.y - agent.y;
        } else {
            agent.vx = (int)((float)(target.x - agent.x) * travelled / distance);
            agent.vy = (int)((float)(target.y - agent.y) * travelled / distance);
        }
    }

    public static void moveAwayFrom(int frames, Agent agent, Agent target, float distance) {
        float travelled = (float)frames * agent.speed;
        if (distance == 0.0f) {
            double a = rnd.nextDouble(Math.PI * 2);
            agent.vx = (int)(Math.cos(a) * (double)travelled);
            agent.vy = (int)(Math.sin(a) * (double)travelled);
        } else {
            agent.vx = (int)((float)(agent.x - target.x) * travelled / distance);
            agent.vy = (int)((float)(agent.y - target.y) * travelled / distance);
        }
    }

    public static int distanceSquared(Agent a, Agent b) {
        return (a.x - b.x) * (a.x - b.x) + (a.y - b.y) * (a.y - b.y);
    }

    public static void dealRadialSplashDamage(Weapon weapon, Agent mainTarget, UnorderedCollection<Agent> allies, UnorderedCollection<Agent> enemies) {
        int i;
        for (i = allies.size() - 1; i >= 0; --i) {
            Agent ally = allies.get(i);
            AgentUtil.applySplashDamage(weapon, mainTarget, ally);
        }
        for (i = enemies.size() - 1; i >= 0; --i) {
            Agent enemy = enemies.get(i);
            AgentUtil.applySplashDamage(weapon, mainTarget, enemy);
        }
    }

    private static void applySplashDamage(Weapon weapon, Agent mainTarget, Agent splashTarget) {
        if (splashTarget == mainTarget || splashTarget.isFlyer != mainTarget.isFlyer) {
            return;
        }
        int distanceSquared = AgentUtil.distanceSquared(splashTarget, mainTarget);
        if (distanceSquared <= weapon.innerSplashRadiusSquared) {
            AgentUtil.applyDamage(splashTarget, weapon.damageType, weapon.damageShifted, weapon.hits);
        } else if (!splashTarget.burrowed) {
            if (distanceSquared <= weapon.medianSplashRadiusSquared) {
                AgentUtil.applyDamage(splashTarget, weapon.damageType, weapon.damageShifted / 2, weapon.hits);
            } else if (distanceSquared <= weapon.outerSplashRadiusSquared) {
                AgentUtil.applyDamage(splashTarget, weapon.damageType, weapon.damageShifted / 4, weapon.hits);
            }
        }
    }

    public static void dealRadialSplashDamage(Weapon weapon, Agent mainTarget, UnorderedCollection<Agent> enemies) {
        for (int i = enemies.size() - 1; i >= 0; --i) {
            Agent enemy = enemies.get(i);
            AgentUtil.applySplashDamage(weapon, mainTarget, enemy);
        }
    }

    public static void dealLineSplashDamage(Agent source, Weapon weapon, Agent mainTarget, UnorderedCollection<Agent> enemies) {
        int dx = mainTarget.x - source.x;
        int dy = mainTarget.y - source.y;
        if (dx == 0 && dy == 0) {
            dx = 1;
        }
        int dxDistSq = dx * dx + dy * dy;
        int rangeWithSplashSquared = weapon.maxRangeSquared + 2 * weapon.maxRange * weapon.innerSplashRadius + weapon.innerSplashRadiusSquared;
        for (int i = enemies.size() - 1; i >= 0; --i) {
            int projdy;
            int projdx;
            int projDistSq;
            int dot;
            int enemyDistSq;
            Agent enemy = enemies.get(i);
            if (enemy == mainTarget || enemy.isFlyer != mainTarget.isFlyer || (enemyDistSq = AgentUtil.distanceSquared(enemy, source)) > rangeWithSplashSquared || (dot = (enemy.x - source.x) * dx + (enemy.y - source.y) * dy) < 0 || (projDistSq = (projdx = source.x + dot * dx / dxDistSq - enemy.x) * projdx + (projdy = source.y + dot * dy / dxDistSq - enemy.y) * projdy) > weapon.innerSplashRadiusSquared) continue;
            AgentUtil.applyDamage(enemy, weapon.damageType, weapon.damageShifted, weapon.hits);
        }
    }

    public static void dealBounceDamage(Weapon weapon, Agent lastTarget, UnorderedCollection<Agent> enemies) {
        int remainingBounces = 2;
        int damage = weapon.damageShifted / 3;
        for (int i = enemies.size() - 1; i >= 0 && remainingBounces > 0; --i) {
            Agent enemy = enemies.get(i);
            if (enemy == lastTarget || enemy.healthShifted <= 0 || Math.abs(enemy.x - lastTarget.x) > 96 || Math.abs(enemy.y - lastTarget.y) > 96) continue;
            lastTarget = enemy;
            AgentUtil.applyDamage(enemy, weapon.damageType, damage, weapon.hits);
            damage /= 3;
            --remainingBounces;
        }
    }

    public static void dealDamage(Agent agent, Weapon wpn, Agent target) {
        int remainingDamage = wpn.damageShifted;
        if (!agent.isMelee) {
            if (target.protectedByDarkSwarm) {
                return;
            }
            if (agent.elevationLevel >= 0 && agent.elevationLevel < target.elevationLevel || (target.elevationLevel & 1) == 1) {
                remainingDamage = remainingDamage * 136 / 256;
            }
            remainingDamage = remainingDamage * 255 / 256;
        }
        AgentUtil.applyDamage(target, wpn.damageType, remainingDamage, wpn.hits);
    }

    private static void applyDamage(Agent target, DamageType damageType, int damage, int hits) {
        int shields = Math.min(target.maxShieldsShifted, target.shieldsShifted) - damage + target.shieldUpgrades;
        if (shields > 0) {
            target.shieldsShifted = shields;
            return;
        }
        if (shields < 0) {
            damage = -shields;
            target.shieldsShifted = 0;
        }
        if (damage == 0) {
            return;
        }
        damage = AgentUtil.reduceDamageByTargetSizeAndDamageType(target, damageType, damage - target.armorShifted * hits);
        target.consumeHealth(Math.max(128, damage));
    }

    public static int reduceDamageByTargetSizeAndDamageType(Agent target, DamageType damageType, int damageShifted) {
        if (damageType == DamageType.CONCUSSIVE) {
            if (target.size == UnitSize.MEDIUM) {
                damageShifted /= 2;
            } else if (target.size == UnitSize.LARGE) {
                damageShifted /= 4;
            }
        } else if (damageType == DamageType.EXPLOSIVE) {
            if (target.size == UnitSize.SMALL) {
                damageShifted /= 2;
            } else if (target.size == UnitSize.MEDIUM) {
                damageShifted /= 4;
            }
        }
        return damageShifted;
    }

    public static void attack(Agent agent, Weapon selectedWeapon, Agent selectedEnemy, UnorderedCollection<Agent> allies, UnorderedCollection<Agent> enemies) {
        AgentUtil.dealDamage(agent, selectedWeapon, selectedEnemy);
        switch (selectedWeapon.splashType) {
            case BOUNCE: {
                AgentUtil.dealBounceDamage(selectedWeapon, selectedEnemy, enemies);
                break;
            }
            case RADIAL_SPLASH: {
                AgentUtil.dealRadialSplashDamage(selectedWeapon, selectedEnemy, allies, enemies);
                break;
            }
            case RADIAL_ENEMY_SPLASH: {
                AgentUtil.dealRadialSplashDamage(selectedWeapon, selectedEnemy, enemies);
                break;
            }
            case LINE_SPLASH: {
                AgentUtil.dealLineSplashDamage(agent, selectedWeapon, selectedEnemy, enemies);
                break;
            }
        }
        agent.cooldown = agent.maxCooldown;
        if (agent.remainingStimFrames > 0) {
            agent.cooldown /= 2;
        }
    }
}

