/*
 * Decompiled with CFR 0.152.
 */
package org.bk.ass.query;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import org.bk.ass.path.Position;
import org.bk.ass.query.DistanceProvider;
import org.bk.ass.query.Distances;

public class PositionQueries<U>
extends AbstractCollection<U> {
    private int size;
    private Node root;
    private Function<U, Position> positionExtractor;
    private DistanceProvider distanceProvider;

    public PositionQueries(Collection<U> elements, Function<U, Position> positionExtractor) {
        this(elements, positionExtractor, Distances.EUCLIDEAN_DISTANCE);
    }

    public PositionQueries(Collection<U> elements, Function<U, Position> positionExtractor, DistanceProvider distanceProvider) {
        this.distanceProvider = distanceProvider;
        if (elements == null) {
            throw new IllegalArgumentException("elements must not be null");
        }
        if (positionExtractor == null) {
            throw new IllegalArgumentException("positionExtractor must not be null");
        }
        this.positionExtractor = positionExtractor;
        this.root = new TreeBuilder(elements.toArray()).makeTree(0, elements.size() - 1, true);
        this.size = elements.size();
    }

    public U nearest(int x, int y) {
        return new NearestSearcher(x, y).search();
    }

    public U nearest(int x, int y, Predicate<U> criteria) {
        return new NearestSearcher(x, y, criteria).search();
    }

    public Collection<U> inArea(int ax, int ay, int bx, int by) {
        if (ax > bx || ay > by) {
            throw new IllegalArgumentException("ax should be <= bx and ay should be <= by");
        }
        return new RectAreaSearcher(ax, ay, bx, by).search();
    }

    public Collection<U> inArea(int ax, int ay, int bx, int by, Predicate<U> criteria) {
        return new RectAreaSearcher(ax, ay, bx, by, criteria).search();
    }

    public Collection<U> inRadius(U u, int radius) {
        if (radius <= 0) {
            throw new IllegalArgumentException("radius should be > 0");
        }
        Position position = this.positionExtractor.apply(u);
        return new RadiusAreaSearcher(position.x, position.y, radius).search();
    }

    public Collection<U> inRadius(int x, int y, int radius) {
        return new RadiusAreaSearcher(x, y, radius).search();
    }

    public Collection<U> inRadius(int x, int y, int radius, Predicate<U> criteria) {
        return new RadiusAreaSearcher(x, y, radius, criteria).search();
    }

    public Collection<U> inRadius(U u, int radius, Predicate<U> criteria) {
        if (radius <= 0) {
            throw new IllegalArgumentException("radius should be > 0");
        }
        Position position = this.positionExtractor.apply(u);
        return new RadiusAreaSearcher(position.x, position.y, radius, criteria).search();
    }

    @Override
    public Iterator<U> iterator() {
        ArrayList items = new ArrayList();
        this.root.addValuesTo(items);
        return items.iterator();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean add(U u) {
        Node node = this.findNodeFor(u);
        Object[] newValues = Arrays.copyOf(node.values, node.values.length + 1);
        newValues[node.values.length] = u;
        node.values = newValues;
        return true;
    }

    private Node findNodeFor(Object o) {
        Node current = this.root;
        boolean xDim = true;
        while (current != null) {
            if (current.values != null) {
                return current;
            }
            Position pos = this.positionExtractor.apply(o);
            current = xDim && pos.x <= current.p || !xDim && pos.y <= current.p ? current.left : current.right;
            xDim = !xDim;
        }
        throw new IllegalStateException("No node with values found!");
    }

    @Override
    public boolean remove(Object o) {
        Node node = this.findNodeFor(o);
        if (node.values.length > 0) {
            int i;
            Object[] replacement = new Object[node.values.length - 1];
            for (i = 0; i < replacement.length && !Objects.equals(node.values[i], o); ++i) {
                replacement[i] = node.values[i];
            }
            if (!Objects.equals(node.values[i], o)) {
                return false;
            }
            while (i < replacement.length) {
                replacement[i] = node.values[i + 1];
                ++i;
            }
            node.values = replacement;
            --this.size;
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean removed = false;
        for (Object o : c) {
            removed |= this.remove(o);
        }
        return removed;
    }

    static class Node {
        Object[] values;
        final int p;
        Node left;
        Node right;

        Node(int p) {
            this.p = p;
        }

        Node(Object[] values) {
            this.p = -1;
            this.values = values;
        }

        <U> void addValuesTo(List<U> dst) {
            if (this.values != null) {
                dst.addAll(Arrays.asList(this.values));
            } else {
                this.left.addValuesTo(dst);
                this.right.addValuesTo(dst);
            }
        }
    }

    class TreeBuilder {
        private final Object[] data;

        TreeBuilder(Object[] data) {
            this.data = data;
        }

        private Position pos(int i) {
            return (Position)PositionQueries.this.positionExtractor.apply(this.data[i]);
        }

        private Pivot partitionX(int start, int end) {
            int mid = (start + end) / 2;
            if (this.pos((int)mid).x < this.pos((int)start).x) {
                this.swap(mid, start);
            }
            if (this.pos((int)end).x < this.pos((int)start).x) {
                this.swap(start, end);
            }
            if (this.pos((int)mid).x < this.pos((int)end).x) {
                this.swap(mid, end);
            }
            int pivot = this.pos((int)end).x;
            while (true) {
                if (start < end && this.pos((int)start).x <= pivot) {
                    ++start;
                    continue;
                }
                while (this.pos((int)end).x > pivot) {
                    --end;
                }
                if (start >= end) {
                    return new Pivot(pivot, end);
                }
                this.swap(start, end);
                ++start;
                --end;
            }
        }

        private Pivot partitionY(int start, int end) {
            int mid = (start + end) / 2;
            if (this.pos((int)mid).y < this.pos((int)start).y) {
                this.swap(mid, start);
            }
            if (this.pos((int)end).y < this.pos((int)start).y) {
                this.swap(start, end);
            }
            if (this.pos((int)mid).y < this.pos((int)end).y) {
                this.swap(mid, end);
            }
            int pivot = this.pos((int)end).y;
            while (true) {
                if (start < end && this.pos((int)start).y <= pivot) {
                    ++start;
                    continue;
                }
                while (this.pos((int)end).y > pivot) {
                    --end;
                }
                if (start >= end) {
                    return new Pivot(pivot, end);
                }
                this.swap(start, end);
                ++start;
                --end;
            }
        }

        private void swap(int a, int b) {
            Object tmp = this.data[a];
            this.data[a] = this.data[b];
            this.data[b] = tmp;
        }

        Node makeTree(int start, int end, boolean xDim) {
            if (end - start < 15) {
                return new Node(Arrays.copyOfRange(this.data, start, end + 1));
            }
            Pivot pivot = xDim ? this.partitionX(start, end) : this.partitionY(start, end);
            if (pivot.index == end) {
                return new Node(Arrays.copyOfRange(this.data, start, end + 1));
            }
            Node mNode = new Node(pivot.value);
            mNode.left = this.makeTree(start, pivot.index, !xDim);
            mNode.right = this.makeTree(pivot.index + 1, end, !xDim);
            return mNode;
        }
    }

    static class Pivot {
        final int value;
        final int index;

        Pivot(int value, int index) {
            this.value = value;
            this.index = index;
        }
    }

    abstract class AreaSearcher {
        final int ax;
        final int ay;
        final int bx;
        final int by;
        private List<U> result = new ArrayList();
        private Predicate<U> criteria;

        AreaSearcher(int ax, int ay, int bx, int by) {
            this.ax = ax;
            this.ay = ay;
            this.bx = bx;
            this.by = by;
        }

        AreaSearcher(int ax, int ay, int bx, int by, Predicate<U> criteria) {
            this(ax, ay, bx, by);
            this.criteria = criteria;
        }

        Collection<U> search() {
            this.searchX(PositionQueries.this.root);
            return this.result;
        }

        private void searchX(Node node) {
            if (node.values != null) {
                this.updateResultFrom(node.values);
                return;
            }
            if (this.ax <= node.p) {
                this.searchY(node.left);
            }
            if (this.bx > node.p) {
                this.searchY(node.right);
            }
        }

        private void updateResultFrom(Object[] values) {
            Object[] objectArray = values;
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                Position pos;
                Object v;
                Object u = v = objectArray[i];
                if (this.criteria != null && !this.criteria.test(u) || !this.accept(pos = (Position)PositionQueries.this.positionExtractor.apply(u))) continue;
                this.result.add(u);
            }
        }

        abstract boolean accept(Position var1);

        private void searchY(Node node) {
            if (node.values != null) {
                this.updateResultFrom(node.values);
                return;
            }
            if (this.ay <= node.p) {
                this.searchX(node.left);
            }
            if (this.by > node.p) {
                this.searchX(node.right);
            }
        }
    }

    class RadiusAreaSearcher
    extends AreaSearcher {
        private final int x;
        private final int y;
        private final int radius;

        RadiusAreaSearcher(int x, int y, int radius) {
            this(x, y, radius, null);
        }

        RadiusAreaSearcher(int x, int y, int radius, Predicate<U> criteria) {
            super(x - radius, y - radius, x + radius, y + radius, criteria);
            this.x = x;
            this.y = y;
            this.radius = radius;
        }

        @Override
        boolean accept(Position pos) {
            return PositionQueries.this.distanceProvider.distance(pos.x, pos.y, this.x, this.y) <= this.radius;
        }
    }

    class RectAreaSearcher
    extends AreaSearcher {
        RectAreaSearcher(int ax, int ay, int bx, int by) {
            super(ax, ay, bx, by);
        }

        RectAreaSearcher(int ax, int ay, int bx, int by, Predicate<U> criteria) {
            super(ax, ay, bx, by, criteria);
        }

        @Override
        boolean accept(Position pos) {
            return pos.x >= this.ax && pos.y >= this.ay && pos.x <= this.bx && pos.y <= this.by;
        }
    }

    class NearestSearcher {
        private Predicate<U> criteria;
        private Object best;
        private int bestDst = Integer.MAX_VALUE;
        private int x;
        private int y;

        NearestSearcher(int x, int y) {
            this.x = x;
            this.y = y;
        }

        NearestSearcher(int x, int y, Predicate<U> criteria) {
            this(x, y);
            this.criteria = criteria;
        }

        U search() {
            this.nearestX(PositionQueries.this.root);
            return this.best;
        }

        private void nearestX(Node node) {
            if (node.values != null) {
                this.updateBestFrom(node.values);
            } else if (this.x <= node.p) {
                this.nearestY(node.left);
                if (node.p - this.x < this.bestDst) {
                    this.nearestY(node.right);
                }
            } else {
                this.nearestY(node.right);
                if (this.x - node.p <= this.bestDst) {
                    this.nearestY(node.left);
                }
            }
        }

        private void nearestY(Node node) {
            if (node.values != null) {
                this.updateBestFrom(node.values);
            } else if (this.y <= node.p) {
                this.nearestX(node.left);
                if (node.p - this.y < this.bestDst) {
                    this.nearestX(node.right);
                }
            } else {
                this.nearestX(node.right);
                if (this.y - node.p <= this.bestDst) {
                    this.nearestX(node.left);
                }
            }
        }

        private void updateBestFrom(Object[] values) {
            Object[] objectArray = values;
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                Object v;
                Object u = v = objectArray[i];
                if (this.criteria != null && !this.criteria.test(u)) continue;
                Position pos = (Position)PositionQueries.this.positionExtractor.apply(u);
                int dst = PositionQueries.this.distanceProvider.distance(pos.x, pos.y, this.x, this.y);
                if (dst >= this.bestDst) continue;
                this.bestDst = dst;
                this.best = v;
            }
        }
    }
}

