/*
 * Decompiled with CFR 0.152.
 */
package org.bk.ass.path;

import org.bk.ass.grid.Grid;

public interface PPMap
extends Grid<Boolean> {
    public short left(int var1, int var2);

    public short down(int var1, int var2);

    public short up(int var1, int var2);

    public short right(int var1, int var2);

    public static PPMap fromBooleanArray(final boolean[][] map) {
        return PPMap.fromMap(new Grid<Boolean>(){

            @Override
            public Boolean get(int x, int y) {
                return y >= 0 && y < map[0].length && x >= 0 && x < map.length && map[x][y];
            }

            @Override
            public int getWidth() {
                return map.length;
            }

            @Override
            public int getHeight() {
                return map[0].length;
            }
        });
    }

    public static PPMap fromMap(final Grid<Boolean> map) {
        int pos;
        final short[][] left = new short[map.getHeight()][map.getWidth()];
        final short[][] right = new short[map.getHeight()][map.getWidth()];
        final short[][] up = new short[map.getHeight()][map.getWidth()];
        final short[][] down = new short[map.getHeight()][map.getWidth()];
        for (int y = 0; y < map.getHeight(); ++y) {
            int x;
            pos = -1;
            for (x = 0; x < map.getWidth(); ++x) {
                left[y][x] = pos;
                if (map.get(x, y).booleanValue()) {
                    if ((!map.get(x - 1, y - 1).booleanValue() || map.get(x, y - 1).booleanValue()) && (!map.get(x - 1, y + 1).booleanValue() || map.get(x, y + 1).booleanValue())) continue;
                    pos = (short)x;
                    continue;
                }
                pos = (short)(-x - 2);
            }
            pos = (short)(-map.getWidth());
            for (x = map.getWidth() - 1; x >= 0; --x) {
                right[y][x] = pos;
                if (map.get(x, y).booleanValue()) {
                    if ((!map.get(x + 1, y - 1).booleanValue() || map.get(x, y - 1).booleanValue()) && (!map.get(x + 1, y + 1).booleanValue() || map.get(x, y + 1).booleanValue())) continue;
                    pos = (short)x;
                    continue;
                }
                pos = (short)(-x);
            }
        }
        for (int x = 0; x < map.getWidth(); ++x) {
            int y;
            pos = -1;
            for (y = 0; y < map.getHeight(); ++y) {
                up[y][x] = pos;
                if (map.get(x, y).booleanValue()) {
                    if ((!map.get(x - 1, y - 1).booleanValue() || map.get(x - 1, y).booleanValue()) && (!map.get(x + 1, y - 1).booleanValue() || map.get(x + 1, y).booleanValue())) continue;
                    pos = (short)y;
                    continue;
                }
                pos = (short)(-y - 2);
            }
            pos = (short)(-map.getHeight());
            for (y = map.getHeight() - 1; y >= 0; --y) {
                down[y][x] = pos;
                if (map.get(x, y).booleanValue()) {
                    if ((!map.get(x - 1, y + 1).booleanValue() || map.get(x - 1, y).booleanValue()) && (!map.get(x + 1, y + 1).booleanValue() || map.get(x + 1, y).booleanValue())) continue;
                    pos = (short)y;
                    continue;
                }
                pos = (short)(-y);
            }
        }
        return new PPMap(){

            @Override
            public short left(int x, int y) {
                return left[y][x];
            }

            @Override
            public short down(int x, int y) {
                return down[y][x];
            }

            @Override
            public short up(int x, int y) {
                return up[y][x];
            }

            @Override
            public short right(int x, int y) {
                return right[y][x];
            }

            @Override
            public Boolean get(int x, int y) {
                return (Boolean)map.get(x, y);
            }

            @Override
            public int getHeight() {
                return map.getHeight();
            }

            @Override
            public int getWidth() {
                return map.getWidth();
            }
        };
    }
}

