/*
 * Decompiled with CFR 0.152.
 */
package org.bk.ass.path;

import java.util.Collections;
import org.bk.ass.grid.Grid;
import org.bk.ass.path.AbstractPathFinder;
import org.bk.ass.path.Position;
import org.bk.ass.path.Result;

public class Jps {
    private final Grid<Boolean> map;

    public Jps(Grid<Boolean> map) {
        this.map = map;
    }

    public Result findPath(Position start, Position end) {
        if (start.equals(end)) {
            return new Result(0.0f, Collections.singletonList(start));
        }
        return new PathFinder(end, this.map).searchFrom(start);
    }

    private static class PathFinder
    extends AbstractPathFinder {
        private final Grid<Boolean> map;

        protected PathFinder(Position target, Grid<Boolean> map) {
            super(target, map);
            this.map = map;
        }

        @Override
        protected Position jumpHorizontal(int px, int py, int dx) {
            assert (dx != 0);
            int x = px + dx;
            int a = (this.map.get(x, py - 1) != false ? 0 : 1) | (this.map.get(x, py + 1) != false ? 0 : 2);
            while (this.map.get(x, py).booleanValue()) {
                int b = (this.map.get(x + dx, py - 1) != false ? 1 : 0) | (this.map.get(x + dx, py + 1) != false ? 2 : 0);
                if (x == this.target.x && py == this.target.y || (a & b) != 0) {
                    return new Position(x, py);
                }
                x += dx;
                a = ~b;
            }
            return null;
        }

        @Override
        protected Position jumpVertical(int px, int py, int dy) {
            assert (dy != 0);
            int y = py + dy;
            int a = (this.map.get(px - 1, y) != false ? 0 : 1) | (this.map.get(px + 1, y) != false ? 0 : 2);
            while (this.map.get(px, y).booleanValue()) {
                int b = (this.map.get(px - 1, y + dy) != false ? 1 : 0) | (this.map.get(px + 1, y + dy) != false ? 2 : 0);
                if (px == this.target.x && y == this.target.y || (a & b) != 0) {
                    return new Position(px, y);
                }
                y += dy;
                a = ~b;
            }
            return null;
        }
    }
}

