/*
 * Decompiled with CFR 0.152.
 */
package org.bk.ass.manage;

import java.util.function.Predicate;
import java.util.function.Supplier;
import org.bk.ass.manage.Reservation;

public class Lock<T> {
    private boolean satisfied;
    private boolean satisfiedLater;
    private boolean changed;
    private T item;
    private Predicate<T> criteria = unused -> true;
    private final Reservation<T> reservation;
    private final Supplier<T> selector;
    private int futureFrame;

    public Lock(Reservation<T> reservation, Supplier<T> selector) {
        this.reservation = reservation;
        this.selector = selector;
    }

    public void setFutureFrame(int futureFrame) {
        this.futureFrame = futureFrame;
    }

    public T getItem() {
        return this.item;
    }

    public boolean isSatisfied() {
        return this.satisfied;
    }

    public boolean isSatisfiedLater() {
        return this.satisfiedLater;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void reacquire() {
        this.reset();
        this.acquire();
    }

    public void release() {
        if (this.item != null) {
            this.reservation.release(this.item);
        }
        this.item = null;
        this.changed = true;
    }

    public void reset() {
        this.item = null;
        this.changed = false;
        this.satisfied = false;
    }

    public void acquire() {
        this.changed = false;
        if (this.item != null && this.criteria.test(this.item) && this.reservation.tryReserve(this.item)) {
            this.satisfied = true;
            this.satisfiedLater = true;
            return;
        }
        this.item = this.selector.get();
        boolean bl = this.satisfied = this.item != null && this.criteria.test(this.item);
        if (this.satisfied) {
            this.changed = true;
            this.satisfiedLater = true;
            boolean reserved = this.reservation.tryReserve(this.item);
            if (!reserved) {
                throw new IllegalStateException("Could not reserve item that was selected!");
            }
        } else {
            this.satisfiedLater = this.reservation.canBeReservedLater(this.item, this.futureFrame);
        }
    }
}

