/*
 * Decompiled with CFR 0.152.
 */
package macro.plan;

import bwapi.Game;
import bwapi.Position;
import bwapi.TilePosition;
import bwapi.Unit;
import bwapi.UnitType;
import info.GameState;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import macro.plan.Plan;
import macro.plan.PlanComparator;
import macro.plan.PlanState;
import macro.plan.PlanType;
import unit.managed.ManagedUnit;
import unit.managed.ManagedUnitToPositionComparator;
import unit.managed.UnitRole;

public class PlanManager {
    private Game game;
    private GameState gameState;
    private HashSet<ManagedUnit> assignedManagedWorkers;
    private HashSet<ManagedUnit> gatherers;
    private HashSet<ManagedUnit> gasGatherers;
    private HashSet<ManagedUnit> larva;
    private HashSet<ManagedUnit> scheduledDrones = new HashSet();

    public PlanManager(Game game, GameState gameState) {
        this.game = game;
        this.gameState = gameState;
        this.gatherers = gameState.getGatherers();
        this.larva = gameState.getLarva();
        this.gasGatherers = gameState.getGasGatherers();
        this.assignedManagedWorkers = gameState.getAssignedManagedWorkers();
    }

    public void onFrame() {
        this.assignScheduledPlannedItems();
        this.executeScheduledDrones();
        this.releaseImpossiblePlans();
    }

    private void assignScheduledPlannedItems() {
        ArrayList<Plan> scheduledPlans = new ArrayList<Plan>(this.gameState.getPlansScheduled());
        if (scheduledPlans.isEmpty()) {
            return;
        }
        Collections.sort(scheduledPlans, new PlanComparator());
        ArrayList<Plan> assignedPlans = new ArrayList<Plan>();
        for (Plan plan : scheduledPlans) {
            UnitType planType = plan.getPlannedUnit();
            boolean didAssign = false;
            if (plan.getType() == PlanType.BUILDING) {
                if (this.isBuildingMorph(planType)) continue;
                didAssign = this.assignMorphDrone(plan);
            } else if (plan.getType() == PlanType.UNIT) {
                didAssign = this.assignMorphUnit(plan);
            }
            if (!didAssign) continue;
            assignedPlans.add(plan);
        }
        HashSet<Plan> buildingPlans = this.gameState.getPlansBuilding();
        for (Plan plan : assignedPlans) {
            scheduledPlans.remove(plan);
            buildingPlans.add(plan);
        }
        this.gameState.setPlansScheduled(new HashSet<Plan>(scheduledPlans));
    }

    private void releaseImpossiblePlans() {
        Plan currentPlan;
        HashSet<Plan> impossiblePlans = this.gameState.getPlansImpossible();
        for (ManagedUnit larva : this.larva) {
            currentPlan = larva.getPlan();
            if (currentPlan == null || !impossiblePlans.contains(currentPlan)) continue;
            this.gameState.cancelPlan(larva.getUnit(), currentPlan);
        }
        for (ManagedUnit drone : this.scheduledDrones) {
            currentPlan = drone.getPlan();
            if (currentPlan == null || !impossiblePlans.contains(currentPlan)) continue;
            this.gameState.cancelPlan(drone.getUnit(), currentPlan);
        }
    }

    private boolean isBuildingMorph(UnitType unitType) {
        switch (unitType) {
            case Zerg_Lair: 
            case Zerg_Sunken_Colony: {
                return true;
            }
        }
        return false;
    }

    private void executeScheduledDrones() {
        int currentFrame = this.game.getFrameCount();
        ArrayList<ManagedUnit> executed = new ArrayList<ManagedUnit>();
        for (ManagedUnit managedUnit : this.scheduledDrones) {
            Plan plan = managedUnit.getPlan();
            int travelFrames = this.getTravelFrames(managedUnit.getUnit(), plan.getBuildPosition().toPosition());
            if (currentFrame <= plan.getPredictedReadyFrame() - travelFrames) continue;
            plan.setState(PlanState.BUILDING);
            managedUnit.setRole(UnitRole.BUILD);
            executed.add(managedUnit);
        }
        for (ManagedUnit managedUnit : executed) {
            this.scheduledDrones.remove(managedUnit);
        }
    }

    private int getTravelFrames(Unit unit, Position buildingPosition) {
        Position unitPosition = unit.getPosition();
        double distance = buildingPosition.getDistance(unitPosition);
        double unitSpeed = unit.getType().topSpeed();
        return (int)(distance / unitSpeed) + 250;
    }

    private boolean assignMorphDrone(Plan plan) {
        List eligibleDrones = this.assignedManagedWorkers.stream().filter(d -> {
            Unit unit = d.getUnit();
            return !unit.isCarrying() && !this.gasGatherers.contains(d) && !this.gameState.getAssignedPlannedItems().containsKey(unit);
        }).collect(Collectors.toList());
        TilePosition buildPosition = plan.getBuildPosition();
        if (buildPosition != null) {
            eligibleDrones.sort(new ManagedUnitToPositionComparator(buildPosition.toPosition()));
        }
        if (eligibleDrones.isEmpty()) {
            return false;
        }
        ManagedUnit managedUnit = (ManagedUnit)eligibleDrones.get(0);
        Unit unit = managedUnit.getUnit();
        this.gameState.clearAssignments(managedUnit);
        this.scheduledDrones.add(managedUnit);
        managedUnit.setPlan(plan);
        this.gameState.getAssignedPlannedItems().put(unit, plan);
        return true;
    }

    private boolean assignMorphUnit(Plan plan) {
        switch (plan.getPlannedUnit()) {
            case Zerg_Lurker: {
                return this.assignMorphHydralisk(plan);
            }
        }
        return this.assignMorphLarva(plan);
    }

    private boolean assignMorphHydralisk(Plan plan) {
        List<ManagedUnit> hydralisks = this.gameState.getManagedUnitsByType(UnitType.Zerg_Hydralisk);
        for (ManagedUnit managedUnit : hydralisks) {
            Unit unit = managedUnit.getUnit();
            if (this.gameState.getAssignedPlannedItems().containsKey(unit)) continue;
            this.gameState.clearAssignments(managedUnit);
            plan.setState(PlanState.MORPHING);
            managedUnit.setRole(UnitRole.MORPH);
            managedUnit.setPlan(plan);
            this.gameState.getAssignedPlannedItems().put(unit, plan);
            return true;
        }
        return false;
    }

    private boolean assignMorphLarva(Plan plan) {
        for (ManagedUnit managedUnit : this.larva) {
            Unit unit = managedUnit.getUnit();
            if (this.gameState.getAssignedPlannedItems().containsKey(unit)) continue;
            this.gameState.clearAssignments(managedUnit);
            plan.setState(PlanState.BUILDING);
            managedUnit.setRole(UnitRole.MORPH);
            managedUnit.setPlan(plan);
            this.gameState.getAssignedPlannedItems().put(unit, plan);
            return true;
        }
        return false;
    }
}

