/*
 * Decompiled with CFR 0.152.
 */
package macro;

import bwapi.Game;
import bwapi.Player;
import bwapi.TechType;
import bwapi.Text;
import bwapi.Unit;
import bwapi.UnitType;
import bwapi.UpgradeType;
import info.BaseData;
import info.GameState;
import info.ResourceCount;
import info.TechProgression;
import info.UnitTypeCount;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.stream.Collectors;
import macro.plan.Plan;
import macro.plan.PlanComparator;
import macro.plan.PlanState;
import macro.plan.PlanType;
import macro.plan.UnitPlan;
import strategy.buildorder.BuildOrder;

public class ProductionManager {
    final int FRAME_ZVZ_HATCH_RESTRICT = 7200;
    private Game game;
    private GameState gameState;
    private boolean isPlanning = false;
    private int scheduledBuildings = 0;
    private int currentFrame = 5;
    private PriorityQueue<Plan> productionQueue = new PriorityQueue<Plan>(new PlanComparator());
    private BuildOrder activeBuildOrder;

    public ProductionManager(Game game, GameState gameState, BuildOrder opener) {
        this.game = game;
        this.gameState = gameState;
        this.activeBuildOrder = opener;
    }

    private void debugProductionQueue() {
        int numDisplayed = 0;
        int x = 4;
        int y = 64;
        for (Plan plan : this.productionQueue) {
            this.game.drawTextScreen(x, y, String.valueOf(plan.getName()) + " " + plan.getPriority(), Text.Green);
            y += 8;
            if (++numDisplayed == 10) break;
        }
        if (numDisplayed < this.productionQueue.size()) {
            this.game.drawTextScreen(x, y, String.format("... %s more planned items", this.productionQueue.size() - numDisplayed), Text.GreyGreen);
        }
    }

    private void debugInProgressQueue() {
        int numDisplayed = 0;
        int x = 100;
        int y = 64;
        for (Plan plan : this.gameState.getAssignedPlannedItems().values()) {
            this.game.drawTextScreen(x, y, String.valueOf(plan.getName()) + " " + plan.getPriority(), Text.Green);
            y += 8;
            if (++numDisplayed == 10) break;
        }
    }

    private void debugScheduledPlannedItems() {
        int numDisplayed = 0;
        int x = 196;
        int y = 64;
        for (Plan plan : this.gameState.getPlansScheduled()) {
            this.game.drawTextScreen(x, y, String.valueOf(plan.getName()) + " " + plan.getPriority(), Text.Green);
            y += 8;
            if (++numDisplayed == 10) break;
        }
    }

    private void debug() {
        this.debugProductionQueue();
        this.debugInProgressQueue();
        this.debugScheduledPlannedItems();
    }

    public void onFrame() {
        this.debug();
        this.currentFrame = this.game.getFrameCount();
        this.transition();
        this.plan();
        this.cancelImpossiblePlans();
        this.schedulePlannedItems();
        this.buildUpgrades();
        this.researchTech();
        for (Unit u : this.game.getAllUnits()) {
            if (!u.getType().isWorker() || !u.isIdle()) continue;
            this.assignUnit(u);
        }
    }

    private void transition() {
        if (this.gameState.isTransitionBuildOrder()) {
            this.activeBuildOrder = this.gameState.getActiveBuildOrder();
        }
    }

    private void cancelImpossiblePlans() {
        ArrayList<Plan> plansToCancel = new ArrayList<Plan>();
        for (Plan plan : this.productionQueue) {
            if (this.canSchedulePlan(plan)) continue;
            plansToCancel.add(plan);
        }
        for (Plan plan : plansToCancel) {
            this.productionQueue.remove(plan);
            this.gameState.setImpossiblePlan(plan);
        }
        this.cancelImpossibleScheduledLurkerPlans();
        this.removePlansWithLaterPrerequisites();
    }

    private void removePlansWithLaterPrerequisites() {
        ArrayList<Plan> plansToRemove = new ArrayList<Plan>();
        ArrayList<Plan> queueList = new ArrayList<Plan>(this.productionQueue);
        int i = 0;
        while (i < queueList.size()) {
            block10: {
                Plan currentPlan = (Plan)queueList.get(i);
                UnitType prerequisite = null;
                switch (currentPlan.getType()) {
                    case UNIT: {
                        prerequisite = this.getPrerequisiteForUnit(currentPlan.getPlannedUnit());
                        break;
                    }
                    case UPGRADE: {
                        prerequisite = this.getPrerequisiteForUpgrade(currentPlan.getPlannedUpgrade());
                        break;
                    }
                    case TECH: {
                        prerequisite = this.getPrerequisiteForTech(currentPlan.getPlannedTechType());
                        break;
                    }
                    default: {
                        break block10;
                    }
                }
                if (prerequisite != null) {
                    int j = i + 1;
                    while (j < queueList.size()) {
                        Plan laterPlan = (Plan)queueList.get(j);
                        if (laterPlan.getType() == PlanType.BUILDING && laterPlan.getPlannedUnit() == prerequisite) {
                            plansToRemove.add(currentPlan);
                            break;
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
        for (Plan plan : plansToRemove) {
            this.productionQueue.remove(plan);
            this.gameState.setImpossiblePlan(plan);
        }
    }

    private UnitType getPrerequisiteForUnit(UnitType unitType) {
        switch (unitType) {
            case Zerg_Zergling: 
            case Zerg_Lair: {
                return UnitType.Zerg_Spawning_Pool;
            }
            case Zerg_Hydralisk: 
            case Zerg_Lurker: {
                return UnitType.Zerg_Hydralisk_Den;
            }
            case Zerg_Mutalisk: 
            case Zerg_Scourge: {
                return UnitType.Zerg_Spire;
            }
            case Zerg_Queen: 
            case Zerg_Hive: {
                return UnitType.Zerg_Queens_Nest;
            }
        }
        return null;
    }

    private UnitType getPrerequisiteForUpgrade(UpgradeType upgradeType) {
        switch (upgradeType) {
            case Metabolic_Boost: {
                return UnitType.Zerg_Spawning_Pool;
            }
            case Muscular_Augments: 
            case Grooved_Spines: {
                return UnitType.Zerg_Hydralisk_Den;
            }
            case Zerg_Carapace: 
            case Zerg_Melee_Attacks: 
            case Zerg_Missile_Attacks: {
                return UnitType.Zerg_Evolution_Chamber;
            }
            case Zerg_Flyer_Carapace: 
            case Zerg_Flyer_Attacks: {
                return UnitType.Zerg_Spire;
            }
            case Pneumatized_Carapace: {
                return UnitType.Zerg_Lair;
            }
        }
        return null;
    }

    private UnitType getPrerequisiteForTech(TechType techType) {
        switch (techType) {
            case Lurker_Aspect: {
                return UnitType.Zerg_Hydralisk_Den;
            }
        }
        return null;
    }

    private void planSupply(Player self) {
        int plannedSupply;
        if (self.supplyUsed() >= 400) {
            return;
        }
        int supplyRemaining = self.supplyTotal() - self.supplyUsed();
        if (supplyRemaining + (plannedSupply = this.gameState.getResourceCount().getPlannedSupply()) < 5) {
            if (this.gameState.getBaseData().numHatcheries() > 3) {
                this.gameState.getResourceCount().setPlannedSupply(plannedSupply + 32);
                this.addUnitToQueue(UnitType.Zerg_Overlord, 1, true);
                this.addUnitToQueue(UnitType.Zerg_Overlord, 1, true);
            } else {
                this.gameState.getResourceCount().setPlannedSupply(plannedSupply + 16);
                this.addUnitToQueue(UnitType.Zerg_Overlord, 1, true);
            }
        }
        if (supplyRemaining == 0 && self.minerals() > 700 && plannedSupply < 80) {
            this.addUnitToQueue(UnitType.Zerg_Overlord, 1, true);
            this.gameState.getResourceCount().setPlannedSupply(plannedSupply + 16);
        }
    }

    private void addUnitToQueue(UnitType unitType, int priority, boolean isBlocking) {
        UnitTypeCount unitTypeCount = this.gameState.getUnitTypeCount();
        this.productionQueue.add(new UnitPlan(unitType, priority, isBlocking));
        unitTypeCount.planUnit(unitType);
    }

    private void plan() {
        if (!this.isPlanning && !this.productionQueue.isEmpty()) {
            return;
        }
        this.isPlanning = true;
        this.planSupply(this.gameState.getSelf());
        List<Plan> plans = this.activeBuildOrder.plan(this.gameState);
        this.productionQueue.addAll(plans);
    }

    private int unitQueueSize() {
        if (this.gameState.getBaseData().numHatcheries() > 3) {
            return 6;
        }
        return 3;
    }

    private boolean canSchedulePlan(Plan plan) {
        switch (plan.getType()) {
            case UNIT: {
                return this.canScheduleUnit(plan.getPlannedUnit());
            }
            case BUILDING: {
                return this.canScheduleBuilding(plan.getPlannedUnit());
            }
            case UPGRADE: {
                return this.canScheduleUpgrade(plan.getPlannedUpgrade());
            }
            case TECH: {
                return this.canScheduleTech(plan.getPlannedTechType());
            }
        }
        return false;
    }

    private boolean canScheduleUnit(UnitType unitType) {
        TechProgression techProgression = this.gameState.getTechProgression();
        boolean hasFourOrMoreDrones = this.gameState.numGatherers() > 3;
        int numHatcheries = this.gameState.getBaseData().numHatcheries();
        switch (unitType) {
            case Zerg_Drone: 
            case Zerg_Overlord: {
                return numHatcheries > 0;
            }
            case Zerg_Zergling: {
                return techProgression.isPlannedSpawningPool() || techProgression.isSpawningPool();
            }
            case Zerg_Hydralisk: {
                return hasFourOrMoreDrones && (techProgression.isPlannedDen() || techProgression.isHydraliskDen());
            }
            case Zerg_Lurker: {
                if (!hasFourOrMoreDrones || !techProgression.isPlannedLurker() && !techProgression.isLurker()) {
                    return false;
                }
                int hydraliskCount = this.gameState.ourUnitCount(UnitType.Zerg_Hydralisk);
                int assignedHydralisks = 0;
                for (Map.Entry<Unit, Plan> entry : this.gameState.getAssignedPlannedItems().entrySet()) {
                    if (entry.getKey().getType() != UnitType.Zerg_Hydralisk || entry.getValue().getPlannedUnit() != UnitType.Zerg_Lurker) continue;
                    ++assignedHydralisks;
                }
                return hydraliskCount > assignedHydralisks;
            }
            case Zerg_Mutalisk: 
            case Zerg_Scourge: {
                return hasFourOrMoreDrones && (techProgression.isPlannedSpire() || techProgression.isSpire());
            }
        }
        return false;
    }

    private boolean canScheduleBuilding(UnitType unitType) {
        TechProgression techProgression = this.gameState.getTechProgression();
        int numHatcheries = this.gameState.getBaseData().numHatcheries();
        switch (unitType) {
            case Zerg_Hatchery: 
            case Zerg_Creep_Colony: 
            case Zerg_Extractor: {
                return true;
            }
            case Zerg_Spawning_Pool: {
                return numHatcheries > 0;
            }
            case Zerg_Hydralisk_Den: 
            case Zerg_Evolution_Chamber: 
            case Zerg_Sunken_Colony: {
                return techProgression.isSpawningPool();
            }
            case Zerg_Lair: {
                return numHatcheries > 0 && techProgression.isSpawningPool();
            }
            case Zerg_Queens_Nest: 
            case Zerg_Spire: {
                return techProgression.isLair();
            }
            case Zerg_Hive: {
                return techProgression.isLair() && techProgression.isQueensNest();
            }
        }
        return false;
    }

    private boolean canScheduleTech(TechType techType) {
        TechProgression techProgression = this.gameState.getTechProgression();
        switch (techType) {
            case Lurker_Aspect: {
                return techProgression.isHydraliskDen();
            }
        }
        return false;
    }

    private boolean canScheduleUpgrade(UpgradeType upgradeType) {
        TechProgression techProgression = this.gameState.getTechProgression();
        switch (upgradeType) {
            case Metabolic_Boost: {
                return techProgression.isSpawningPool();
            }
            case Muscular_Augments: 
            case Grooved_Spines: {
                return techProgression.isHydraliskDen();
            }
            case Zerg_Carapace: 
            case Zerg_Melee_Attacks: 
            case Zerg_Missile_Attacks: {
                return techProgression.getEvolutionChambers() > 0;
            }
            case Zerg_Flyer_Carapace: 
            case Zerg_Flyer_Attacks: {
                return techProgression.isSpire();
            }
            case Pneumatized_Carapace: {
                return techProgression.isLair();
            }
        }
        return false;
    }

    private void schedulePlannedItems() {
        if (this.productionQueue.isEmpty()) {
            return;
        }
        this.reprioritizeHatcheriesForLarvaConstraint();
        Player self = this.game.self();
        HashSet<Plan> scheduledPlans = this.gameState.getPlansScheduled();
        ArrayList<Plan> requeuePlans = new ArrayList<Plan>();
        ResourceCount resourceCount = this.gameState.getResourceCount();
        int mineralBuffer = resourceCount.availableMinerals();
        int i = 0;
        while (i < this.productionQueue.size()) {
            boolean canSchedule = false;
            Plan plan = this.productionQueue.poll();
            if (plan != null) {
                if (!this.canSchedulePlan(plan)) {
                    this.gameState.setImpossiblePlan(plan);
                } else {
                    PlanType planType = plan.getType();
                    switch (planType) {
                        case BUILDING: {
                            canSchedule = this.scheduleBuildingItem(plan);
                            break;
                        }
                        case UNIT: {
                            canSchedule = this.scheduleUnitItem(plan);
                            break;
                        }
                        case UPGRADE: {
                            canSchedule = this.scheduleUpgradeItem(self, plan);
                            break;
                        }
                        case TECH: {
                            canSchedule = this.scheduleResearch(plan);
                        }
                    }
                    if (canSchedule) {
                        scheduledPlans.add(plan);
                    } else {
                        requeuePlans.add(plan);
                        if (plan.isBlockOtherPlans() || (mineralBuffer -= plan.mineralPrice()) <= 0) break;
                    }
                }
            }
            ++i;
        }
        this.productionQueue.addAll(requeuePlans);
    }

    private void buildUpgrades() {
        HashSet<Plan> scheduledPlans = this.gameState.getPlansScheduled();
        if (scheduledPlans.isEmpty()) {
            return;
        }
        HashSet<Unit> unitsExecutingPlan = new HashSet<Unit>();
        List scheduledUpgradeAssignments = this.gameState.getAssignedPlannedItems().entrySet().stream().filter(assignment -> ((Plan)assignment.getValue()).getType() == PlanType.UPGRADE).collect(Collectors.toList());
        for (Map.Entry entry : scheduledUpgradeAssignments) {
            Plan plan;
            Unit unit = (Unit)entry.getKey();
            if (!this.buildUpgrade(unit, plan = (Plan)entry.getValue())) continue;
            unitsExecutingPlan.add(unit);
            scheduledPlans.remove(plan);
            plan.setState(PlanState.BUILDING);
            this.gameState.getPlansBuilding().add(plan);
        }
        for (Unit u : unitsExecutingPlan) {
            this.gameState.getAssignedPlannedItems().remove(u);
        }
    }

    private void researchTech() {
        HashSet<Plan> scheduledPlans = this.gameState.getPlansScheduled();
        if (scheduledPlans.isEmpty()) {
            return;
        }
        HashSet<Unit> unitsExecutingPlan = new HashSet<Unit>();
        List scheduledTechResearch = this.gameState.getAssignedPlannedItems().entrySet().stream().filter(assignment -> ((Plan)assignment.getValue()).getType() == PlanType.TECH).collect(Collectors.toList());
        for (Map.Entry entry : scheduledTechResearch) {
            Plan plan;
            Unit unit = (Unit)entry.getKey();
            if (!this.researchTech(unit, plan = (Plan)entry.getValue())) continue;
            unitsExecutingPlan.add(unit);
            scheduledPlans.remove(plan);
            plan.setState(PlanState.BUILDING);
            this.gameState.getPlansBuilding().add(plan);
        }
        for (Unit u : unitsExecutingPlan) {
            this.gameState.getAssignedPlannedItems().remove(u);
        }
    }

    private void plannedItemToMorphing(Plan plan) {
        UnitType unitType = plan.getPlannedUnit();
        ResourceCount resourceCount = this.gameState.getResourceCount();
        resourceCount.unreserveUnit(unitType);
        if (unitType == UnitType.Zerg_Drone) {
            this.gameState.removePlannedWorker(1);
        }
        if (unitType.isBuilding()) {
            --this.scheduledBuildings;
        }
        TechProgression techProgression = this.gameState.getTechProgression();
        switch (unitType) {
            case Zerg_Hydralisk_Den: {
                techProgression.setHydraliskDen(true);
                techProgression.setPlannedDen(false);
                break;
            }
            case Zerg_Spawning_Pool: {
                techProgression.setSpawningPool(true);
                techProgression.setPlannedSpawningPool(false);
                break;
            }
            case Zerg_Lair: {
                techProgression.setLair(true);
                techProgression.setPlannedLair(false);
                break;
            }
            case Zerg_Spire: {
                techProgression.setSpire(true);
                techProgression.setPlannedSpire(false);
                break;
            }
            case Zerg_Queens_Nest: {
                techProgression.setQueensNest(true);
                techProgression.setPlannedQueensNest(false);
            }
            case Zerg_Hive: {
                techProgression.setHive(true);
                techProgression.setPlannedHive(false);
            }
        }
        this.gameState.getPlansBuilding().remove(plan);
        plan.setState(PlanState.MORPHING);
        this.gameState.getPlansMorphing().add(plan);
    }

    private boolean buildUpgrade(Unit unit, Plan plan) {
        UpgradeType upgradeType = plan.getPlannedUpgrade();
        if (this.game.canUpgrade(upgradeType, unit)) {
            unit.upgrade(upgradeType);
        }
        ResourceCount resourceCount = this.gameState.getResourceCount();
        TechProgression techProgression = this.gameState.getTechProgression();
        if (unit.isUpgrading()) {
            resourceCount.unreserveUpgrade(upgradeType);
            techProgression.upgradeTech(upgradeType);
            return true;
        }
        return false;
    }

    private boolean researchTech(Unit unit, Plan plan) {
        TechType techType = plan.getPlannedTechType();
        if (this.game.canResearch(techType, unit)) {
            unit.research(techType);
        }
        ResourceCount resourceCount = this.gameState.getResourceCount();
        TechProgression techProgression = this.gameState.getTechProgression();
        if (unit.isResearching()) {
            resourceCount.unreserveTechResearch(techType);
            techProgression.upgradeTech(techType);
            return true;
        }
        return false;
    }

    private boolean scheduleBuildingItem(Plan plan) {
        UnitType building = plan.getPlannedUnit();
        ResourceCount resourceCount = this.gameState.getResourceCount();
        int predictedReadyFrame = this.gameState.frameCanAffordUnit(building, this.currentFrame);
        if (this.scheduledBuildings > 0 && resourceCount.canAffordUnit(building)) {
            return false;
        }
        if (plan.getBuildPosition() == null) {
            plan.setBuildPosition(this.game.getBuildLocation(building, this.gameState.getBaseData().mainBasePosition(), 128, true));
        }
        ++this.scheduledBuildings;
        resourceCount.reserveUnit(building);
        plan.setPredictedReadyFrame(predictedReadyFrame);
        plan.setState(PlanState.SCHEDULE);
        return true;
    }

    private boolean scheduleUnitItem(Plan plan) {
        UnitType unit = plan.getPlannedUnit();
        ResourceCount resourceCount = this.gameState.getResourceCount();
        if (resourceCount.canAffordUnit(unit)) {
            return false;
        }
        if (!resourceCount.canScheduleLarva(this.gameState.numLarva())) {
            return false;
        }
        resourceCount.reserveUnit(unit);
        plan.setState(PlanState.SCHEDULE);
        return true;
    }

    private boolean scheduleUpgradeItem(Player self, Plan plan) {
        UpgradeType upgrade = plan.getPlannedUpgrade();
        ResourceCount resourceCount = this.gameState.getResourceCount();
        if (resourceCount.canAffordUpgrade(upgrade)) {
            return false;
        }
        Unit nextAvailable = null;
        for (Unit unit : self.getUnits()) {
            UnitType unitType = unit.getType();
            if (unitType != upgrade.whatUpgrades()) continue;
            if (nextAvailable == null) {
                nextAvailable = unit;
            }
            if (!unit.isUpgrading() && !this.gameState.getAssignedPlannedItems().containsKey(unit)) {
                this.gameState.getAssignedPlannedItems().put(unit, plan);
                plan.setState(PlanState.SCHEDULE);
                resourceCount.reserveUpgrade(upgrade);
                return true;
            }
            if (unit.getRemainingUpgradeTime() <= nextAvailable.getRemainingUpgradeTime()) continue;
            nextAvailable = unit;
        }
        if (nextAvailable != null) {
            int priority = plan.getPriority();
            plan.setPriority(priority + nextAvailable.getRemainingUpgradeTime());
        }
        return false;
    }

    private boolean scheduleResearch(Plan plan) {
        TechType techType = plan.getPlannedTechType();
        ResourceCount resourceCount = this.gameState.getResourceCount();
        if (resourceCount.canAffordResearch(techType)) {
            return false;
        }
        Unit nextAvailable = null;
        for (Unit unit : this.game.self().getUnits()) {
            UnitType unitType = unit.getType();
            if (unitType != techType.whatResearches()) continue;
            if (nextAvailable == null) {
                nextAvailable = unit;
            }
            if (!unit.isUpgrading() && !this.gameState.getAssignedPlannedItems().containsKey(unit)) {
                this.gameState.getAssignedPlannedItems().put(unit, plan);
                plan.setState(PlanState.SCHEDULE);
                resourceCount.reserveTechResearch(techType);
                return true;
            }
            if (unit.getRemainingUpgradeTime() <= nextAvailable.getRemainingUpgradeTime()) continue;
            nextAvailable = unit;
        }
        if (nextAvailable != null) {
            int priority = plan.getPriority();
            plan.setPriority(priority + nextAvailable.getRemainingUpgradeTime());
        }
        return false;
    }

    private void reprioritizeHatcheriesForLarvaConstraint() {
        if (this.gameState.numLarva() > 0) {
            return;
        }
        if (this.gameState.getResourceCount().availableMinerals() < 300) {
            return;
        }
        Plan priorityHatcheryPlan = null;
        int highestPriority = Integer.MAX_VALUE;
        for (Plan plan : this.productionQueue) {
            if (plan.getType() != PlanType.BUILDING || plan.getPlannedUnit() != UnitType.Zerg_Hatchery || plan.getPriority() >= highestPriority) continue;
            highestPriority = plan.getPriority();
            priorityHatcheryPlan = plan;
        }
        if (priorityHatcheryPlan != null && highestPriority > 0) {
            priorityHatcheryPlan.setPriority(0);
        }
    }

    public void onUnitComplete(Unit unit) {
        this.assignUnit(unit);
    }

    private void assignUnit(Unit unit) {
        Player self = this.game.self();
        if (unit.getPlayer() != self) {
            return;
        }
        UnitType unitType = unit.getType();
        if (unitType == UnitType.Zerg_Extractor) {
            this.gameState.getGeyserAssignments().put(unit, new HashSet());
        }
        if (unitType == UnitType.Zerg_Overlord) {
            this.gameState.getResourceCount().setPlannedSupply(Math.max(0, this.gameState.getResourceCount().getPlannedSupply() - unitType.supplyProvided()));
        }
        if (unitType == UnitType.Zerg_Hatchery) {
            BaseData baseData = this.gameState.getBaseData();
            if (baseData.isBaseTilePosition(unit.getTilePosition())) {
                this.gameState.claimBase(unit);
            } else {
                this.gameState.addMacroHatchery(unit);
            }
            this.gameState.removePlannedHatchery(1);
            if (this.gameState.getPlannedHatcheries() < 0) {
                this.gameState.setPlannedHatcheries(0);
            }
        }
    }

    public void onUnitMorph(Unit unit) {
        UnitType unitType = unit.getType();
        HashMap<Unit, Plan> assignedPlannedItems = this.gameState.getAssignedPlannedItems();
        if (assignedPlannedItems.containsKey(unit)) {
            Plan plan = this.gameState.getAssignedPlannedItems().get(unit);
            this.plannedItemToMorphing(plan);
        }
        this.clearAssignments(unit, false);
    }

    public void onUnitRenegade(Unit unit) {
        Player self = this.game.self();
        if (unit.getPlayer() != self) {
            return;
        }
        UnitType unitType = unit.getType();
        if (unitType == UnitType.Zerg_Extractor) {
            ResourceCount resourceCount = this.gameState.getResourceCount();
            resourceCount.unreserveUnit(unitType);
            this.clearAssignments(unit, false);
        }
    }

    public void onUnitDestroy(Unit unit) {
        Player self = this.game.self();
        if (unit.getPlayer() != self) {
            return;
        }
        this.clearAssignments(unit, true);
    }

    private void clearAssignments(Unit unit, boolean isDestroyed) {
        if (this.gameState.getAssignedPlannedItems().containsKey(unit)) {
            Plan plan = this.gameState.getAssignedPlannedItems().get(unit);
            switch (plan.getState()) {
                case BUILDING: {
                    if (isDestroyed) {
                        this.gameState.cancelPlan(unit, plan);
                    } else {
                        this.gameState.completePlan(unit, plan);
                    }
                }
                case SCHEDULE: {
                    this.gameState.cancelPlan(unit, plan);
                    break;
                }
                default: {
                    this.gameState.completePlan(unit, plan);
                }
            }
        }
    }

    private void cancelImpossibleScheduledLurkerPlans() {
        Set lurkerPlans = this.gameState.getPlansScheduled().stream().filter(plan -> plan.getType() == PlanType.UNIT && plan.getPlannedUnit() == UnitType.Zerg_Lurker).collect(Collectors.toSet());
        int hydraliskCount = this.gameState.getUnitTypeCount().livingCount(UnitType.Zerg_Hydralisk);
        int lurkerPlanCount = lurkerPlans.size();
        if (hydraliskCount == 0 || lurkerPlanCount > hydraliskCount) {
            for (Plan plan2 : lurkerPlans) {
                this.gameState.getPlansScheduled().remove(plan2);
                this.gameState.cancelPlan(null, plan2);
            }
        }
    }
}

