/*
 * Decompiled with CFR 0.152.
 */
package learning;

import learning.UCBRecord;
import lombok.Generated;

public class DefensiveSunkRecord
implements UCBRecord {
    private int wins;
    private int losses;

    public int netWins() {
        return this.wins - this.losses;
    }

    @Override
    public int wins() {
        return this.wins;
    }

    @Override
    public int games() {
        return this.wins + this.losses;
    }

    @Override
    public int winsSquared() {
        return this.wins * this.wins;
    }

    @Override
    public double index(int totalGames) {
        if (totalGames == 0 || this.games() == 0) {
            return 2.0;
        }
        double sampleMean = this.wins() / this.games();
        double c = Math.sqrt(2.0 * Math.log(totalGames) / (double)this.games());
        return sampleMean + c;
    }

    @Generated
    DefensiveSunkRecord(int wins, int losses) {
        this.wins = wins;
        this.losses = losses;
    }

    @Generated
    public static DefensiveSunkRecordBuilder builder() {
        return new DefensiveSunkRecordBuilder();
    }

    @Generated
    public int getWins() {
        return this.wins;
    }

    @Generated
    public int getLosses() {
        return this.losses;
    }

    @Generated
    public void setWins(int wins) {
        this.wins = wins;
    }

    @Generated
    public void setLosses(int losses) {
        this.losses = losses;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefensiveSunkRecord)) {
            return false;
        }
        DefensiveSunkRecord other = (DefensiveSunkRecord)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getWins() != other.getWins()) {
            return false;
        }
        return this.getLosses() == other.getLosses();
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DefensiveSunkRecord;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getWins();
        result = result * 59 + this.getLosses();
        return result;
    }

    @Generated
    public String toString() {
        return "DefensiveSunkRecord(wins=" + this.getWins() + ", losses=" + this.getLosses() + ")";
    }

    @Generated
    public static class DefensiveSunkRecordBuilder {
        @Generated
        private int wins;
        @Generated
        private int losses;

        @Generated
        DefensiveSunkRecordBuilder() {
        }

        @Generated
        public DefensiveSunkRecordBuilder wins(int wins) {
            this.wins = wins;
            return this;
        }

        @Generated
        public DefensiveSunkRecordBuilder losses(int losses) {
            this.losses = losses;
            return this;
        }

        @Generated
        public DefensiveSunkRecord build() {
            return new DefensiveSunkRecord(this.wins, this.losses);
        }

        @Generated
        public String toString() {
            return "DefensiveSunkRecord.DefensiveSunkRecordBuilder(wins=" + this.wins + ", losses=" + this.losses + ")";
        }
    }
}

