/*
 * Decompiled with CFR 0.152.
 */
package info.map;

import bwapi.TilePosition;
import info.exception.NoWalkablePathException;
import info.map.GroundPath;
import info.map.MapTile;
import info.map.MapTileFScoreComparator;
import info.map.MapTileScoutImportanceComparator;
import info.map.MapTileType;
import info.map.ScoutPath;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import lombok.Generated;

public class GameMap {
    private int x;
    private int y;
    private ArrayList<MapTile> heatMap = new ArrayList();
    private MapTile[][] mapTiles;

    public GameMap(int x, int y) {
        this.mapTiles = new MapTile[x][y];
        this.x = x;
        this.y = y;
    }

    public void addTile(MapTile tile, int x, int y) {
        this.mapTiles[x][y] = tile;
        this.heatMap.add(tile);
    }

    public MapTile get(int x, int y) {
        return this.mapTiles[x][y];
    }

    public void ageHeatMap() {
        int weight = 1;
        for (MapTile mapTile : this.heatMap) {
            if (mapTile.getType() == MapTileType.BASE_START) {
                weight = 3;
            } else if (mapTile.getType() == MapTileType.BASE_EXPANSION) {
                weight = 2;
            } else if (mapTile.getType() == MapTileType.NORMAL) {
                weight = 1;
            }
            mapTile.setScoutImportance(mapTile.getScoutImportance() + weight);
        }
        Collections.sort(this.heatMap, new MapTileScoutImportanceComparator());
    }

    public GroundPath aStarSearch(MapTile start, MapTile end) throws NoWalkablePathException {
        HashMap<MapTile, MapTile> cameFrom = new HashMap<MapTile, MapTile>();
        HashMap<MapTile, Integer> gScore = new HashMap<MapTile, Integer>();
        HashMap<MapTile, Integer> fScore = new HashMap<MapTile, Integer>();
        gScore.put(start, 0);
        fScore.put(start, this.calculateH(start, end));
        PriorityQueue<MapTile> openSet = new PriorityQueue<MapTile>(new MapTileFScoreComparator(fScore));
        openSet.add(start);
        while (!openSet.isEmpty()) {
            MapTile current = openSet.poll();
            if (current == end) {
                return this.reconstructPath(cameFrom, current);
            }
            List<MapTile> neighbors = this.getNeighbors(current);
            for (MapTile n : neighbors) {
                int neighborG = Integer.MAX_VALUE;
                int currentG = (Integer)gScore.get(current);
                int tentativeGScore = this.calculateG(current, n, currentG);
                if (gScore.containsKey(n)) {
                    neighborG = (Integer)gScore.get(n);
                }
                if (tentativeGScore >= neighborG) continue;
                cameFrom.put(n, current);
                gScore.put(n, tentativeGScore);
                fScore.put(n, this.calculateH(n, end));
                if (openSet.contains(n)) continue;
                openSet.add(n);
            }
        }
        throw new NoWalkablePathException("no walkable path exists");
    }

    public GroundPath aStarSearch(TilePosition start, TilePosition end) throws NoWalkablePathException {
        MapTile startTile = this.mapTiles[start.getX()][start.getY()];
        MapTile endTile = this.mapTiles[end.getX()][end.getY()];
        return this.aStarSearch(startTile, endTile);
    }

    public ScoutPath findScoutPath(TilePosition center) {
        ArrayList<TilePosition> points = new ArrayList<TilePosition>();
        TilePosition north = center.add(new TilePosition(0, Math.max(0, center.getY()) - 7));
        TilePosition east = center.add(new TilePosition(Math.min(this.x, center.getX()) + 7, 0));
        TilePosition south = center.add(new TilePosition(0, Math.min(this.y, center.getY()) + 7));
        TilePosition west = center.add(new TilePosition(Math.max(0, center.getX()) - 7, 0));
        points.add(north);
        points.add(east);
        points.add(south);
        points.add(west);
        return new ScoutPath(points);
    }

    private int calculateG(MapTile current, MapTile target, int currentG) {
        return currentG + (int)target.getTile().getDistance(current.getTile());
    }

    private int calculateH(MapTile current, MapTile destination) {
        return (int)destination.getTile().getDistance(current.getTile());
    }

    private GroundPath reconstructPath(Map<MapTile, MapTile> cameFrom, MapTile current) {
        ArrayDeque<MapTile> path = new ArrayDeque<MapTile>();
        path.add(current);
        while (cameFrom.containsKey(current)) {
            current = cameFrom.get(current);
            path.addFirst(current);
        }
        return new GroundPath(path);
    }

    private List<MapTile> getNeighbors(MapTile current) {
        MapTile sw;
        MapTile se;
        MapTile nw;
        MapTile ne;
        MapTile east;
        MapTile west;
        MapTile south;
        MapTile north;
        ArrayList<MapTile> neighbors = new ArrayList<MapTile>();
        int currentX = current.getX();
        int currentY = current.getY();
        boolean northWalkable = false;
        boolean southWalkable = false;
        boolean eastWalkable = false;
        boolean westWalkable = false;
        if (this.isValidTile(currentX, currentY + 1) && (north = this.mapTiles[currentX][currentY + 1]).isWalkable()) {
            neighbors.add(north);
            northWalkable = true;
        }
        if (this.isValidTile(currentX, currentY - 1) && (south = this.mapTiles[currentX][currentY - 1]).isWalkable()) {
            neighbors.add(south);
            southWalkable = true;
        }
        if (this.isValidTile(currentX - 1, currentY) && (west = this.mapTiles[currentX - 1][currentY]).isWalkable()) {
            neighbors.add(west);
            westWalkable = true;
        }
        if (this.isValidTile(currentX + 1, currentY) && (east = this.mapTiles[currentX + 1][currentY]).isWalkable()) {
            neighbors.add(east);
            eastWalkable = true;
        }
        if (this.isValidTile(currentX + 1, currentY + 1) && (ne = this.mapTiles[currentX + 1][currentY + 1]).isWalkable() && (northWalkable || eastWalkable)) {
            neighbors.add(ne);
        }
        if (this.isValidTile(currentX - 1, currentY + 1) && (nw = this.mapTiles[currentX - 1][currentY + 1]).isWalkable() && (northWalkable || westWalkable)) {
            neighbors.add(nw);
        }
        if (this.isValidTile(currentX + 1, currentY - 1) && (se = this.mapTiles[currentX + 1][currentY - 1]).isWalkable() && (southWalkable || eastWalkable)) {
            neighbors.add(se);
        }
        if (this.isValidTile(currentX - 1, currentY - 1) && (sw = this.mapTiles[currentX - 1][currentY - 1]).isWalkable() && (southWalkable || westWalkable)) {
            neighbors.add(sw);
        }
        return neighbors;
    }

    private boolean isValidTile(int x, int y) {
        return x >= 0 && x < this.x && y >= 0 && y < this.y;
    }

    @Generated
    public ArrayList<MapTile> getHeatMap() {
        return this.heatMap;
    }
}

