/*
 * Decompiled with CFR 0.152.
 */
package info.map;

import bwapi.Color;
import bwapi.Game;
import bwapi.Point;
import bwapi.Position;
import bwapi.Race;
import bwapi.TilePosition;
import bwapi.Unit;
import bwapi.UnitType;
import bwem.BWEM;
import bwem.Base;
import bwem.ChokePoint;
import bwem.Geyser;
import bwem.Mineral;
import info.BaseData;
import info.map.GameMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import util.TilePositionComparator;

public class BuildingPlanner {
    private Game game;
    private BWEM bwem;
    private GameMap gameMap;
    private HashSet<TilePosition> reservedTiles = new HashSet();

    public BuildingPlanner(Game game, BWEM bwem, GameMap gameMap) {
        this.game = game;
        this.bwem = bwem;
        this.gameMap = gameMap;
    }

    public void debugBaseCreepTiles(Base base) {
        Set<TilePosition> creepTiles = this.findSurroundingCreepTiles(base);
        for (TilePosition tp : creepTiles) {
            this.game.drawBoxMap(tp.toPosition(), tp.add(new TilePosition(1, 1)).toPosition(), Color.Brown);
        }
    }

    public void debugBaseChoke(Base base) {
        Set<TilePosition> creepTiles = this.findSurroundingCreepTiles(base);
        Position closestChoke = this.closestChokeToBase(base);
        this.game.drawCircleMap(closestChoke, 2, Color.Yellow);
        List farthestFromChoke = creepTiles.stream().collect(Collectors.toList());
        farthestFromChoke.sort(new TilePositionComparator(closestChoke.toTilePosition()));
    }

    public void debugLocationForTechBuilding(Base base, UnitType unitType) {
        if (base == null) {
            return;
        }
        TilePosition tp = this.getLocationForTechBuilding(base, unitType);
        this.game.drawBoxMap(tp.toPosition(), tp.add(unitType.tileSize()).toPosition(), Color.White);
    }

    public void debugReserveTiles() {
        for (TilePosition tp : this.reservedTiles) {
            this.game.drawBoxMap(tp.toPosition(), tp.add(new TilePosition(1, 1)).toPosition(), Color.White);
        }
    }

    public void debugNextCreepColonyLocation(Base base) {
        TilePosition cc = this.getLocationForCreepColony(base, this.game.enemy().getRace());
        if (cc != null) {
            this.game.drawBoxMap(cc.toPosition(), cc.add(new TilePosition(2, 2)).toPosition(), Color.White);
        }
    }

    public void debugMineralBoundingBox(Base base) {
        HashSet<TilePosition> tiles = this.mineralBoundingBox(base);
        if (!tiles.isEmpty()) {
            for (TilePosition tp : tiles) {
                if (tp == null) continue;
                this.game.drawBoxMap(tp.toPosition(), tp.add(new TilePosition(1, 1)).toPosition(), Color.Blue);
            }
        }
    }

    public void debugGeyserBoundingBox(Base base) {
        HashSet<TilePosition> tiles = this.geyserBoundingBox(base);
        if (!tiles.isEmpty()) {
            for (TilePosition tp : tiles) {
                if (tp == null) continue;
                this.game.drawBoxMap(tp.toPosition(), tp.add(new TilePosition(1, 1)).toPosition(), Color.Blue);
            }
        }
    }

    public void debugMacroHatcheryLocation(Race opponentRace, BaseData baseData) {
        TilePosition location = this.getLocationForMacroHatchery(opponentRace, baseData);
        if (location != null) {
            UnitType hatchType = UnitType.Zerg_Hatchery;
            this.game.drawBoxMap(location.toPosition(), location.add(hatchType.tileSize()).toPosition(), Color.Green);
        }
    }

    public TilePosition getLocationForTechBuilding(Base base, UnitType unitType) {
        Position closestChoke = this.closestChokeToBase(base);
        Set<TilePosition> creepTiles = this.findSurroundingCreepTiles(base);
        TilePosition tileSize = unitType.tileSize();
        ArrayList<TilePosition> farthestFromChoke = new ArrayList<TilePosition>(creepTiles);
        farthestFromChoke.sort(new TilePositionComparator(closestChoke.toTilePosition()));
        TilePosition best = null;
        for (TilePosition northWestCandidate : creepTiles) {
            TilePosition southEastCandidate = northWestCandidate.add(tileSize);
            if (!creepTiles.contains(southEastCandidate) || !this.isValidBuildingLocation(northWestCandidate, tileSize, creepTiles)) continue;
            if (best == null) {
                best = northWestCandidate;
            }
            if (!(northWestCandidate.getDistance(closestChoke.toTilePosition()) > best.getDistance(closestChoke.toTilePosition()))) continue;
            best = northWestCandidate;
        }
        return best;
    }

    public void reserveBuildingTiles(Unit unit) {
        TilePosition candidate = unit.getTilePosition();
        TilePosition tileSize = unit.getType().tileSize();
        int dx = 0;
        while (dx < tileSize.getX()) {
            int dy = 0;
            while (dy < tileSize.getY()) {
                TilePosition currentTile = candidate.add(new TilePosition(dx, dy));
                this.reservedTiles.add(currentTile);
                ++dy;
            }
            ++dx;
        }
    }

    public void removeBuildingTiles(Unit unit) {
        TilePosition candidate = unit.getTilePosition();
        TilePosition tileSize = unit.getType().tileSize();
        int dx = 0;
        while (dx < tileSize.getX()) {
            int dy = 0;
            while (dy < tileSize.getY()) {
                TilePosition currentTile = candidate.add(new TilePosition(dx, dy));
                this.reservedTiles.remove(currentTile);
                ++dy;
            }
            ++dx;
        }
    }

    private boolean isValidBuildingLocation(TilePosition candidate, TilePosition tileSize, Set<TilePosition> creepTiles) {
        int dx = 0;
        while (dx < tileSize.getX()) {
            int dy = 0;
            while (dy < tileSize.getY()) {
                TilePosition currentTile = candidate.add(new TilePosition(dx, dy));
                if (!creepTiles.contains(currentTile) || this.reservedTiles.contains(currentTile)) {
                    return false;
                }
                ++dy;
            }
            ++dx;
        }
        return true;
    }

    private Position closestChokeToBase(Base base) {
        Position closestChoke = null;
        for (ChokePoint cp : this.bwem.getMap().getChokePoints()) {
            Position cpp = cp.getCenter().toPosition();
            if (closestChoke == null) {
                closestChoke = cpp;
                continue;
            }
            Position basePosition = base.getLocation().toPosition();
            if (!(basePosition.getDistance(cpp) < basePosition.getDistance(closestChoke))) continue;
            closestChoke = cpp;
        }
        return closestChoke;
    }

    private HashSet<TilePosition> geyserBoundingBox(Base base) {
        Point topLeft = null;
        Point bottomRight = null;
        for (Geyser geyser : base.getGeysers()) {
            TilePosition geyserTopLeft = geyser.getTopLeft();
            TilePosition geyserBottomRight = geyser.getBottomRight();
            this.game.drawBoxMap(geyserTopLeft.toPosition(), geyserBottomRight.toPosition(), Color.Green);
            if (topLeft == null) {
                topLeft = geyserTopLeft;
            }
            if (bottomRight == null) {
                bottomRight = geyserBottomRight;
            }
            if (geyserTopLeft.getX() < topLeft.getX()) {
                topLeft = new TilePosition(geyserTopLeft.getX(), topLeft.getY());
            }
            if (geyserTopLeft.getY() > topLeft.getY()) {
                topLeft = new TilePosition(topLeft.getX(), geyserTopLeft.getY());
            }
            if (geyserBottomRight.getX() > bottomRight.getX()) {
                bottomRight = new TilePosition(geyserBottomRight.getX(), bottomRight.getY());
            }
            if (geyserBottomRight.getY() >= bottomRight.getY()) continue;
            bottomRight = new TilePosition(bottomRight.getX(), geyserBottomRight.getY());
        }
        if (topLeft == null || bottomRight == null) {
            return new HashSet<TilePosition>();
        }
        TilePosition baseTopLeft = base.getLocation();
        TilePosition baseBottomRight = baseTopLeft.add(new TilePosition(4, 3));
        int geyserMidX = (topLeft.getX() + bottomRight.getX()) / 2;
        int geyserMidY = (topLeft.getY() + bottomRight.getY()) / 2;
        int baseMidX = (baseTopLeft.getX() + baseBottomRight.getX()) / 2;
        int baseMidY = (baseTopLeft.getY() + baseBottomRight.getY()) / 2;
        int dx = geyserMidX - baseMidX;
        int dy = geyserMidY - baseMidY;
        if (Math.abs(dx) > Math.abs(dy)) {
            if (dx > 0) {
                topLeft = new TilePosition(baseTopLeft.getX(), topLeft.getY());
            } else {
                bottomRight = new TilePosition(baseBottomRight.getX(), bottomRight.getY());
            }
        } else if (dy > 0) {
            bottomRight = new TilePosition(bottomRight.getX(), baseBottomRight.getY());
        } else {
            topLeft = new TilePosition(topLeft.getX(), baseTopLeft.getY());
        }
        HashSet<TilePosition> boundingTiles = new HashSet<TilePosition>();
        int x = topLeft.getX();
        while (x <= bottomRight.getX()) {
            int y = bottomRight.getY();
            while (y <= topLeft.getY()) {
                boundingTiles.add(new TilePosition(x, y));
                ++y;
            }
            ++x;
        }
        return boundingTiles;
    }

    private HashSet<TilePosition> mineralBoundingBox(Base base) {
        Point topLeft = null;
        Point bottomRight = null;
        for (Mineral mineral : base.getMinerals()) {
            TilePosition mineralTopLeft = mineral.getTopLeft();
            TilePosition mineralBottomRight = mineral.getBottomRight();
            this.game.drawBoxMap(mineralTopLeft.toPosition(), mineralTopLeft.add(new TilePosition(1, 1)).toPosition(), Color.Cyan);
            if (topLeft == null) {
                topLeft = mineralTopLeft;
            }
            if (bottomRight == null) {
                bottomRight = mineralBottomRight;
            }
            if (mineralTopLeft.getX() < topLeft.getX()) {
                topLeft = new TilePosition(mineralTopLeft.getX(), topLeft.getY());
            }
            if (mineralTopLeft.getY() > topLeft.getY()) {
                topLeft = new TilePosition(topLeft.getX(), mineralTopLeft.getY());
            }
            if (mineralBottomRight.getX() > bottomRight.getX()) {
                bottomRight = new TilePosition(mineralBottomRight.getX(), bottomRight.getY());
            }
            if (mineralBottomRight.getY() >= bottomRight.getY()) continue;
            bottomRight = new TilePosition(bottomRight.getX(), mineralBottomRight.getY());
        }
        TilePosition baseTopLeft = base.getLocation();
        TilePosition baseBottomRight = baseTopLeft.add(new TilePosition(4, 3));
        int mineralMidX = (topLeft.getX() + bottomRight.getX()) / 2;
        int mineralMidY = (topLeft.getY() + bottomRight.getY()) / 2;
        int baseMidX = (baseTopLeft.getX() + baseBottomRight.getX()) / 2;
        int baseMidY = (baseTopLeft.getY() + baseBottomRight.getY()) / 2;
        int dx = mineralMidX - baseMidX;
        int dy = mineralMidY - baseMidY;
        if (Math.abs(dx) > Math.abs(dy)) {
            if (dx > 0) {
                topLeft = new TilePosition(baseTopLeft.getX(), topLeft.getY());
            } else {
                bottomRight = new TilePosition(baseBottomRight.getX(), bottomRight.getY());
            }
        } else if (dy > 0) {
            bottomRight = new TilePosition(bottomRight.getX(), baseBottomRight.getY());
        } else {
            topLeft = new TilePosition(topLeft.getX(), baseTopLeft.getY());
        }
        HashSet<TilePosition> boundingTiles = new HashSet<TilePosition>();
        int x = topLeft.getX();
        while (x <= bottomRight.getX()) {
            int y = bottomRight.getY();
            while (y <= topLeft.getY()) {
                boundingTiles.add(new TilePosition(x, y));
                ++y;
            }
            ++x;
        }
        return boundingTiles;
    }

    private Set<TilePosition> findSurroundingCreepTiles(Base base) {
        HashSet<TilePosition> creepTiles = new HashSet();
        HashSet<TilePosition> checked = new HashSet<TilePosition>();
        HashSet<TilePosition> mineralExcluded = this.mineralBoundingBox(base);
        HashSet<TilePosition> geyserExcluded = this.geyserBoundingBox(base);
        LinkedList<TilePosition> candidates = new LinkedList<TilePosition>();
        TilePosition tileSize = new TilePosition(6, 5);
        TilePosition baseLocation = base.getLocation();
        int x = -1;
        while (x < tileSize.getX()) {
            int y = -1;
            while (y < tileSize.getX()) {
                candidates.add(baseLocation.add(new TilePosition(x, y)));
                ++y;
            }
            ++x;
        }
        while (!candidates.isEmpty()) {
            TilePosition current = (TilePosition)candidates.poll();
            if (checked.contains(current)) continue;
            checked.add(current);
            if (!this.game.hasCreep(current)) continue;
            creepTiles.add(current);
            int dx = -1;
            while (dx <= 1) {
                int dy = -1;
                while (dy <= 1) {
                    if (dx != 0 || dy != 0) {
                        TilePosition neighbor;
                        int newX = current.getX() + dx;
                        int newY = current.getY() + dy;
                        if (newX >= 0 && newX < this.game.mapWidth() && newY >= 0 && newY < this.game.mapHeight() && !checked.contains(neighbor = new TilePosition(newX, newY))) {
                            candidates.add(neighbor);
                        }
                    }
                    ++dy;
                }
                ++dx;
            }
        }
        creepTiles = creepTiles.stream().filter(t -> !mineralExcluded.contains(t) && !geyserExcluded.contains(t)).collect(Collectors.toSet());
        return creepTiles;
    }

    public TilePosition getLocationForCreepColony(Base base, Race opponentRace) {
        Position chokeCenter = this.closestChokeToBase(base);
        Set<TilePosition> creepTiles = this.findSurroundingCreepTiles(base);
        TilePosition colonySize = UnitType.Zerg_Creep_Colony.tileSize();
        ArrayList<TilePosition> candidates = new ArrayList<TilePosition>();
        for (TilePosition tp : creepTiles) {
            TilePosition se = tp.add(colonySize);
            if (!creepTiles.contains(se) || !this.isValidBuildingLocation(tp, colonySize, creepTiles)) continue;
            candidates.add(tp);
        }
        HashSet<TilePosition> existing = new HashSet<TilePosition>(this.reservedTiles);
        existing.retainAll(creepTiles);
        if (!existing.isEmpty()) {
            ArrayList<TilePosition> adjacent = new ArrayList<TilePosition>();
            block1: for (TilePosition cand : candidates) {
                for (TilePosition res : existing) {
                    if (res.getApproxDistance(cand) > 23) continue;
                    adjacent.add(cand);
                    continue block1;
                }
            }
            if (!adjacent.isEmpty()) {
                candidates = adjacent;
            }
        }
        candidates.sort(new TilePositionComparator(chokeCenter.toTilePosition()));
        return candidates.isEmpty() ? null : (TilePosition)candidates.get(0);
    }

    public TilePosition getLocationForMacroHatchery(Race opponentRace, BaseData baseData) {
        Base targetBase = this.determineTargetBaseForMacroHatch(opponentRace, baseData);
        if (targetBase == null) {
            return null;
        }
        return this.findBuildableLocationNearBase(targetBase);
    }

    private Base determineTargetBaseForMacroHatch(Race opponentRace, BaseData baseData) {
        Base mainBase = baseData.getMainBase();
        Base naturalBase = baseData.hasNaturalExpansion() ? baseData.baseAtTilePosition(baseData.naturalExpansionPosition()) : null;
        Base thirdBase = this.findThirdBase(baseData);
        int existingMacroHatchCount = baseData.numMacroHatcheries();
        if (opponentRace == Race.Terran) {
            switch (existingMacroHatchCount) {
                case 0: {
                    return mainBase;
                }
                case 1: {
                    return naturalBase;
                }
            }
            return thirdBase;
        }
        if (opponentRace == Race.Protoss) {
            switch (existingMacroHatchCount) {
                case 0: {
                    return naturalBase;
                }
                case 1: 
                case 2: {
                    return thirdBase;
                }
            }
            return mainBase;
        }
        switch (existingMacroHatchCount) {
            case 0: {
                return mainBase;
            }
            case 1: {
                return naturalBase;
            }
        }
        return thirdBase;
    }

    private Base findThirdBase(BaseData baseData) {
        Base mainBase = baseData.getMainBase();
        Base naturalBase = baseData.hasNaturalExpansion() ? baseData.baseAtTilePosition(baseData.naturalExpansionPosition()) : null;
        HashSet<Base> myBases = baseData.getMyBases();
        Base closestBase = null;
        double closestDistance = Double.MAX_VALUE;
        for (Base base : myBases) {
            double distance;
            if (base == mainBase || base == naturalBase || !((distance = mainBase.getLocation().getDistance(base.getLocation())) < closestDistance)) continue;
            closestDistance = distance;
            closestBase = base;
        }
        return closestBase;
    }

    private TilePosition findBuildableLocationNearBase(Base base) {
        TilePosition baseLocation = base.getLocation();
        TilePosition buildingSize = UnitType.Zerg_Hatchery.tileSize();
        int radius = 1;
        while (radius <= 10) {
            int dx = -radius;
            while (dx <= radius) {
                int dy = -radius;
                while (dy <= radius) {
                    TilePosition candidate;
                    if ((Math.abs(dx) == radius || Math.abs(dy) == radius) && this.isValidMacroHatchLocation(candidate = baseLocation.add(new TilePosition(dx, dy)), buildingSize, base)) {
                        return candidate;
                    }
                    ++dy;
                }
                ++dx;
            }
            ++radius;
        }
        return null;
    }

    private boolean isValidMacroHatchLocation(TilePosition location, TilePosition buildingSize, Base base) {
        if (location.getX() < 0 || location.getY() < 0 || location.getX() + buildingSize.getX() >= this.game.mapWidth() || location.getY() + buildingSize.getY() >= this.game.mapHeight()) {
            return false;
        }
        int dx = 0;
        while (dx < buildingSize.getX()) {
            int dy = 0;
            while (dy < buildingSize.getY()) {
                TilePosition currentTile = location.add(new TilePosition(dx, dy));
                if (!this.game.isBuildable(currentTile) || this.reservedTiles.contains(currentTile)) {
                    return false;
                }
                ++dy;
            }
            ++dx;
        }
        if (!this.isValidDistanceFromBaseHatchery(location, buildingSize, base)) {
            return false;
        }
        return this.isValidDistanceFromResources(location, buildingSize, base);
    }

    private boolean isValidDistanceFromResources(TilePosition hatchLocation, TilePosition buildingSize, Base base) {
        int minDistance;
        int MIN_DISTANCE = 5;
        for (Mineral mineral : base.getMinerals()) {
            TilePosition mineralPos = mineral.getTopLeft();
            minDistance = this.calculateMinManhattanDistance(hatchLocation, buildingSize, mineralPos, new TilePosition(2, 1));
            if (minDistance >= 5) continue;
            return false;
        }
        for (Geyser geyser : base.getGeysers()) {
            TilePosition geyserPos = geyser.getTopLeft();
            minDistance = this.calculateMinManhattanDistance(hatchLocation, buildingSize, geyserPos, new TilePosition(4, 2));
            if (minDistance >= 5) continue;
            return false;
        }
        return true;
    }

    private boolean isValidDistanceFromBaseHatchery(TilePosition hatchLocation, TilePosition buildingSize, Base base) {
        TilePosition baseSize;
        TilePosition baseLocation = base.getLocation();
        int distance = this.calculateMinManhattanDistance(hatchLocation, buildingSize, baseLocation, baseSize = new TilePosition(4, 3));
        return distance > 0;
    }

    private int calculateMinManhattanDistance(TilePosition pos1, TilePosition size1, TilePosition pos2, TilePosition size2) {
        int x1_min = pos1.getX();
        int x1_max = pos1.getX() + size1.getX() - 1;
        int y1_min = pos1.getY();
        int y1_max = pos1.getY() + size1.getY() - 1;
        int x2_min = pos2.getX();
        int x2_max = pos2.getX() + size2.getX() - 1;
        int y2_min = pos2.getY();
        int y2_max = pos2.getY() + size2.getY() - 1;
        int dx = 0;
        if (x1_max < x2_min) {
            dx = x2_min - x1_max;
        } else if (x2_max < x1_min) {
            dx = x1_min - x2_max;
        }
        int dy = 0;
        if (y1_max < y2_min) {
            dy = y2_min - y1_max;
        } else if (y2_max < y1_min) {
            dy = y1_min - y2_max;
        }
        return dx + dy;
    }

    public void reservePlannedBuildingTiles(TilePosition buildPosition, UnitType unitType) {
        if (buildPosition == null || unitType == null) {
            return;
        }
        TilePosition tileSize = unitType.tileSize();
        int dx = 0;
        while (dx < tileSize.getX()) {
            int dy = 0;
            while (dy < tileSize.getY()) {
                TilePosition currentTile = buildPosition.add(new TilePosition(dx, dy));
                this.reservedTiles.add(currentTile);
                ++dy;
            }
            ++dx;
        }
    }

    public void unreservePlannedBuildingTiles(TilePosition buildPosition, UnitType unitType) {
        if (buildPosition == null || unitType == null) {
            return;
        }
        TilePosition tileSize = unitType.tileSize();
        int dx = 0;
        while (dx < tileSize.getX()) {
            int dy = 0;
            while (dy < tileSize.getY()) {
                TilePosition currentTile = buildPosition.add(new TilePosition(dx, dy));
                this.reservedTiles.remove(currentTile);
                ++dy;
            }
            ++dx;
        }
    }
}

