/*
 * Decompiled with CFR 0.152.
 */
package info;

import bwapi.Player;
import bwapi.TechType;
import bwapi.UnitType;
import bwapi.UpgradeType;

public class ResourceCount {
    final double mineralsPerFramePerWorker = 0.044;
    final double gasPerFramePerWorker = 0.069;
    private Player self;
    private int reservedMinerals = 0;
    private int reservedGas = 0;
    private int reservedLarva = 0;
    private int plannedSupply;

    public ResourceCount(Player self) {
        this.self = self;
    }

    public void reserveUnit(UnitType unit) {
        this.reservedMinerals += unit.mineralPrice();
        this.reservedGas += unit.gasPrice();
        if (this.shouldReserveLarva(unit)) {
            ++this.reservedLarva;
        }
    }

    public void unreserveUnit(UnitType unit) {
        this.reservedMinerals -= unit.mineralPrice();
        this.reservedGas -= unit.gasPrice();
        if (this.shouldReserveLarva(unit)) {
            --this.reservedLarva;
        }
    }

    private boolean shouldReserveLarva(UnitType unit) {
        return !unit.isBuilding() && unit != UnitType.Zerg_Lurker;
    }

    public int availableMinerals() {
        return this.self.minerals() - this.reservedMinerals;
    }

    public int availableGas() {
        return this.self.gas() - this.reservedGas;
    }

    private boolean canAfford(int mineralPrice, int gasPrice) {
        return this.availableMinerals() < mineralPrice || this.availableGas() < gasPrice;
    }

    public boolean canAffordUnit(UnitType unit) {
        int mineralPrice = unit.mineralPrice();
        int gasPrice = unit.gasPrice();
        return this.canAfford(mineralPrice, gasPrice);
    }

    public void reserveUpgrade(UpgradeType upgrade) {
        this.reservedMinerals += upgrade.mineralPrice();
        this.reservedGas += upgrade.gasPrice();
    }

    public void unreserveUpgrade(UpgradeType upgrade) {
        this.reservedMinerals -= upgrade.mineralPrice();
        this.reservedGas -= upgrade.gasPrice();
    }

    public void reserveTechResearch(TechType techType) {
        this.reservedMinerals += techType.mineralPrice();
        this.reservedGas += techType.gasPrice();
    }

    public void unreserveTechResearch(TechType techType) {
        this.reservedMinerals -= techType.mineralPrice();
        this.reservedGas -= techType.gasPrice();
    }

    public boolean canAffordUpgrade(UpgradeType upgrade) {
        int mineralPrice = upgrade.mineralPrice();
        int gasPrice = upgrade.gasPrice();
        return this.canAfford(mineralPrice, gasPrice);
    }

    public boolean canAffordResearch(TechType techType) {
        int mineralPrice = techType.mineralPrice();
        int gasPrice = techType.gasPrice();
        return this.canAfford(mineralPrice, gasPrice);
    }

    public boolean canAffordHatch(int plannedHatcheries) {
        return this.availableMinerals() > (1 + plannedHatcheries) * 300;
    }

    public boolean needExtractor() {
        return this.isFloatingMinerals();
    }

    public int frameCanAffordUnit(UnitType unit, int currentFrame, int mineralWorkers, int gasWorkers) {
        int neededFrames;
        int mineralsNeeded = unit.mineralPrice() + this.reservedMinerals - this.self.minerals();
        int gasNeeded = unit.gasPrice() + this.reservedGas - this.self.gas();
        int framesToGather = 0;
        if (mineralsNeeded > 0) {
            if (mineralWorkers == 0) {
                return Integer.MAX_VALUE;
            }
            double mineralsPerFrame = 0.044 * (double)mineralWorkers;
            neededFrames = (int)Math.round((double)mineralsNeeded / mineralsPerFrame);
            if (neededFrames > framesToGather) {
                framesToGather = neededFrames;
            }
        }
        if (gasNeeded > 0) {
            if (gasWorkers == 0) {
                return Integer.MAX_VALUE;
            }
            double gasPerFrame = 0.069 * (double)gasWorkers;
            neededFrames = (int)Math.round((double)gasNeeded / gasPerFrame);
            if (neededFrames > framesToGather) {
                framesToGather = neededFrames;
            }
        }
        return currentFrame + framesToGather + 20;
    }

    public boolean canScheduleLarva(int currentLarva) {
        return currentLarva > this.reservedLarva;
    }

    public int frameCanAffordUpgrade() {
        return 0;
    }

    public boolean isFloatingMinerals() {
        return this.availableMinerals() - this.availableGas() > 100;
    }

    public boolean isFloatingGas() {
        return this.availableGas() - this.availableMinerals() > 150;
    }

    public int getPlannedSupply() {
        return this.plannedSupply;
    }

    public void setPlannedSupply(int s) {
        this.plannedSupply = s;
    }
}

