/*
 * Decompiled with CFR 0.152.
 */
package bwapi;

import bwapi.ClientConnection;
import bwapi.SharedLockConnectionException;
import bwapi.SharedMemoryConnectionException;
import bwapi.WrappedBuffer;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.win32.W32APIOptions;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

class ClientConnectionW32
implements ClientConnection {
    private static final int READ_WRITE = 7;
    private RandomAccessFile pipeObjectHandle = null;

    ClientConnectionW32() {
    }

    @Override
    public void disconnect() {
        if (this.pipeObjectHandle != null) {
            try {
                this.pipeObjectHandle.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.pipeObjectHandle = null;
        }
    }

    @Override
    public WrappedBuffer getGameTable() {
        Pointer gameTableView = Kernel32.INSTANCE.MapViewOfFile(MappingKernel.INSTANCE.OpenFileMapping(7, false, "Local\\bwapi_shared_memory_game_list"), 7, 0, 0, 96);
        return new WrappedBuffer(gameTableView, 96);
    }

    @Override
    public WrappedBuffer getSharedMemory(int serverProcID) {
        String sharedMemoryName = "Local\\bwapi_shared_memory_" + serverProcID;
        try {
            Pointer mapFileView = Kernel32.INSTANCE.MapViewOfFile(MappingKernel.INSTANCE.OpenFileMapping(7, false, sharedMemoryName), 7, 0, 0, 33017048);
            return new WrappedBuffer(mapFileView, 33017048);
        }
        catch (Exception e) {
            throw new SharedMemoryConnectionException(sharedMemoryName, e);
        }
    }

    @Override
    public void connectSharedLock(int serverProcID) {
        String communicationPipe = "\\\\.\\pipe\\bwapi_pipe_" + serverProcID;
        try {
            this.pipeObjectHandle = new RandomAccessFile(communicationPipe, "rw");
        }
        catch (FileNotFoundException e) {
            throw new SharedLockConnectionException("Unable to open communications pipe: " + communicationPipe, e);
        }
    }

    @Override
    public void waitForServerData() throws IOException {
        while (this.pipeObjectHandle.readByte() != 2) {
        }
    }

    @Override
    public void submitClientData() throws IOException {
        this.pipeObjectHandle.writeByte(1);
    }

    static interface MappingKernel
    extends Kernel32 {
        public static final MappingKernel INSTANCE = Native.load(MappingKernel.class, W32APIOptions.DEFAULT_OPTIONS);

        @Override
        public WinNT.HANDLE OpenFileMapping(int var1, boolean var2, String var3);
    }
}

