/*
 * Decompiled with CFR 0.152.
 */
package bwapi;

import bwapi.BWClient;
import bwapi.ClientConnection;
import bwapi.ClientConnectionPosix;
import bwapi.ClientConnectionW32;
import bwapi.ClientData;
import bwapi.GameInstance;
import bwapi.GameTable;
import bwapi.PerformanceMetrics;
import bwapi.WrappedBuffer;

class Client {
    private static final int SUPPORTED_BWAPI_VERSION = 10003;
    private ClientData clientData;
    private BWClient bwClient;
    private boolean connected = false;
    private WrappedBuffer mapShm = null;
    private WrappedBuffer gameTableShm = null;
    private final ClientConnection clientConnector;

    Client(BWClient bwClient) {
        this.bwClient = bwClient;
        boolean windowsOs = System.getProperty("os.name").toLowerCase().contains("win");
        this.clientConnector = windowsOs ? new ClientConnectionW32() : new ClientConnectionPosix();
    }

    Client(WrappedBuffer buffer) {
        this.clientData = new ClientData();
        this.clientData.setBuffer(buffer);
        this.clientConnector = null;
    }

    ClientData liveClientData() {
        return this.clientData;
    }

    WrappedBuffer mapFile() {
        return this.mapShm;
    }

    boolean isConnected() {
        return this.connected;
    }

    void reconnect() {
        while (!this.connect()) {
            this.sleep(1000);
        }
    }

    private void disconnect() {
        if (this.bwClient.getConfiguration().getDebugConnection()) {
            System.err.print("Disconnect called by: ");
            System.err.println(Thread.currentThread().getStackTrace()[2]);
        }
        if (!this.connected) {
            return;
        }
        this.clientConnector.disconnect();
        this.mapShm = null;
        this.gameTableShm = null;
        this.clientData = null;
        this.connected = false;
    }

    boolean connect() {
        GameTable gameTable;
        if (this.connected) {
            System.err.println("Already connected");
            return true;
        }
        int serverProcID = -1;
        int gameTableIndex = -1;
        try {
            this.gameTableShm = this.clientConnector.getGameTable();
        }
        catch (Exception e) {
            System.err.println("Game table mapping not found.");
            return false;
        }
        try {
            gameTable = new GameTable(this.gameTableShm);
        }
        catch (Exception e) {
            System.err.println("Unable to map Game table.");
            if (this.bwClient.getConfiguration().getDebugConnection()) {
                e.printStackTrace();
            }
            return false;
        }
        int oldest = Integer.MAX_VALUE;
        for (int i = 0; i < 8; ++i) {
            GameInstance gameInstance = gameTable.gameInstances[i];
            System.out.println(i + " | " + gameInstance.serverProcessID + " | " + (gameInstance.isConnected ? 1 : 0) + " | " + gameInstance.lastKeepAliveTime);
            if (gameInstance.serverProcessID == 0 || gameInstance.isConnected || gameTableIndex != -1 && gameInstance.lastKeepAliveTime >= oldest) continue;
            oldest = gameInstance.lastKeepAliveTime;
            gameTableIndex = i;
        }
        if (gameTableIndex != -1) {
            serverProcID = gameTable.gameInstances[gameTableIndex].serverProcessID;
        }
        if (serverProcID == -1) {
            System.err.println("No server proc ID");
            return false;
        }
        try {
            this.mapShm = this.clientConnector.getSharedMemory(serverProcID);
        }
        catch (Exception e) {
            System.err.println("Unable to open shared memory mapping: " + e.getMessage());
            if (this.bwClient.getConfiguration().getDebugConnection()) {
                e.printStackTrace();
            }
            this.gameTableShm = null;
            return false;
        }
        try {
            this.clientData = new ClientData();
            this.clientData.setBuffer(this.mapShm);
        }
        catch (Exception e) {
            System.err.println("Unable to map game data.");
            if (this.bwClient.getConfiguration().getDebugConnection()) {
                e.printStackTrace();
            }
            return false;
        }
        try {
            this.clientConnector.connectSharedLock(serverProcID);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            if (this.bwClient.getConfiguration().getDebugConnection()) {
                e.printStackTrace();
            }
            this.gameTableShm = null;
            return false;
        }
        System.out.println("Connected");
        if (10003 != this.clientData.gameData().getClient_version()) {
            System.err.println("Error: Client and Server are not compatible!");
            System.err.println("Client version: 10003");
            System.err.println("Server version: " + this.clientData.gameData().getClient_version());
            this.disconnect();
            this.sleep(2000);
            return false;
        }
        try {
            this.clientConnector.waitForServerData();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            if (this.bwClient.getConfiguration().getDebugConnection()) {
                e.printStackTrace();
            }
            this.disconnect();
            return false;
        }
        System.out.println("Connection successful");
        this.connected = true;
        return true;
    }

    void sendFrameReceiveFrame() {
        PerformanceMetrics metrics = this.bwClient.getPerformanceMetrics();
        metrics.getFrameDurationReceiveToSend().stopTiming();
        if (this.bwClient.doTime()) {
            metrics.getCommunicationSendToReceive().startTiming();
            metrics.getCommunicationSendToSent().startTiming();
        }
        try {
            this.clientConnector.submitClientData();
        }
        catch (Exception e) {
            System.err.println("failed, disconnecting");
            if (this.bwClient.getConfiguration().getDebugConnection()) {
                e.printStackTrace();
            }
            this.disconnect();
        }
        metrics.getCommunicationSendToSent().stopTiming();
        metrics.getFrameDurationReceiveToSent().stopTiming();
        if (this.bwClient.doTime()) {
            int eventCount = this.clientData.gameData().getEventCount();
            metrics.getNumberOfEvents().record(eventCount);
            metrics.getNumberOfEventsTimesDurationReceiveToSent().record((double)eventCount * metrics.getFrameDurationReceiveToSent().getRunningTotal().getLast());
        }
        if (this.bwClient.doTime()) {
            metrics.getCommunicationListenToReceive().startTiming();
        }
        try {
            this.clientConnector.waitForServerData();
        }
        catch (Exception e) {
            System.err.println("failed, disconnecting");
            if (this.bwClient.getConfiguration().getDebugConnection()) {
                e.printStackTrace();
            }
            this.disconnect();
            return;
        }
        metrics.getCommunicationListenToReceive().stopTiming();
        metrics.getCommunicationSendToReceive().stopTiming();
        if (this.bwClient.doTime()) {
            metrics.getFrameDurationReceiveToSend().startTiming();
            metrics.getFrameDurationReceiveToSent().startTiming();
        }
        metrics.getFrameDurationReceiveToReceive().stopTiming();
        if (this.bwClient.doTime()) {
            metrics.getFrameDurationReceiveToReceive().startTiming();
        }
    }

    private void sleep(int millis) {
        try {
            Thread.sleep(millis);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

