/*
 * Decompiled with CFR 0.152.
 */
import bwapi.Game;
import bwapi.Position;
import bwapi.Unit;
import config.Config;
import java.util.Iterator;
import unit.managed.ManagedUnit;
import unit.scout.ScoutManager;
import unit.squad.Squad;
import unit.squad.SquadManager;

public class AutoObserver {
    private Config config;
    private Game game;
    private ScoutManager scoutManager;
    private SquadManager squadManager;
    private Unit m_observerFollowingUnit;
    private int m_cameraLastMoved;
    private int m_unitFollowFrames;
    private static final int FOLLOW_DURATION_DEFAULT = 24;
    private static final int FOLLOW_DURATION_SCOUT = 6;
    private static final int SCREEN_WIDTH_HALF = 320;
    private static final int SCREEN_HEIGHT_HALF = 180;
    private static final int BUILD_TIME_THRESHOLD = 12;

    public AutoObserver(Config config, Game game, ScoutManager scoutManager, SquadManager squadManager) {
        this.config = config;
        this.game = game;
        this.scoutManager = scoutManager;
        this.squadManager = squadManager;
    }

    public void onFrame() {
        if (!this.config.enabledAutoObserver) {
            return;
        }
        if (this.shouldPickNewUnitToFollow()) {
            this.followHighestPriorityUnit();
        }
        this.updateCameraPosition();
    }

    private boolean shouldPickNewUnitToFollow() {
        return this.m_observerFollowingUnit == null || !this.m_observerFollowingUnit.exists() || this.game.getFrameCount() - this.m_cameraLastMoved > this.m_unitFollowFrames;
    }

    private void followHighestPriorityUnit() {
        Unit unitToFollow = this.findUnitUnderAttackOrAttacking();
        if (unitToFollow == null) {
            unitToFollow = this.findFirstUnitInLargestSquad();
        }
        if (unitToFollow == null) {
            unitToFollow = this.findAlmostCompletedBuilding();
        }
        if (unitToFollow == null) {
            unitToFollow = this.findScoutDrone();
        }
        if (unitToFollow != null) {
            int followDuration = unitToFollow == this.findScoutDrone() ? 6 : 24;
            this.startFollowingUnit(unitToFollow, followDuration);
        }
    }

    private Unit findUnitUnderAttackOrAttacking() {
        for (Unit unit : this.game.self().getUnits()) {
            if (!unit.isUnderAttack() && !unit.isAttacking()) continue;
            return unit;
        }
        return null;
    }

    private Unit findFirstUnitInLargestSquad() {
        Iterator<ManagedUnit> iterator;
        Squad largestSquad = this.squadManager.largestSquad();
        if (largestSquad != null && !largestSquad.getMembers().isEmpty() && (iterator = largestSquad.getMembers().iterator()).hasNext()) {
            ManagedUnit managedUnit = iterator.next();
            return managedUnit.getUnit();
        }
        return null;
    }

    private Unit findAlmostCompletedBuilding() {
        for (Unit unit : this.game.self().getUnits()) {
            if (!unit.isBeingConstructed() || unit.getRemainingBuildTime() >= 12) continue;
            return unit;
        }
        return null;
    }

    private Unit findScoutDrone() {
        for (Unit unit : this.game.self().getUnits()) {
            if (!this.scoutManager.isDroneScout(unit)) continue;
            return unit;
        }
        return null;
    }

    private void startFollowingUnit(Unit unit, int followDuration) {
        this.m_cameraLastMoved = this.game.getFrameCount();
        this.m_unitFollowFrames = followDuration;
        this.m_observerFollowingUnit = unit;
    }

    private void updateCameraPosition() {
        if (this.m_observerFollowingUnit != null && this.m_observerFollowingUnit.exists()) {
            Position unitPos = this.m_observerFollowingUnit.getPosition();
            Position screenPos = new Position(unitPos.getX() - 320, unitPos.getY() - 180);
            this.game.setScreenPosition(screenPos);
        }
    }
}

