/*
 * Decompiled with CFR 0.152.
 */
package macro;

import bwapi.Game;
import bwapi.Player;
import bwapi.Position;
import bwapi.TilePosition;
import bwapi.Unit;
import bwapi.UnitType;
import bwem.Base;
import bwem.Mineral;
import bwem.Neutral;
import information.BaseInfo;
import information.enemy.EnemyInformation;
import information.enemy.EnemyScoutResponse;
import information.enemy.EnemyUnits;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.stream.Collectors;
import macro.unitgroups.WorkerStatus;
import macro.unitgroups.Workers;

public class ResourceManager {
    private BaseInfo baseInfo;
    private Player player;
    private Game game;
    private EnemyInformation enemyInformation;
    private EnemyScoutResponse enemyScoutResponse;
    private HashSet<Workers> workers = new HashSet();
    private HashSet<Workers> defenseForce = new HashSet();
    private HashSet<Workers> repairForce = new HashSet();
    private HashMap<Unit, HashSet<Workers>> refinerySaturation = new HashMap();
    private HashMap<Base, HashSet<Workers>> mineralSaturation = new HashMap();
    private HashMap<Unit, Workers> buildingRepair = new HashMap();
    private int reservedMinerals = 0;
    private int reservedGas = 0;
    private int availableMinerals = 0;
    private int availableGas = 0;
    private boolean isReserved = false;
    private boolean openerResponse = false;
    private boolean startingMineralsAssigned = false;

    public ResourceManager(BaseInfo baseInfo, Player player, Game game, EnemyInformation enemyInformation) {
        this.baseInfo = baseInfo;
        this.player = player;
        this.enemyInformation = enemyInformation;
        this.game = game;
        this.enemyScoutResponse = new EnemyScoutResponse(game, enemyInformation, this, baseInfo);
    }

    public void onFrame() {
        this.startingMineralAssignment();
        this.setAvailableMinerals(this.availableMinerals);
        this.setAvailableGas(this.availableGas);
        this.gatherGas();
        this.workerBuildClock();
        this.buildingHealthCheck();
        this.preemptiveBunkerRepair();
        this.enemyScoutResponse.onFrame();
        int frameCount = this.game.getFrameCount();
        if (this.enemyInformation.getEnemyOpener() != null && !this.openerResponse) {
            this.enemyStrategyResponse();
            this.openerResponse = true;
        }
        for (Workers worker : this.workers) {
            if (worker.getUnit().isUnderAttack() && (worker.getWorkerStatus() != WorkerStatus.SCOUTING || worker.getWorkerStatus() != WorkerStatus.COUNTERSCOUT) && this.baseInfo.getBaseTiles().contains(worker.getUnit().getTilePosition())) {
                this.createDefenseForce(7);
            }
            if (worker.getWorkerStatus() == WorkerStatus.IDLE) {
                if (!worker.isAssignedToBase()) {
                    this.assignMineralSaturation(worker);
                }
                worker.setWorkerStatus(WorkerStatus.MINERALS);
            }
            if (worker.getWorkerStatus() == WorkerStatus.DEFEND) {
                this.updateClosetEnemy(worker);
                this.workerAttackClock(worker);
                if (frameCount % 24 != 0) {
                    return;
                }
                if (worker.getEnemyUnit() != null) {
                    worker.selfDefense();
                }
                if (worker.getAttackClock() > 300 && worker.getEnemyUnit() == null || !this.enemyInBase()) {
                    worker.setWorkerStatus(WorkerStatus.IDLE);
                    worker.setAttackClock(0);
                    this.removeDefenseForce(worker);
                }
            }
            if (worker.getWorkerStatus() == WorkerStatus.MINERALS) {
                for (Unit building : this.buildingRepair.keySet()) {
                    if (this.buildingRepair.get(building) != null) continue;
                    this.buildingRepair.put(building, worker);
                    worker.setRepairTarget(building);
                    worker.setWorkerStatus(WorkerStatus.REPAIRING);
                }
                if (worker.getUnit().isIdle()) {
                    this.gatherMinerals(worker);
                }
                if (worker.getUnit().isGatheringGas()) {
                    worker.getUnit().stop();
                }
                worker.setIdleClock(0);
            }
            if (worker.getWorkerStatus() == WorkerStatus.STUCK) {
                if (frameCount % 24 != 0) {
                    return;
                }
                if (worker.getUnit().isGatheringMinerals()) {
                    worker.setWorkerStatus(WorkerStatus.MINERALS);
                }
                this.gatherMinerals(worker);
            }
            if (worker.getWorkerStatus() == WorkerStatus.REPAIRING) {
                worker.repair(worker.getRepairTarget());
            }
            if (worker.getWorkerStatus() != WorkerStatus.BUILDING || !worker.getUnit().isIdle()) continue;
            worker.setIdleClock(worker.getIdleClock() + 12);
            if (worker.getIdleClock() <= 300) continue;
            worker.setWorkerStatus(WorkerStatus.IDLE);
            worker.setIdleClock(0);
        }
    }

    private void gatherMinerals(Workers worker) {
        for (Base base : this.mineralSaturation.keySet()) {
            Iterator<Mineral> iterator;
            if (!this.mineralSaturation.get(base).contains(worker) || !(iterator = base.getMinerals().iterator()).hasNext()) continue;
            Mineral mineral = iterator.next();
            worker.getUnit().gather(mineral.getUnit());
        }
        if (!worker.isAssignedToBase()) {
            this.assignMineralSaturation(worker);
        }
    }

    private void gatherGas() {
        for (Workers scv : this.workers) {
            if (scv.getWorkerStatus() != WorkerStatus.MINERALS) continue;
            for (Unit geyser : this.refinerySaturation.keySet()) {
                if (this.refinerySaturation.get(geyser).size() >= 3) continue;
                this.refinerySaturation.get(geyser).add(scv);
                scv.setWorkerStatus(WorkerStatus.GAS);
                scv.getUnit().gather(geyser);
            }
        }
    }

    private void assignMineralSaturation(Workers worker) {
        for (Base base : this.baseInfo.getOwnedBases()) {
            if (this.mineralSaturation.get(base).size() >= 24) continue;
            this.mineralSaturation.get(base).add(worker);
            worker.setAssignedToBase(true);
            break;
        }
    }

    private void removeMineralSaturation(Workers worker) {
        for (Base base : this.mineralSaturation.keySet()) {
            if (!this.mineralSaturation.get(base).contains(worker)) continue;
            this.mineralSaturation.get(base).remove(worker);
            break;
        }
    }

    private void startingMineralAssignment() {
        if (this.startingMineralsAssigned) {
            return;
        }
        Base mainBase = this.baseInfo.getStartingBase();
        HashSet minerals = new HashSet(mainBase.getMinerals().stream().map(Neutral::getUnit).collect(Collectors.toList()));
        for (Workers worker : this.workers) {
            if (minerals.isEmpty()) continue;
            Unit mineralPatch = (Unit)minerals.iterator().next();
            worker.getUnit().gather(mineralPatch);
            minerals.remove(mineralPatch);
        }
        this.startingMineralsAssigned = true;
    }

    public void reserveResources(UnitType unitType) {
        this.reservedMinerals += unitType.mineralPrice();
        this.reservedGas += unitType.gasPrice();
        this.availableMinerals = this.player.minerals() - this.reservedMinerals;
        this.availableGas = this.player.gas() - this.reservedGas;
        this.isReserved = true;
    }

    public void unreserveResources(UnitType unitType) {
        this.reservedMinerals -= unitType.mineralPrice();
        this.reservedGas -= unitType.gasPrice();
        this.availableMinerals = this.player.minerals() - this.reservedMinerals;
        this.availableGas = this.player.gas() - this.reservedGas;
        this.isReserved = false;
    }

    private void workerBuildClock() {
        for (Workers worker : this.workers) {
            if (worker.getWorkerStatus() == WorkerStatus.MOVING_TO_BUILD) {
                worker.stuckCheck();
                worker.setBuildFrameCount(worker.getBuildFrameCount() + 1);
                continue;
            }
            worker.setLastFrameChecked(0);
            worker.setBuildFrameCount(0);
        }
    }

    private void createDefenseForce(int defenseSize) {
        for (Workers worker : this.workers) {
            if (worker.getWorkerStatus() == WorkerStatus.MINERALS && this.defenseForce.size() < defenseSize) {
                this.defenseForce.add(worker);
                worker.setWorkerStatus(WorkerStatus.DEFEND);
            }
            if (this.defenseForce.size() < defenseSize) continue;
            return;
        }
    }

    private void removeDefenseForce(Workers worker) {
        worker.setWorkerStatus(WorkerStatus.IDLE);
        this.defenseForce.remove(this.workers);
    }

    public void updateClosetEnemy(Workers worker) {
        int closestDistance = 1000;
        EnemyUnits closestEnemy = null;
        for (EnemyUnits enemyUnit : this.enemyInformation.getEnemyUnits()) {
            int distance;
            Position enemyPosition = enemyUnit.getEnemyPosition();
            Position unitPosition = worker.getUnit().getPosition();
            if (worker.getUnit().getDistance(enemyPosition) < 250 && !enemyUnit.getEnemyUnit().isVisible() || !worker.getUnit().hasPath(enemyPosition) || enemyUnit.getEnemyUnit().getType().isFlyer() || !enemyUnit.getEnemyUnit().isDetected() || (distance = unitPosition.getApproxDistance(enemyPosition)) >= closestDistance) continue;
            closestDistance = distance;
            closestEnemy = enemyUnit;
        }
        if (closestEnemy != null) {
            worker.setEnemyUnit(closestEnemy);
        } else {
            worker.setEnemyUnit(null);
        }
    }

    private boolean enemyInBase() {
        for (EnemyUnits enemyUnit : this.enemyInformation.getEnemyUnits()) {
            if (enemyUnit.getEnemyPosition() == null) continue;
            TilePosition enemyTile = enemyUnit.getEnemyPosition().toTilePosition();
            if (!this.baseInfo.getBaseTiles().contains(enemyTile)) continue;
            return true;
        }
        return false;
    }

    private void enemyStrategyResponse() {
        switch (this.enemyInformation.getEnemyOpener().getStrategyName()) {
            case "Cannon Rush": {
                this.createDefenseForce(6);
            }
        }
    }

    private void buildingHealthCheck() {
        for (Unit building : this.player.getUnits()) {
            if (building.getType().isBuilding() && building.getHitPoints() < building.getType().maxHitPoints() && building.isCompleted() && !this.buildingRepair.containsKey(building)) {
                this.buildingRepair.put(building, null);
            }
            if (!building.getType().isBuilding() || building.getHitPoints() < building.getType().maxHitPoints() || !building.isCompleted() || !this.buildingRepair.containsKey(building)) continue;
            this.buildingRepair.remove(building);
        }
    }

    private void repairTargetDestroyed(Unit building) {
        if (this.buildingRepair.containsKey(building) && this.buildingRepair.get(building) != null) {
            Workers worker = this.buildingRepair.get(building);
            worker.setWorkerStatus(WorkerStatus.IDLE);
            worker.setRepairTarget(null);
        }
        if (building.getType() == UnitType.Terran_Bunker) {
            for (Workers worker : this.repairForce) {
                worker.setWorkerStatus(WorkerStatus.IDLE);
                worker.setRepairTarget(null);
                worker.setPreemptiveRepair(false);
            }
            this.repairForce.clear();
        }
    }

    private void preemptiveBunkerRepair() {
        block0: for (Unit bunker : this.player.getUnits()) {
            if (bunker.getType() != UnitType.Terran_Bunker || !bunker.isCompleted()) continue;
            if (this.enemyInRange()) {
                for (Workers worker : this.workers) {
                    if (worker.getWorkerStatus() == WorkerStatus.MINERALS && this.repairForce.size() < 3) {
                        worker.setWorkerStatus(WorkerStatus.REPAIRING);
                        worker.setRepairTarget(bunker);
                        worker.setPreemptiveRepair(true);
                        this.repairForce.add(worker);
                        continue;
                    }
                    if (this.repairForce.size() <= 2) continue;
                    continue block0;
                }
                continue;
            }
            if (this.enemyInRange()) continue;
            for (Workers worker : this.repairForce) {
                worker.setWorkerStatus(WorkerStatus.IDLE);
                worker.setRepairTarget(null);
                worker.setPreemptiveRepair(false);
            }
            this.repairForce.clear();
        }
    }

    private boolean enemyInRange() {
        Unit mainBunker = null;
        for (Unit bunker : this.player.getUnits()) {
            if (bunker.getType() != UnitType.Terran_Bunker || !bunker.isCompleted()) continue;
            mainBunker = bunker;
            break;
        }
        for (EnemyUnits enemyUnit : this.enemyInformation.getEnemyUnits()) {
            if (enemyUnit.getEnemyPosition() == null || enemyUnit.getEnemyType() == UnitType.Zerg_Overlord || enemyUnit.getEnemyType().isWorker() || enemyUnit.getEnemyUnit().getType().isFlyer() || !enemyUnit.getEnemyUnit().isDetected() || !enemyUnit.getEnemyUnit().exists()) continue;
            if (mainBunker == null) {
                return false;
            }
            if (enemyUnit.getEnemyPosition().getApproxDistance(mainBunker.getPosition()) >= 400) continue;
            return true;
        }
        return false;
    }

    private void workerAttackClock(Workers worker) {
        worker.setAttackClock(worker.getAttackClock() + 1);
    }

    public Workers getClosestWorker(Position position) {
        Workers closestWorker = null;
        int closestDistance = Integer.MAX_VALUE;
        for (Workers worker : this.workers) {
            int distance;
            if (worker.getWorkerStatus() != WorkerStatus.MINERALS || (distance = worker.getUnit().getPosition().getApproxDistance(position)) >= closestDistance) continue;
            closestDistance = distance;
            closestWorker = worker;
        }
        if (closestWorker != null) {
            closestWorker.setDistanceToBuildTarget(closestWorker.getUnit().getDistance(position));
        }
        return closestWorker;
    }

    public void onUnitComplete(Unit unit) {
        if (unit.getType() == UnitType.Terran_SCV) {
            this.workers.add(new Workers(this.game, unit, WorkerStatus.IDLE));
        }
        if (unit.getType() == UnitType.Terran_Refinery) {
            this.refinerySaturation.put(unit, new HashSet());
        }
        if (unit.getType() == UnitType.Terran_Command_Center) {
            for (Base base : this.baseInfo.getOwnedBases()) {
                if (unit.getPosition().getApproxDistance(base.getCenter()) >= 100) continue;
                this.mineralSaturation.put(base, new HashSet());
            }
        }
    }

    public void onUnitDestroy(Unit unit) {
        if (unit.getPlayer() != this.player) {
            return;
        }
        if (unit.getType().isBuilding()) {
            this.repairTargetDestroyed(unit);
        }
        if (unit.getType() != UnitType.Terran_SCV && unit.getType() != UnitType.Terran_Refinery) {
            return;
        }
        if (unit.getType() == UnitType.Terran_Refinery) {
            for (Workers worker : this.refinerySaturation.get(unit)) {
                worker.setWorkerStatus(WorkerStatus.IDLE);
            }
            this.refinerySaturation.remove(unit);
            return;
        }
        for (Workers worker : this.workers) {
            if (worker.getUnit() != unit) continue;
            for (Unit building : this.buildingRepair.keySet()) {
                if (this.buildingRepair.get(building) != worker) continue;
                this.buildingRepair.put(building, null);
            }
            this.removeMineralSaturation(worker);
            this.workers.remove(worker);
            break;
        }
    }

    public int getReservedMinerals() {
        return this.reservedMinerals;
    }

    public void setReservedMinerals(int reservedMinerals) {
        this.reservedMinerals = reservedMinerals;
    }

    public int getReservedGas() {
        return this.reservedGas;
    }

    public void setReservedGas(int reservedGas) {
        this.reservedGas = reservedGas;
    }

    public int getAvailableMinerals() {
        return this.availableMinerals;
    }

    private void setAvailableMinerals(int availableMinerals) {
        this.availableMinerals = this.player.minerals() - this.reservedMinerals;
    }

    public int getAvailableGas() {
        return this.availableGas;
    }

    public void setAvailableGas(int availableGas) {
        this.availableGas = this.player.gas() - this.reservedGas;
    }

    public boolean isReserved() {
        return this.isReserved;
    }

    public void setReserved(boolean reserved) {
        this.isReserved = reserved;
    }

    public HashSet<Workers> getWorkers() {
        return this.workers;
    }

    public HashSet<Workers> getDefenseForce() {
        return this.defenseForce;
    }
}

