/*
 * Decompiled with CFR 0.152.
 */
package macro;

import bwapi.Position;
import bwem.Base;
import information.BaseInfo;
import information.enemy.EnemyInformation;
import information.enemy.enemyopeners.EnemyStrategy;
import java.util.List;
import macro.unitgroups.CombatUnits;
import map.PathFinding;
import util.PositionInterpolator;

public class RallyPoint {
    private PathFinding pathFinding;
    private EnemyInformation enemyInformation;
    private BaseInfo baseInfo;
    private EnemyStrategy enemyStrategy = null;
    private Base startingBase;

    public RallyPoint(PathFinding pathFinding, EnemyInformation enemyInformation, BaseInfo baseInfo) {
        this.pathFinding = pathFinding;
        this.enemyInformation = enemyInformation;
        this.baseInfo = baseInfo;
        this.startingBase = baseInfo.getStartingBase();
    }

    public void setRallyPoint(CombatUnits combatUnit) {
        if (this.enemyInformation.getEnemyOpener() == null || this.enemyStrategy.isStrategyDefended()) {
            if (this.baseInfo.isNaturalOwned() || this.baseInfo.hasBunkerInNatural()) {
                combatUnit.setRallyPoint(this.rallyPath(this.baseInfo.getNaturalBase().getCenter(), this.baseInfo.getNaturalChoke().getCenter().toPosition(), 0.8).toTilePosition());
            } else {
                combatUnit.setRallyPoint(this.rallyPath(this.startingBase.getCenter(), this.baseInfo.getMainChoke().getCenter().toPosition(), 0.75).toTilePosition());
            }
        } else if (this.enemyInformation.getEnemyOpener().getStrategyName().equals("Four Pool")) {
            combatUnit.setRallyPoint(this.baseInfo.getStartingBase().getCenter().toTilePosition());
        }
    }

    private Position rallyPath(Position startingPos, Position endPoint, double percentage) {
        Position nearestWalkable = this.pathFinding.findNearestWalkable(startingPos);
        Position nearestWalkableToEnd = this.pathFinding.findNearestWalkable(endPoint);
        List<Position> path = nearestWalkable != null && nearestWalkableToEnd != null ? this.pathFinding.findPath(nearestWalkable, nearestWalkableToEnd) : this.pathFinding.findPath(startingPos, endPoint);
        if (path == null || path.isEmpty()) {
            return endPoint;
        }
        return PositionInterpolator.interpolate(path, percentage);
    }

    public void onFrame() {
        this.enemyStrategy = this.enemyInformation.getEnemyOpener();
    }
}

