/*
 * Decompiled with CFR 0.152.
 */
package macro;

import bwapi.Game;
import bwapi.Player;
import bwapi.Race;
import bwapi.TechType;
import bwapi.TilePosition;
import bwapi.Unit;
import bwapi.UnitType;
import bwapi.UpgradeType;
import bwem.BWEM;
import bwem.Base;
import debug.Painters;
import information.BaseInfo;
import information.enemy.EnemyInformation;
import information.enemy.enemytechunits.EnemyTechUnits;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.function.Predicate;
import macro.ResourceManager;
import macro.buildorders.BuildOrder;
import macro.buildorders.BuildOrderName;
import macro.buildorders.EightRax;
import macro.buildorders.OneRaxFE;
import macro.buildorders.TwoFac;
import macro.buildorders.TwoRax;
import macro.buildorders.TwoRaxAcademy;
import macro.unitgroups.WorkerStatus;
import macro.unitgroups.Workers;
import map.BuildTiles;
import map.TilePositionValidator;
import planner.BuildComparator;
import planner.PlannedItem;
import planner.PlannedItemStatus;
import planner.PlannedItemType;

public class ProductionManager {
    private Game game;
    private Player player;
    private Race enemyRace;
    private ResourceManager resourceManager;
    private BaseInfo baseInfo;
    private BWEM bwem;
    private Painters painters;
    private TilePositionValidator tilePositionValidator;
    private BuildTiles buildTiles;
    private EnemyInformation enemyInformation;
    private HashMap<UnitType, Integer> unitTypeCount = new HashMap();
    private HashSet<Unit> productionBuildings = new HashSet();
    private HashSet<Unit> allBuildings = new HashSet();
    private HashSet<TilePosition> reservedTurretPositions = new HashSet();
    private ArrayList<BuildOrder> openerNames = new ArrayList();
    private PriorityQueue<PlannedItem> productionQueue = new PriorityQueue<PlannedItem>(new BuildComparator());
    private BuildOrder startingOpener;
    private Unit newestCompletedBuilding = null;
    private TilePosition bunkerPosition = null;
    private boolean openerResponse = false;
    private boolean priorityStop = false;

    public ProductionManager(Game game, Player player, ResourceManager resourceManager, BaseInfo baseInfo, BWEM bwem, EnemyInformation enemyInformation) {
        this.game = game;
        this.player = player;
        this.resourceManager = resourceManager;
        this.baseInfo = baseInfo;
        this.enemyInformation = enemyInformation;
        this.tilePositionValidator = new TilePositionValidator(game);
        this.buildTiles = new BuildTiles(game, bwem, baseInfo);
        this.painters = new Painters(game);
        this.initialize();
    }

    public void initialize() {
        this.enemyRace = this.game.enemy().getRace();
        this.getOpenerNames();
        this.appendBuildOrder(this.enemyRace);
        this.initUnitCounts();
    }

    private PriorityQueue<PlannedItem> appendBuildOrder(Race enemyRace) {
        if (enemyRace.toString().equals("Zerg")) {
            for (BuildOrder buildOrder : this.openerNames) {
                if (buildOrder.getBuildOrderName() != BuildOrderName.TWORAXACADEMY) continue;
                this.bunkerPosition = this.buildTiles.getMainChokeBunker();
                this.productionQueue.addAll(buildOrder.getBuildOrder());
                this.startingOpener = buildOrder;
            }
        } else if (enemyRace.toString().equals("Terran")) {
            for (BuildOrder buildOrder : this.openerNames) {
                if (buildOrder.getBuildOrderName() != BuildOrderName.TWORAXACADEMY) continue;
                this.bunkerPosition = this.buildTiles.getMainChokeBunker();
                this.productionQueue.addAll(buildOrder.getBuildOrder());
                this.startingOpener = buildOrder;
            }
        } else if (enemyRace.toString().equals("Protoss")) {
            for (BuildOrder buildOrder : this.openerNames) {
                if (buildOrder.getBuildOrderName() != BuildOrderName.TWOFAC) continue;
                this.bunkerPosition = this.buildTiles.getNaturalChokeBunker();
                this.productionQueue.addAll(buildOrder.getBuildOrder());
                this.startingOpener = buildOrder;
            }
        } else {
            for (BuildOrder buildOrder : this.openerNames) {
                if (buildOrder.getBuildOrderName() != BuildOrderName.TWORAXACADEMY) continue;
                this.bunkerPosition = this.buildTiles.getMainChokeBunker();
                this.productionQueue.addAll(buildOrder.getBuildOrder());
                this.startingOpener = buildOrder;
            }
        }
        return this.productionQueue;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private void buildingProduction() {
        hasHighPriorityBuilding = this.hasHigherPriorityBuilding();
        worker = null;
        for (PlannedItem pi : this.productionQueue) {
            if (pi.getPriority() == 1 && pi.getPlannedItemStatus() == PlannedItemStatus.NOT_STARTED && pi.getPlannedItemType() == PlannedItemType.BUILDING && this.meetsRequirements(pi.getUnitType()) && pi.getSupply() <= this.player.supplyUsed() / 2) {
                this.priorityStop = true;
            }
            if (this.priorityStop && pi.getPriority() != 1 && pi.getPlannedItemType() == PlannedItemType.BUILDING && pi.getPlannedItemStatus() == PlannedItemStatus.NOT_STARTED || hasHighPriorityBuilding && pi.getPlannedItemType() == PlannedItemType.UNIT && pi.getPlannedItemStatus() == PlannedItemStatus.NOT_STARTED) continue;
            block0 : switch (1.$SwitchMap$planner$PlannedItemStatus[pi.getPlannedItemStatus().ordinal()]) {
                case 1: {
                    if (pi.getSupply() > this.player.supplyUsed() / 2) ** GOTO lbl63
                    if (pi.getPlannedItemType() == PlannedItemType.UPGRADE) {
                        if (!this.canBeResearched(pi.getTechBuilding()) || !this.isResearching(pi.getTechBuilding())) break;
                        if (pi.getTechUpgrade() != null) {
                            if (this.resourceManager.getAvailableMinerals() < pi.getTechUpgrade().mineralPrice() || this.resourceManager.getAvailableGas() < pi.getTechUpgrade().gasPrice()) break;
                            this.researchTech(pi.getTechUpgrade());
                            pi.setPlannedItemStatus(PlannedItemStatus.IN_PROGRESS);
                            break;
                        }
                        if (pi.getUpgradeType() == null || this.resourceManager.getAvailableMinerals() < pi.getUpgradeType().mineralPrice() || this.resourceManager.getAvailableGas() < pi.getUpgradeType().gasPrice()) break;
                        this.researchUpgrade(pi.getUpgradeType());
                        pi.setPlannedItemStatus(PlannedItemStatus.IN_PROGRESS);
                        break;
                    }
                    if (this.resourceManager.getAvailableMinerals() < pi.getUnitType().mineralPrice() || this.resourceManager.getAvailableGas() < pi.getUnitType().gasPrice()) ** GOTO lbl63
                    if (pi.getPlannedItemType() != PlannedItemType.UNIT) ** GOTO lbl31
                    for (Unit productionBuilding : this.productionBuildings) {
                        if (!productionBuilding.canTrain(pi.getUnitType()) || productionBuilding.isTraining()) continue;
                        productionBuilding.train(pi.getUnitType());
                        pi.setProductionBuilding(productionBuilding);
                        pi.setPlannedItemStatus(PlannedItemStatus.IN_PROGRESS);
                        ** GOTO lbl63
                    }
                    ** GOTO lbl63
lbl31:
                    // 1 sources

                    if (pi.getPlannedItemType() != PlannedItemType.BUILDING) ** GOTO lbl55
                    if (pi.getBuildPosition() == null) {
                        if (pi.getUnitType() == UnitType.Terran_Refinery) {
                            this.setRefineryPosition(pi);
                        } else if (pi.getUnitType() == UnitType.Terran_Command_Center) {
                            this.setCommandCenterPosition(pi);
                        } else {
                            this.setBuildingPosition(pi);
                        }
                        if (pi.getBuildPosition() == null) break;
                    }
                    if (pi.getBuildPosition() != null) {
                        worker = this.resourceManager.getClosestWorker(pi.getBuildPosition().toPosition());
                        pi.setAssignedBuilder(worker);
                    }
                    if (pi.getAssignedBuilder() != null && worker.getWorkerStatus() == WorkerStatus.MINERALS && worker.getUnit().canBuild(pi.getUnitType())) {
                        this.resourceManager.reserveResources(pi.getUnitType());
                        worker.setBuildingPosition(pi.getBuildPosition().toPosition());
                        worker.getUnit().move(pi.getBuildPosition().toPosition());
                        worker.getUnit().build(pi.getUnitType(), pi.getBuildPosition());
                        pi.setPlannedItemStatus(PlannedItemStatus.SCV_ASSIGNED);
                        worker.setWorkerStatus(WorkerStatus.MOVING_TO_BUILD);
                    }
                    ** GOTO lbl63
lbl55:
                    // 1 sources

                    if (pi.getPlannedItemType() == PlannedItemType.ADDON) {
                        for (Unit productionBuilding : this.productionBuildings) {
                            if (!productionBuilding.canBuildAddon(pi.getUnitType()) || productionBuilding.isTraining() || productionBuilding.getAddon() != null || this.productionQueue.stream().anyMatch((Predicate<PlannedItem>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$buildingProduction$0(bwapi.Unit planner.PlannedItem ), (Lplanner/PlannedItem;)Z)((Unit)productionBuilding))) continue;
                            productionBuilding.buildAddon(pi.getUnitType());
                            pi.setAddOnParent(productionBuilding);
                            pi.setPlannedItemStatus(PlannedItemStatus.IN_PROGRESS);
                            break;
                        }
                    }
lbl63:
                    // 9 sources

                    if ((pi.getPriority() != 1 || pi.getPlannedItemStatus() == PlannedItemStatus.NOT_STARTED) && (pi.getPlannedItemType() != PlannedItemType.BUILDING || this.meetsRequirements(pi.getUnitType()))) break;
                    this.priorityStop = false;
                    break;
                }
                case 2: {
                    worker = pi.getAssignedBuilder();
                    if (worker.getUnit().getID() == pi.getAssignedBuilder().getUnitID() && worker.getWorkerStatus() == WorkerStatus.MOVING_TO_BUILD) {
                        worker.pulseCheck();
                        if (worker.getUnit().getDistance(pi.getBuildPosition().toPosition()) < 96) {
                            worker.getUnit().build(pi.getUnitType(), pi.getBuildPosition());
                        }
                        if (worker.getBuildFrameCount() > 600) {
                            worker.setWorkerStatus(WorkerStatus.IDLE);
                            worker.getUnit().stop();
                            this.resourceManager.unreserveResources(pi.getUnitType());
                            pi.setPlannedItemStatus(PlannedItemStatus.NOT_STARTED);
                        }
                    }
                    if (worker.getWorkerStatus() == WorkerStatus.STUCK) {
                        this.resourceManager.unreserveResources(pi.getUnitType());
                        pi.setPlannedItemStatus(PlannedItemStatus.NOT_STARTED);
                    }
                    if (!worker.getUnit().exists()) {
                        pi.setPlannedItemStatus(PlannedItemStatus.NOT_STARTED);
                    }
                    if (!this.buildingInProduction(pi.getBuildPosition(), pi.getUnitType())) break;
                    this.resourceManager.unreserveResources(pi.getUnitType());
                    pi.setPlannedItemStatus(PlannedItemStatus.IN_PROGRESS);
                    if (worker.getUnitID() != pi.getAssignedBuilder().getUnitID()) break;
                    worker.setWorkerStatus(WorkerStatus.BUILDING);
                    break;
                }
                case 3: {
                    if (pi.getPlannedItemType() == PlannedItemType.BUILDING) {
                        if (pi.getAssignedBuilder() != null) {
                            worker = pi.getAssignedBuilder();
                        }
                        for (Object building : this.allBuildings) {
                            if (building.getType() != pi.getUnitType() || !building.getTilePosition().equals(pi.getBuildPosition()) || !building.isCompleted()) continue;
                            pi.setPlannedItemStatus(PlannedItemStatus.COMPLETE);
                            if (building.canTrain()) {
                                this.productionBuildings.add((Unit)building);
                            }
                            if (worker.getWorkerStatus() != WorkerStatus.BUILDING) break;
                            worker.setWorkerStatus(WorkerStatus.IDLE);
                            break;
                        }
                        builderHasDied = true;
                        for (Workers workers : this.resourceManager.getWorkers()) {
                            if (workers.getUnit().getID() != pi.getAssignedBuilder().getUnitID()) continue;
                            builderHasDied = false;
                            break;
                        }
                        if (builderHasDied) {
                            for (Workers newWorker : this.resourceManager.getWorkers()) {
                                if (newWorker.getWorkerStatus() != WorkerStatus.MINERALS) continue;
                                pi.setAssignedBuilder(newWorker);
                                newWorker.setWorkerStatus(WorkerStatus.MOVING_TO_BUILD);
                                break;
                            }
                        }
                        building = this.player.getUnits().iterator();
                        while (building.hasNext()) {
                            building = (Unit)building.next();
                            if (!building.isCompleted() && building.getType() == pi.getUnitType() && !building.isBeingConstructed()) {
                                pi.getAssignedBuilder().getUnit().rightClick(building);
                                break;
                            }
                            if (!building.isBeingConstructed() || !pi.getAssignedBuilder().getUnit().isConstructing() || worker.getUnit().getID() != pi.getAssignedBuilder().getUnitID()) continue;
                            worker.setWorkerStatus(WorkerStatus.BUILDING);
                            break;
                        }
                    }
                    if (pi.getPlannedItemType() == PlannedItemType.UPGRADE) {
                        if (pi.getUpgradeType() != null) {
                            if (this.game.self().getUpgradeLevel(pi.getUpgradeType()) == pi.getUpgradeLevel().intValue()) {
                                pi.setPlannedItemStatus(PlannedItemStatus.COMPLETE);
                            }
                            if (!this.isUpgrading(pi.getUpgradeType()) && this.game.self().getUpgradeLevel(pi.getUpgradeType()) < pi.getUpgradeLevel()) {
                                pi.setPlannedItemStatus(PlannedItemStatus.NOT_STARTED);
                            }
                        } else if (pi.getTechUpgrade() != null) {
                            if (this.game.self().hasResearched(pi.getTechUpgrade())) {
                                pi.setPlannedItemStatus(PlannedItemStatus.COMPLETE);
                            }
                            if (!this.isResearching(pi.getTechUpgrade()) && !this.game.self().hasResearched(pi.getTechUpgrade())) {
                                pi.setPlannedItemStatus(PlannedItemStatus.NOT_STARTED);
                            }
                        }
                    }
                    if (pi.getPlannedItemType() == PlannedItemType.ADDON) {
                        if (pi.getAddOnParent() == null || pi.getAddOnParent().getAddon() == null) break;
                        if (pi.getAddOnParent() != null && pi.getAddOnParent().getAddon().isCompleted()) {
                            pi.setPlannedItemStatus(PlannedItemStatus.COMPLETE);
                            break;
                        }
                    }
                    for (Unit productionBuilding : this.productionBuildings) {
                        if (pi.getProductionBuilding() != productionBuilding || productionBuilding.isTraining()) continue;
                        pi.setPlannedItemStatus(PlannedItemStatus.COMPLETE);
                        break block0;
                    }
                    break;
                }
            }
        }
        this.productionQueue.removeIf((Predicate<PlannedItem>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$buildingProduction$1(planner.PlannedItem ), (Lplanner/PlannedItem;)Z)());
    }

    private void addToQueue(UnitType unitType, PlannedItemType plannedItemType, int priority) {
        this.productionQueue.add(new PlannedItem(unitType, (Integer)0, PlannedItemStatus.NOT_STARTED, plannedItemType, priority));
    }

    private void addAddOn(UnitType unitType, int priority) {
        this.productionQueue.add(new PlannedItem(unitType, (Integer)0, PlannedItemStatus.NOT_STARTED, PlannedItemType.ADDON, priority));
    }

    private boolean hasHigherPriorityBuilding() {
        for (PlannedItem pi : this.productionQueue) {
            if (pi.getPlannedItemType() == PlannedItemType.BUILDING && pi.getPlannedItemStatus() == PlannedItemStatus.NOT_STARTED && pi.getSupply() <= this.player.supplyUsed() / 2 && this.meetsRequirements(pi.getUnitType()) && pi.getPriority() < 3) {
                return true;
            }
            if (pi.getPlannedItemType() != PlannedItemType.UPGRADE || pi.getPlannedItemStatus() != PlannedItemStatus.NOT_STARTED || pi.getSupply() > this.player.supplyUsed() / 2 || !this.isResearching(pi.getTechBuilding())) continue;
            return true;
        }
        return false;
    }

    private void addUnitProduction() {
        switch (this.startingOpener.getBuildOrderName()) {
            case EIGHTRAX: {
                for (Unit productionBuilding : this.productionBuildings) {
                    if (productionBuilding.getType() != UnitType.Terran_Barracks || productionBuilding.isTraining() || this.resourceManager.getAvailableMinerals() < 50) continue;
                    productionBuilding.train(UnitType.Terran_Marine);
                }
                break;
            }
            case TWORAX: {
                for (Unit productionBuilding : this.productionBuildings) {
                    if (productionBuilding.getType() != UnitType.Terran_Barracks || productionBuilding.isTraining() || this.resourceManager.getAvailableMinerals() < 50) continue;
                    productionBuilding.train(UnitType.Terran_Marine);
                }
                break;
            }
            case TWORAXACADEMY: {
                for (Unit productionBuilding : this.productionBuildings) {
                    if (this.isCurrentlyTraining(productionBuilding, UnitType.Terran_Barracks)) {
                        if (productionBuilding.canTrain(UnitType.Terran_Medic) && this.isRecruitable(UnitType.Terran_Medic) && this.unitTypeCount.get((Object)UnitType.Terran_Medic) < 3 && !this.hasUnitInQueue(UnitType.Terran_Medic)) {
                            this.addToQueue(UnitType.Terran_Medic, PlannedItemType.UNIT, 2);
                        } else if (this.isRecruitable(UnitType.Terran_Marine) && !this.hasUnitInQueue(UnitType.Terran_Marine)) {
                            this.addToQueue(UnitType.Terran_Marine, PlannedItemType.UNIT, 3);
                        }
                    }
                    if (!this.isCurrentlyTraining(productionBuilding, UnitType.Terran_Factory) || !this.isRecruitable(UnitType.Terran_Siege_Tank_Tank_Mode) || this.unitTypeCount.get((Object)UnitType.Terran_Siege_Tank_Tank_Mode) >= 7 || this.hasUnitInQueue(UnitType.Terran_Siege_Tank_Tank_Mode)) continue;
                    this.addToQueue(UnitType.Terran_Siege_Tank_Tank_Mode, PlannedItemType.UNIT, 2);
                }
                if (this.resourceManager.getAvailableMinerals() <= 500 || this.buildTiles.getLargeBuildTiles().isEmpty() || this.unitTypeCount.get((Object)UnitType.Terran_Barracks) >= 6 || this.hasUnitInQueue(UnitType.Terran_Barracks)) break;
                this.addToQueue(UnitType.Terran_Barracks, PlannedItemType.BUILDING, 3);
                break;
            }
            case ONERAXFE: {
                for (Unit productionBuilding : this.productionBuildings) {
                    if (!this.isCurrentlyTraining(productionBuilding, UnitType.Terran_Barracks) || !this.isRecruitable(UnitType.Terran_Marine)) continue;
                    this.addToQueue(UnitType.Terran_Marine, PlannedItemType.UNIT, 3);
                }
                break;
            }
            case TWOFAC: {
                for (Unit productionBuilding : this.productionBuildings) {
                    if (!this.enemyInformation.getTechUnitResponse().isEmpty()) {
                        for (UnitType unitType : this.enemyInformation.getTechUnitResponse()) {
                            if (!this.isCurrentlyTraining(productionBuilding, unitType.whatBuilds().getKey()) || !this.isRecruitable(unitType) || this.hasUnitInQueue(unitType)) continue;
                            this.addToQueue(unitType, PlannedItemType.UNIT, 2);
                        }
                    }
                    if (this.isCurrentlyTraining(productionBuilding, UnitType.Terran_Barracks) && this.unitTypeCount.get((Object)UnitType.Terran_Factory) < 1 && this.isRecruitable(UnitType.Terran_Marine) && !this.hasUnitInQueue(UnitType.Terran_Marine)) {
                        this.addToQueue(UnitType.Terran_Marine, PlannedItemType.UNIT, 3);
                    }
                    if (this.isCurrentlyTraining(productionBuilding, UnitType.Terran_Factory)) {
                        if (this.isRecruitable(UnitType.Terran_Siege_Tank_Tank_Mode) && this.unitTypeCount.get((Object)UnitType.Terran_Siege_Tank_Tank_Mode) < 4 && !this.hasUnitInQueue(UnitType.Terran_Siege_Tank_Tank_Mode)) {
                            this.addToQueue(UnitType.Terran_Siege_Tank_Tank_Mode, PlannedItemType.UNIT, 2);
                        } else if (this.isRecruitable(UnitType.Terran_Goliath) && !this.hasUnitInQueue(UnitType.Terran_Goliath) && (this.enemyInformation.hasType(UnitType.Protoss_Arbiter) || this.enemyInformation.hasType(UnitType.Protoss_Carrier) || this.enemyInformation.hasType(UnitType.Protoss_Scout))) {
                            this.addToQueue(UnitType.Terran_Goliath, PlannedItemType.UNIT, 2);
                        } else if (this.isRecruitable(UnitType.Terran_Vulture) && !this.hasUnitInQueue(UnitType.Terran_Vulture)) {
                            this.addToQueue(UnitType.Terran_Vulture, PlannedItemType.UNIT, 3);
                        }
                    }
                    if (this.resourceManager.getAvailableMinerals() <= 500 || this.unitTypeCount.get((Object)UnitType.Terran_Factory) >= 4 || this.hasUnitInQueue(UnitType.Terran_Factory)) continue;
                    this.addProductionBuilding(UnitType.Terran_Factory, 3);
                }
                break;
            }
        }
    }

    private void addSupplyDepot() {
        if (!this.isDepotInQueue()) {
            int usedSupply = this.game.self().supplyUsed() / 2;
            int totalSupply = this.game.self().supplyTotal() / 2;
            int freeSupply = totalSupply - usedSupply;
            if (freeSupply <= 4 && this.buildTiles.getMediumBuildTiles().size() >= 2) {
                this.addToQueue(UnitType.Terran_Supply_Depot, PlannedItemType.BUILDING, 1);
                this.addToQueue(UnitType.Terran_Supply_Depot, PlannedItemType.BUILDING, 1);
            }
            if (freeSupply <= 4 && this.buildTiles.getMediumBuildTiles().size() == 1) {
                this.addToQueue(UnitType.Terran_Supply_Depot, PlannedItemType.BUILDING, 1);
            }
        }
    }

    private void addProductionBuilding(UnitType unitType, int priority) {
        if (this.buildTiles.getLargeBuildTiles().isEmpty()) {
            return;
        }
        int currentlyBuilding = (int)this.productionQueue.stream().filter(pi -> pi.getUnitType() != null && pi.getUnitType().tileHeight() == 3 && pi.getUnitType().tileWidth() == 4 && (pi.getPlannedItemStatus() == PlannedItemStatus.SCV_ASSIGNED || pi.getPlannedItemStatus() == PlannedItemStatus.IN_PROGRESS)).count();
        if (this.buildTiles.getLargeBuildTiles().size() == currentlyBuilding) {
            return;
        }
        this.addToQueue(unitType, PlannedItemType.BUILDING, priority);
    }

    private void scvProduction() {
        boolean scvInQueue;
        int ownedBases = this.baseInfo.getOwnedBases().size();
        int workerCap = 24 * ownedBases;
        if (this.unitTypeCount.get((Object)UnitType.Terran_SCV) < workerCap && !(scvInQueue = this.productionQueue.stream().anyMatch(pi -> pi.getUnitType() == UnitType.Terran_SCV))) {
            for (int i = 0; i < ownedBases; ++i) {
                this.addToQueue(UnitType.Terran_SCV, PlannedItemType.UNIT, 4);
            }
        }
    }

    private boolean isDepotInQueue() {
        if (this.buildTiles.getMediumBuildTiles().isEmpty()) {
            return true;
        }
        for (PlannedItem pi : this.productionQueue) {
            if (pi.getUnitType() == UnitType.Terran_Supply_Depot) {
                return true;
            }
            if (pi.getUnitType() != UnitType.Terran_Command_Center) continue;
            return true;
        }
        return false;
    }

    private void setRefineryPosition(PlannedItem pi) {
        for (Base base : this.baseInfo.getOwnedBases()) {
            if (!this.baseInfo.getGeyserTiles().containsKey(base) || this.baseInfo.getUsedGeysers().contains(this.baseInfo.getGeyserTiles().get(base))) continue;
            this.baseInfo.getUsedGeysers().add(this.baseInfo.getGeyserTiles().get(base));
            pi.setBuildPosition(this.baseInfo.getGeyserTiles().get(base));
        }
    }

    private void setBuildingPosition(PlannedItem pi) {
        TilePosition cloestBuildTile = null;
        int distanceFromSCV = Integer.MAX_VALUE;
        if (pi.getUnitType().tileHeight() == 3 && pi.getUnitType().tileWidth() == 4) {
            if (this.buildTiles.getLargeBuildTiles().isEmpty()) {
                return;
            }
            for (TilePosition tilePosition : this.buildTiles.getLargeBuildTiles()) {
                int distance;
                if (this.tileTaken(tilePosition) || (distance = tilePosition.getApproxDistance(this.baseInfo.getStartingBase().getLocation())) >= distanceFromSCV) continue;
                distanceFromSCV = distance;
                cloestBuildTile = tilePosition;
            }
            pi.setBuildPosition(cloestBuildTile);
        } else if (pi.getUnitType().tileHeight() == 2 && pi.getUnitType().tileWidth() == 3) {
            if (this.buildTiles.getMediumBuildTiles().isEmpty()) {
                return;
            }
            if (pi.getUnitType() == UnitType.Terran_Bunker) {
                if (this.buildTiles.getCloseBunkerTile() == null) {
                    return;
                }
                if (this.enemyInformation.getEnemyOpener() != null && this.enemyInformation.getEnemyOpener().getStrategyName().equals("Four Pool")) {
                    pi.setBuildPosition(this.buildTiles.getCloseBunkerTile());
                    return;
                }
                if (this.bunkerPosition != null) {
                    pi.setBuildPosition(this.bunkerPosition);
                }
                return;
            }
            for (TilePosition tilePosition : this.buildTiles.getMediumBuildTiles()) {
                int distance;
                if (this.tileTaken(tilePosition) || (distance = tilePosition.getApproxDistance(this.baseInfo.getStartingBase().getLocation())) >= distanceFromSCV) continue;
                distanceFromSCV = distance;
                cloestBuildTile = tilePosition;
            }
            pi.setBuildPosition(cloestBuildTile);
        } else {
            if (this.buildTiles.getNaturalChokeTurret() != null && !this.reservedTurretPositions.contains(this.buildTiles.getNaturalChokeTurret())) {
                this.reservedTurretPositions.add(this.buildTiles.getNaturalChokeTurret());
                pi.setBuildPosition(this.buildTiles.getNaturalChokeTurret());
                return;
            }
            if (this.buildTiles.getMainChokeTurret() != null && !this.reservedTurretPositions.contains(this.buildTiles.getMainChokeTurret())) {
                this.reservedTurretPositions.add(this.buildTiles.getMainChokeTurret());
                pi.setBuildPosition(this.buildTiles.getMainChokeTurret());
                return;
            }
        }
    }

    private void setCommandCenterPosition(PlannedItem pi) {
        for (Base base : this.baseInfo.getOrderedExpansions()) {
            if (!this.tilePositionValidator.isBuildable(base.getLocation(), UnitType.Terran_Command_Center)) continue;
            TilePosition tilePosition = base.getLocation();
            pi.setBuildPosition(tilePosition);
            this.baseInfo.getOrderedExpansions().removeIf(base1 -> base1.getLocation() == tilePosition);
            break;
        }
    }

    private void openerResponse() {
        this.openerResponse = true;
        for (UnitType building : this.enemyInformation.getEnemyOpener().getBuildingResponse()) {
            this.productionQueue.removeIf(pi -> pi.getUnitType() == building);
            this.addToQueue(building, PlannedItemType.BUILDING, 1);
        }
    }

    private void enemyTechResponse() {
        if (this.enemyInformation.getEnemyTechUnits().isEmpty()) {
            return;
        }
        for (EnemyTechUnits techUnit : this.enemyInformation.getEnemyTechUnits()) {
            if (techUnit.getFriendlyBuildingResponse().isEmpty()) continue;
            for (UnitType buildingResponse : techUnit.getFriendlyBuildingResponse()) {
                boolean existingBuilding = false;
                for (Unit building : this.allBuildings) {
                    if (building.getType() != buildingResponse) continue;
                    existingBuilding = true;
                    break;
                }
                for (PlannedItem pi : this.productionQueue) {
                    if (pi.getUnitType() != buildingResponse) continue;
                    existingBuilding = true;
                    break;
                }
                if (existingBuilding) continue;
                this.addToQueue(buildingResponse, PlannedItemType.BUILDING, 1);
            }
            if (techUnit.getFriendlyUpgradeResponse().isEmpty()) continue;
            for (PlannedItem upgradeResponse : techUnit.getFriendlyUpgradeResponse()) {
                boolean existingUpgrade = false;
                for (PlannedItem pi : this.productionQueue) {
                    if (pi.getTechUpgrade() != null && upgradeResponse.getTechUpgrade() != null && pi.getTechUpgrade() == upgradeResponse.getTechUpgrade()) {
                        existingUpgrade = true;
                        break;
                    }
                    if (pi.getUpgradeType() == null || upgradeResponse.getUpgradeType() == null || pi.getUpgradeType() != upgradeResponse.getUpgradeType()) continue;
                    existingUpgrade = true;
                    break;
                }
                if (upgradeResponse.getTechUpgrade() != null && this.game.self().hasResearched(upgradeResponse.getTechUpgrade())) {
                    existingUpgrade = true;
                }
                if (upgradeResponse.getUpgradeType() != null && this.game.self().getUpgradeLevel(upgradeResponse.getUpgradeType()) >= upgradeResponse.getUpgradeLevel()) {
                    existingUpgrade = true;
                }
                if (existingUpgrade) continue;
                this.productionQueue.add(upgradeResponse);
            }
        }
    }

    private void addUnitTypeCount(Unit unit) {
        this.unitTypeCount.put(unit.getType(), this.unitTypeCount.get((Object)unit.getType()) + 1);
    }

    private void initUnitCounts() {
        for (UnitType unitType : UnitType.values()) {
            if (!unitType.getRace().toString().equals("Terran") || unitType.isCritter() || unitType.isHero() || unitType.isBeacon() || unitType.isSpecialBuilding()) continue;
            this.unitTypeCount.put(unitType, 0);
        }
    }

    private boolean isCurrentlyTraining(Unit unit, UnitType unitType) {
        return unit.getType() == unitType && !unit.isTraining();
    }

    private boolean isRecruitable(UnitType unitType) {
        int usedSupply = this.game.self().supplyUsed() / 2;
        int totalSupply = this.game.self().supplyTotal() / 2;
        int freeSupply = totalSupply - usedSupply;
        return this.resourceManager.getAvailableMinerals() >= unitType.mineralPrice() && this.resourceManager.getAvailableGas() >= unitType.gasPrice() && freeSupply >= unitType.supplyRequired() / 2;
    }

    private boolean isUpgrading(UpgradeType upgradeType) {
        for (Unit researchBuilding : this.allBuildings) {
            if (researchBuilding.getAddon() != null && researchBuilding.getAddon().getUpgrade() == upgradeType) {
                return true;
            }
            if (researchBuilding.getUpgrade() != upgradeType) continue;
            return true;
        }
        return false;
    }

    private boolean isResearching(TechType techType) {
        for (Unit researchBuilding : this.allBuildings) {
            if (researchBuilding.getAddon() != null && researchBuilding.getAddon().getTech() == techType) {
                return true;
            }
            if (researchBuilding.getTech() != techType) continue;
            return true;
        }
        return false;
    }

    private void researchUpgrade(UpgradeType upgradeType) {
        if (this.resourceManager.getAvailableMinerals() >= upgradeType.mineralPrice() && this.resourceManager.getAvailableGas() >= upgradeType.gasPrice()) {
            for (Unit researchBuilding : this.allBuildings) {
                if (!researchBuilding.canUpgrade(upgradeType) || researchBuilding.isUpgrading()) continue;
                researchBuilding.upgrade(upgradeType);
                break;
            }
        }
    }

    private void researchTech(TechType techType) {
        if (this.resourceManager.getAvailableMinerals() >= techType.mineralPrice() && this.resourceManager.getAvailableGas() >= techType.gasPrice()) {
            for (Unit researchBuilding : this.allBuildings) {
                if (!researchBuilding.canResearch(techType) || researchBuilding.isUpgrading()) continue;
                researchBuilding.research(techType);
                break;
            }
        }
    }

    private boolean isResearching(UnitType unitType) {
        int availableBuildings = 0;
        for (Unit researchBuilding : this.allBuildings) {
            if (researchBuilding.getType() != unitType || !researchBuilding.isCompleted() || researchBuilding.isResearching() || researchBuilding.isUpgrading()) continue;
            ++availableBuildings;
        }
        return availableBuildings > 0;
    }

    private boolean buildingInProduction(TilePosition tilePosition, UnitType unitType) {
        if (tilePosition == null) {
            return false;
        }
        for (Unit building : this.allBuildings) {
            if (building.getType() != unitType || building.getTilePosition().getX() != tilePosition.getX() || building.getTilePosition().getY() != tilePosition.getY()) continue;
            return true;
        }
        return false;
    }

    private void removeUnitTypeCount(Unit unit) {
        this.unitTypeCount.put(unit.getType(), this.unitTypeCount.get((Object)unit.getType()) - 1);
    }

    private void removeUnitTypeCount(UnitType unit) {
        this.unitTypeCount.put(unit, this.unitTypeCount.get((Object)unit) - 1);
    }

    private void removeBuilding(Unit unit) {
        this.allBuildings.remove(unit);
    }

    private void resetBuilding(Unit unit) {
        for (PlannedItem pi : this.productionQueue) {
            if (pi.getPlannedItemStatus() != PlannedItemStatus.IN_PROGRESS || pi.getUnitType() != unit.getType()) continue;
            for (Workers worker : this.resourceManager.getWorkers()) {
                if (!worker.getUnit().exists() || worker.getUnit() == null || worker.getUnit().getID() != pi.getAssignedBuilder().getUnitID()) continue;
                worker.setWorkerStatus(WorkerStatus.IDLE);
                break;
            }
            pi.setPlannedItemStatus(PlannedItemStatus.NOT_STARTED);
            pi.setAssignedBuilder(null);
            pi.setBuildPosition(null);
            pi.setPriority(1);
            break;
        }
    }

    private boolean meetsRequirements(UnitType unitType) {
        if (!unitType.isBuilding()) {
            return false;
        }
        if (unitType.tileHeight() == 3 && unitType.tileWidth() == 4 && this.buildTiles.getLargeBuildTiles().isEmpty()) {
            return false;
        }
        if (unitType.tileHeight() == 2 && unitType.tileWidth() == 3 && this.buildTiles.getMediumBuildTiles().isEmpty()) {
            return false;
        }
        Map<UnitType, Integer> requiredUnits = unitType.requiredUnits();
        if (requiredUnits.isEmpty()) {
            return true;
        }
        for (UnitType requiredUnit : requiredUnits.keySet()) {
            if (requiredUnits.size() == 1 && requiredUnit == UnitType.Terran_SCV) {
                return true;
            }
            if (!requiredUnit.isBuilding() || this.unitTypeCount.get((Object)requiredUnit) <= 0) continue;
            return true;
        }
        return false;
    }

    private boolean tileTaken(TilePosition tilePosition) {
        for (PlannedItem pi : this.productionQueue) {
            if (pi.getBuildPosition() == null || pi.getBuildPosition() != tilePosition) continue;
            return true;
        }
        return false;
    }

    private boolean canBeResearched(UnitType unitType) {
        return this.unitTypeCount.get((Object)unitType) > 0;
    }

    private boolean hasUnitInQueue(UnitType unitType) {
        return this.productionQueue.stream().anyMatch(pi -> pi.getUnitType() == unitType && pi.getPlannedItemStatus() == PlannedItemStatus.NOT_STARTED);
    }

    private void getOpenerNames() {
        this.openerNames.add(new EightRax());
        this.openerNames.add(new TwoRax());
        this.openerNames.add(new TwoRaxAcademy());
        this.openerNames.add(new OneRaxFE());
        this.openerNames.add(new TwoFac());
    }

    public void onFrame() {
        this.scvProduction();
        this.buildingProduction();
        this.addSupplyDepot();
        this.addUnitProduction();
        if (this.enemyInformation.getEnemyOpener() != null && !this.openerResponse) {
            this.openerResponse();
        }
        this.enemyTechResponse();
        this.buildTiles.onFrame();
        this.painters.paintProductionQueueReadout(this.productionQueue);
    }

    public void onUnitCreate(Unit unit) {
        if (unit.getType().isBuilding()) {
            this.allBuildings.add(unit);
        }
    }

    public void onUnitComplete(Unit unit) {
        this.addUnitTypeCount(unit);
        if (unit.canTrain()) {
            this.productionBuildings.add(unit);
        }
        if (unit.getType().isBuilding()) {
            this.newestCompletedBuilding = unit;
        }
        this.buildTiles.onUnitComplete(unit);
    }

    public void onUnitDestroy(Unit unit) {
        this.removeUnitTypeCount(unit);
        this.removeBuilding(unit);
        if (unit.getType().isBuilding()) {
            if (unit.getType() == UnitType.Terran_Bunker || unit.getType() == UnitType.Terran_Missile_Turret || unit.getType() == UnitType.Terran_Refinery) {
                return;
            }
            if (!unit.isCompleted()) {
                this.resetBuilding(unit);
            } else if (unit.getType().isAddon()) {
                this.addToQueue(unit.getType(), PlannedItemType.ADDON, 1);
            } else {
                this.addToQueue(unit.getType(), PlannedItemType.BUILDING, 1);
            }
            if (unit.getType().tileHeight() == 3 && unit.getType().tileWidth() == 4) {
                if (unit.getType() == UnitType.Terran_Command_Center) {
                    this.baseInfo.readdExpansion(unit);
                    return;
                }
                this.buildTiles.getLargeBuildTiles().add(unit.getTilePosition());
            } else if (unit.getType().tileHeight() == 2 && unit.getType().tileWidth() == 3) {
                this.buildTiles.getMediumBuildTiles().add(unit.getTilePosition());
            }
        }
    }

    public void onUnitMorph(Unit unit) {
        if (unit.getType().isBuilding()) {
            this.allBuildings.add(unit);
        }
        if (unit.getType() == UnitType.Terran_Siege_Tank_Siege_Mode) {
            this.removeUnitTypeCount(UnitType.Terran_Siege_Tank_Tank_Mode);
        } else if (unit.getType() == UnitType.Terran_Siege_Tank_Tank_Mode) {
            this.removeUnitTypeCount(UnitType.Terran_Siege_Tank_Siege_Mode);
        }
    }

    private static /* synthetic */ boolean lambda$buildingProduction$1(PlannedItem pi) {
        return pi.getPlannedItemStatus() == PlannedItemStatus.COMPLETE;
    }

    private static /* synthetic */ boolean lambda$buildingProduction$0(Unit productionBuilding, PlannedItem plannedItem) {
        return plannedItem.getAddOnParent() == productionBuilding;
    }
}

