/*
 * Decompiled with CFR 0.152.
 */
package information.enemy;

import information.BaseInfo;
import information.enemy.enemyopeners.CannonRush;
import information.enemy.enemyopeners.EnemyStrategy;
import information.enemy.enemyopeners.FourPool;
import information.enemy.enemytechunits.Arbiter;
import information.enemy.enemytechunits.Carrier;
import information.enemy.enemytechunits.EnemyTechUnits;
import information.enemy.enemytechunits.ShuttleReaver;
import java.util.HashSet;

public class EnemyStrategyManager {
    private BaseInfo baseInfo;
    private HashSet<EnemyStrategy> enemyStrategies = new HashSet();
    private HashSet<EnemyTechUnits> enemyTechUnits = new HashSet();

    public EnemyStrategyManager(BaseInfo baseInfo) {
        this.baseInfo = baseInfo;
        this.init();
    }

    private void init() {
        this.addEnemyStrategies();
        this.addEnemyTechUnits();
    }

    private void addEnemyStrategies() {
        this.enemyStrategies.add(new FourPool());
        this.enemyStrategies.add(new CannonRush(this.baseInfo));
    }

    private void addEnemyTechUnits() {
        this.enemyTechUnits.add(new ShuttleReaver());
        this.enemyTechUnits.add(new Arbiter());
        this.enemyTechUnits.add(new Carrier());
    }

    public HashSet<EnemyStrategy> getEnemyStrategies() {
        return this.enemyStrategies;
    }

    public HashSet<EnemyTechUnits> getEnemyTechUnits() {
        return this.enemyTechUnits;
    }
}

