/*
 * Decompiled with CFR 0.152.
 */
package debug;

import bwapi.Color;
import bwapi.Game;
import bwapi.Position;
import bwapi.Text;
import bwapi.TilePosition;
import bwapi.Unit;
import bwapi.UnitType;
import bwem.BWEM;
import bwem.Base;
import bwem.ChokePoint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.PriorityQueue;
import macro.ResourceManager;
import macro.unitgroups.CombatUnits;
import macro.unitgroups.UnitStatus;
import macro.unitgroups.Workers;
import planner.PlannedItem;

public class Painters {
    Game game;
    BWEM bwem;
    ResourceManager resourceManager;

    public Painters(Game game, BWEM bwem, ResourceManager resourceManager) {
        this.game = game;
        this.bwem = bwem;
        this.resourceManager = resourceManager;
    }

    public Painters(Game game) {
        this.game = game;
    }

    public Painters(Game game, BWEM bwem) {
        this.game = game;
        this.bwem = bwem;
    }

    private void paintCircle(Unit unit, int radius, Color color) {
        if (unit == null) {
            return;
        }
        this.game.drawCircleMap(unit.getPosition(), radius, color);
    }

    private void paintCircle(Unit unit, Color color) {
        if (unit == null) {
            return;
        }
        this.game.drawCircleMap(unit.getPosition(), 8, color);
    }

    private void paintCircle(Position position, int radius, Color color) {
        if (position == null) {
            return;
        }
        this.game.drawCircleMap(position, radius, color);
    }

    private void paintWorker() {
        for (Workers worker : this.resourceManager.getWorkers()) {
            switch (worker.getWorkerStatus()) {
                case MINERALS: {
                    this.paintCircle(worker.getUnit(), 8, Color.Blue);
                    break;
                }
                case SCOUTING: {
                    this.paintCircle(worker.getUnit(), 8, Color.Orange);
                    break;
                }
                case IDLE: {
                    this.paintCircle(worker.getUnit(), 8, Color.White);
                    break;
                }
                case MOVING_TO_BUILD: {
                    this.paintCircle(worker.getUnit(), 8, Color.Purple);
                    break;
                }
                case BUILDING: {
                    this.paintCircle(worker.getUnit(), 8, Color.Yellow);
                    break;
                }
                case GAS: {
                    this.paintCircle(worker.getUnit(), 8, Color.Green);
                    break;
                }
                case ATTACKING: {
                    this.paintCircle(worker.getUnit(), 8, Color.Red);
                    break;
                }
                case REPAIRING: {
                    this.paintCircle(worker.getUnit(), 8, Color.Grey);
                    break;
                }
                case DEFEND: {
                    this.paintCircle(worker.getUnit(), 8, Color.Teal);
                    break;
                }
                case STUCK: {
                    this.paintCircle(worker.getUnit(), 8, Color.Black);
                }
            }
        }
    }

    public void paintBuildTile(TilePosition tilePosition, UnitType unitType, Color color) {
        this.game.drawBoxMap(tilePosition.toPosition(), tilePosition.toPosition().add(new Position(unitType.width() + 2, unitType.height() + 2)), color);
    }

    public void drawAttackRange(Unit unit) {
        if (unit == null) {
            return;
        }
        this.game.drawCircleMap(unit.getPosition(), unit.getType().groundWeapon().maxRange(), Color.Cyan);
    }

    public void paintNatural(Base base) {
        this.game.drawCircleMap(base.getCenter(), 40, Color.Green);
        this.game.drawTextMap(base.getCenter(), "Natural", new Text[0]);
    }

    public void paintNaturalChoke(ChokePoint chokePoint) {
        this.game.drawCircleMap(chokePoint.getCenter().toPosition(), 40, Color.Yellow);
    }

    public void paintAllChokes() {
        for (ChokePoint chokePoint : this.bwem.getMap().getChokePoints()) {
            this.game.drawCircleMap(chokePoint.getCenter().toPosition(), 25, Color.White);
        }
    }

    public void paintTilePositions(List<Position> position) {
        for (Position pos : position) {
            this.game.drawCircleMap(pos, 2, Color.White, true);
        }
    }

    public void paintBasePosition(HashSet<Base> bases) {
        for (Base base : bases) {
            this.game.drawTextMap(base.getCenter(), String.valueOf(base.getCenter()), new Text[0]);
        }
    }

    public void paintUnitStatus(CombatUnits unit) {
        switch (unit.getUnitStatus()) {
            case RALLY: {
                this.game.drawCircleMap(unit.getUnit().getPosition(), 3, Color.White, true);
                break;
            }
            case ATTACK: {
                this.game.drawCircleMap(unit.getUnit().getPosition(), 3, Color.Red, true);
                break;
            }
            case LOAD: {
                this.game.drawCircleMap(unit.getUnit().getPosition(), 3, Color.Blue, true);
                break;
            }
            case DEFEND: {
                this.game.drawCircleMap(unit.getUnit().getPosition(), 3, Color.Purple, true);
                break;
            }
            case SCOUT: {
                this.game.drawCircleMap(unit.getUnit().getPosition(), 3, Color.Orange, true);
                break;
            }
            case RETREAT: {
                this.game.drawCircleMap(unit.getUnit().getPosition(), 3, Color.Teal, true);
                break;
            }
            case OBSTRUCTING: {
                this.game.drawCircleMap(unit.getUnit().getPosition(), 3, Color.Grey, true);
                break;
            }
            case SIEGEDEF: {
                this.game.drawCircleMap(unit.getUnit().getPosition(), 3, Color.Yellow, true);
                break;
            }
            case HUNTING: {
                this.game.drawCircleMap(unit.getUnit().getPosition(), 3, Color.Green, true);
            }
        }
    }

    public void paintStimStatus(CombatUnits unit) {
        if (unit.getUnit().isStimmed()) {
            this.game.drawTextMap(unit.getUnit().getPosition(), "STIMMED", new Text[0]);
        }
    }

    public void paintWorkerText() {
        for (Workers worker : this.resourceManager.getWorkers()) {
            this.game.drawTextMap(worker.getUnit().getPosition(), worker.getWorkerStatus().toString(), new Text[0]);
        }
    }

    public void paintClosestEnemy(CombatUnits unit) {
        if (unit.getEnemyUnit() != null && unit.getEnemyUnit().getEnemyPosition() != null) {
            this.game.drawLineMap(unit.getUnit().getPosition(), unit.getEnemyUnit().getEnemyPosition(), Color.Yellow);
        }
    }

    public void paintScoutPath(Unit unit) {
        this.game.drawLineMap(unit.getPosition(), unit.getTargetPosition(), Color.Cyan);
    }

    public void paintScoutPoints(int x, int y) {
        this.game.drawCircleMap(x, y, 25, Color.Orange, true);
    }

    public void paintLargeBuildTiles(HashSet<TilePosition> buildTiles) {
        for (TilePosition tilePosition : buildTiles) {
            this.game.drawTextMap(tilePosition.toPosition(), String.valueOf(tilePosition), new Text[0]);
            Position start = tilePosition.toPosition();
            Position end = new Position(start.getX() + UnitType.Terran_Barracks.tileWidth() * 32, start.getY() + UnitType.Terran_Barracks.tileHeight() * 32);
            this.game.drawBoxMap(start, end, Color.Green);
        }
    }

    public void paintMediumBuildTiles(HashSet<TilePosition> buildTiles, Color color) {
        for (TilePosition tilePosition : buildTiles) {
            this.game.drawTextMap(tilePosition.toPosition(), String.valueOf(tilePosition), new Text[0]);
            Position depotStart = tilePosition.toPosition();
            Position depotEnd = new Position(depotStart.getX() + UnitType.Terran_Supply_Depot.tileWidth() * 32, depotStart.getY() + UnitType.Terran_Supply_Depot.tileHeight() * 32);
            this.game.drawBoxMap(depotStart, depotEnd, color);
        }
    }

    public void paintPaintBunkerTile(TilePosition tilePosition) {
        if (tilePosition == null) {
            return;
        }
        this.game.drawTextMap(tilePosition.toPosition(), String.valueOf(tilePosition), new Text[0]);
        Position start = tilePosition.toPosition();
        Position end = new Position(start.getX() + UnitType.Terran_Bunker.tileWidth() * 32, start.getY() + UnitType.Terran_Bunker.tileHeight() * 32);
        this.game.drawBoxMap(start, end, Color.Red);
    }

    public void paintMissileTile(TilePosition tilePosition) {
        if (tilePosition == null) {
            return;
        }
        this.game.drawTextMap(tilePosition.toPosition(), String.valueOf(tilePosition), new Text[0]);
        Position start = tilePosition.toPosition();
        Position end = new Position(start.getX() + UnitType.Terran_Missile_Turret.tileWidth() * 32, start.getY() + UnitType.Terran_Missile_Turret.tileHeight() * 32);
        this.game.drawBoxMap(start, end, Color.Teal);
    }

    public void paintTiles(HashSet<TilePosition> tiles) {
        for (TilePosition tile : tiles) {
            this.game.drawBoxMap(tile.toPosition(), tile.toPosition().add(new Position(32, 32)), Color.White);
        }
    }

    public void paintAvailableBuildTiles(HashSet<TilePosition> buildTiles, int offset, String tileType) {
        this.game.drawTextScreen(5, 30 + offset, tileType + " Tiles Available: " + buildTiles.size(), new Text[0]);
    }

    public void paintExpansionOrdering(List<Base> orderedExpansions) {
        for (int i = 0; i < orderedExpansions.size(); ++i) {
            this.game.drawTextMap(orderedExpansions.get(i).getCenter(), "Expansion: " + i, new Text[0]);
            this.game.drawCircleMap(orderedExpansions.get(i).getCenter(), 40, Color.Purple);
        }
    }

    public void paintCombatScouts(CombatUnits unit) {
        if (unit.getUnitStatus() == UnitStatus.SCOUT) {
            this.game.drawLineMap(unit.getUnit().getPosition(), unit.getUnit().getTargetPosition(), Color.Purple);
        }
    }

    public void paintMainBufferZone(Base base) {
        this.game.drawCircleMap(base.getCenter(), 800, Color.Yellow);
    }

    public void paintTileZone(HashSet<TilePosition> buildTiles, Color color) {
        for (TilePosition tile : buildTiles) {
            this.game.drawBoxMap(tile.toPosition(), tile.toPosition().add(new Position(32, 32)), color);
        }
    }

    public void paintMedicTarget(CombatUnits unit) {
        if (unit.getUnitType() != UnitType.Terran_Medic) {
            return;
        }
        if (unit.getFriendlyUnit() != null) {
            this.game.drawLineMap(unit.getUnit().getPosition(), unit.getFriendlyUnit().getUnit().getPosition(), Color.Green);
        }
    }

    public void paintProductionQueueReadout(PriorityQueue<PlannedItem> productionQueue) {
        ArrayList<PlannedItem> safeQueue = new ArrayList<PlannedItem>(productionQueue);
        Collections.sort(safeQueue, Comparator.comparingInt(PlannedItem::getSupply));
        int readoutAmount = 0;
        this.game.setTextSize(Text.Size.Small);
        for (PlannedItem pi : safeQueue) {
            if (readoutAmount >= 10) continue;
            if (pi.getUnitType() != null) {
                this.game.drawTextScreen(350, 20 + 15 * readoutAmount, "\u0004 Supply: " + pi.getSupply() + " Type: " + pi.getUnitType().toString() + " " + pi.getPlannedItemStatus().toString() + " " + pi.getPriority(), new Text[0]);
                ++readoutAmount;
                continue;
            }
            if (pi.getUpgradeType() != null) {
                this.game.drawTextScreen(350, 20 + 15 * readoutAmount, "\u000e Supply: " + pi.getSupply() + " Type: " + pi.getUpgradeType().toString() + " " + pi.getPlannedItemStatus().toString() + " " + pi.getPriority(), new Text[0]);
                ++readoutAmount;
                continue;
            }
            if (pi.getTechUpgrade() == null) continue;
            this.game.drawTextScreen(350, 20 + 15 * readoutAmount, "\u000e Supply: " + pi.getSupply() + " Type: " + pi.getTechUpgrade().toString() + " " + pi.getPlannedItemStatus().toString() + " " + pi.getPriority(), new Text[0]);
            ++readoutAmount;
        }
        this.game.setTextSize(Text.Size.Default);
    }

    public void paintRadiusAroundUnit(Unit unit, int radius, Color color) {
        if (unit == null) {
            return;
        }
        this.game.drawCircleMap(unit.getPosition(), radius, color);
    }

    public void onFrame() {
        this.paintWorker();
        this.paintWorkerText();
    }
}

