/*
 * Decompiled with CFR 0.152.
 */
package bwem;

import bwapi.WalkPosition;
import bwem.Altitude;
import bwem.AreaId;
import bwem.Asserter;
import bwem.MiniTile;

class TempAreaInfo {
    private final AreaId id;
    private final WalkPosition walkPositionWithHighestAltitude;
    private final Altitude highestAltitude;
    private boolean isValid;
    private int size;
    private final Asserter asserter;

    TempAreaInfo(Asserter asserter) {
        this.isValid = false;
        this.id = AreaId.ZERO;
        this.walkPositionWithHighestAltitude = new WalkPosition(0, 0);
        this.highestAltitude = Altitude.ZERO;
        this.asserter = asserter;
        if (this.isValid()) {
            asserter.throwIllegalStateException("");
        }
    }

    TempAreaInfo(AreaId id, MiniTile miniTile, WalkPosition walkPositionWithHighestAltitude, Asserter asserter) {
        this.isValid = true;
        this.id = id;
        this.walkPositionWithHighestAltitude = walkPositionWithHighestAltitude;
        this.size = 0;
        this.highestAltitude = miniTile.getAltitude();
        this.asserter = asserter;
        this.add(miniTile);
        if (!this.isValid()) {
            asserter.throwIllegalStateException("");
        }
    }

    boolean isValid() {
        return this.isValid;
    }

    AreaId getId() {
        if (!this.isValid()) {
            this.asserter.throwIllegalStateException("");
        }
        return this.id;
    }

    WalkPosition getWalkPositionWithHighestAltitude() {
        if (!this.isValid()) {
            this.asserter.throwIllegalStateException("");
        }
        return this.walkPositionWithHighestAltitude;
    }

    public int getSize() {
        if (!this.isValid()) {
            this.asserter.throwIllegalStateException("");
        }
        return this.size;
    }

    Altitude getHighestAltitude() {
        if (!this.isValid()) {
            this.asserter.throwIllegalStateException("");
        }
        return this.highestAltitude;
    }

    public void add(MiniTile miniTile) {
        if (!this.isValid()) {
            this.asserter.throwIllegalStateException("");
        }
        ++this.size;
        miniTile.setAreaId(this.id);
    }

    void merge(TempAreaInfo absorbed) {
        if (!this.isValid() || !absorbed.isValid()) {
            this.asserter.throwIllegalStateException("");
        } else if (this.size < absorbed.size) {
            this.asserter.throwIllegalStateException("");
        }
        this.size += absorbed.size;
        absorbed.isValid = false;
    }
}

