/*
 * Decompiled with CFR 0.152.
 */
package bwem;

import bwapi.Game;
import bwapi.Pair;
import bwapi.Player;
import bwapi.Position;
import bwapi.TilePosition;
import bwapi.Unit;
import bwapi.UnitType;
import bwapi.WalkPosition;
import bwem.Altitude;
import bwem.Area;
import bwem.AreaId;
import bwem.AreaInitializer;
import bwem.Asserter;
import bwem.Base;
import bwem.CPPath;
import bwem.ChokePoint;
import bwem.Graph;
import bwem.Mineral;
import bwem.MiniTile;
import bwem.NeutralData;
import bwem.PathingResult;
import bwem.StaticBuilding;
import bwem.TerrainData;
import bwem.Tile;
import bwem.util.BwemExt;
import bwem.util.CheckMode;
import bwem.util.Pred;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;

public abstract class BWMap {
    final List<Pair<Pair<AreaId, AreaId>, WalkPosition>> rawFrontier = new ArrayList<Pair<Pair<AreaId, AreaId>, WalkPosition>>();
    final Game game;
    final List<Unit> mineralPatches;
    final List<Player> players;
    final List<Unit> vespeneGeysers;
    final List<Unit> units;
    private boolean automaticPathUpdate = false;
    private final Graph graph;
    private final NeighboringAreaChooser neighboringAreaChooser;
    TerrainData terrainData = null;
    NeutralData neutralData = null;
    Altitude highestAltitude;
    final Asserter asserter;

    BWMap(Game game, Asserter asserter) {
        this.game = game;
        this.players = game.getPlayers();
        this.mineralPatches = game.getMinerals();
        this.vespeneGeysers = game.getGeysers();
        this.units = game.getAllUnits();
        this.graph = new Graph(this);
        this.neighboringAreaChooser = new NeighboringAreaChooser();
        this.asserter = asserter;
    }

    public TerrainData getData() {
        return this.terrainData;
    }

    public boolean isInitialized() {
        return this.terrainData != null;
    }

    Graph getGraph() {
        return this.graph;
    }

    public List<Pair<Pair<AreaId, AreaId>, WalkPosition>> getRawFrontier() {
        return this.rawFrontier;
    }

    public boolean automaticPathUpdate() {
        return this.automaticPathUpdate;
    }

    public void enableAutomaticPathAnalysis() {
        this.automaticPathUpdate = true;
    }

    public void assignStartingLocationsToSuitableBases() {
        boolean atLeastOneFailed = false;
        for (TilePosition startingLocation : this.getData().getMapData().getStartingLocations()) {
            boolean isAssigned = false;
            for (Base base : this.getBases()) {
                if (BwemExt.queenWiseDist(base.getLocation(), startingLocation) > 3) continue;
                base.assignStartingLocation(startingLocation);
                isAssigned = true;
            }
            if (atLeastOneFailed || isAssigned) continue;
            atLeastOneFailed = true;
        }
        if (atLeastOneFailed) {
            this.asserter.throwIllegalStateException("At least one starting location was not assigned to a base.");
        }
    }

    public List<TilePosition> getUnassignedStartingLocations() {
        ArrayList<TilePosition> remainingStartingLocations = new ArrayList<TilePosition>(this.getData().getMapData().getStartingLocations());
        for (Base base : this.getBases()) {
            if (remainingStartingLocations.isEmpty()) break;
            if (!base.isStartingLocation() || !base.getLocation().equals(remainingStartingLocations.get(0))) continue;
            remainingStartingLocations.remove(0);
        }
        return remainingStartingLocations;
    }

    public Altitude getHighestAltitude() {
        return this.highestAltitude;
    }

    public List<Base> getBases() {
        return this.getGraph().getBases();
    }

    public List<ChokePoint> getChokePoints() {
        return this.getGraph().getChokePoints();
    }

    public NeutralData getNeutralData() {
        return this.neutralData;
    }

    public void onUnitDestroyed(Unit u) {
        if (u.getType().isMineralField()) {
            this.onMineralDestroyed(u);
        } else {
            this.onStaticBuildingDestroyed(u);
        }
    }

    private void onMineralDestroyed(Unit u) {
        for (int i = 0; i < this.getNeutralData().getMinerals().size(); ++i) {
            Mineral mineral = this.getNeutralData().getMinerals().get(i);
            if (!mineral.getUnit().equals(u)) continue;
            this.onMineralDestroyed(mineral);
            mineral.simulateCPPObjectDestructor();
            this.getNeutralData().getMinerals().remove(i);
            return;
        }
        this.asserter.throwIllegalStateException("unit is not a Mineral");
    }

    private void onMineralDestroyed(Mineral pMineral) {
        for (Area area : this.getGraph().getAreas()) {
            ((AreaInitializer)area).onMineralDestroyed(pMineral);
        }
    }

    private void onStaticBuildingDestroyed(Unit u) {
        for (int i = 0; i < this.getNeutralData().getStaticBuildings().size(); ++i) {
            StaticBuilding building = this.getNeutralData().getStaticBuildings().get(i);
            if (!building.getUnit().equals(u)) continue;
            building.simulateCPPObjectDestructor();
            this.getNeutralData().getStaticBuildings().remove(i);
            return;
        }
    }

    public List<Area> getAreas() {
        return this.getGraph().getAreas();
    }

    public Area getArea(AreaId id) {
        return this.graph.getArea(id);
    }

    public Area getArea(WalkPosition w) {
        return this.graph.getArea(w);
    }

    public Area getArea(TilePosition t) {
        return this.graph.getArea(t);
    }

    public Area getNearestArea(WalkPosition w) {
        return this.graph.getNearestArea(w);
    }

    public Area getNearestArea(TilePosition t) {
        return this.graph.getNearestArea(t);
    }

    public Area getMainArea(TilePosition topLeft, TilePosition size) {
        for (int dy = 0; dy < size.getY(); ++dy) {
            for (int dx = 0; dx < size.getX(); ++dx) {
                Area area = this.getArea(topLeft.add(new TilePosition(dx, dy)));
                if (area == null) continue;
                return area;
            }
        }
        return null;
    }

    public int getPathLength(Position a, Position b) {
        return this.graph.getPathingResult(a, b).map(PathingResult::getLength).orElse(-1);
    }

    public CPPath getPath(Position a, Position b) {
        return this.graph.getPath(a, b).orElse(CPPath.EMPTY_PATH);
    }

    public TilePosition breadthFirstSearch(TilePosition start, Pred<Tile, TilePosition> findCond, Pred<Tile, TilePosition> visitCond, boolean connect8) {
        TilePosition[] directions;
        if (findCond.test(this.getData().getTile(start), start)) {
            return start;
        }
        TreeSet<TilePosition> visited = new TreeSet<TilePosition>(Comparator.comparing(tilePosition -> tilePosition.x).thenComparing(tilePosition -> tilePosition.y));
        ArrayDeque<TilePosition> toVisit = new ArrayDeque<TilePosition>();
        toVisit.add(start);
        visited.add(start);
        TilePosition[] dir8 = new TilePosition[]{new TilePosition(-1, -1), new TilePosition(0, -1), new TilePosition(1, -1), new TilePosition(-1, 0), new TilePosition(1, 0), new TilePosition(-1, 1), new TilePosition(0, 1), new TilePosition(1, 1)};
        TilePosition[] dir4 = new TilePosition[]{new TilePosition(0, -1), new TilePosition(-1, 0), new TilePosition(1, 0), new TilePosition(0, 1)};
        TilePosition[] tilePositionArray = directions = connect8 ? dir8 : dir4;
        while (!toVisit.isEmpty()) {
            TilePosition current = (TilePosition)toVisit.remove();
            for (TilePosition delta : directions) {
                TilePosition next = current.add(delta);
                if (!this.getData().getMapData().isValid(next)) continue;
                Tile nextTile = this.getData().getTile(next, CheckMode.NO_CHECK);
                if (findCond.test(nextTile, next)) {
                    return next;
                }
                if (!visitCond.test(nextTile, next) || visited.contains(next)) continue;
                toVisit.add(next);
                visited.add(next);
            }
        }
        this.asserter.throwIllegalStateException("");
        return start;
    }

    public TilePosition breadthFirstSearch(TilePosition start, Pred<Tile, TilePosition> findCond, Pred<Tile, TilePosition> visitCond) {
        return this.breadthFirstSearch(start, findCond, visitCond, true);
    }

    public WalkPosition breadthFirstSearch(WalkPosition start, Pred<MiniTile, WalkPosition> findCond, Pred<MiniTile, WalkPosition> visitCond, boolean connect8) {
        WalkPosition[] directions;
        if (findCond.test(this.getData().getMiniTile(start), start)) {
            return start;
        }
        TreeSet<WalkPosition> visited = new TreeSet<WalkPosition>(Comparator.comparing(pos -> pos.x).thenComparing(pos -> pos.y));
        ArrayDeque<WalkPosition> toVisit = new ArrayDeque<WalkPosition>();
        toVisit.add(start);
        visited.add(start);
        WalkPosition[] dir8 = new WalkPosition[]{new WalkPosition(-1, -1), new WalkPosition(0, -1), new WalkPosition(1, -1), new WalkPosition(-1, 0), new WalkPosition(1, 0), new WalkPosition(-1, 1), new WalkPosition(0, 1), new WalkPosition(1, 1)};
        WalkPosition[] dir4 = new WalkPosition[]{new WalkPosition(0, -1), new WalkPosition(-1, 0), new WalkPosition(1, 0), new WalkPosition(0, 1)};
        WalkPosition[] walkPositionArray = directions = connect8 ? dir8 : dir4;
        while (!toVisit.isEmpty()) {
            WalkPosition current = (WalkPosition)toVisit.remove();
            for (WalkPosition delta : directions) {
                WalkPosition next = current.add(delta);
                if (!this.getData().getMapData().isValid(next)) continue;
                MiniTile miniTile = this.getData().getMiniTile(next, CheckMode.NO_CHECK);
                if (findCond.test(miniTile, next)) {
                    return next;
                }
                if (!visitCond.test(miniTile, next) || visited.contains(next)) continue;
                toVisit.add(next);
                visited.add(next);
            }
        }
        this.asserter.throwIllegalStateException("");
        return start;
    }

    public WalkPosition breadthFirstSearch(WalkPosition start, Pred<MiniTile, WalkPosition> findCond, Pred<MiniTile, WalkPosition> visitCond) {
        return this.breadthFirstSearch(start, findCond, visitCond, true);
    }

    public Tile getTile(TilePosition tilePosition) {
        return this.getData().getTile(tilePosition);
    }

    public Position getCenter() {
        return this.getData().getMapData().getCenter();
    }

    public List<TilePosition> getStartingLocations() {
        return this.getData().getMapData().getStartingLocations();
    }

    private List<Unit> filterPlayerUnits(Collection<Unit> units, Player player) {
        ArrayList<Unit> ret = new ArrayList<Unit>();
        for (Unit u : units) {
            if (u.getType().isMineralField() || u.getType().equals((Object)UnitType.Resource_Vespene_Geyser) || !u.getPlayer().equals(player)) continue;
            ret.add(u);
        }
        return ret;
    }

    List<Unit> filterNeutralPlayerUnits(Collection<Unit> units, Collection<Player> players) {
        ArrayList<Unit> ret = new ArrayList<Unit>();
        for (Player player : players) {
            if (!player.isNeutral()) continue;
            ret.addAll(this.filterPlayerUnits(units, player));
        }
        return ret;
    }

    void setAreaIdInTile(TilePosition t) {
        Tile tile = this.getData().getTile(t);
        if (tile.getAreaId().intValue() != 0) {
            this.asserter.throwIllegalStateException("");
        }
        for (int dy = 0; dy < 4; ++dy) {
            for (int dx = 0; dx < 4; ++dx) {
                AreaId id = this.getData().getMiniTile(t.toWalkPosition().add(new WalkPosition(dx, dy)), CheckMode.NO_CHECK).getAreaId();
                if (id.intValue() == 0) continue;
                if (tile.getAreaId().intValue() == 0) {
                    tile.setAreaId(id);
                    continue;
                }
                if (tile.getAreaId().equals(id)) continue;
                tile.setAreaId(AreaId.UNINITIALIZED);
                return;
            }
        }
    }

    Pair<AreaId, AreaId> findNeighboringAreas(WalkPosition p) {
        WalkPosition[] deltas;
        Pair<Object, Object> result = new Pair<Object, Object>(null, null);
        for (WalkPosition delta : deltas = new WalkPosition[]{new WalkPosition(0, -1), new WalkPosition(-1, 0), new WalkPosition(1, 0), new WalkPosition(0, 1)}) {
            AreaId areaId;
            if (!this.getData().getMapData().isValid(p.add(delta)) || (areaId = this.getData().getMiniTile(p.add(delta), CheckMode.NO_CHECK).getAreaId()).intValue() <= 0) continue;
            if (result.getLeft() == null) {
                result.setLeft(areaId);
                continue;
            }
            if (((AreaId)result.getLeft()).equals(areaId) || result.getRight() != null && areaId.intValue() >= ((AreaId)result.getRight()).intValue()) continue;
            result.setRight(areaId);
        }
        return result;
    }

    AreaId chooseNeighboringArea(AreaId a, AreaId b) {
        return this.neighboringAreaChooser.chooseNeighboringArea(a, b);
    }

    private static class NeighboringAreaChooser {
        private final BitSet areaPairFlag = new BitSet(800000);

        private NeighboringAreaChooser() {
        }

        AreaId chooseNeighboringArea(AreaId a, AreaId b) {
            int aId = a.intValue();
            int bId = b.intValue();
            int cantor = (aId + bId) * (aId + bId + 1);
            cantor = aId > bId ? (cantor += bId) : (cantor += aId);
            this.areaPairFlag.flip(cantor);
            return this.areaPairFlag.get(cantor) ? a : b;
        }
    }
}

