/*
 * Decompiled with CFR 0.152.
 */
package bwapi;

import bwapi.ClientConnection;
import bwapi.SharedLockConnectionException;
import bwapi.SharedMemoryConnectionException;
import bwapi.WrappedBuffer;
import com.sun.jna.LastErrorException;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.linux.LibRT;
import com.sun.jna.platform.unix.LibC;
import java.io.File;
import java.io.IOException;
import java.util.function.Supplier;
import org.newsclub.net.unix.AFUNIXSocket;
import org.newsclub.net.unix.AFUNIXSocketAddress;

class ClientConnectionPosix
implements ClientConnection {
    private AFUNIXSocket syncSocket = null;

    ClientConnectionPosix() {
    }

    @Override
    public void disconnect() {
        if (this.syncSocket != null) {
            try {
                this.syncSocket.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.syncSocket = null;
        }
    }

    @Override
    public WrappedBuffer getGameTable() {
        int fd = PosixShm.INSTANCE.shm_open("/bwapi_shared_memory_game_list", 2, 0);
        if (fd < 0) {
            throw new IllegalStateException("SHM not found");
        }
        Pointer gameTableView = LibCExt.INSTANCE.mmap(Pointer.NULL, 96, 3, 1, fd, 0);
        return new WrappedBuffer(gameTableView, 96);
    }

    @Override
    public WrappedBuffer getSharedMemory(int serverProcID) {
        String sharedMemoryName = "/bwapi_shared_memory_" + serverProcID;
        try {
            Pointer mapFileView = LibCExt.INSTANCE.mmap(Pointer.NULL, 33017048, 3, 1, LibRT.INSTANCE.shm_open(sharedMemoryName, 2, 0), 0);
            return new WrappedBuffer(mapFileView, 33017048);
        }
        catch (Exception e) {
            throw new SharedMemoryConnectionException(sharedMemoryName, e);
        }
    }

    @Override
    public void connectSharedLock(int serverProcID) {
        String communicationSocket = "/tmp/bwapi_socket_" + serverProcID;
        try {
            this.syncSocket = AFUNIXSocket.newInstance();
            this.syncSocket.connect(new AFUNIXSocketAddress(new File(communicationSocket)));
        }
        catch (IOException e) {
            this.syncSocket = null;
            throw new SharedLockConnectionException("Unable to open communications socket: " + communicationSocket, e);
        }
    }

    @Override
    public void waitForServerData() throws IOException {
        while (this.syncSocket.getInputStream().read() != 2) {
        }
    }

    @Override
    public void submitClientData() throws IOException {
        this.syncSocket.getOutputStream().write(1);
    }

    static interface PosixShm
    extends Library {
        public static final PosixShm INSTANCE = ((Supplier<PosixShm>)() -> {
            if (System.getProperty("os.name").toLowerCase().contains("linux")) {
                Native.load("rt", LibRT.class);
            }
            return Native.load(PosixShm.class);
        }).get();

        public int shm_open(String var1, int var2, int var3);
    }

    static interface LibCExt
    extends LibC {
        public static final LibCExt INSTANCE = Native.load(LibCExt.class);

        public Pointer mmap(Pointer var1, int var2, int var3, int var4, int var5, int var6) throws LastErrorException;
    }
}

