/*
 * Decompiled with CFR 0.152.
 */
package jps;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import jps.Graph;
import jps.JPS;
import jps.Node;

public class JPSDiagNoObstacles<T extends Node>
extends JPS<T> {
    public JPSDiagNoObstacles(Graph<T> graph) {
        super(graph);
    }

    @Override
    protected Set<T> findNeighbors(T node, Map<T, T> parentMap) {
        HashSet<T> neighbors = new HashSet<T>();
        Node parent = (Node)parentMap.get(node);
        if (parent != null) {
            int dy;
            int x = ((Node)node).x;
            int y = ((Node)node).y;
            int dx = (x - parent.x) / Math.max(Math.abs(x - parent.x), 1);
            if ((dx & (dy = (y - parent.y) / Math.max(Math.abs(y - parent.y), 1))) != 0) {
                if (this.graph.isWalkable(x, y + dy)) {
                    neighbors.add(this.graph.getNode(x, y + dy));
                }
                if (this.graph.isWalkable(x + dx, y)) {
                    neighbors.add(this.graph.getNode(x + dx, y));
                }
                if (this.graph.isWalkable(x, y + dy) && this.graph.isWalkable(x + dx, y)) {
                    neighbors.add(this.graph.getNode(x + dx, y + dy));
                }
            } else if (dx != 0) {
                boolean nextWalkable = this.graph.isWalkable(x + dx, y);
                boolean topWalkable = this.graph.isWalkable(x, y + 1);
                boolean bottomWalkable = this.graph.isWalkable(x, y - 1);
                if (nextWalkable) {
                    neighbors.add(this.graph.getNode(x + dx, y));
                    if (topWalkable) {
                        neighbors.add(this.graph.getNode(x + dx, y + 1));
                    }
                    if (bottomWalkable) {
                        neighbors.add(this.graph.getNode(x + dx, y - 1));
                    }
                }
                if (topWalkable) {
                    neighbors.add(this.graph.getNode(x, y + 1));
                }
                if (bottomWalkable) {
                    neighbors.add(this.graph.getNode(x, y - 1));
                }
            } else if (dy != 0) {
                boolean nextWalkable = this.graph.isWalkable(x, y + dy);
                boolean rightWalkable = this.graph.isWalkable(x + 1, y);
                boolean leftWalkable = this.graph.isWalkable(x - 1, y);
                if (nextWalkable) {
                    neighbors.add(this.graph.getNode(x, y + dy));
                    if (rightWalkable) {
                        neighbors.add(this.graph.getNode(x + 1, y + dy));
                    }
                    if (leftWalkable) {
                        neighbors.add(this.graph.getNode(x - 1, y + dy));
                    }
                }
                if (rightWalkable) {
                    neighbors.add(this.graph.getNode(x + 1, y));
                }
                if (leftWalkable) {
                    neighbors.add(this.graph.getNode(x - 1, y));
                }
            }
        } else {
            neighbors.addAll(this.graph.getNeighborsOf(node, Graph.Diagonal.NO_OBSTACLES));
        }
        return neighbors;
    }

    @Override
    protected T jump(T neighbor, T current, Set<T> goals) {
        if (neighbor == null || !((Node)neighbor).walkable) {
            return null;
        }
        if (goals.contains(neighbor)) {
            return neighbor;
        }
        int dx = ((Node)neighbor).x - ((Node)current).x;
        int dy = ((Node)neighbor).y - ((Node)current).y;
        if ((dx & dy) != 0 ? this.jump(this.graph.getNode(((Node)neighbor).x + dx, ((Node)neighbor).y), neighbor, goals) != null || this.jump(this.graph.getNode(((Node)neighbor).x, ((Node)neighbor).y + dy), neighbor, goals) != null : (dx != 0 ? this.graph.isWalkable(((Node)neighbor).x, ((Node)neighbor).y - 1) && !this.graph.isWalkable(((Node)neighbor).x - dx, ((Node)neighbor).y - 1) || this.graph.isWalkable(((Node)neighbor).x, ((Node)neighbor).y + 1) && !this.graph.isWalkable(((Node)neighbor).x - dx, ((Node)neighbor).y + 1) : dy != 0 && (this.graph.isWalkable(((Node)neighbor).x - 1, ((Node)neighbor).y) && !this.graph.isWalkable(((Node)neighbor).x - 1, ((Node)neighbor).y - dy) || this.graph.isWalkable(((Node)neighbor).x + 1, ((Node)neighbor).y) && !this.graph.isWalkable(((Node)neighbor).x + 1, ((Node)neighbor).y - dy)))) {
            return neighbor;
        }
        if (this.graph.isWalkable(((Node)neighbor).x + dx, ((Node)neighbor).y) && this.graph.isWalkable(((Node)neighbor).x, ((Node)neighbor).y + dy)) {
            return this.jump(this.graph.getNode(((Node)neighbor).x + dx, ((Node)neighbor).y + dy), neighbor, goals);
        }
        return null;
    }
}

