/*
 * Decompiled with CFR 0.152.
 */
package jbweb;

import bwapi.Color;
import bwapi.Position;
import bwapi.Text;
import bwapi.TilePosition;
import bwapi.UnitType;
import bwem.Base;
import java.util.List;
import jbweb.JBWEB;

public class Station {
    private final Base base;
    private final List<TilePosition> defenses;
    private final Position resourceCentroid;
    private final boolean main;
    private final boolean natural;

    Station(Position _resourceCentroid, List<TilePosition> _defenses, Base _base, boolean _main, boolean _natural) {
        this.resourceCentroid = _resourceCentroid;
        this.defenses = _defenses;
        this.base = _base;
        this.main = _main;
        this.natural = _natural;
    }

    public boolean equals(Station s) {
        return this.base == s.base;
    }

    public Position getResourceCentroid() {
        return this.resourceCentroid;
    }

    public List<TilePosition> getDefenseLocations() {
        return this.defenses;
    }

    public Base getBWEMBase() {
        return this.base;
    }

    public boolean isMain() {
        return this.main;
    }

    public boolean isNatural() {
        return this.natural;
    }

    public int getGroundDefenseCount() {
        int count = 0;
        for (TilePosition defense : this.defenses) {
            UnitType type = JBWEB.isUsed(defense, 1, 1);
            if (type != UnitType.Protoss_Photon_Cannon && type != UnitType.Zerg_Sunken_Colony && type != UnitType.Terran_Bunker) continue;
            ++count;
        }
        return count;
    }

    public int getAirDefenseCount() {
        int count = 0;
        for (TilePosition defense : this.defenses) {
            UnitType type = JBWEB.isUsed(defense, 1, 1);
            if (type != UnitType.Protoss_Photon_Cannon && type != UnitType.Zerg_Spore_Colony && type != UnitType.Terran_Missile_Turret) continue;
            ++count;
        }
        return count;
    }

    public void draw() {
        Color color = JBWEB.game.self().getColor();
        Text textColor = color.id == 185 ? Text.DarkGreen : JBWEB.game.self().getTextColor();
        for (TilePosition tile : this.defenses) {
            JBWEB.game.drawBoxMap(new Position(tile), new Position(tile.toPosition().x + 65, tile.toPosition().y + 65), color);
            JBWEB.game.drawTextMap(new Position(tile.toPosition().x + 4, tile.toPosition().y + 52), "%cS", textColor);
        }
        JBWEB.game.drawBoxMap(new Position(this.base.getLocation()), new Position(this.base.getLocation().toPosition().x + 129, this.base.getLocation().toPosition().y + 97), color);
    }
}

