/*
 * Decompiled with CFR 0.152.
 */
package jbweb;

import bwapi.Color;
import bwapi.Game;
import bwapi.Key;
import bwapi.Pair;
import bwapi.Position;
import bwapi.TilePosition;
import bwapi.Unit;
import bwapi.UnitType;
import bwapi.WalkPosition;
import bwem.Area;
import bwem.BWEM;
import bwem.Base;
import bwem.ChokePoint;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import jbweb.Block;
import jbweb.Blocks;
import jbweb.Pathfinding;
import jbweb.Station;
import jbweb.Stations;
import jbweb.Wall;
import jbweb.Walls;

public class JBWEB {
    static Game game;
    static BWEM mapBWEM;
    private static Position mainPosition;
    private static Position naturalPosition;
    private static TilePosition mainTile;
    private static TilePosition naturalTile;
    private static Area naturalArea;
    private static Area mainArea;
    private static ChokePoint naturalChoke;
    private static ChokePoint mainChoke;
    private static boolean drawReserveOverlap;
    private static boolean drawUsed;
    private static boolean drawWalk;
    private static boolean drawArea;
    private static HashMap<Key, Boolean> lastKeyState;
    private static HashMap<ChokePoint, List<TilePosition>> chokeTiles;
    private static HashMap<ChokePoint, Pair<Position, Position>> chokeLines;
    private static int[][] overlapGrid;
    private static UnitType[][] usedGrid;
    static boolean[][] walkGrid;
    private static final boolean logInfo = true;

    private static void findLines() {
        for (Area area : mapBWEM.getMap().getAreas()) {
            for (ChokePoint choke : area.getChokePoints()) {
                double yInt;
                double slope;
                double denominator;
                int minX = Integer.MAX_VALUE;
                int maxX = Integer.MIN_VALUE;
                int minY = Integer.MAX_VALUE;
                int maxY = Integer.MIN_VALUE;
                double sumX = 0.0;
                double sumY = 0.0;
                double sumXY = 0.0;
                double sumX2 = 0.0;
                double sumY2 = 0.0;
                for (WalkPosition geo : choke.getGeometry()) {
                    if (geo.x < minX) {
                        minX = geo.x;
                    }
                    if (geo.y < minY) {
                        minY = geo.y;
                    }
                    if (geo.x > maxX) {
                        maxX = geo.x;
                    }
                    if (geo.y > maxY) {
                        maxY = geo.y;
                    }
                    sumX += (double)geo.x;
                    sumY += (double)geo.y;
                    sumXY += (double)(geo.x * geo.y);
                    sumX2 += (double)(geo.x * geo.x);
                    sumY2 += (double)(geo.y * geo.y);
                }
                double size = choke.getGeometry().size();
                double xMean = sumX / size;
                double yMean = sumY / size;
                if (maxY - minY > maxX - minX) {
                    denominator = sumXY - sumY * xMean;
                    if (Math.abs(denominator) < 16000.0) {
                        slope = 0.0;
                        yInt = yMean;
                    } else {
                        slope = (sumY2 - sumY * yMean) / denominator;
                        yInt = yMean - slope * xMean;
                    }
                } else {
                    denominator = sumX2 - sumX * xMean;
                    if (Math.abs(denominator) < 1.0) {
                        slope = Double.MAX_VALUE;
                        yInt = yMean;
                    } else {
                        slope = (sumXY - sumX * yMean) / denominator;
                        yInt = yMean - slope * xMean;
                    }
                }
                int x1 = new Position((WalkPosition)choke.getNodePosition((ChokePoint.Node)ChokePoint.Node.END1)).x;
                int y1 = (int)Math.round((double)x1 * slope) + (int)Math.round(yInt);
                Position p1 = new Position(x1, y1);
                int x2 = new Position((WalkPosition)choke.getNodePosition((ChokePoint.Node)ChokePoint.Node.END2)).x;
                int y2 = (int)Math.round((double)x2 * slope) + (int)Math.round(yInt);
                Position p2 = new Position(x2, y2);
                if (p1 == p2 || !p1.isValid(game) || !p2.isValid(game)) {
                    p1 = new Position(choke.getNodePosition(ChokePoint.Node.END1));
                    p2 = new Position(choke.getNodePosition(ChokePoint.Node.END2));
                }
                chokeLines.put(choke, new Pair<Position, Position>(p1, p2));
            }
        }
    }

    private static void findMain() {
        mainTile = game.self().getStartLocation();
        mainPosition = new Position(JBWEB.mainTile.toPosition().x + 64, JBWEB.mainTile.toPosition().y + 48);
        mainArea = mapBWEM.getMap().getArea(mainTile);
    }

    private static void findNatural() {
        double distBest = Double.MAX_VALUE;
        for (Area area : mapBWEM.getMap().getAreas()) {
            for (Base base : area.getBases()) {
                double dist;
                if (base.isStartingLocation() || base.getGeysers().isEmpty() || area.getAccessibleNeighbors().isEmpty() || base.getMinerals().size() < 5 || !((dist = JBWEB.getGroundDistance(base.getCenter(), mainPosition)) < distBest)) continue;
                distBest = dist;
                naturalArea = base.getArea();
                naturalTile = base.getLocation();
                naturalPosition = new Position(JBWEB.naturalTile.toPosition().x + 64, JBWEB.naturalTile.toPosition().y + 48);
            }
        }
        if (naturalArea == null) {
            naturalArea = mainArea;
        }
    }

    private static void findMainChoke() {
        double dist;
        double distBest;
        ArrayList<ChokePoint> mainChokes = new ArrayList<ChokePoint>(mainArea.getChokePoints());
        if (mainChokes.size() == 1) {
            mainChoke = (ChokePoint)mainChokes.iterator().next();
            return;
        }
        ArrayList<ChokePoint> naturalChokes = new ArrayList<ChokePoint>(naturalArea.getChokePoints());
        if (naturalArea != null && naturalArea.getChokePoints().size() == 1) {
            distBest = Double.MAX_VALUE;
            for (ChokePoint choke : mainArea.getChokePoints()) {
                dist = JBWEB.getGroundDistance(choke.getCenter().toPosition(), mainPosition);
                if (!(dist < distBest) || JBWEB.findNode(naturalChokes, choke) != null) continue;
                mainChoke = choke;
                distBest = dist;
            }
        } else if (naturalArea != null) {
            distBest = Double.MAX_VALUE;
            for (ChokePoint choke : naturalArea.getChokePoints()) {
                dist = JBWEB.getGroundDistance(choke.getCenter().toPosition(), mainPosition);
                if (!(dist < distBest) || JBWEB.findNode(mainChokes, choke) == null) continue;
                mainChoke = choke;
                distBest = dist;
            }
        }
        if (mainChoke == null && mainPosition.isValid(game) && naturalPosition.isValid(game)) {
            distBest = Double.MAX_VALUE;
            for (ChokePoint choke : mapBWEM.getMap().getPath(mainPosition, naturalPosition)) {
                double width = choke.getNodePosition(ChokePoint.Node.END1).getDistance(choke.getNodePosition(ChokePoint.Node.END2));
                if (!(width < distBest)) continue;
                mainChoke = choke;
                distBest = width;
            }
        }
        if (mainChoke == null) {
            distBest = Double.MAX_VALUE;
            for (ChokePoint choke : mainArea.getChokePoints()) {
                dist = choke.getCenter().getDistance(mainPosition.toWalkPosition());
                if (!(dist < distBest)) continue;
                mainChoke = choke;
                distBest = dist;
            }
        }
    }

    private static void findNaturalChoke() {
        if (!naturalPosition.isValid(game)) {
            naturalChoke = mainChoke;
            return;
        }
        ArrayList<ChokePoint> nonChokes = new ArrayList<ChokePoint>();
        for (ChokePoint choke : mapBWEM.getMap().getPath(mainPosition, naturalPosition)) {
            nonChokes.add(choke);
        }
        if (naturalArea != null && naturalArea.getChokePoints().size() == 1) {
            naturalChoke = naturalArea.getChokePoints().get(0);
        } else {
            double distBest = Double.MAX_VALUE;
            Area second = null;
            if (naturalArea != null) {
                for (Area area : naturalArea.getAccessibleNeighbors()) {
                    WalkPosition center = area.getTop();
                    double dist = center.getDistance(mapBWEM.getMap().getCenter().toWalkPosition());
                    boolean wrongArea = false;
                    for (ChokePoint choke : area.getChokePoints()) {
                        if (!(!choke.isBlocked() && choke.getNodePosition(ChokePoint.Node.END1).getDistance(choke.getNodePosition(ChokePoint.Node.END2)) <= 2.0) && JBWEB.findNode(nonChokes, choke) == null) continue;
                        wrongArea = true;
                    }
                    if (wrongArea || !center.isValid(game) || !(dist < distBest)) continue;
                    second = area;
                    distBest = dist;
                }
                distBest = Double.MAX_VALUE;
                for (ChokePoint choke : naturalArea.getChokePoints()) {
                    double dist;
                    if (choke.getCenter() == mainChoke.getCenter() || choke.isBlocked() || choke.getGeometry().size() <= 3 || choke.getAreas().getFirst() != second && choke.getAreas().getSecond() != second || !((dist = choke.getCenter().getDistance(game.self().getStartLocation().toWalkPosition())) < distBest)) continue;
                    naturalChoke = choke;
                    distBest = dist;
                }
            }
        }
    }

    private static void findNeutrals() {
        for (Unit unit : game.getNeutralUnits()) {
            if (unit != null && unit.exists() && unit.getType().topSpeed() == 0.0) {
                JBWEB.addReserve(unit.getTilePosition(), unit.getType().tileWidth(), unit.getType().tileHeight());
            }
            if (!unit.getType().isBuilding()) continue;
            JBWEB.addUsed(unit.getTilePosition(), unit.getType());
        }
    }

    public static void easyWrite(String stuff) {
        try {
            FileWriter writeFile = new FileWriter("bwapi-data/write/BWEB_Log.txt");
            writeFile.write(stuff);
            writeFile.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static ChokePoint findNode(List<ChokePoint> treeSet, ChokePoint choke) {
        for (ChokePoint cp : treeSet) {
            if (cp != choke) continue;
            return cp;
        }
        return null;
    }

    public static void draw() {
        WalkPosition mouse = new WalkPosition(JBWEB.game.getMousePosition().x + JBWEB.game.getScreenPosition().x, JBWEB.game.getMousePosition().y + JBWEB.game.getScreenPosition().y);
        Area mouseArea = mouse.isValid(game) ? mapBWEM.getMap().getArea(mouse) : null;
        boolean k1 = game.getKeyState(Key.K_1);
        boolean k2 = game.getKeyState(Key.K_2);
        boolean k3 = game.getKeyState(Key.K_3);
        boolean k4 = game.getKeyState(Key.K_4);
        drawReserveOverlap = (k1 && k1 != lastKeyState.get((Object)Key.K_1)) != drawReserveOverlap;
        drawUsed = (k2 && k2 != lastKeyState.get((Object)Key.K_2)) != drawUsed;
        drawWalk = (k3 && k3 != lastKeyState.get((Object)Key.K_3)) != drawWalk;
        drawArea = (k4 && k4 != lastKeyState.get((Object)Key.K_4)) != drawArea;
        lastKeyState.put(Key.K_1, k1);
        lastKeyState.put(Key.K_2, k2);
        lastKeyState.put(Key.K_3, k3);
        lastKeyState.put(Key.K_4, k4);
        if (drawReserveOverlap || drawUsed || drawWalk || drawArea) {
            for (int x = 0; x < game.mapWidth(); ++x) {
                for (int y = 0; y < game.mapHeight(); ++y) {
                    UnitType type;
                    Position rightBottom;
                    Position leftTop;
                    TilePosition t = new TilePosition(x, y);
                    if (drawReserveOverlap && overlapGrid[x][y] >= 1) {
                        leftTop = new Position(t.toPosition().x + 4, t.toPosition().y + 4);
                        rightBottom = new Position(t.toPosition().x + 29, t.toPosition().y + 29);
                        game.drawBoxMap(leftTop, rightBottom, Color.Grey, false);
                    }
                    if (drawUsed && (type = usedGrid[x][y]) != UnitType.None) {
                        Position leftTop2 = new Position(t.toPosition().x + 8, t.toPosition().y + 8);
                        Position rightBottom2 = new Position(t.toPosition().x + 25, t.toPosition().y + 25);
                        game.drawBoxMap(leftTop2, rightBottom2, Color.Black, true);
                    }
                    if (drawWalk && walkGrid[x][y]) {
                        leftTop = new Position(t);
                        rightBottom = new Position(t.toPosition().x + 33, t.toPosition().y + 33);
                        game.drawBoxMap(leftTop, rightBottom, Color.Black, false);
                    }
                    if (!drawArea || mapBWEM.getMap().getArea(t) != mouseArea) continue;
                    leftTop = new Position(t);
                    rightBottom = new Position(t.toPosition().x + 33, t.toPosition().y + 33);
                    game.drawBoxMap(leftTop, rightBottom, Color.Green, false);
                }
            }
        }
        Walls.draw();
        Blocks.draw();
        Stations.draw();
    }

    public static void onStart(Game _game, BWEM _mapBWEM) {
        game = _game;
        mapBWEM = _mapBWEM;
        for (int x = 0; x < game.mapWidth(); ++x) {
            for (int y = 0; y < game.mapHeight(); ++y) {
                JBWEB.usedGrid[x][y] = UnitType.None;
                int cnt = 0;
                for (int dx = x * 4; dx < x * 4 + 4; ++dx) {
                    for (int dy = y * 4; dy < y * 4 + 4; ++dy) {
                        WalkPosition w = new WalkPosition(dx, dy);
                        if (!game.isWalkable(w)) continue;
                        ++cnt;
                    }
                }
                if (cnt < 14) continue;
                JBWEB.walkGrid[x][y] = true;
            }
        }
        for (Unit gas : game.getGeysers()) {
            for (int x = gas.getTilePosition().x; x < gas.getTilePosition().x + 4; ++x) {
                for (int y = gas.getTilePosition().y; y < gas.getTilePosition().y + 2; ++y) {
                    JBWEB.walkGrid[x][y] = false;
                }
            }
        }
        for (Area area : mapBWEM.getMap().getAreas()) {
            for (ChokePoint choke : area.getChokePoints()) {
                ArrayList<TilePosition> tileGeography = new ArrayList<TilePosition>();
                for (WalkPosition geo : choke.getGeometry()) {
                    tileGeography.add(geo.toTilePosition());
                }
                chokeTiles.put(choke, tileGeography);
            }
        }
        JBWEB.findNeutrals();
        JBWEB.findMain();
        JBWEB.findNatural();
        JBWEB.findMainChoke();
        JBWEB.findNaturalChoke();
        JBWEB.findLines();
    }

    public static void onUnitDiscover(Unit unit) {
        boolean okayToAdd;
        TilePosition tile = unit.getTilePosition();
        UnitType type = unit.getType();
        boolean gameStart = game.getFrameCount() == 0;
        boolean bl = okayToAdd = unit.getType().isBuilding() && !unit.isFlying() || gameStart && unit.getType().topSpeed() == 0.0;
        if (okayToAdd) {
            for (int x = tile.x; x < tile.x + type.tileWidth(); ++x) {
                for (int y = tile.y; y < tile.y + type.tileHeight(); ++y) {
                    TilePosition t = new TilePosition(x, y);
                    if (!t.isValid(game)) continue;
                    JBWEB.usedGrid[x][y] = type;
                }
            }
            Pathfinding.clearCache();
        }
    }

    public static void onUnitDestroy(Unit unit) {
        boolean okayToRemove;
        TilePosition tile = unit.getTilePosition();
        UnitType type = unit.getType();
        boolean gameStart = game.getFrameCount() == 0;
        boolean bl = okayToRemove = unit.getType().isBuilding() && !unit.isFlying() || !gameStart && unit.getType().topSpeed() == 0.0;
        if (okayToRemove) {
            for (int x = tile.x; x < tile.x + type.tileWidth(); ++x) {
                for (int y = tile.y; y < tile.y + type.tileHeight(); ++y) {
                    TilePosition t = new TilePosition(x, y);
                    if (!t.isValid(game)) continue;
                    JBWEB.usedGrid[x][y] = UnitType.None;
                }
            }
            Pathfinding.clearCache();
        }
    }

    public static void onUnitMorph(Unit unit) {
        JBWEB.onUnitDiscover(unit);
    }

    public static void addReserve(TilePosition t, int w, int h) {
        for (int x = t.x; x < t.x + w; ++x) {
            for (int y = t.y; y < t.y + h; ++y) {
                TilePosition t2 = new TilePosition(x, y);
                if (!t2.isValid(game)) continue;
                JBWEB.overlapGrid[x][y] = 1;
            }
        }
    }

    public static void removeReserve(TilePosition t, int w, int h) {
        for (int x = t.x; x < t.x + w; ++x) {
            for (int y = t.y; y < t.y + h; ++y) {
                TilePosition t2 = new TilePosition(x, y);
                if (!t2.isValid(game)) continue;
                JBWEB.overlapGrid[x][y] = 0;
            }
        }
    }

    public static boolean isReserved(TilePosition here, int width, int height) {
        for (int x = here.x; x < here.x + width; ++x) {
            for (int y = here.y; y < here.y + height; ++y) {
                TilePosition t = new TilePosition(x, y);
                if (!t.isValid(game) || overlapGrid[x][y] <= 0) continue;
                return true;
            }
        }
        return false;
    }

    public static void addUsed(TilePosition t, UnitType type) {
        for (int x = t.x; x < t.x + type.tileWidth(); ++x) {
            for (int y = t.y; y < t.y + type.tileHeight(); ++y) {
                if (!new TilePosition(x, y).isValid(game)) continue;
                JBWEB.usedGrid[x][y] = type;
            }
        }
    }

    public static void removeUsed(TilePosition t, int w, int h) {
        for (int x = t.x; x < t.x + w; ++x) {
            for (int y = t.y; y < t.y + h; ++y) {
                TilePosition t2 = new TilePosition(x, y);
                if (!t2.isValid(game)) continue;
                JBWEB.usedGrid[x][y] = UnitType.None;
            }
        }
    }

    public static UnitType isUsed(TilePosition here, int width, int height) {
        for (int x = here.x; x < here.x + width; ++x) {
            for (int y = here.y; y < here.y + height; ++y) {
                TilePosition t = new TilePosition(x, y);
                if (!t.isValid(game) || usedGrid[x][y] == UnitType.None) continue;
                return usedGrid[x][y];
            }
        }
        return UnitType.None;
    }

    public static boolean isWalkable(TilePosition here) {
        return walkGrid[here.x][here.y];
    }

    public static boolean isPlaceable(UnitType type, TilePosition location) {
        int x;
        if (type.requiresCreep()) {
            for (x = location.x; x < location.x + type.tileWidth(); ++x) {
                TilePosition creepTile = new TilePosition(x, location.y + type.tileHeight());
                if (game.isBuildable(creepTile)) continue;
                return false;
            }
        }
        if (type.isResourceDepot() && !game.canBuildHere(location, type)) {
            return false;
        }
        for (x = location.x; x < location.x + type.tileWidth(); ++x) {
            for (int y = location.y; y < location.y + type.tileHeight(); ++y) {
                TilePosition tile = new TilePosition(x, y);
                if (tile.isValid(game) && game.isBuildable(tile) && game.isWalkable(tile.toWalkPosition()) && JBWEB.isUsed(tile, 1, 1) == UnitType.None) continue;
                return false;
            }
        }
        return true;
    }

    public static int tilesWithinArea(Area area, TilePosition here, int width, int height) {
        int cnt = 0;
        for (int x = here.x; x < here.x + width; ++x) {
            for (int y = here.y; y < here.y + height; ++y) {
                TilePosition t = new TilePosition(x, y);
                if (!t.isValid(game)) {
                    return 0;
                }
                if (mapBWEM.getMap().getArea(t) != area) continue;
                ++cnt;
            }
        }
        return cnt;
    }

    private static Position validatePoint(WalkPosition w) {
        double distBest = 0.0;
        Position posBest = new Position(w);
        for (int x = w.x - 1; x < w.x + 1; ++x) {
            for (int y = w.y - 1; y < w.y + 1; ++y) {
                Position p;
                double dist;
                WalkPosition w2 = new WalkPosition(x, y);
                if (!w.isValid(game) || mapBWEM.getMap().getArea(w2) == null || !((dist = (p = new Position(w)).getDistance(mapBWEM.getMap().getCenter())) > distBest)) continue;
                distBest = dist;
                posBest = p;
            }
        }
        return posBest;
    }

    private static Position fastClosestNode(ChokePoint cp, Position last) {
        Position n1 = new Position(cp.getNodePosition(ChokePoint.Node.END1));
        Position n2 = new Position(cp.getNodePosition(ChokePoint.Node.END2));
        Position n3 = new Position(cp.getCenter());
        double d1 = n1.getDistance(last);
        double d2 = n2.getDistance(last);
        double d3 = n3.getDistance(last);
        return d1 < d2 ? (d1 < d3 ? n1 : n3) : (d2 < d3 ? n2 : n3);
    }

    private static Position accurateClosestNode(ChokePoint cp, Position start) {
        return JBWEB.getClosestChokeTile(cp, start);
    }

    public static double getGroundDistance(Position s, Position e) {
        Position start = new Position(s);
        Position end = new Position(e);
        double dist = 0.0;
        Position last = start;
        if (!start.isValid(game) || !end.isValid(game)) {
            return Double.MAX_VALUE;
        }
        if (mapBWEM.getMap().getArea(new WalkPosition(start)) == null) {
            start = JBWEB.validatePoint(new WalkPosition(start));
        }
        if (mapBWEM.getMap().getArea(new WalkPosition(end)) == null) {
            end = JBWEB.validatePoint(new WalkPosition(end));
        }
        if (!(start.isValid(game) && end.isValid(game) && mapBWEM.getMap().getArea(new WalkPosition(start)) != null && mapBWEM.getMap().getArea(new WalkPosition(end)) != null && mapBWEM.getMap().getArea(new WalkPosition(start)).isAccessibleFrom(mapBWEM.getMap().getArea(new WalkPosition(end))))) {
            return Double.MAX_VALUE;
        }
        boolean first = true;
        for (ChokePoint cpp : mapBWEM.getMap().getPath(start, end)) {
            boolean large = cpp.getNodePosition(ChokePoint.Node.END1).getDistance(cpp.getNodePosition(ChokePoint.Node.END2)) > 40.0;
            Position next = first && !large ? JBWEB.accurateClosestNode(cpp, start) : JBWEB.fastClosestNode(cpp, last);
            dist += next.getDistance(last);
            last = next;
            first = false;
        }
        return dist + last.getDistance(end);
    }

    public static double getAngle(Pair<Position, Position> p) {
        Position left = p.getFirst().x < p.getSecond().x ? p.getFirst() : p.getSecond();
        Position right = left == p.getFirst() ? p.getSecond() : p.getFirst();
        double dy = left.y - right.y;
        double dx = left.x - right.x;
        return Math.abs(dx) > 1.0 ? Math.atan(dy / dx) * 180.0 / 3.14 : 90.0;
    }

    public static Position getClosestChokeTile(ChokePoint choke, Position here) {
        double best = Double.MAX_VALUE;
        Position posBest = Position.Invalid;
        for (TilePosition tile : JBWEB.getChokeTiles(choke)) {
            Position p = new Position(tile.toPosition().x + 16, tile.toPosition().y + 16);
            double dist = p.getDistance(here);
            if (!(dist < best)) continue;
            posBest = p;
            best = dist;
        }
        return posBest;
    }

    public static List<TilePosition> getChokeTiles(ChokePoint choke) {
        if (choke != null) {
            return chokeTiles.get(choke);
        }
        return null;
    }

    public static Pair<Position, Position> lineOfBestFit(ChokePoint choke) {
        if (choke != null) {
            return chokeLines.get(choke);
        }
        return null;
    }

    public static Pair<Position, Position> perpendicularLine(Pair<Position, Position> points, double length) {
        Position n1 = points.getFirst();
        Position n2 = points.getSecond();
        double dist = n1.getDistance(n2);
        int dx1 = (int)((double)(n2.x - n1.x) * length / dist);
        int dy1 = (int)((double)(n2.y - n1.y) * length / dist);
        int dx2 = (int)((double)(n1.x - n2.x) * length / dist);
        int dy2 = (int)((double)(n1.y - n2.y) * length / dist);
        int x1 = (n1.x + n2.x) / 2;
        int y1 = (n1.y + n2.y) / 2;
        Position direction1 = new Position(-dy1 + x1, dx1 + y1);
        Position direction2 = new Position(-dy2 + x1, dx2 + y1);
        return new Pair<Position, Position>(direction1, direction2);
    }

    public static TilePosition getBuildPosition(UnitType type, TilePosition searchCenter) {
        double distBest = Double.MAX_VALUE;
        TilePosition tileBest = TilePosition.Invalid;
        for (Block block : Blocks.getBlocks()) {
            List<TilePosition> placements = type.tileWidth() == 4 ? block.getLargeTiles() : (type.tileWidth() == 3 ? block.getMediumTiles() : block.getSmallTiles());
            for (TilePosition tile : placements) {
                double dist = tile.getDistance(searchCenter);
                if (!(dist < distBest) || !JBWEB.isPlaceable(type, tile)) continue;
                distBest = dist;
                tileBest = tile;
            }
        }
        return tileBest;
    }

    public static TilePosition getDefBuildPosition(UnitType type, TilePosition searchCenter) {
        double distBest = Double.MAX_VALUE;
        TilePosition tileBest = TilePosition.Invalid;
        for (ChokePoint chokePoint : Walls.getWalls().keySet()) {
            Wall wall = Walls.getWalls().get(chokePoint);
            for (TilePosition tile : wall.getDefenses()) {
                double dist = tile.getDistance(searchCenter);
                if (!(dist < distBest) || !JBWEB.isPlaceable(type, tile)) continue;
                distBest = dist;
                tileBest = tile;
            }
        }
        for (Station station : Stations.getStations()) {
            for (TilePosition tile : station.getDefenseLocations()) {
                double dist = tile.getDistance(searchCenter);
                if (!(dist < distBest) || !JBWEB.isPlaceable(type, tile)) continue;
                distBest = dist;
                tileBest = tile;
            }
        }
        return tileBest;
    }

    public static Area getNaturalArea() {
        return naturalArea;
    }

    public static Area getMainArea() {
        return mainArea;
    }

    public static ChokePoint getNaturalChoke() {
        return naturalChoke;
    }

    public static ChokePoint getMainChoke() {
        return mainChoke;
    }

    public static TilePosition getNaturalTile() {
        return naturalTile;
    }

    public static Position getNaturalPosition() {
        return naturalPosition;
    }

    public static TilePosition getMainTile() {
        return mainTile;
    }

    public static Position getMainPosition() {
        return mainPosition;
    }

    static {
        mainPosition = Position.Invalid;
        naturalPosition = Position.Invalid;
        mainTile = TilePosition.Invalid;
        naturalTile = TilePosition.Invalid;
        naturalArea = null;
        mainArea = null;
        naturalChoke = null;
        mainChoke = null;
        lastKeyState = new HashMap();
        chokeTiles = new HashMap();
        chokeLines = new HashMap();
        overlapGrid = new int[256][256];
        usedGrid = new UnitType[256][256];
        walkGrid = new boolean[256][256];
    }
}

